

<!DOCTYPE html>
<!--Fiber Availability Map, Strata Networks-->
<html>
  <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no">
    
    <style>
      html, body, #map-canvas {
        margin-left: auto;
		margin-right: auto;
		padding: 0;
		width: 100%;
		height: 800px;
      }
      .controls {
        margin-top: 16px;
        border: 1px solid transparent;
        border-radius: 2px 0 0 2px;
        box-sizing: border-box;
        -moz-box-sizing: border-box;
        height: 32px;
        outline: none;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);
      }

      #pac-input {
        background-color: #fff;
        font-family: Roboto;
        font-size: 15px;
        font-weight: 300;
        margin-left: 12px;
        padding: 0 11px 0 13px;
        text-overflow: ellipsis;
        width: 400px;
      }

      #pac-input:focus {
        border-color: #4d90fe;
      }

      .pac-container {
        font-family: Roboto;
      }

      #type-selector {
        color: #fff;
        background-color: #4d90fe;
        padding: 5px 11px 0px 11px;
      }

      #type-selector label {
        font-family: Roboto;
        font-size: 13px;
        font-weight: 300;
      }

    </style>
    <title>Places search box</title>
	<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAs1vy2Ew3LctHIECAqhxNlhBzJ9hBtdpU&libraries=places">
</script>
    
    <script>
// This adds a search box to a map, using the Google Place Autocomplete
// feature. People can enter geographical searches. The search box will return a
// pick list containing a mix of places and predicted search terms.
// The Location below is center of downtown Vernal Utah 84078.
var mylocation = {'latitude':  40.455725,'longitude':  -109.528582};
var map;

var layers=[];

layers[0] = new  google.maps.KmlLayer('http://stratanetworks.com/KML/6MbpsInternetMap.kml',
{preserveViewport: true});

layers[1] = new google.maps.KmlLayer('http://stratanetworks.com/KML/15MbpsInternetMap.kml',
{preserveViewport: true});

layers[2] = new google.maps.KmlLayer('http://stratanetworks.com/KML/FiberInternetMap3.kml',
{preserveViewport: true});
function initialize() {

  var markers = [];
  var myLatlng = new google.maps.LatLng( mylocation.latitude, mylocation.longitude );
  var mapOptions = {zoom: 12,center: myLatlng,mapTypeId: google.maps.MapTypeId.ROADMAP};
  map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
  layers[2].setMap(map);
  
			
  // Create the search box and link it to the UI element.
  var input = (
      document.getElementById('pac-input'));
  map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

  var searchBox = new google.maps.places.SearchBox(
    (input));

  // [START region_getplaces]
  // Listen for the event fired when the user selects an item from the
  // pick list. Retrieve the matching places for that item.
  google.maps.event.addListener(searchBox, 'places_changed', function() {
    var places = searchBox.getPlaces();

    if (places.length == 0) {
      return;
    }
    for (var i = 0, marker; marker = markers[i]; i++) {
      marker.setMap(null);
    }

    // For each place, get the icon, place name, and location.
	var pinColor = "00000";
    markers = [];
    var bounds = new google.maps.LatLngBounds();
    for (var i = 0, place; place = places[i]; i++) {
      var pinColor = "008000";
    var pinImage = new google.maps.MarkerImage("http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=%E2%80%A2|" + pinColor,
        new google.maps.Size(21, 34),
        new google.maps.Point(0,0),
        new google.maps.Point(10, 34));
    var pinShadow = new google.maps.MarkerImage("http://chart.apis.google.com/chart?chst=d_map_pin_shadow",
        new google.maps.Size(40, 37),
        new google.maps.Point(0, 0),
        new google.maps.Point(12, 35));

      // Create a marker for each place.
      var marker = new google.maps.Marker({
        map: map,
        icon: pinImage,
        title: place.name,
        position: place.geometry.location
      });

      markers.push(marker);

      bounds.extend(place.geometry.location);
    }

    map.fitBounds(bounds);
  });
  // [END region_getplaces]

  // Bias the SearchBox results towards places that are within the bounds of the
  // current map's viewport.
  google.maps.event.addListener(map, 'bounds_changed', function() {
    var bounds = map.getBounds();
    searchBox.setBounds(bounds);
  });
}
function toggleLayers(i)
{

  if(layers[i].getMap()==null) {
     layers[i].setMap(map);
  }
  else {
     layers[i].setMap(null);
  }
  
}









function newLocation(newLat,newLng) {
			map.setCenter({
				lat : newLat,
				lng : newLng
			});
		}
		
google.maps.event.addDomListener(window, 'load', initialize);


    </script>
    <style>
      #target {
        width: 345px;
      }
    </style>
  </head>
  <body onload="initialize()">
    <input id="pac-input" class="controls" type="text" placeholder="Enter Address to Search">
    <div id="map-canvas"></div>
	<button type="button" id="layer_01" onclick="toggleLayers(0);">6Mbs Internet Availability</button>
	<button type="button" id="layer_02" onclick="toggleLayers(1);">15Mbs Internet Availability</button>
	<button type="button" id="layer_02" onclick="toggleLayers(2);">Fiber Internet Availability</button>
	
	<p style="font-size:10px; font-family:verdana">All information presented on STRATA’s interactive broadband map is for general reference purposes only and may contain errors or omissions. Speeds shown are maximum speed capabilities & may vary. Areas with fiber connectivity are capable of speeds up to 50 Mbps. Broadband availability, speeds, and map details are subject to change. Address may not be reflected accurately. For questions and comments, please call (435)622-5007.<p>
  </body>
</html>

