

<!DOCTYPE html>
<!-- Reconnect Map, Strata Networks -->
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <meta name="viewport" content="initial-scale=1.0, user-scalable=no">
    
        <!-- CSS Styles -->
        <style>
            html, body, #map-canvas {
                margin-left: auto;
                margin-right: auto;
                padding: 0;
                width: 100%;
                height: 800px;
            }
            .controls {
                margin-top: 16px;
                border: 1px solid transparent;
                border-radius: 2px 0 0 2px;
                box-sizing: border-box;
                -moz-box-sizing: border-box;
                height: 32px;
                outline: none;
                box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);
            }
        </style>
        
        <!-- This sets page title -->
        <title>
            Reconnect Map
        </title>

        <!-- Google Maps API Key -->
        <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAs1vy2Ew3LctHIECAqhxNlhBzJ9hBtdpU&libraries=places">
        </script>
    
        <script>
            // This location is just east of Roosevelt to have the entire Basin centered on the map.
            var mylocation = {'latitude':  40.192512,'longitude':  -110.008153};
            var map;
            // Location of KML file to be loaded on the map.
            layer = new google.maps.KmlLayer('http://stratanetworks.com/KML/ReconnectMap-Round2.kml',
            {preserveViewport: true});


            function initialize() {
                var markers = [];
                var myLatlng = new google.maps.LatLng( mylocation.latitude, mylocation.longitude );
                var mapOptions = {zoom: 10, center: myLatlng,mapTypeId: google.maps.MapTypeId.ROADMAP};
                map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
                layer.setMap(map);
                map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
                google.maps.event.addListener(map, 'bounds_changed', function() {
                    var bounds = map.getBounds();
                    searchBox.setBounds(bounds);
                });
            }
      
            google.maps.event.addDomListener(window, 'load', initialize);

        </script>
    </head>

    <body onload="initialize()">
        <div id="map-canvas"></div>
    </body>

</html>