<?php
/**
 * @package            Joomla
 * @subpackage         Event Booking
 * @author             Tuan Pham Ngoc
 * @copyright          Copyright (C) 2010 - 2019 Ossolution Team
 * @license            GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

class EventbookingControllerLocation extends EventbookingController
{
	/**
	 * Search for a given address using OpenStreetMap API
	 */
	public function search()
	{
		$address = $this->input->getString('query');

		/* @var EventbookingModelLocations $model */
		$model = $this->getModel('Locations', array('ignore_request' => true));

		$response['suggestions'] = $model->searchInOpenStreetMap($address);

		echo json_encode($response);

		$this->app->close();
	}
}
