<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/joomla-platform
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2020 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

namespace Jchoptimize\Component\Admin\Helper;

defined( '_JEXEC' ) or dir( 'Restricted Access' );

use JchOptimize\Component\Admin\View\OptimizeImage\Html;
use JchOptimize\Platform\Utility;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route as JRoute;

class OptimizeImage
{

	public static function loadResources( Html $oHtml )
	{
		/** @var \JchOptimize\Component\Admin\Model\OptimizeImage $oModel */
		$oModel     = $oHtml->getModel();
		$jch_params = json_encode( $oModel->getCompParams() );

		$oHtml->addCssFile( 'media://com_jchoptimize/jquery-ui/jquery-ui.css', JCH_VERSION );
		$oHtml->addJavascriptFile( 'media://com_jchoptimize/core/js/ioptimize-api.js', JCH_VERSION );
		$oHtml->addJavascriptFile( 'media://com_jchoptimize/jquery-ui/jquery-ui.js', JCH_VERSION );

		$message = addslashes( Utility::translate( 'Please select files or subfolders to optimize.' ) );
		$noproid = addslashes( Utility::translate( 'Please enter your Download ID in the component options section.' ) );

		$sJs = <<<JS
var jch_message = '$message';   
var jch_noproid = '$noproid';        
var jch_params = JSON.parse('{$jch_params}');
JS;
		$oHtml->addJavascriptInline( $sJs );
	}
}