<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// No direct access
namespace ParseCsv\enums;
defined('_JEXEC') or die;
abstract class AbstractEnum {

    /**
     * Creates a new value of some type
     *
     * @param mixed $value
     *
     * @throws \UnexpectedValueException if incompatible type is given.
     */
    public function __construct($value) {
        if (!$this->isValid($value)) {
            throw new \UnexpectedValueException("Value '$value' is not part of the enum " . get_called_class());
        }
        $this->value = $value;
    }

    public static function getConstants() {
        $class = get_called_class();
        $reflection = new \ReflectionClass($class);

        return $reflection->getConstants();
    }

    /**
     * Check if enum value is valid
     *
     * @param $value
     *
     * @return bool
     */
    public static function isValid($value) {
        return in_array($value, static::getConstants(), true);
    }
}
