<?php

/*
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ***@author      Created by JoomUnited (C)
 */

defined('_JEXEC') or die;
jimport('joomla.version');
// import Joomla Categories Library
jimport('joomla.application.categories');
if (!(class_exists('MyMapLocationsHelper'))) {

    $helper = JPATH_SITE . '/components/com_mymaplocations/helpers/mymaplocations.php';
    if (file_exists($helper)) {
        require_once($helper);
    }
}
$lang = JFactory::getLanguage();
$app = JFactory::getApplication();
$mapid = $params->get('mapid');
$height = $params->get('height');
$width = $params->get('width');
$zoom = $params->get('zoom');
$type = $params->get('type');
$mode = $params->get('map_mode', 0);
$limit=$params->get('limit');
$map_display=$params->get('map_display',0);
$category_id = $params->get('catid');
$component = "com_hikamarket";
$orderCol=$params->get('filter_order');
$db = JFactory::getDBO();
$plugin = JPluginHelper::getPlugin('hikamarket', 'mymaplocations');
$params = new JRegistry($plugin->params);
$company=$db->escape($params->get('vendor_company_column','vendor_address_company'));
$address=$db->escape($params->get('vendor_address_column','vendor_address_street'));
$city=$db->escape($params->get('vendor_city_column','vendor_address_city'));
$st=$db->escape($params->get('vendor_state_column','vendor_address_state'));
$country=$db->escape($params->get('vendor_country_column','vendor_address_country '));
$zip=$db->escape($params->get('vendor_zip_column','vendor_address_post_code'));

$query = $db->getQuery(true);
$query->select('a.*');

$query->select('k.vendor_name as name,k.'.$company.' as company, k.'.$address.' as address, k.'.$zip.' as postal,k.'.$city.' as town,q.zone_name_english as locationstate,m.zone_name_english as country,k.vendor_image as icon');  
$query->select('k.vendor_name as nom');
$query->select('k.vendor_name as name');
 $query->select('k.vendor_alias as vendor_alias');

$query->from('#__mymaplocations_location as a ');
$query->join('LEFT', '#__hikamarket_vendor AS k ON k.vendor_id= a.extra_id');
$query->join('LEFT', '#__hikashop_zone AS q ON q.zone_namekey =k.'.$st);
$query->join('LEFT', '#__hikashop_zone AS m ON m.zone_namekey =k.'.$country);

$query->where(' ( component = ' . $db->quote($component) . ') ');
$query->where('state=1');
if ($orderCol=="date")
	{
		$query->order( $db->escape( 'k.vendor_id  asc'  ) );
	}
	else if($orderCol=="rdate")
	{
		$query->order( $db->escape( 'k.vendor_id desc'  ) );
	}
	else if (($orderCol=="alpha"))
            {
			$query->order( $db->escape( 'k.vendor_name asc'  ));
            }
			else if (($orderCol=="ralpha"))
			{
				$query->order( $db->escape( 'k.vendor_name desc'  ));
			}
			else
            {
                $query->order('a.ordering');
            }


if($limit!=0)
{
	$db->setQuery($query,0,$limit);

}
else
{
$db->setQuery($query);
}

$result = $db->loadObjectList();
if (empty($result)) {
    return;
}
require_once JPATH_ADMINISTRATOR.'/components/com_hikashop/helpers/helper.php';
	$config =@hikashop::config();
		$uploadFolder = ltrim(JPath::clean(html_entity_decode($config->get('uploadfolder'))),DS);
		$uploadFolder = rtrim($uploadFolder,DS).DS;
        $hikaiconheight = (int)$config->get('thumbnail_y');
        $hikaiconwidth = (int)$config->get('thumbnail_x');
		
$hika_image=hikashop_get('helper.image');

$c=0;
foreach($result as $item)
{
	$result[$c]->component="com_hikashop";
	$f_image=$hika_image->display($item->icon,false,$item->icon, '' , '' , $hikaiconwidth,$hikaiconheight);
	preg_match_all("/<img .*?(?=src)src=\"([^\"]+)\"/si", $f_image, $m);
	$result[$c]->logo=str_replace(JURI::base(),'',$m[1][0]);
	$result[$c]->icon=null;
	$c++;
}

$result[0]->google_maptype = $params->get('google_maptype', 'ROADMAP');
$result[0]->bing_maptype = $params->get('bing_maptype', 'road');
$result[0]->openmapstyle=$params->get('openmapstyle', 1);
$result[0]->map_design=$params->get('map_design', 1);
$result[0]->map_layer=$params->get('map_layer',1);
$result[0]->maplayer_url=$params->get('maplayer_url','');
require JModuleHelper::getLayoutPath('mod_mymaplocationsmaps', $params->get('layout', 'default'));
