<?php

/*
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ***@author      Created by JoomUnited (C)
 */

defined('_JEXEC') or die;
jimport('joomla.version');
use Joomla\Utilities\ArrayHelper;

// import Joomla Categories Library
jimport('joomla.application.categories');
if (!(class_exists('MyMapLocationsHelper'))) {

    $helper = JPATH_SITE . '/components/com_mymaplocations/helpers/mymaplocations.php';
    if (file_exists($helper)) {
        require_once($helper);
    }
}


if (!(MyMapLocationsHelper::checkComponent('com_k2'))) {
    return;

}
$lang = JFactory::getLanguage();
$app = JFactory::getApplication();
$mode = $params->get('map_mode');
$catfilter = $params->get('catfilter');
$category_id = $params->get('category_id');
$mapid = $params->get('mapid');
$autoadjust=$params->get('autoadjust',0);
$limit=$params->get('limit');
$orderCol=$params->get('filter_order');
$map_display=$params->get('map_display',0);
$now=JFactory::getDate()->toSql();
if($autoadjust)
{
    
    $layout=JFactory::getApplication()->input->get('layout');
    $option=JFactory::getApplication()->input->get('option');
    $task=JFactory::getApplication()->input->get('task');
    if(($option=="com_k2")&&(($layout=="category")||($task=="category")))
    {
     $mode=0;
     $catfilter=1;
     $category_id=array(intval(JFactory::getApplication()->input->get('id')));
    }
    
}
if (($mode == 0) && ($catfilter==0))
{
    
}
else if (($mode == 0) && (empty($category_id))) {
    return;
} else if (($mode == 1) && (empty($mapid))) {
    return;
}

$height = $params->get('height');
$width = $params->get('width');
$zoom = $params->get('zoom');
$type = $params->get('type');
$db = JFactory::getDBO();
	$nullDate = $db->getNullDate();
$query = $db->getQuery(true);
$query->select('a.*');
$query->select('k.title as name,k.alias as k2alias,k.catid as k2catid');
$query->select('k.ordering as cordering');
$query->select('cat.alias as k2catalias');
$query->from('#__mymaplocations_location AS a');
$query->join('LEFT', '#__k2_items AS k ON k.id = a.extra_id');
$query->join('LEFT', '#__k2_categories AS cat ON cat.id = k.catid');
$query->where('component=' . $db->quote('com_k2'));
  $query->where(' k.published =1 AND k.trash=0 ');
  $query->where(' cat.published =1 ');
  
if ($mode == 0) {
    if ($catfilter != 0) {
		 ArrayHelper::toInteger($category_id);
        $query->where('k.catid IN (' . implode(',', $category_id) . ')');
    }
} else {
    $query->where('k.id IN (' . implode(',', $mapid) . ')');
}
if(JLanguageMultilang::isEnabled())
{
$query->where('k.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
}

$query->where("(k.publish_up = ".$db->Quote($nullDate)." OR k.publish_up <= ".$db->Quote($now).")");
$query->where("(k.publish_down = ".$db->Quote($nullDate)." OR k.publish_down >= ".$db->Quote($now).")");
 
if ($orderCol=="date")
	{
		$query->order( $db->escape( 'extra_id  asc'  ) );
	}
	else if($orderCol=="rdate")
	{
		$query->order( $db->escape( 'extra_id  desc'  ) );
	}
	else if (($orderCol=="alpha"))
            {
			$query->order( $db->escape( 'k.title asc'  ));
            }
			else if (($orderCol=="ralpha"))
			{
				$query->order( $db->escape( 'k.title desc'  ));
			}
			else
            {
                $query->order('cordering');
            }

 
if($limit!=0)
{
	$db->setQuery($query,0,$limit);

}
else
{
$db->setQuery($query);
}

$result = $db->loadObjectList();
if(!$result)
{
    return;
}

foreach($result as $i=>$res)
{
    if($res->logo)
				{
                    
				}
			else if(JFile::exists(JPATH_SITE.'/media/k2/items/cache/'.md5("Image".$res->extra_id).'_S.jpg'))
			{
                
				$result[$i]->logo=JURI::base().'/media/k2/items/cache/'.md5("Image".$res->extra_id).'_S.jpg';	
			}
}

$result[0]->google_maptype = $params->get('google_maptype', 'ROADMAP');
$result[0]->bing_maptype = $params->get('bing_maptype', 'road');
$result[0]->openmapstyle=$params->get('openmapstyle', 1);
$result[0]->map_design=$params->get('map_design', 1);
$result[0]->map_layer=$params->get('map_layer',1);
$result[0]->maplayer_url=$params->get('maplayer_url','');
require JModuleHelper::getLayoutPath('mod_k2mymaplocationsmaps', $params->get('layout', 'default'));
