<?php

/*
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ***@author      Created by JoomUnited (C)
 */

defined('_JEXEC') or die;
jimport('joomla.version');
use Joomla\Utilities\ArrayHelper;

// import Joomla Categories Library
jimport('joomla.application.categories');
if (!(class_exists('MyMapLocationsHelper'))) {

    $helper = JPATH_SITE . '/components/com_mymaplocations/helpers/mymaplocations.php';
    if (file_exists($helper)) {
        require_once($helper);
    }
}
$lang = JFactory::getLanguage();
$app = JFactory::getApplication();
$mapid = $params->get('mapid');
ArrayHelper::toInteger($mapid);
$height = $params->get('height');
$width = $params->get('width');
$zoom = $params->get('zoom');
$type = $params->get('type');
$mode = $params->get('map_mode', 0);
$limit=$params->get('limit');
$category_id = $params->get('catid');
$map_display=$params->get('map_display',0);
$component = "com_mymaplocations";
$orderCol=$params->get('filter_order');
if (($mode == 1) && (empty($mapid))) {
    return;
}

$db = JFactory::getDBO();
$query = $db->getQuery(true);
$query->select('a.*');
$query->select('c.params as catparams');
$query->from('#__mymaplocations_location as a ');
$query->join('LEFT', '#__categories AS c on c.id = a.catid');
 $query->select('c.access AS category_access');
if ($mode == 0) {
    if (!empty($category_id[0])) {
             ArrayHelper::toInteger($category_id);
        $query->where('a.catid IN (' . implode(',', $category_id) . ')');
    }
} else {
    $query->where('a.id IN (' . implode(',', $mapid) . ')');
}

$query->where(' ( a.component = ' . $db->quote($component) . ' OR a.component=' . $db->quote("") . ') ');
$query->where('a.state=1');
if(JLanguageMultilang::isEnabled())
{
$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
}

if ($orderCol=="date")
	{
		$query->order( $db->escape( 'a.id  asc'  ) );
	}
	else if($orderCol=="rdate")
	{
		$query->order( $db->escape( 'a.id  desc'  ) );
	}
	else if (($orderCol=="alpha"))
            {
			$query->order( $db->escape( 'a.name asc'  ));
            }
			else if (($orderCol=="ralpha"))
			{
				$query->order( $db->escape( 'a.name desc'  ));
			}
			else
            {
                $query->order('a.ordering');
            }

if($limit!=0)
{
	$db->setQuery($query,0,$limit);

}
else
{
$db->setQuery($query);
}

$result = $db->loadObjectList();
if (empty($result)) {
    return;
}
$user = JFactory::getUser();
$groups = $user->getAuthorisedViewLevels();
for ($x = 0, $count = count($result); $x < $count; $x++)
			{
				// Check the access level. Remove articles the user shouldn't see
  
				if (!in_array(@$result[$x]->category_access, $groups))
				{
     
					unset($result[$x]);
				}
			}
   
$result[0]->google_maptype = $params->get('google_maptype', 'ROADMAP');
$result[0]->bing_maptype = $params->get('bing_maptype', 'road');
$result[0]->openmapstyle=$params->get('openmapstyle', 1);
$result[0]->map_design=$params->get('map_design', 1);
$result[0]->map_layer=$params->get('map_layer',1);
$result[0]->maplayer_url=$params->get('maplayer_url','');
require JModuleHelper::getLayoutPath('mod_mymaplocationsmaps', $params->get('layout', 'default'));
