<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

jimport('joomla.language.helper');
use Joomla\Utilities\ArrayHelper;

class plgContentMyMapLocations extends JPlugin {
    
    protected $autoloadLanguage = true;

    public function onContentPrepare($context,$content,$params, $limitstart=0) {
        // Get data to replace
        $tag = 'mymaplocation';

        $app = JFactory::getApplication();
        $db = JFactory::getDBO();
        $option = JFactory::getApplication()->input->get('option');
        $task = JFactory::getApplication()->input->get('task');
        $width = null;
        $height = null;
        if ($option == 'com_content' && $task == 'edit')
            return true;
        if($context!="com_content.article")
              return true;
        if (strpos($content->text, '{' . $tag . ' ') !== false)
           {
        if (!$this->checkComponent())
            return true;
        $pattern = '#\{' . $tag . ' (.*?)}#i';
        if (preg_match_all($pattern, $content->text, $matches)) {
            $mapid = "";
            $height = "";
            $width = "";
            $zoom = "";
            $type = "";
            $catid=null;
            foreach ($matches[0] as $i => $match) {
                $datas = explode(" ", $matches[1][$i]);
                foreach ($datas as $data) {
                    if (preg_match('|catid=|', $data)) {
                        @$catid = (str_ireplace('catid=', '', $data));
                        @$catid = explode(",", $catid);
                    }
                    else if (preg_match('|id=|', $data)) {
                        $id = (str_ireplace('id=', '', $data));
                        $mapid = explode(",", $id);
                        ArrayHelper::toInteger($mapid);
                    } else if (preg_match('|height=|', $data)) {
                        $height = (str_ireplace('height=', '', $data));
                    } else if (preg_match('|width=|', $data)) {
                        $width = (str_ireplace('width=', '', $data));
                    } else if (preg_match('|zoom=|', $data)) {
                        $zoom = (str_ireplace('zoom=', '', $data));
                    } else if (preg_match('|type=|', $data)) {
                        $type = (str_ireplace('type=', '', $data));
                    }
                    
                }
                
                // Create a new query object.
                $query = $db->getQuery(true);
                $query->select('a.*');
                $query->select('c.params as catparams');
                $query->from('#__mymaplocations_location as a');
                 $query->join('LEFT', '#__categories AS c on c.id = catid');
                 if(@$catid)
                 {
                     ArrayHelper::toInteger($catid);
                    $query->where('a.catid IN (' . implode(',',$catid) . ')');
                 
                 }
                 else
                 {
                    ArrayHelper::toInteger($mapid);
                $query->where('a.id IN (' . implode(',',$mapid) . ')');
                 }
                 $query->order('a.ordering');
                $db->setQuery($query);
                $result = $db->loadObjectList();
                
                if(count($result))
                {
                $content->text = str_replace($matches[0][$i], MyMapLocationsHelper::CreateMap($result, $width, $height, $zoom, $type), $content->text);
                }
                else
                {
                $content->text = str_replace($matches[0][$i],'', $content->text);
                    
                }
            }
        }
           }
           
        $mapparams = JComponentHelper::getParams('com_mymaplocations');
        $enable_extension=$mapparams->get('enable_extension',1);
        if(!$enable_extension)
        {
            return;
        }
        $catids=$mapparams->get('filter_catid');
        if((@$catids)&&in_array(@$content->catid,@$catids))
           {
           }
           else
           {
            return;
           }
        $path = JPluginHelper::getLayoutPath('content', 'mymaplocations', 'default');
        ob_start();
        include $path;
        $html = ob_get_clean();
        $content->text = $content->text.$html;
    }
    public function onContentPrepareForm($form, $data)
	{
	if (!($form instanceof JForm))
	{
        JFactory::getApplication()->enqueueMessage('JERROR_NOT_A_FORM','error');
         return false;
	}
	if ($form->getName()!='com_content.article') {
	    return true;
        }
        $mapparams = JComponentHelper::getParams('com_mymaplocations');
        $autocomplete_type=$mapparams->get('autocomplete_type',1);
        $enable_extension=$mapparams->get('enable_extension',1);
        if(!$enable_extension)
        {
            return;
        }
		$document = JFactory::getDocument();
        if (!(class_exists('MyMapLocationsHelper'))) {

    $helper = JPATH_SITE . '/components/com_mymaplocations/helpers/mymaplocations.php';
    if (file_exists($helper)) {
        require_once($helper);
        }
        }
        MyMaplocationsHelper::loadLanguage();
        $catids=$mapparams->get('filter_catid');
        $catscript=null;
        $q=0;
        if($catids)
        {
        foreach($catids as $catid)
        {
            if($q==0)
            {
            $catscript.="if(value==".$catid.")
            {
                 jQuery('#location-form').show();
            }
            ";
            $q++;
            }
            else
            {
            $catscript.="else if(value==".$catid.")
            {
                 jQuery('#location-form').show();
            }
            ";    
            }
        }
        if($q!=0)
        {
            $catscript.="else
            {
                 jQuery('#location-form').hide();
            }
            ";
        }
        if($catids)
        {
       echo '
       <script type="text/javascript">
        jQuery(document).ready(function () {
         var value=jQuery("#jform_catid").val();
         
        '.$catscript.'
           jQuery(document).on("change","#jform_catid", function () {
           var value=jQuery("#jform_catid").val();
           '.$catscript.'
           });
          
        });
        </script>';
        }
        }
        if($autocomplete_type==1)
        {
        echo'<script type="text/javascript">
        jQuery(document).ready(function () {
         google.maps.event.trigger(map, "resize");
         map.setCenter(marker.getPosition());
         });
        jQuery(function($){ $("#myTabTabs a").click(function (e) {
        var tab = $(e.target);
        var contentId = tab.attr("href");
        if(contentId=="#attrib-mymaplocation")
        {
                e.preventDefault();   
                $(this).tab("show");  
                google.maps.event.trigger(map, "resize");
                map.setCenter(marker.getPosition());
        }
        });});</script>';
        }
   	JForm::addFormPath(JPATH_SITE.'/administrator/components/com_mymaplocations/models/forms/');
		$form->loadFile('contentlocation', false);
		return true;
	}
   public function onContentAfterSave($context, $article, $isNew)
   {
    
        if(($context=="com_content.article")||($context=="com_content.form"))
        {
        }
        else
        {
         return;
        }  
        require_once(JPATH_SITE .'/components/com_mymaplocations/helpers/mymaplocations.php');
        JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_mymaplocations/tables');
      $articleId = $article->id;
      $mapparams = JComponentHelper::getParams('com_mymaplocations');
        $enable_extension=$mapparams->get('enable_extension',0);
    if(!$enable_extension)
    {
        return;
    }
      if ($articleId)
      {
         $catids=$mapparams->get('filter_catid');
           if (($catids)&&in_array($article->catid,$catids))
           {
            
           }
           else
           {
            return;
           }
        $mapdata = JFactory::getApplication()->input->getArray();
        $mapdata['hours']=JFactory::getApplication()->input->post->get('hours',null,'RAW');
         $db = JFactory::getDBO();
        $sql = "select id from #__mymaplocations_location where component=" . $db->Quote('com_content') . "AND extra_id=" . $db->Quote($article->id);
        $db->setQuery($sql);
        $mapitem = $db->loadObject();
         if((!$mapdata['latitude'])||(!$mapdata['longitude']))
        {
            return;
        }
        if (!empty($mapitem->id)) {
            $mapdata['id'] = $mapitem->id;
        } else {
            unset($mapdata['id']);
        }
        $type = 'location';
        $prefix = 'MyMaplocationsTable';
        $config = array();
        $maptable = JTable::getInstance($type, $prefix, $config);
        if((!$mapdata['latitude'])||(!$mapdata['longitude']))
        {
            return true;
        }
        if (!empty($mapitem->id)) {
            $mapdata['id'] = $mapitem->id;
        } else {
            unset($mapdata['id']);
        }
        $mapdata['name'] = $article->id . '-' . $article->title;
        $mapdata['alias'] = $article->id . '-' . $article->title;
        $mapdata['catid'] = $mapdata['mapcatid'];
        $mapdata['component'] = 'com_content';
        $mapdata['extra_id'] = $article->id;
        $maptable->bind($mapdata);
        if (!$maptable->check()) {

            JFactory::getApplication()->enqueueMessage($maptable->getError(), 'error');
        }
        if (!$maptable->store()) {
            JFactory::getApplication()->enqueueMessage($maptable->getError(), 'error');
        }
      }
 
      return true;
   }
    function checkComponent() {
        if (class_exists('MyMapLocationsHelper'))
            return true;
        $helper = JPATH_SITE . '/components/com_mymaplocations/helpers/mymaplocations.php';
        if (file_exists($helper)) {
            require_once($helper);
            return true;
        }
        return false;
    }

}
