<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// Import Joomla plugin library
jimport('joomla.plugin.plugin');

/**
 * Editor Article buton
 *
 * @package		Joomla.Plugin
 * @subpackage	Editors-xtd.article
 * @since 1.5
 */
class plgButtonMyMaplocations extends JPlugin {

    /**
     * Constructor
     *
     * @access      protected
     * @param       object  $subject The object to observe
     * @param       array   $config  An array that holds the plugin configuration
     * @since       1.5
     */
    public function __construct(& $subject, $config) {
        parent::__construct($subject, $config);
        $this->loadLanguage();
    }

    /**
     * Display the button
     *
     * @return array A four element array of (article_id, article_title, category_id, object)
     */
    function onDisplay($name) {
        $app = JFactory::getApplication();
        if ($app->isClient('site')) {
            return;
        }

        /*
         * Javascript to insert the link
         * View element calls jSelectMedia when a media is clicked
         * jSelectMedia creates the link tag, sends it to the editor,
         * and closes the select frame.
         */
        $js = "
		function jSelectChart_jform_request_id(id) {
			var tag = '{mymaplocation id=\"'+id+'\"}';
			if (typeof Joomla.editors.instances['".$name."'] !== 'undefined') {
			window.parent.Joomla.editors.instances['".$name."'].replaceSelection(tag);
			if(typeof window.parent.Joomla.Modal!=='undefined')
			{
			window.parent.Joomla.Modal.getCurrent().close();
			}
			else
			{
			SqueezeBox.close();	
			}
		}
		else
		{
			window.parent.jInsertEditorText(tag, '".$name."');
			SqueezeBox.close();
			}
		}";
        $doc = JFactory::getDocument();
        $doc->addScriptDeclaration($js);

        
        $link = 'index.php?option=com_mymaplocations&view=locations&layout=modal&tmpl=component&component=com_mymaplocations&data=bulk&function=jSelectChart_jform_request_id';

        $button = new JObject;
        $button->modal = true;
        $button->class = 'btn';
        $button->link = $link;
        $button->icon    = 'file-add';
		$button->iconSVG = '<svg viewBox="0 0 32 32" width="24" height="24"><path d="M28 24v-4h-4v4h-4v4h4v4h4v-4h4v-4zM2 2h18v6h6v10h2v-10l-8-'
								. '8h-20v32h18v-2h-16z"></path></svg>';
        $button->text = JText::_('My Maps Location');
        $button->name = 'mymaplocations';
        $button->options = "{handler: 'iframe', size: {x: 800, y: 500}}";
        return $button;
    }

}
