<?php

/**
 * @version     4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

defined('_JEXEC') or die('Restricted access');
?>
<?php
jimport('joomla.form.form');
class plgHikamarketMymapLocations extends JPlugin {
	public function __construct(&$subject, $config) {
		parent::__construct($subject, $config);
	}

	public function onAfterVendorCreate(&$vendor) {
		$this->_insertMML($vendor);
			}

	public function onAfterVendorUpdate(&$vendor) {
		$this->_insertMML($vendor);
		}
	private function _insertMML($vendor)
	{
		$task=JFactory::getApplication()->input->getString('task');
		if($task=="vendor_published-".$vendor->vendor_id)
		{
			return;
		}
		$mapdata=array();
		$filename=JPATH_SITE . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_mymaplocations' . DIRECTORY_SEPARATOR . 'helpers' . DIRECTORY_SEPARATOR . 'mymaplocations.php';
		if (file_exists($filename)) {
			require_once($filename);
		}
		else
		{
			return;
		}
		
		JTable::addIncludePath(JPATH_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_mymaplocations' . DIRECTORY_SEPARATOR . 'tables');
		$vendor_address_column=$this->params->get('vendor_address_column');
		$vendor_city_column=$this->params->get('vendor_city_column');
		$vendor_state_column=$this->params->get('vendor_state_column');
		$vendor_country_column=$this->params->get('vendor_country_column');
		$vendor_zip_column=$this->params->get('vendor_zip_column');
		$db = JFactory::getDBO();
		$address="";
		if(!empty($vendor->$vendor_address_column))
		{
			$address.=$vendor->$vendor_address_column." ";
		}
	
		if(!empty($vendor->$vendor_city_column))
		{
			$address.=$vendor->$vendor_city_column." ";
		}
		if(!empty($vendor->$vendor_state_column))
		{
			$sql = "select zone_name_english from #__hikashop_zone where zone_namekey=" . $db->Quote($vendor->$vendor_state_column);
		$db->setQuery($sql);
		$state= $db->loadObject();
		if (!preg_match('/[^A-Za-z0-9]/', $state->zone_name_english)) // '/[^a-z\d]/i' should also work.
		{
		$address.=" ".$state->zone_name_english;
		}
		}
		if(!empty($vendor->$vendor_country_column))
		{
			
			$sql = "select zone_name_english from #__hikashop_zone where zone_namekey=" . $db->Quote($vendor->$vendor_country_column);
		$db->setQuery($sql);
		$country= $db->loadObject();
		$address.=" ".$country->zone_name_english;
		
		}
		if(!empty($vendor->$vendor_zip_column))
		{
			$address.=$vendor->$vendor_zip_column;
		}
		
		$geo=@MyMaplocationsHelper::getLatLongFromPostcode($address) ;
		
		$sql = "select id from #__mymaplocations_location where component=" . $db->Quote('com_hikamarket') . "AND extra_id=" . $db->Quote($vendor->vendor_id);
		$db->setQuery($sql);
		$mapitem = $db->loadObject();
		 if (!empty($mapitem->id)) {
		   $mapdata['id'] = $mapitem->id;
		} else {
		    unset($mapdata['id']);
		}
		$type = 'location';
	        $prefix = 'MyMaplocationsTable';
	        $config = array();
	        $table = JTable::getInstance($type, $prefix, $config);
		$mapdata['name'] = $vendor->vendor_id. '-' . $vendor->vendor_name;
		$mapdata['alias'] = $vendor->vendor_id . '-' . $vendor->vendor_name;
		$mapdata['component'] = 'com_hikamarket';
		$mapdata['extra_id'] = $vendor->vendor_id;
		$mapdata['latitude'] =$geo['lat'];
		$mapdata['longitude'] =$geo['lang'];	
		$table->bind($mapdata);
		if (!$table->check()) {
			JFactory::getApplication()->enqueueMessage($table->getError(), 'error');
		}
		if (!$table->store()) {
			JFactory::getApplication()->enqueueMessage($table->getError(), 'error');
		}
	}
	

}
