<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

jimport('joomla.language.helper');
use Joomla\Utilities\ArrayHelper;

class plgSystemMyMapLocations extends JPlugin {
    public $app;
    function onAfterInitialise()
    {
        $mainframe = JFactory::getApplication();
        $db = JFactory::getDBO();
        if ($mainframe->isClient('administrator')) {
             $option = JFactory::getApplication()->input->getString('option');
             $groupjive=JPATH_SITE . '/components/com_comprofiler/plugin/user/plug_cbgroupjive/cbgroupjive.xml';
            if((file_exists($groupjive)))
            {
                $session =JFactory::getSession();
                if (($option=="com_mymaplocations")) {
                    
               $cql="select * from #__modules where module='mod_cbadmin' AND client_id=1 AND published=1 AND position='menu'";
               $db->setQuery($cql);
                $result = $db->loadObject();
                if($result)
                {
                    $object = new stdClass();
                    $object->id = $result->id;
                    $object->published=0;
                    $res= JFactory::getDbo()->updateObject('#__modules', $object, 'id');
                    $session->set( 'com_mymaplocations.cbenabled', 'yes' );
                    JFactory::getApplication()->enqueueMessage(JText::_('Disable CB admin menu on this page to avoid conflict'));
                }
            }
            else
            {
                $value=$session->get( 'com_mymaplocations.cbenabled', 'empty' );
            
                 if($value=="yes")
                {
                    
                    $cql="select * from #__modules where module='mod_cbadmin' AND client_id=1 AND published=0 AND position='menu'";
                    $db->setQuery($cql);
                    $result = $db->loadObject();
                    if($result)
                    {
                    $object = new stdClass();
                    $object->id = $result->id;
                    $object->published=1;
                    $res = JFactory::getDbo()->updateObject('#__modules', $object, 'id');
                   $session->clear( 'com_mymaplocations.cbenabled' );
                    }
                }
            }
            }
        }
		
		 jimport('joomla.filesystem.folder');
        if ((JFolder::exists(JPATH_SITE . '/components/com_zoo'))) {
           
		   if (JComponentHelper::getComponent('com_zoo', true)->enabled) {
            jimport('joomla.filesystem.file');
		if (!JFile::exists(JPATH_ADMINISTRATOR.'/components/com_zoo/config.php') || !JComponentHelper::getComponent('com_zoo', true)->enabled) {
			return;
		}
		require_once(JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');

		// make sure App class exists
		if (!class_exists('App')) {
			return;
		}
				// Here are a number of events for demonstration purposes.
		// Have a look at administrator/components/com_zoo/config.php
		// and also at administrator/components/com_zoo/events/

		// Get the ZOO App instance
		$zoo = App::getInstance('zoo');
		// register event
		$zoo->event->dispatcher->connect('item:saved', array('plgSystemMyMapLocations', 'itemSaved'));
        }
		}
		return;

    }

    function onAfterRender() {
        $mainframe = JFactory::getApplication();

        $response = $mainframe->getBody();
        // Get data to replace
        $tag = 'mymaplocation';

        $app = JFactory::getApplication();
        $db = JFactory::getDBO();
        $option = JFactory::getApplication()->input->getString('option');
        $task = JFactory::getApplication()->input->getString('task');
        $width = null;
        $height = null;
        if ($mainframe->isClient('administrator')) {
            return;
        }
        if ($option == 'com_content' && $task == 'edit')
            return true;
        if (strpos($response, '{' . $tag . ' ') === false)
            return true;

        if (!$this->checkComponent())
            return true;
        $pattern = '#\{' . $tag . ' (.*?)}#i';
        if (preg_match_all($pattern, $response, $matches)) {

            $lang = JFactory::getLanguage();
            $lang->load('com_mymaplocations', JPATH_SITE);
            $mapid = "";
            $height = "";
            $width = "";
            $zoom = "";
            $type = "";
            foreach ($matches[0] as $i => $match) {
                $datas = explode(" ", $matches[1][$i]);
                foreach ($datas as $data) {
                    if (preg_match('|catid=|', $data)) {
                        $catid = (str_ireplace('catid=', '', $data));
                        $catid = explode(",", $catid);
                    }
                    else if (preg_match('|id=|', $data)) {
                        $id = (str_ireplace('id=', '', $data));
                        $mapid = explode(",", $id);
                    } else if (preg_match('|height=|', $data)) {
                        $height = (str_ireplace('height=', '', $data));
                    } else if (preg_match('|width=|', $data)) {
                        $width = (str_ireplace('width=', '', $data));
                    } else if (preg_match('|zoom=|', $data)) {
                        $zoom = (str_ireplace('zoom=', '', $data));
                    } else if (preg_match('|type=|', $data)) {
                        $type = (str_ireplace('type=', '', $data));
                    } 
                }
                 ArrayHelper::toInteger($mapid);
                // Create a new query object.
                $query = $db->getQuery(true);
                $query->select('*');
                $query->select('c.params as catparams');
                $query->from('#__mymaplocations_location as a');
                $query->join('LEFT', '#__categories AS c on c.id = a.catid');
                 if(@$catid)
                 {
                     ArrayHelper::toInteger($catid);
                    $query->where('a.catid IN (' . implode(',',$catid) . ')');
                 
                 }
                 else
                 {
                    ArrayHelper::toInteger($mapid);
                $query->where('a.id IN (' . implode(',', $mapid) . ')');
                 }
                 $query->order('a.ordering');
                $db->setQuery($query);
                $result = $db->loadObjectList();
                $searches = $matches[0][$i];
                if(count($result))
                {
                $replacements= MyMapLocationsHelper::CreateMap($result, $width, $height, $zoom, $type,false);
                }
                else
                {
                    $replacements="";
                }
                $response = str_ireplace($searches, $replacements, $response);
                $mainframe->setBody($response);
            }
        }
    }

    function checkComponent() {
        if (class_exists('MyMapLocationsHelper'))
            return true;

        $helper = JPATH_SITE . '/components/com_mymaplocations/helpers/mymaplocations.php';
        if (file_exists($helper)) {
            require_once($helper);
            return true;
        }

        return false;
    }
    public function itemSaved($event) {
		require_once(JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');
        $zoo = App::getInstance('zoo');
        $item = $event->getSubject();
		$postdata=JFactory::getApplication()->input->post->getArray();
        $citem=$zoo->table->item->get($item->id);
        
		jimport('joomla.form.form');
		JTable::addIncludePath(JPATH_ADMINISTRATOR .'/components/com_mymaplocations/tables');
		$db = JFactory::getDBO();
        $sql = "select id from #__mymaplocations_location where component=" . $db->Quote('com_zoo') . "AND extra_id=" . $db->Quote($item->id);
        $db->setQuery($sql);
        $mapitem = $db->loadObject();
        $type = 'location';
        $prefix = 'MyMaplocationsTable';
        $config = array();
        $table = JTable::getInstance($type, $prefix, $config);
        $mapdata = JFactory::getApplication()->input->post->getArray(array());
        if((!$mapdata['latitude'])||(!$mapdata['longitude']))
        {
            return;
        }
        if (!empty($mapitem->id)) {
            $mapdata['id'] = $mapitem->id;
        } else {
            unset($mapdata['id']);
        }
        $mapdata['name'] = $item->id . '-' . $citem->name;
        $mapdata['catid'] = $mapdata['mapcatid'];
        $mapdata['component'] = 'com_zoo';
        $mapdata['extra_id'] = $item->id;
        $table->bind($mapdata);
        if (!$table->check()) {

            JFactory::getApplication()->enqueueMessage($table->getError(), 'error');
        }
        if (!$table->store()) {
            JFactory::getApplication()->enqueueMessage($table->getError(), 'error');
        }
    }

}
