<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
defined('_JEXEC') or 	die( 'Direct Access to ' . basename( __FILE__ ) . ' is not allowed.' ) ;
if (!class_exists('vmCustomPlugin')) require(JPATH_VM_PLUGINS . DIRECTORY_SEPARATOR . 'vmcustomplugin.php');
require_once(JPATH_SITE .'/components/com_mymaplocations/helpers/mymaplocations.php');
JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_mymaplocations/tables');

class plgVmCustomMyMapLocations extends vmCustomPlugin {
	
	static $result = 0;
	static $product_id = 0;
	function __construct(& $subject, $config) {

		parent::__construct($subject, $config);
		$lang = JFactory::getLanguage();
		$lang->load('com_mymaplocations', JPATH_ADMINISTRATOR);
		
		parent::__construct($subject, $config);

		$varsToPush = array('description_view'=>array(1,'int'),
			'width'=>array('', 'string'),
			'height'=>array('', 'string'),
			'zoom'=>array(10,'int'),
			'type'=>array('google', 'string'),
			'map_design'=>array(1, 'int'),
			'google_maptype'=>array('', 'string'),
			'bing_maptype'=>array('', 'string'),			
			'openmapstyle'=>array('', 'string'),					
			
		);

		$this->setConfigParameterable('customfield_params',$varsToPush);
	}

	// get product param for this plugin on edit
	function plgVmOnProductEdit($field, $product_id, &$row,&$retValue) {
		if ($field->custom_element != $this->_name) return '';
		if (self::$result == 0) {
			self::$result = self::$result + 1;
		
		MyMaplocationsHelper::loadLanguage();
		$form = JForm::getInstance('form', JPATH_ADMINISTRATOR . '/components/com_mymaplocations/models/forms/location.xml');
		$component="com_virtuemart";
            $db = JFactory::getDBO();
            $sql = "select * from #__mymaplocations_location where component=" . $db->Quote('com_virtuemart') . "AND extra_id=" . $db->Quote($product_id);
            $db->setQuery($sql);
            $result = $db->loadObject();
            $html="";
			$task=JFactory::getApplication()->input->getString('task');
			if($task=="getData")
			{
				$html.="<style type='text/css'> #map{display:none}</style>";
			}
			if (!empty($result)) {
                $form->bind($result);
                $latlng = $result->latitude . "," . $result->longitude;
            } else {
                $latlng = "44.824708,-0.615234";
            }
		$html.='<div class="alert alert-success"  id="place_id_data" style="display:none;">
         <button type="button" class="close" data-dismiss="alert">&times;</button>
		 <div id="place_id_div"></div>
		</div>
        <div id="container_mml">
 <input id="postcode" style="width:250px;" autocomplete="off" type="text" class="search-query"/><input type="button" onclick="Geocode()" value="' . JTEXT::_("COM_MYMAPLOCATIONS_FORM_LBL_STORE_SEARCH") . '"  class="btn"/>
 </div>
 <span class="span12">
	<div class="navbar-form pull-left" >
	<label><span class="label">' . JTEXT::_("COM_MYMAPLOCATIONS_FORM_LBL_STORE_LATITUDE") . '</span></label>' . $form->getInput('latitude') . '
	</div>
							<div class="navbar-form pull-left" style="margin-bottom:10px;">
	<label><span class="label"> ' . JTEXT::_("COM_MYMAPLOCATIONS_FORM_LBL_STORE_LONGITUDE") . '</span></label>' . $form->getInput('longitude') . '
							</div>
							</span>
	<div id="map" style="width: 100%; height: 300px;max-width:450px;clear:both;"></div><table class="adminFormK2 table"><tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('address') . '</label></td>
									<td class="adminK2RightCol">
			' . $form->getInput('address') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>
                        ' . $form->getLabel('town') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('town') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('locationstate') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('locationstate') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('country') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('country') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol"><label>' . $form->getLabel('postal') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('postal') . '</td>
								</tr>
                                                            
			<input name="component" type="hidden" default="'.$component.'" />
								</table>
								
        </div>';
		if ((@$result->latitude)) {
                 $html.=MyMaplocationsHelper::getBackEndJs(false,$result->latitude ,$result->longitude,false);
                }
				else {
                 $html.=MyMaplocationsHelper::getBackEndJs(false,44.824708,-0.615234,false);
                }
		$html .='<input type="hidden" value="'.$field->virtuemart_custom_id.'" name="customfield_params['.$row.']['.$field->custom_element.'][virtuemart_custom_id]">';
		
		$retValue .= $html;
		}
		$row++;
		return true ;
	}
	
	function plgVmOnStoreProduct($data,$plugin_param){
		$mapdata = JFactory::getApplication()->input->getArray();
		if((!$mapdata['latitude'])||(!$mapdata['longitude']))
        {
            return;
        }
		$db = JFactory::getDBO();
        $sql = "select id from #__mymaplocations_location where component=" . $db->Quote('com_virtuemart') . " AND extra_id=" . $db->Quote($data['virtuemart_product_id']);
        $db->setQuery($sql);
        $mapitem = $db->loadObject();
		JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_mymaplocations/tables');
		$type = 'location';
        $prefix = 'MyMaplocationsTable';
        $config = array();
        $table = JTable::getInstance($type, $prefix, $config);
         if (!empty($mapitem->id)) {
            $mapdata['id'] = $mapitem->id;
        } else {
            unset($mapdata['id']);
        }
		$mapdata['name'] = $mapdata['virtuemart_product_id'] . '-' . $mapdata['product_name'];
        $mapdata['alias'] =$mapdata['virtuemart_product_id'] . '-' . $mapdata['product_name'];
        $mapdata['component'] = 'com_virtuemart';
        $mapdata['extra_id'] = $mapdata['virtuemart_product_id'];
		$mapdata['state']=1;
        $table->bind($mapdata);
        if (!$table->check()) {

            JFactory::getApplication()->enqueueMessage($table->getError(), 'error');
        }
        if (!$table->store()) {
            JFactory::getApplication()->enqueueMessage($table->getError(), 'error');
        }
	}

	function plgVmOnDisplayProductFEVM3(&$product,&$group) {
	
		if ($group->custom_element != $this->_name) return '';
			if (self::$product_id == 0) {
				self::$product_id=$product->virtuemart_product_id;
			@$this->getCustomParams($group);
		$group->display .= $this->renderByLayout('default',array(&$product,&$group) );
			}
		return true;
	}


	
	
	/**
	 * Declares the Parameters of a plugin
	 * @param $data
	 * @return bool
	 */
	function plgVmDeclarePluginParamsCustomVM3(&$data){

		return $this->declarePluginParams('custom', $data);
	}

	function plgVmGetTablePluginParams($psType, $name, $id, &$xParams, &$varsToPush){
		return $this->getTablePluginParams($psType, $name, $id, $xParams, $varsToPush);
	}

	function plgVmSetOnTablePluginParamsCustom($name, $id, &$table,$xParams){
		return $this->setOnTablePluginParams($name, $id, $table,$xParams);
	}

	/**
	 * Custom triggers note by Max Milbers
	 */
	function plgVmOnDisplayEdit($virtuemart_custom_id,&$customPlugin){
		return $this->onDisplayEditBECustom($virtuemart_custom_id,$customPlugin);
	}

	function plgVmOnSelfCallFE($type,$name,&$render) {
		$render->html = '';
	}

}

// No closing tag