<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
use Joomla\Utilities\ArrayHelper;
defined( '_JEXEC' ) or die( 'Restricted access' );

/** Adds support for Mymaplocations  to Xmap */
class xmap_com_mymaplocations
{
    private static $views = array('locations');
    private static $enabled = false;
    
    public static function getTree($xmap, $parent, $params)
    {
    
        $uri = new JUri($parent->link);
        if (!in_array($uri->getVar('view'), self::$views)) {
            return;
        }
       
        $params['groups'] = implode(',', JFactory::getUser()->getAuthorisedViewLevels());
        $params['include_location'] = ArrayHelper::getValue($params, 'include_location', 1);
        $params['include_location'] = ($params['include_location'] == 1 || ($params['include_location'] == 2 && $xmap->view == 'xml') || ($params['include_location'] == 3 && $xmap->view == 'html'));

        $params['priority'] = ArrayHelper::getValue($params, 'priority', $parent->priority);
        $params['changefreq'] = ArrayHelper::getValue($params, 'changefreq', $parent->changefreq);

        if ($params['priority'] == -1) {
            $params['priority'] = $parent->priority;
        }

        if ($params['changefreq'] == -1) {
            $params['changefreq'] = $parent->changefreq;
        }
        switch ($uri->getVar('view')) {
            case 'locations':
                
                self::getLocationsTree($xmap, $parent, $params, $uri->getVar('catid', 0));
                break;
        }
    }

    private static function getLocationsTree($xmap, $parent, $params, $cat_id)
    {
        
        require_once(JPATH_SITE . '/components/com_mymaplocations/helpers/mymaplocations.php');
        $uri = new JUri($parent->link);
        $db = JFactory::getDbo();
		$nullDate = $db->getNullDate();
		$now = JFactory::getDate()->toSql();
        $query = $db->getQuery(true)
            ->select('s.*')
            ->from('#__mymaplocations_location AS s')
            ->where('s.state = 1');
            $lang = JFactory::getLanguage();
		$query->where( '( s.language LIKE \'' . $lang->getTag() .'\' OR s.language = \'*\' )');
		$query->where(' ( s.component = ' . $db->quote('com_mymaplocations') . ' OR s.component=' . $db->quote("") . ') ');
        
	    $db->setQuery($query);
        $rows = $db->loadObjectList();
        
        if (empty($rows)) {
            return;
        }
        
        $xmap->changeLevel(1);
        foreach ($rows as $row) {
            $node = new stdclass;
            $node->id = $parent->id;
            $node->name = $row->name;
            $node->uid = $parent->uid . '_tid_' . $row->id;
            $node->browserNav = $parent->browserNav;
            $node->priority = $params['priority'];
            $node->changefreq = $params['changefreq'];
            $node->pid = $parent->id;
            $node->componenet="com_mymaplocations";
            // workaround
            $url= MyMaplocationsHelper::getUrlLink($row);
            $node->link=$url;          
            $xmap->printNode($node);
        }

        $xmap->changeLevel(-1);
    }
    
}
?>