<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// No direct access
defined('_JEXEC') or die;

/**
 * MyMaplocations helper.
 */
$option=JFactory::getApplication()->input->getString('option');
if((($option=="com_categories"))||(($option=="com_fields")))
{
	  if (version_compare(JVERSION, '4.0', 'ge'))
				{}else{
	class MyMaplocationsHelper extends JHelperContent {
		 /**
     * Configure the Linkbar.
     */
    public static function addSubmenu($vName) {
        JHtmlSidebar::addEntry(
                JText::_('COM_MYMAPLOCATIONS_TITLE_STORES'), 'index.php?option=com_mymaplocations&view=locations', $vName == 'locations'
        );
        JHtmlSidebar::addEntry(
                JText::_('JCATEGORY'), 'index.php?option=com_categories&extension=com_mymaplocations', $vName == 'categories'
        );
        JHtmlSidebar::addEntry(
                JText::_('COM_MYMAPLOCATIONS_EXPORTIMPORT'), 'index.php?option=com_mymaplocations&view=locations&view=import', $vName == 'import'
        );

        JHtmlSidebar::addEntry(
                JText::_('COM_MYMAPLOCATIONS_CONFIGURATION'), 'index.php?option=com_config&view=component&component=com_mymaplocations', $vName == 'configuration'
        );
		  
        JHtmlSidebar::addEntry(
                JText::_('COM_MYMAPLOCATIONS_REPORT'), 'index.php?option=com_mymaplocations&view=statistics', $vName == 'report'
        );
		  
        if ($vName == 'categories') {
            JToolBarHelper::title(
                    JText::sprintf('COM_CATEGORIES_CATEGORIES_TITLE', JText::_('com_mymaplocations')), 'mymaplocations-categories');
        }
		if (JComponentHelper::isEnabled('com_fields'))
		{
			JHtmlSidebar::addEntry(
			JText::_('JGLOBAL_FIELDS'),
			'index.php?option=com_fields&context=com_mymaplocations.location',
			$vName == 'fields.fields'
		);
		JHtmlSidebar::addEntry(
		JText::_('JGLOBAL_FIELD_GROUPS'),
		'index.php?option=com_fields&view=groups&context=com_mymaplocations.location',
		$vName == 'fields.groups'
	);
	}
    }

	}
}
}
else
{
	
class MyMaplocationsBackendHelper extends JHelperContent {
    
            /**
	 * @var    JObject  A cache for the available actions.
	 * @since  1.6
	 */
	protected static $actions;

    /**
     * Configure the Linkbar.
     */
    public static function addSubmenu($vName) {
        JHtmlSidebar::addEntry(
                JText::_('COM_MYMAPLOCATIONS_TITLE_STORES'), 'index.php?option=com_mymaplocations&view=locations', $vName == 'locations'
        );
        JHtmlSidebar::addEntry(
                JText::_('JCATEGORY'), 'index.php?option=com_categories&extension=com_mymaplocations', $vName == 'categories'
        );
        JHtmlSidebar::addEntry(
                JText::_('COM_MYMAPLOCATIONS_EXPORTIMPORT'), 'index.php?option=com_mymaplocations&view=locations&view=import', $vName == 'import'
        );

        JHtmlSidebar::addEntry(
                JText::_('COM_MYMAPLOCATIONS_CONFIGURATION'), 'index.php?option=com_config&view=component&component=com_mymaplocations', $vName == 'configuration'
        );
		  
        JHtmlSidebar::addEntry(
                JText::_('COM_MYMAPLOCATIONS_REPORT'), 'index.php?option=com_mymaplocations&view=statistics', $vName == 'report'
        );
		  
        if ($vName == 'categories') {
            JToolBarHelper::title(
                    JText::sprintf('COM_CATEGORIES_CATEGORIES_TITLE', JText::_('com_mymaplocations')), 'mymaplocations-categories');
        }
		if (JComponentHelper::isEnabled('com_fields'))
		{
			JHtmlSidebar::addEntry(
			JText::_('JGLOBAL_FIELDS'),
			'index.php?option=com_fields&context=com_mymaplocations.location',
			$vName == 'fields.fields'
		);
		JHtmlSidebar::addEntry(
		JText::_('JGLOBAL_FIELD_GROUPS'),
		'index.php?option=com_fields&view=groups&context=com_mymaplocations.location',
		$vName == 'fields.groups'
	);
	}
    }

    /**
     * Gets a list of the actions that can be performed.
     *
     * @return	JObject
     * @since	1.6
     */
    public static function getActions($component = '', $section = '', $id = 0) {
        
        if (empty(self::$actions))
		{
			$user = JFactory::getUser();
			self::$actions = new JObject;

			$actions = JHelperContent::getActions('com_mymaplocations');

			foreach ($actions as $name=>$action)
			{
				self::$actions->set($name, $user->authorise($name, 'com_mymaplocations'));
			}
		}

		return self::$actions;
    }
    
    public static function getLastExtensionVersion($extension=null){
        if($extension===null){
            $extension = JFactory::getApplication()->input->getString('option', '');
        }
        if (ini_get("allow_url_fopen") == 1) {
            $content = file_get_contents('http://www.joomunited.com/UPDATE-INFO/updates.json');
        }else{
           
            return false;
        }
        $json = json_decode($content);
        
        return $json->extensions->$extension->version;       
   }
   
   /**
    * Return the extension version
    * @param string $extension
    * @param string $type
    * @return string version or false
    */
   public static function getExtensionVersion($extension=null,$type=''){
        if($extension===null){
             $extension = JFactory::getApplication()->input->getString('option', '');
        }
        $db = JFactory::getDbo();
        $query = 'SELECT manifest_cache FROM #__extensions WHERE element='.$db->quote($extension);

        if($type!=''){
            $query.=' AND type='.$db->quote($type);
        }
        $db->setQuery($query);
        if($db->execute()){
            $manifest = $db->loadResult();
            $json = json_decode($manifest);
            if(property_exists($json, 'version')){
                return $json->version;
            }
        }
        return false;
   }
	public static function getReportChart($cal_event_date,$cal_event_enddate,$component)
	{
		$db=JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('SUM(hits) as count,updated');
		$query->from($db->quoteName('#__mymaplocations_statistics'));
		$query->where('DATE(updated) >='. $db->quote($cal_event_date) );
		$query->where('DATE(updated) <='.$db->quote($cal_event_enddate));
		$query->group('month,year');
		$query->order('updated asc');
		$db->setQuery($query);
	   $result_data = $db->loadObjectList();
      return $result_data;     
	}
	public static function getExtensionData($data)
	{
		
		$db=JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select("DISTINCT extension");
		$query->from($db->quoteName('#__mymaplocations_statistics'));
		$db->setQuery($query);
      $rows = $db->loadObjectList();
		$html="";
		$html .= '<select id="component" class="form-select" name="filter_component">';
            foreach ($rows as $row) {
					$component=$row->extension;
					if($component=="com_mymaplocations")
					{
						$text="My Map Locations";
					}
					else if($component=="com_k2")
					{
						$text="K2 Component";
					}
					else if($component=="com_content")
					{
						$text="Joomla Article/Flexicontent";
					}
					else if($component=="com_easyblog")
					{
						$text="Easy Blog";
					}
					else if($component=="com_zoo")
					{
						$text="Zoo";
					}
					else if($component=="com_community")
					{
						$text="Joomsocial";
					}
					else if($component=="com_comprofiler")
					{
						$text="Community Builder";
					}
					else if($component=="com_easysocial")
					{
						$text="Easy Social";
					}
					else if($component=="com_hikamarket")
					{
						$text="Hika Market Product";
					}
					else if($component=="com_hikashop")
					{
						$text="Hika Market Vendor";
					}
					else if($component=="com_adsmanager")
					{
						$text="Adsmanager";
					}else if($component=="com_djclassifieds")
					{
						$text="DJ Classifieds";
					}else if($component=="com_jomclassifieds")
					{
						$text="Joom Classified";
					}else if($component=="com_mytestimonials")
					{
						$text="My Testimonials";
					}else if($component=="com_ohanah")
					{
						$text="Ohanah Upcoming Event";
					}else if($component=="com_eventbooking")
					{
						$text="Event Booking Upcoming Events";
					}else if($component=="com_custom")
					{
						$text="Custom Component";
					}
					else
					{
						$text=$component;
					}
                $html .= '<option value="' .$row->extension . '" ';
                if ($data == $row->extension)
                    $html .= 'selected';
                $html .= '>' .$text  . '</option>';
            }
            $html .= '</select>';
      return $html;     
	}
   public static function getNearLocations($zip)
	{
		$db=JFactory::getDbo();
		$query = $db->getQuery(true);
		 $params = JComponentHelper::getParams('com_mymaplocations');
            $type = $params->get('distance_type', 1);
            if ($type == 1) {
                $distance = 3959;
            } else {
                $distance = 6371;
            }
           
		 $query->select( " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( a.latitude ) ) * cos( radians( a.longitude ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( a.latitude ) ) ) ) AS distance ");
                $query->select('a.*');
					$query->from('`#__mymaplocations_location` AS a');
					$query->where('a.state=1');
					$query->where(' ( a.component = ' . $db->quote('com_mymaplocations') . ' OR a.component=' . $db->quote("") . ') ');
					$query->order('distance');
					$db->setQuery($query,0,10);
					$rows = $db->loadObjectList();
               return $rows;
		
	}
    public static function loadLanguage() {
            $lang = JFactory::getLanguage();
            $lang->load('com_mymaplocations',JPATH_ADMINISTRATOR.'/components/com_mymaplocations',null, true );
            $lang->load('com_mymaplocations.override',JPATH_ADMINISTRATOR.'/components/com_mymaplocations',null, true );
            $lang->load('com_mymaplocations.sys',JPATH_ADMINISTRATOR.'/components/com_mymaplocations',null, true );
        }
		  public static function checkCms()
			{
       if (version_compare(JVERSION, '4.0', 'ge'))
				{
					return true;
                }
            else
            {
            return false;
            }
        
        }
}
}
