<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

/**
 * Supports an HTML select list of categories
 */
class JFormFieldMapHelper extends JFormField {

    /**
     * The form field type.
     *
     * @var		string
     * @since	1.6
     */
    protected $type = 'maphelper';

    /**
     * Method to get the field input markup.
     *
     * @return	string	The field input markup.
     * @since	1.6
     */
    protected function getInput() {
        // Initialize variables.
		$component=JFactory::getApplication()->input->get('option');
		$id=JFactory::getApplication()->input->getInt('id',0);
        $catscript = " var mycatid = new Array();";
        $n = 0;
        $html = "";
        $found = false;
        $script="";
		 $result =new stdClass();
            $lang = JFactory::getLanguage();
            $extension = 'com_mymaplocations';
            $lang->load($extension, JPATH_ADMINISTRATOR);
            $form = JForm::getInstance('form', JPATH_ADMINISTRATOR . '/components/com_mymaplocations/models/forms/locationcontent.xml');
				if($id!=0)
				{
					$db = JFactory::getDBO();
            $sql = "select * from #__mymaplocations_location where component=" . $db->Quote($component) . "AND extra_id=" . $db->Quote($id);
            $db->setQuery($sql);
            $result = $db->loadObject();
				}
				
			if ((@$result->latitude)) {
				$form->bind($result);
                $latlng = $result->latitude . "," . $result->longitude;
            } else {
                $latlng = "44.824708,-0.615234";
            }
			$params=JComponentHelper::getParams('com_mymaplocations');
			$googleapi=$params->get('googleapi','AIzaSyDyJXSfY3iyCQCku7oKqFiZMOV6aFXQxls');
			if(!$googleapi)
			{
				JFactory::getApplication()->enqueueMessage( JText::_('COM_MYMAPLOCATIONS_MAP_ERROR'), 'error');
			}
			$key="";
			if($googleapi){
				$key='&amp;key='.$googleapi;
			}
           

        $document = JFactory::getDocument();
        $document->addStyleSheet(JURI::root() . '/components/com_mymaplocations/assets/css/materialize.css');
            require_once  (JPATH_SITE.'/components/com_mymaplocations/helpers/mymaplocations.php'); 
            if(method_exists('MyMapLocationsHelper','getBackEndJs'))
               {
                  if ((@$result->latitude)) {
                 MyMaplocationsHelper::getBackEndJs(false,$result->latitude ,$result->longitude);
                } else {
                 MyMaplocationsHelper::getBackEndJs(false);
                              }
               }else {
            JHtml::_('jquery.framework'); 
         $script = <<<EOF
                 <script src="//maps.google.com/maps/api/js?libraries=places<?php if($googleapi){ echo '&amp;key='.$googleapi;}?>" type="text/javascript"></script>
         <script src="components/com_mymaplocations/assets/site.js" type="text/javascript"></script>
            <script type="text/javascript">
               /* <![CDATA[ */
                var latlng = new google.maps.LatLng($latlng);
                   var options = {
                       zoom: 5,
                       center: latlng,
                       mapTypeId: google.maps.MapTypeId.ROADMAP,
                       draggableCursor: "crosshair",
                       streetViewControl: false
                   };
               var map = new google.maps.Map(document.getElementById("map"), options);
               var marker = new google.maps.Marker({
               position: latlng,
               map: map
               });
               
                   
                   jQuery("#zoom").html(5);
                   google.maps.event.addListener(map,"click", function(location)
                   {
                       GetlocationInfo(location.latLng);
                   });
                   google.maps.event.addListener(map,'zoom_changed', function(oldLevel, newLevel)
                   {
                       jQuery("#zoom").html(map.getZoom());
                   });
                   var myPano = new google.maps.StreetViewPanorama(document.getElementById("pano"),
                   { visible:false});
                   myPano.setPov({
                       heading: 265,
                       zoom:1,
                       pitch:0});
                   jQuery('#pano').hide();
                   google.maps.event.trigger(myPano, 'resize');
               
                   // autocomplete
                   var autocomplete = new google.maps.places.Autocomplete(document.getElementById('postcode'), {});
                   google.maps.event.addListener(autocomplete, 'place_changed', function() {
                       jQuery("#locations").html("");
                       jQuery("#error").html("");
                       var place = autocomplete.getPlace();
               if (place.place_id ) {
                       jQuery("#place_id_data").show();
               jQuery("#place_id").html("We have found Google Place <a href='"+place.url+"' class='btn btn-primary' target='_blank'>"+place.name+"</a> linked with data.Click here to copy data directly to our fields from Google places API  <input type='button' class='btn btn-inverse' value='insert' onclick='insertGooglePlaces()'/>");
               }
                       Gotolocation(place.geometry.location);
                   });
               
                   var initListener;
                   var marker;
                   function StartStreetView() {
                       // street view
                       if (jQuery("#streetViewBtn").val() == "Start StreetView") {
                           initListener = google.maps.event.addListener(myPano, "position_changed", handlePanoMove);
                           jQuery('#pano').show();
                           myPano.setVisible(true);
                           jQuery("#streetViewBtn").val("End StreetView");
                           google.maps.event.trigger(myPano, 'resize');
                           GotoLatLong();
                       }
                       else {
                           google.maps.event.removeListener(initListener);
                           myPano.setVisible(false);
                           jQuery('#pano').hide();
                           jQuery("#streetViewBtn").val("Start StreetView");
                           google.maps.event.trigger(myPano, 'resize');
                       }
                   }
               function GeocodeLatlang()
               {
               var localSearch = new google.maps.Geocoder();
               var clat=jQuery("#jform_latitude").val();
               var clang=jQuery("#jform_longitude").val();
               var latlng = new google.maps.LatLng(clat,clang);
               localSearch.geocode({ 'location': latlng },
                       function(results, status) {
                           if (results.length) {
                               var result = results[0];
                               var location = result.geometry.location;
                               Gotolocation(location);
                           }
                           else {
                               jQuery("#error").html("Address not found");
                           }
               
               
               });	
               }
                   function Geocode()
                   {
                       jQuery("#locations").html("");
                       jQuery("#error").html("");
                       var place = autocomplete.getPlace();
               if(typeof place === 'undefined'){
                        var localSearch = new google.maps.Geocoder();
                       var postcode = jQuery("#postcode").val();
                       localSearch.geocode({ 'address': postcode },
                       function(results, status) {
                           if (results.length == 1) {
                               var result = results[0];
                               var location = result.geometry.location;
                               Gotolocation(location);
                           }
                           else if (results.length > 1) {
                               jQuery("#error").html("Multiple addresses found");
                               // build a list of possible addresses
                               var html = "";
                               for (var i=0; i<results.length; i++) {
                                   html += '<a href="javascript:Gotolocation(new google.maps.LatLng(' + 
                                       results[i].geometry.location.lat() + ', ' + results[i].geometry.location.lng() + '))">' + 
                                       results[i].formatted_address + "</a><br/>";
                               }
                               jQuery("#locations").html(html);
                           }
                           else {
                               jQuery("#error").html("Address not found");
                           }
                       });	
               }
               else
               {
               if (place.place_id ) {
               
                       jQuery("#place_id_data").show();
               jQuery("#place_id").html("We have found Google Place <a href='"+place.url+"' class='btn btn-primary' target='_blank'>"+place.name+"</a> linked with data.Click here to copy data directly to our fields from Google placs API  <input type='button' class='btn btn-inverse' value='insert' onclick='insertGooglePlaces()'/>");
               }
               Gotolocation(place.geometry.location);
               }
                       
                   }
                   function useGeocode()
                   {
                       if (navigator.geolocation)
                       {
                           navigator.geolocation.getCurrentPosition(showPosition);
                       }
                       else
                       {
                           x.innerHTML="Geolocation is not supported by this browser.";
                       }
                   }
                   function showPosition(position)
                   {
                       document.getElementById('jform_latitude').value= position.coords.latitude;
                       document.getElementById('jform_longitude').value=position.coords.longitude;
                       ReverseGeocode(position.coords.latitude, position.coords.longitude, '#address');
                       Gotolocation(new google.maps.LatLng( position.coords.latitude, position.coords.longitude));
                   }
               
                   function Gotolocation(location) {
                       GetlocationInfo(location);
                       map.setCenter(location);
                   }
               
                   function GetlocationInfo(latlng)
                   {
                       if (latlng != null)
                       {
                           ShowLatLong(latlng);
                           UpdateStreetView(latlng);
                       }
                   }
               
                   function GotoLatLong()
                   {
                       if (jQuery("#jform_latitude").val() != "" && jQuery("#jform_longitude").val() != "") {
                           var lat = jQuery("#jform_latitude").val();
                           var long = jQuery("#jform_longitude").val();
                           var latLong = new google.maps.LatLng(lat, long);
                           ShowLatLong(latLong);
                           map.setCenter(latLong);
                           UpdateStreetView(latLong);
                       }
                   }
               
                   function ShowLink(){
                       jQuery("#mapLink").html('<a href="https://maps.google.com/?ll=' + jQuery("#jform_latitude").val() +
                           ',' + jQuery("#jform_longitude").val() + '&z=' + jQuery("#zoom").html() + '">Link for this map</a>');
                   }
               
                   function toDMS(latOrLng) {
                       var d = parseInt(latOrLng);
                       var md = Math.abs(latOrLng - d) * 60;
                       var m = Math.floor(md);
                       var sd = (md - m) * 60;
                       return Math.abs(d) + "\u00B0 " + m + "' " + roundNumber(sd, 4) + '"';
                   }
               
                   function latToDMS(lat) {
                       var dms = toDMS(lat);
                       if (lat > 0)
                           return dms + "N";
                       else
                           return dms + "S";
                   }
               
                   function lngToDMS(lng) {
                       var dms = toDMS(lng);
                       if (lng > 0)
                           return dms + "E";
                       else
                           return dms + "W";
                   }
               
                   function ShowLatLong(latLong)
                   {
                       // show the lat/long
                       if (marker != null) {
                           marker.setMap(null);
                       }
                       marker = new google.maps.Marker({
                           position: latLong,
                           map: map});
                       jQuery("#jform_latitude").val(roundNumber(latLong.lat(), 6));
                       jQuery("#jform_longitude").val(roundNumber(latLong.lng(), 6));
                       jQuery("#latDMS").html(latToDMS(latLong.lat()));
                       jQuery("#lngDMS").html(lngToDMS(latLong.lng()));
                       ShowLink();
                       GetElevation(latLong.lat(), latLong.lng(), '#elevation');
                       ReverseGeocode(latLong.lat(), latLong.lng(), '#address');
               
                   }
               
                   function UpdateStreetView(latLong)
                   {
                       // street view
                       if (jQuery("#streetViewBtn").val() == "End StreetView") {
                           jQuery("#panoError").html("");
                           myPano.setVisible(true);
                           myPano.setPosition(latLong);
                           // also set via the service API so we know if there is a view available
                           var service = new google.maps.StreetViewService();
                           service.getPanoramaBylocation(latLong, 50,
                           function(result, status) {
                               if (status != google.maps.StreetViewStatus.OK) {
                                   jQuery("#panoError").html("No street view available");
                                   myPano.setVisible(false);
                               }
                           }
                       );
                       }
                   }
               
                   function handlePanoMove(location)
                   {
                       ShowLatLong(myPano.getPosition());
                   }
                   function copyData()
                   {
                       var lat=document.getElementById('lat').value;
                       var long=document.getElementById('long').value;
                       document.getElementById('jform_latitude').value=lat;
                       document.getElementById('jform_longitude').value=long;
                   }
               function insertGooglePlaces() {
                       //code
               var place = autocomplete.getPlace();
               document.getElementById('jform_place_id').value=place.place_id;
               document.getElementById('jform_name').value=place.name;
               document.getElementById('jform_alias').value="";
               if (typeof place.international_phone_number !== 'undefined') {
               document.getElementById('jform_phone').value=place.international_phone_number;
               }else
               {
               document.getElementById('jform_phone').value="";
               }
               if (typeof place.website !== 'undefined') {
               document.getElementById('jform_contactlink').value=place.website;
               }else
               {
               document.getElementById('jform_contactlink').value="";
               }
               document.getElementById('jform_hours').value="";
               if (typeof place.types !== 'undefined') {
               document.getElementById('jform_metakey').value=place.types;
               }else
               {
               document.getElementById('jform_metakey').value="";
               }
            }
                   /* ]]> */
            </script>
                
                
EOF;
               }
           $script.="
<script type='text/javascript'>
jQuery('#catid').change(function() {
       var selectedValue =  jQuery(this).val();
       $catscript
       var data = mycatid.indexOf(selectedValue);
   
	});
    </script>
    ";
            $html.='<style type="text/css">
	  
	  .adminFormK2.table  th,.adminFormK2.table  td
	  {
		border:none;
	  }
	  #mapcatid_chzn,.catid .chzn-drop
	  {
	    min-width:120px;
	  }
	  #attrib-mymaplocation .controls
	  {
		margin-left:20px;
	  }
	  </style><div id="ju-form" class="main-card">
	  <div class="span12 uk-grid container-fluid row" id="location-form"><div class="span6 uk-width-1-2 col-md-6"><table class="adminFormK2 table">
			<tbody><tr style="display:none;">
			<td class="adminK2LeftCol block_catid"><label>' . $form->getLabel('catid') . '</label></td>
									<td class="adminK2RightCol catid">
			' . str_replace('catid', 'mapcatid', $form->getInput('catid')) . '</td>
								</tr>
								<tr>
			<td class="adminK2LeftCol block_logo"><label>' . $form->getLabel('logo') . '</label></td>
									<td class="adminK2RightCol">
				' . $form->getInput('logo') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol  block_icon"><label>' . $form->getLabel('icon') . '
				</label></td>
			<td class="adminK2RightCol">' . $form->getInput('icon') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol block_contactlink"><label>' . $form->getLabel('contactlink') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('contactlink') . '</td>
								</tr>
			<tr>
                            <td class="adminK2LeftCol  block_phone"><label>' . $form->getLabel('phone') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('phone') . '</td>
								</tr><tr>
                            <td class="adminK2LeftCol  block_hours"><label>' . $form->getLabel('hours') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('hours') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol  block_place"><label>' . $form->getLabel('place_id') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('place_id') . '</td>
								
							</tr></table></div><div class="span6 uk-width-1-2 col-md-6">
	<div class="alert alert-success"  id="place_id_data" style="display:none;">
         <button type="button" class="close" data-dismiss="alert">&times;</button>
		 <div id="place_id_div"></div>
		</div>
        <div id="container_mml">
 <input id="postcode" style="width:250px;" autocomplete="off" type="text" class="search-query"/><input type="button" onclick="Geocode()" value="' . JTEXT::_("COM_MYMAPLOCATIONS_FORM_LBL_STORE_SEARCH") . '"  class="btn"/>
 </div>
 <span class="span12">
	<div class="navbar-form pull-left" >
	<label><span class="label">' . JTEXT::_("COM_MYMAPLOCATIONS_FORM_LBL_STORE_LATITUDE") . '</span></label>' . $form->getInput('latitude') . '
	</div>
							<div class="navbar-form pull-left" style="margin-bottom:10px;">
	<label><span class="label"> ' . JTEXT::_("COM_MYMAPLOCATIONS_FORM_LBL_STORE_LONGITUDE") . '</span></label>' . $form->getInput('longitude') . '
							</div>
							</span>
	<div id="map" style="width: 100%; height: 300px;max-width:450px;clear:both;"></div>' . $script . '<table class="adminFormK2 table"><tr>
                            <td class="adminK2LeftCol block_address"><label>' . $form->getLabel('address') . '</label></td>
									<td class="adminK2RightCol">
			' . $form->getInput('address') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol  block_town"><label>
                        ' . $form->getLabel('town') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('town') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol   block_state"><label>' . $form->getLabel('locationstate') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('locationstate') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol  block_country"><label>' . $form->getLabel('country') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('country') . '</td>
								</tr>
								<tr>
                            <td class="adminK2LeftCol   block_postal"><label>' . $form->getLabel('postal') . '</label></td>
			<td class="adminK2RightCol">
			' . $form->getInput('postal') . '</td>
								</tr>
                                                            
			<input name="component" type="hidden" default="'.$component.'" />
								</table>
								
        </div></div></div>';

        return $html;
    }
     protected function getLabel() {
        
            return;
    }


}