<?php

/**
 * @copyright	Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license		http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
defined('JPATH_BASE') or die;
use Joomla\CMS\Language\LanguageHelper;
/**
 * Supports a modal contact picker.
 *
 * @package		Joomla.Administrator
 * @subpackage	com_mymaplocations
 * @since		1.6
 */
class JFormFieldModal_location extends JFormField {

    /**
     * The form field type.
     *
     * @var		string
     * @since	1.6
     */
    protected $type = 'Modal_location';

    /**
     * Method to get the field input markup.
     *
     * @return	string	The field input markup.
     * @since	1.6
     */
    protected function getInput() {
        $allowClear     = ((string) $this->element['clear'] != 'true');
		$allowSelect    = ((string) $this->element['select'] != 'true');

		$languages = LanguageHelper::getContentLanguages(array(0, 1));

		// Load language
		JFactory::getLanguage()->load('com_mytestimonials', JPATH_ADMINISTRATOR);

		// The active map id field.
		$value = (int) $this->value > 0 ? (int) $this->value : '';

		// Create the modal id.
		$modalId = 'Location_' . $this->id;

		if (version_compare(JVERSION, '4.0', 'ge'))
		{
		$wa = JFactory::getApplication()->getDocument()->getWebAssetManager();
		// Add the modal field script to the document head.
		$wa->useScript('field.modal-fields');
		}
		else
		{
		// Add the modal field script to the document head.
		JHtml::_('jquery.framework');
		JHtml::_('script', 'system/modal-fields.js', array('version' => 'auto', 'relative' => true));	
		}
		// Script to proxy the select modal function to the modal-fields.js file.
		if ($allowSelect)
		{
			static $scriptSelect = null;

			if (is_null($scriptSelect))
			{
				$scriptSelect = array();
			}

			if (!isset($scriptSelect[$this->id]))
			{
				JFactory::getDocument()->addScriptDeclaration("
				function jSelectLocation_" . $this->id . "(id, title, object) {
					window.processModalSelect('Location', '" . $this->id . "', id, title, '', object);
				}
				");

				JText::script('JGLOBAL_ASSOCIATIONS_PROPAGATE_FAILED');

				$scriptSelect[$this->id] = true;
			}
		}

		// Setup variables for display.
		$linkmaplocations = 'index.php?option=com_mymaplocations&amp;view=locations&amp;layout=modal&amp;tmpl=component'
			. '&amp;function=jSelectLocation_' . $this->id;
		$modalTitle   = JText::_('map');

		if (isset($this->element['language']))
		{
			$linkMaplocations .= '&amp;forcedLanguage=' . $this->element['language'];
			$modalTitle     .= ' &#8212; ' . $this->element['label'];
		}

		
		

		if ($value)
		{
			$db = JFactory::getDBO();
        $db->setQuery(
                'SELECT name' .
                ' FROM #__mymaplocations_location' .
                ' WHERE id = ' . (int) $this->value
        );
		try
			{
				$title = $db->loadResult();
			}
			catch (RuntimeException $e)
			{
				JFactory::getApplication()->enqueueMessage($e->getMessage());
			}
		}

		$title = empty($title) ? JText::_('COM_MYMAPLOCATIONS_SELECT_AN_STOREID') : htmlspecialchars($title, ENT_QUOTES, 'UTF-8');

		// The current map display field.
		$html  = '<span class="input-append input-group">';
		$html .= '<input class="input-medium" id="' . $this->id . '_name" type="text" value="' . $title . '" disabled="disabled" size="35" />';

		// Select map button
		if ($allowSelect)
		{
			$html .= '<button'
				. ' type="button"'
				. ' class="btn btn btn-primary hasTooltip' . ($value ? ' hidden' : '') . '"'
				. ' id="' . $this->id . '_select"'
				. ' data-toggle="modal"'
				. ' data-bs-toggle="modal"'
				. ' data-bs-target="#ModalSelect' . $modalId . '"'
				. ' data-target="#ModalSelect' . $modalId . '"'
				. ' title="' . JHtml::tooltipText('Select Location') . '">'
				. '<span class="icon-file" aria-hidden="true"></span> ' . JText::_('JSELECT')
				. '</button>';
		}

		
		// Clear map button
		if ($allowClear)
		{
			$html .= '<button'
				. ' type="button"'
				. ' class="btn btn btn-primary' . ($value ? '' : ' hidden') . '"'
				. ' id="' . $this->id . '_clear"'
				. ' onclick="window.processModalParent(\'' . $this->id . '\'); return false;">'
				. '<span class="icon-remove" aria-hidden="true"></span>' . JText::_('JCLEAR')
				. '</button>';
		}

		
		$html .= '</span>';

		// Select map modal
		if ($allowSelect)
		{
			$html .= JHtmlBootstrap::renderModal(
				'ModalSelect' . $modalId,
				array(
					'title'       => $modalTitle,
					'url'         => $linkmaplocations,
					'height'      => '400px',
					'width'       => '800px',
					'bodyHeight'  => '70',
					'modalWidth'  => '80',
					'footer'      => '<button type="button" class="btn" data-dismiss="modal">' . JText::_('JLIB_HTML_BEHAVIOR_CLOSE') . '</button>',
				)
			);
		}

		// Note: class='required' for client side validation.
		$class = $this->required ? ' class="required modal-value"' : '';

		$html .= '<input type="hidden" id="' . $this->id . '_id"' . $class . ' data-required="' . (int) $this->required . '" name="' . $this->name
			. '" data-text="' . htmlspecialchars(JText::_('Select map', true), ENT_COMPAT, 'UTF-8') . '" value="' . $value . '" />';

		return $html;
    }

}
