<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * MyMaplocations model.
 */
class MyMaplocationsModellocation extends JModelAdmin {

    /**
     * @var		string	The prefix to use with controller messages.
     * @since	1.6
     */
    protected $text_prefix = 'COM_MYMAPLOCATIONS';

    /**
     * Returns a reference to the a Table object, always creating it.
     *
     * @param	type	The table type to instantiate
     * @param	string	A prefix for the table class name. Optional.
     * @param	array	Configuration array for model. Optional.
     * @return	JTable	A database object
     * @since	1.6
     */
    public function getTable($type = 'location', $prefix = 'MyMaplocationsTable', $config = array()) {
        return JTable::getInstance($type, $prefix, $config);
    }

    /**
     * Method to get the record form.
     *
     * @param	array	$data		An optional array of data for the form to interogate.
     * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
     * @return	JForm	A JForm object on success, false on failure
     * @since	1.6
     */
    public function getForm($data = array(), $loadData = true) {
        // Initialise variables.
        $app = JFactory::getApplication();

        // Get the form.
        $form = $this->loadForm('com_mymaplocations.location', 'location', array('control' => 'jform', 'load_data' => $loadData));
        if (empty($form)) {
            return false;
        }

        return $form;
    }

    /**
     * Method to get the data that should be injected in the form.
     *
     * @return	mixed	The data for the form.
     * @since	1.6
     */
    protected function loadFormData() {
        // Check the session for previously entered form data.
        $data = JFactory::getApplication()->getUserState('com_mymaplocations.edit.location.data', array());

        if (empty($data)) {
            $data = $this->getItem();
        }

        return $data;
    }

    /**
     * Method to get a single record.
     *
     * @param	integer	The id of the primary key.
     *
     * @return	mixed	Object on success, false on failure.
     * @since	1.6
     */
    public function getItem($pk = null) {
        if ($item = parent::getItem($pk)) {

            //Do any procesing on fields here if needed
        }
         if (!empty($item->id))
        {
         $item->tags = new JHelperTags;
         $item->tags->getTagIds($item->id, 'com_mymaplocations.location');
        }

        return $item;
    }

    /**
     * @since  3.0
     */
    protected function prepareTable($table) {
        jimport('joomla.filter.output');
        $user = JFactory::getUser();
        $table->name = htmlspecialchars_decode($table->name, ENT_QUOTES);
        $table->alias = JApplicationHelper::stringURLSafe($table->alias);

        if (empty($table->alias)) {
            $table->alias = JApplicationHelper::stringURLSafe($table->name);
        }
        if (empty($table->id)) {
            $table->created_by = $user->id;
            // Set ordering to the last item if not set
            if (@$table->ordering === '') {
                $db = JFactory::getDbo();
                $db->setQuery('SELECT MAX(ordering) FROM #__mymaplocations_location');
                $max = $db->loadResult();
                $table->ordering = $max + 1;
            }
        }
    }
     public function saveCsv()
        {
            $file = JFactory::getApplication()->input->files->get('file_csv', null, 'files', 'array');
            $app = JFactory::getApplication();
            jimport('joomla.filesystem.file');
            //Clean up filename to get rid of strange characters like spaces etc
            $filename = JFile::makeSafe($file['name']);
            $src = $file['tmp_name'];
            JFolder::create(JPATH_SITE ."/tmp/mymap/");
            $dest = JPATH_SITE ."/tmp/mymap/".$filename;
            $location = new stdClass();
            $operation=JFactory::getApplication()->input->getString('operation',0);
            if ( strtolower(JFile::getExt($filename) ) == 'csv') {
       if ( JFile::upload($src, $dest) ) {
        	$db=JFactory::getDbo();
                $sql = "SELECT DISTINCT title,id FROM #__categories WHERE published = '1' And extension='com_mymaplocations'";
                $db->setQuery( $sql );
                $catrows=$db->loadAssocList();
                $n=count($catrows);
                if (version_compare(JVERSION, '4.0', 'ge'))
				{
				$catmodel = JFactory::getApplication()->bootComponent('com_categories')
				->getMVCFactory()->createModel('Category', 'Administrator', ['ignore_request' => true]);
			    }else{
                $basePath = JPATH_ADMINISTRATOR . '/components/com_categories';
                require_once $basePath . '/models/category.php';
                $config = array('table_path' => $basePath . '/tables');
                $catmodel = new CategoriesModelCategory($config);
                }
                 if (version_compare(JVERSION, '4.0', 'ge'))
				{
                $tagTable  = JFactory::getApplication()->bootComponent('com_tags')->getMVCFactory()->createTable('Tag', 'Administrator');
                $fieldTable  = JFactory::getApplication()->bootComponent('com_fields')->getMVCFactory()->createTable('Field', 'Administrator');
                }
                else
                {
                JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_tags/tables');
                $tagTable  = JTable::getInstance('Tag', 'TagsTable');
                JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_fields/tables');
                $fieldTable  = JTable::getInstance('Field', 'FieldsTable');
                }
                require_once JPATH_COMPONENT_ADMINISTRATOR . '/assets/parsecsv.lib.php';
                $csv = new parseCSV();
                $csv->auto($dest);
                $q=0;
                $l=0;
                foreach ($csv->data as $key => $row):
                 $values="";
                  $c=0;
                   $location=array();
                foreach ($row as $key2 =>$value):

                if($key2=='category_title')
                {

                    $found=false;
                    if($value==null)
                    {
                        $value="my category";
                    }
                    foreach($catrows as $cat)
                    {
                        if($cat['title']==$value)
                        {
                          $found=true;
                          $values=$cat['id'];
                          break;
                        }
                    }
                    if(!$found)
                    {
                         $catData = array('id' => 0, 'parent_id' => 0, 'level' => 1, 'path' => JApplicationHelper::stringURLSafe($value), 'extension' => 'com_mymaplocations'
                , 'title' =>$value , 'alias' => JApplicationHelper::stringURLSafe($value), 'description' => '', 'published' => 1, 'language' => '*');

                        $status = $catmodel->save($catData);
                        $values= $catmodel->getState('category.id');

                        $catrows[$n]['id']=$catmodel->getState('category.id');
                        $catrows[$n]['title']=$value;
                        $sql = "SELECT DISTINCT title,id FROM #__categories WHERE published = '1' And extension='com_mymaplocations'";
                        $db->setQuery( $sql );
                        $catrows=$db->loadAssocList();
                        $n++;
                    }

                }
                else if($key2=='description')
                   {
                       $values= "";                    
                   }
                else if(($key2=='latitude')||($key2=='longitude'))
                {
                    if($value==null)
                    {
                       $values= 0;

                    }
                    else
                    {
                        $values=$value;
                    }
                }
                else if($key2=='language')
                {
                    if($value==null)
                    {
                       $values= '*';

                    }
                    else
                    {
                        $values= $value;
                    }
                }
                else
                {
                $values= $value;
                }
                if(($key2=='tags'))
                {
                    if($value)
                    {
                       $tagdatas=explode(":",$value);
                       foreach($tagdatas as $tagText)
                       {
                        $tagTable->reset();
                        if ($tagTable->load(array('title' => $tagText)))
                        {
                             $location['tags'][]=(string)$tagTable->id;
                        }
                        else
                        {
                                $location['tags'][]="#new#".$tagText;
					
                        }
                       }
                    }
                }
                else if($key2=='extra_field')
                {
                    $fielddatas=explode("||",$value);
                    foreach($fielddatas as $fielddata)
                    {
                        $finalfielddata=explode("--",($fielddata));
                         $fieldTable->reset();
                        if ($fieldTable->load(array('title' => $finalfielddata[0])))
                        {
                           $location['com_fields'][$finalfielddata[0]]=$finalfielddata[2];
                        }
                        else
                        {
                            $fieldTable->id = 0;
                            $fieldTable->title = $finalfielddata[0];
                            $fieldTable->state = 1;
                             $fieldTable->label=$finalfielddata[0];
                            // $tagTable->language = property_exists ($item, 'language') ? $item->language : '*';
                            $fieldTable->language = '*';
                            $fieldTable->access = 1;
                            $fieldTable->description = "";
                            $fieldTable->type=$finalfielddata[1];
                             $fieldTable->params = "";
                            $fieldTable->context="com_mymaplocations.location";
                            // Try to store tag
                            if ($fieldTable->check())
                            {
						// Assign the alias as path (autogenerated tags have always level 1)
						//$fieldTable->path = $fieldTable->alias;
                    	if ($fieldTable->store())
                        	{
                                $location['com_fields'][$finalfielddata[0]]=$finalfielddata[2];
                            }
                        }
					
                        }
                    }
                }
                else if (strpos($key2, "extrafield___") === 0)
                {
                      $finalfielddata=explode("___",($key2));
                      
                         $fieldTable->reset();
                        if ($fieldTable->load(array('name' => $finalfielddata[1])))
                        {
                           $location['com_fields'][$finalfielddata[1]]=$value;
                        }
                        else
                        {
                            $fieldTable->id = 0;
                            $fieldTable->title = $finalfielddata[1];
                            $fieldTable->state = 1;
                             $fieldTable->label=$finalfielddata[1];
                            // $tagTable->language = property_exists ($item, 'language') ? $item->language : '*';
                            $fieldTable->language = '*';
                            $fieldTable->access = 1;
                            $fieldTable->description = "";
                            $fieldTable->params = "";
                            
                            if(@$finalfielddata[2])
                            {
                                $fieldTable->type="text";
                            }
                            else
                            {
                            $fieldTable->type=$finalfielddata[2];
                            }
                            $fieldTable->context="com_mymaplocations.location";
                            // Try to store tag
                            if ($fieldTable->check())
                            {
						// Assign the alias as path (autogenerated tags have always level 1)
						//$fieldTable->path = $fieldTable->alias;
                    	if ($fieldTable->store())
                        	{
                                $location['com_fields'][$finalfielddata[1]]=$value;
                            }
                        }
					
                        }
                }
                else if($key2=='category_title')
                {
                          $location['catid']=$values;
                }
                else if($key2=='category_title')
                {
                          $location['catid']=$values;
                }
                else
                {
                 $col=$csv->titles[$c];
                 $location[$col]=$values;
                }
                 $c++;

                endforeach;

                if($location['name'])
                   {
                if($operation==0)
                {
                   $location['id']=0;
                }
                }
                $location['alias']=JApplicationHelper::stringURLSafe($location['name']);
                
                $data=parent::save($location);
                
                unset($location);

                endforeach;

                // $db->setQuery($query);
                //$result = $db->execute();

    JFolder::delete(JPATH_SITE ."/tmp/mymap/");
        $msg = JText::_('Success');
          //Redirect to a page of your choice
       } else {
         $msg = JText::_('ERROR_IN_UPLOAD');
          //Redirect and throw an error message
       }
        } else {
          $msg = JText::_('FILE_TYPE_INVALID');

         //Redirect and notify user file is not right extension
        }
            JFactory::getApplication()->enqueueMessage($msg);
          $app->redirect('index.php?option=com_mymaplocations&task=sync');
        }
       

}