<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');
JLoader::register('FieldsHelper', JPATH_ADMINISTRATOR . '/components/com_fields/helpers/fields.php');
/**
 * Methods supporting a list of Mymaplocations records.
 *
 * @since  1.6
 */
class MymaplocationsModelStatistics extends JModelList
{
    
        
/**
	* Constructor.
	*
	* @param   array  $config  An optional associative array of configuration settings.
	*
	* @see        JController
	* @since      1.6
	*/
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'a.`id`',
				'term', 'a.`term`',
				'count', '`count`',
				'month', 'a.`month`',
				'year', 'a.`year`',
				'catid', 'a.`catid`',
				'extension', 'a.`extension`',
				'hits', 'a.`hits`',
			);
		}

		parent::__construct($config);
	}

    
        
    
        
	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   Elements order
	 * @param   string  $direction  Order direction
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	protected function populateState($ordering = null, $direction = null)
	{
        // List state information.
        parent::populateState('a.term', 'asc');

        $context = $this->getUserStateFromRequest($this->context . '.context', 'context', 'com_content.article', 'CMD');
        $this->setState('filter.context', $context);
            $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
            $this->setState('filter.search', $search);
			$component = $this->getUserStateFromRequest($this->context . '.filter.filter_component', 'filter_component','com_mymaplocations');
            $this->setState('filter.filter_component', $component);
			$now=JFactory::getDate()->Format('Y-m-d');
			$newDate  = new JDate('now -1 year');  
			$enddate = $newDate->format('Y-m-d');
			$cal_event_date = $this->getUserStateFromRequest($this->context . '.filter.cal_event_date', 'cal_event_date',$enddate);
            $this->setState('filter.cal_event_date', $cal_event_date);
			$cal_event_enddate = $this->getUserStateFromRequest($this->context . '.filter.cal_event_enddate', 'cal_event_enddate',$now);
            $this->setState('filter.cal_event_enddate', $cal_event_enddate);
        // Split context into component and optional section
			$parts = FieldsHelper::extract($context);

        if ($parts)
        {
            $this->setState('filter.component', $parts[0]);
            $this->setState('filter.section', $parts[1]);
        }
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id  A prefix for the store id.
	 *
	 * @return   string A store id.
	 *
	 * @since    1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.state');

                
                    return parent::getStoreId($id);
                
	}

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return   JDatabaseQuery
	 *
	 * @since    1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db    = $this->getDbo();
		$query = $db->getQuery(true);
		$component=$this->getState('filter.filter_component');
		$cal_event_date=$this->getState('filter.cal_event_date');
		$cal_event_enddate=$this->getState('filter.cal_event_enddate');
		
		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select', 'DISTINCT a.*'
			)
		);
		$query->select('SUM(a.hits) as count');
		$query->from('`#__mymaplocations_statistics` AS a');
        $query->where('a.extension = ' . $db->quote($component));                
		// Add the list ordering clause.
		$orderCol  = $this->state->get('list.ordering', "count");
		$orderDirn = $this->state->get('list.direction', "DESC");
		$query->where('DATE(a.updated) >='. $db->quote($cal_event_date) );
		$query->where('DATE(a.updated) <='.$db->quote($cal_event_enddate));
		$query->group('a.term');
		$query->order('a.updated asc');
        //$query->order($db->escape($orderCol . ' ' . $orderDirn));
		//echo nl2br($query);die();
		return $query;
	}

	/**
	 * Get an array of data items
	 *
	 * @return mixed Array of data items on success, false on failure.
	 */
	public function getItems()
	{
		$items = parent::getItems();
                

		return $items;
	}
}
