<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
// No direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');

jimport('joomla.installer.installer');

/**
 * MML custom installer class
 */
class com_mymaplocationsInstallerScript {

    public function install($parent) {
        $installer = method_exists($parent, 'getParent') ? $parent->getParent() : $parent->parent;
        $dst = JPATH_ROOT . DIRECTORY_SEPARATOR  . 'images' . DIRECTORY_SEPARATOR . 'icons';
        $src = $installer->getPath('source') . DIRECTORY_SEPARATOR . 'images' . DIRECTORY_SEPARATOR . 'icons';
        $this->recurse_copy($src, $dst);
    }

    function postflight($type, $parent) {
        // $parent is the class calling this method
        // $type is the type of change (install, update or discover_install)
        JLoader::register('InstallerHelper', JPATH_ADMINISTRATOR . '/components/com_mymaplocations/helpers/installer.php');
           
        if ($type == 'install') {
            $basePath = JPATH_ADMINISTRATOR . '/components/com_categories';
            $jversion = new JVersion;
            	if((int)($jversion->getShortVersion())>=4)
                {
                     $category = [
				// Remove #new# prefix, if exists.
				'title'     => 'my category',
				'parent_id' => 1,
				'extension' => 'com_mymaplocations',
				'language'  => '*',
				'published' => 1,
			];

			/** @var \Joomla\Component\Categories\Administrator\Model\CategoryModel $categoryModel */
			$categoryModel = JFactory::getApplication()->bootComponent('com_categories')
				->getMVCFactory()->createModel('Category', 'Administrator', ['ignore_request' => true]);

			// Create new category.
			if (!$categoryModel->save($category))
			{
				$this->setError($categoryModel->getError());

				return false;
			}
                }
                else{
            require_once $basePath . '/models/category.php';
                
            $config = array('table_path' => $basePath . '/tables');
            $catmodel = new CategoriesModelCategory($config);
            $catData = array('id' => 0, 'parent_id' => 0, 'level' => 1, 'path' => 'locationlocator', 'extension' => 'com_mymaplocations'
                , 'title' => 'my category', 'alias' => 'my-category', 'description' => '', 'published' => 1, 'language' => '*');
            $status = @$catmodel->save($catData);

            if (!$status) {
                JFactory::getApplication()->enqueueMessage(JText::_('Unable to create default content category!'),'error');
        
            }
                }
        }
        $db = JFactory::getDBO();
        // Log for updates
        $query = "CREATE TABLE IF NOT EXISTS `#__mymaplocations_statistics` (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `term` varchar(255) NOT NULL DEFAULT 'null',
            `month` int(11) NOT NULL DEFAULT 0,
            `year` int(11) NOT NULL DEFAULT 0,
            `catid` int(11) NOT NULL DEFAULT '0',
            `extension` varchar(200) NOT NULL DEFAULT '0',
            `hits` int(11) NOT NULL DEFAULT '0',
            `updated` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
            PRIMARY KEY (`id`)
            )DEFAULT COLLATE=utf8_general_ci;";
        $db->setQuery($query);
        $db->execute();

        
        $fields = $db->getTableColumns('#__mymaplocations_location');

        if (!array_key_exists('component', $fields)) {

            $query = "ALTER TABLE #__mymaplocations_location ADD `maptype` varchar(255) NOT NULL  AFTER `description`";
            $db->setQuery($query);
            $db->execute();
            $query = "ALTER TABLE #__mymaplocations_location ADD `extra_id` int(11) NOT NULL AFTER `description`";
            $db->setQuery($query);
            $db->execute();
            $query = "ALTER TABLE #__mymaplocations_location ADD `component` varchar(255) NOT NULL AFTER `description`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('phone', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `phone` varchar(255) NOT NULL  AFTER `description`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('hours', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `hours` text NOT NULL  AFTER `description`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('contactlink', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `contactlink` varchar(255) NOT NULL  AFTER `description`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('metadesc', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `metadesc` text NOT NULL  AFTER `description`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('metakey', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `metakey` text NOT NULL  AFTER `description`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('extlink', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `extlink` char(7) NOT NULL  AFTER `description`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('exturl', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `exturl` varchar(255) NOT NULL  AFTER `description`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('place_id', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `place_id` varchar(255) NOT NULL  AFTER `exturl`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('featured', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `featured` varchar(255) NOT NULL  AFTER `exturl`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('use_category_image', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `use_category_image` char(7)  NOT NULL  AFTER `extlink`";
            $db->setQuery($query);
            $db->execute();
        }
        if (!array_key_exists('markercolor', $fields)) {
            $query = "ALTER TABLE #__mymaplocations_location ADD `markercolor` char(7)  NOT NULL  AFTER `extlink`";
            $db->setQuery($query);
            $db->execute();
        }
        $fieldsreport = $db->getTableColumns('#__mymaplocations_statistics');
         if (!array_key_exists('updated', $fieldsreport)) {
            $query = "ALTER TABLE #__mymaplocations_statistics ADD `updated` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00'";
            $db->setQuery($query);
            $db->execute();
        }
            $query = "select * from #__content_types where `type_title` =".$db->Quote('MyMaplocations');
            $db->setQuery($query);
            $db->execute();
            $num_rows = $db->getNumRows();
            
            if($num_rows==0){
            $content_type = new stdClass();
            $content_type->type_title = 'MyMaplocations';
            $content_type->type_alias='com_mymaplocations.location';
            $content_type->table='{"special":{"dbtable":"#__mymaplocations_location","key":"id","type":"location","prefix":"MyMaplocationsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}';
            $content_type->rules='';
            $content_type->field_mappings='{"common":{"core_content_item_id":"id","core_title":"name","core_state":"state","core_alias":"alias","core_body":"description","core_access":"access","core_metadata":"metadata", "core_language":"language","core_catid":"catid"}}';
            $content_type->router=1;
            $content_type->content_history_options='{"formFile":"administrator\/components\/com_mymaplocations\/models\/forms\/location.xml","hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}';
            $result = JFactory::getDbo()->insertObject('#__content_types', $content_type);
            }
            $path=JPATH_SITE.'/media/zoo/elements/';
             $imgsrc = JURI::root() .'/components/com_mymaplocations/assets/images/tick.png';
             $imgsno = JURI::root() .'/components/com_mymaplocations/assets/images/exclamation.png';
             
            echo ' <p style="font-family: Open Sans,Helvetica,Arial,sans-serif;">
                <h2><strong>My Maps location - Google Maps Integration for Joomla  </strong></h2><br /></p>
                
                <p style="font-family: Open Sans,Helvetica,Arial,sans-serif;"><a style="text-decoration: none; background-color: #2089c0; color: #fff; padding: 10px 20px 10px 20px; border-radius 2px;" href="index.php?option=com_mymaplocations">LOAD THE DASHBOARD</a> </p>
                
                <p style="font-family: Open Sans,Helvetica,Arial,sans-serif;">
                    <br /><br /> <ul>';
                  
                 if (JFolder::exists($path)) {
                        $installer = method_exists($parent, 'getParent') ? $parent->getParent() : $parent->parent;
                        $dst = JPATH_ROOT.'/media/zoo/elements/mymaplocations';
                        $src = $installer->getPath('source') .'/administrator/extensions/zoo/mymaplocations';
                        if(!JFolder::exists( $dst))
                        {
                            JFolder::create( $dst);
                        }
                        JFile::copy( $src. "/mymaplocations.php" , $dst. "/mymaplocations.php");
                        JFile::copy( $src. "/mymaplocations.xml" , $dst. "/mymaplocations.xml");
                               echo '<li style="background-image: url(' .  $imgsrc. '); background-repeat: no-repeat; background-position: left center; padding-left: 24px;list-style-type: none; line-height: 25px; font-family: Open Sans,Helvetica,Arial,sans-serif;">Zoo Installation : '.JText::sprintf('OK','').'</li>';
                    }
        
            $manifest = $parent->getManifest();
          $extensions = $manifest->extensions;
          if ($type != 'uninstall') {
           foreach($extensions->children() as $extension){
                        $folder = $extension->attributes()->folder;
                        $enable = $extension->attributes()->enable;
                        if(InstallerHelper::install(JPATH_ADMINISTRATOR.'/components/com_mymaplocations/extensions/'.$folder,$enable)){
                        echo '<li style="background-image: url(' .  $imgsrc. '); background-repeat: no-repeat; background-position: left center; padding-left: 24px;list-style-type: none; line-height: 25px; font-family: Open Sans,Helvetica,Arial,sans-serif;">'.JText::sprintf($folder).' : '.JText::sprintf('OK','').'</li>';
                        }else{
                            echo '<li style="background-image: url(' .  $imgsno. '); background-repeat: no-repeat; background-position: left center; padding-left: 24px;list-style-type: none; line-height: 25px; font-family: Open Sans,Helvetica,Arial,sans-serif;">'.JText::sprintf($folder).' : '.JText::sprintf('Not OK','').'</li>';
                        }
                }
          }
                echo"</ul>";


    }

    function createIndexFolder($path) {
        if (!class_exists('JFile'))
            require(JPATH_ROOT . DIRECTORY_SEPARATOR . 'joomla' . DIRECTORY_SEPARATOR . 'filesystem' . DIRECTORY_SEPARATOR . 'file.php');
        if (JFolder::create($path)) {
            if (!JFile::exists($path . DIRECTORY_SEPARATOR . 'index.html')) {
                JFile::copy(JPATH_ROOT . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'index.html', $path . DIRECTORY_SEPARATOR . 'index.html');
            }
            return true;
        }
        return false;
    }

    /**
     * copy all $src to $dst folder and remove it
     *
     * ***@author Max Milbers
     * @param String $src path
     * @param String $dst path
     * @param String $type modules, plugins, languageBE, languageFE
     */
    private function recurse_copy($src, $dst) {

        $dir = opendir($src);
        $this->createIndexFolder($dst);

        if (is_resource($dir)) {
            while (false !== ( $file = readdir($dir))) {
                if (( $file != '.' ) && ( $file != '..' )) {
                    if (is_dir($src . DIRECTORY_SEPARATOR . $file)) {
                        $this->recurse_copy($src . DIRECTORY_SEPARATOR . $file, $dst . DIRECTORY_SEPARATOR . $file);
                    } else {
                        if (JFile::exists($dst . DIRECTORY_SEPARATOR . $file)) {
                            if (!JFile::delete($dst . DIRECTORY_SEPARATOR . $file)) {
                                $app = JFactory::getApplication();
                                $app->enqueueMessage('Couldnt delete ' . $dst . DIRECTORY_SEPARATOR . $file);
                            }
                        }
                        if (!JFile::move($src . DIRECTORY_SEPARATOR . $file, $dst . DIRECTORY_SEPARATOR . $file)) {
                            $app = JFactory::getApplication();
                            $app->enqueueMessage('Couldnt move ' . $src . DIRECTORY_SEPARATOR . $file . ' to ' . $dst . DIRECTORY_SEPARATOR . $file);
                        }
                    }
                }
            }
            closedir($dir);
            if (is_dir($src))
                JFolder::delete($src);
        } else {
            $app = JFactory::getApplication();
            $app->enqueueMessage('Couldnt read dir ' . $dir . ' source ' . $src);
        }
    }
    function uninstall($parent)
        {
        $db = JFactory::getDBO();
        $status = new stdClass;
        $status->modules = array();
        $status->plugins = array();
        $manifest = $parent->getManifest();
        $extensions = $manifest->extensions;
        
        foreach($extensions->children() as $plugin)
        {
            $group = (string)$plugin->attributes()->group;
	    $element=(string)$plugin->attributes()->element;
	    $type=(string)$plugin->attributes()->type;
            $query = "SELECT `extension_id` FROM #__extensions WHERE element = ".$db->Quote($element)." AND folder=".$db->Quote($group);
            $db->setQuery($query);
            $extensions = $db->loadColumn();
	    if (count($extensions))
            {
                foreach ($extensions as $id)
                {
                    $installer = new JInstaller;
                    $result = $installer->uninstall($type, $id);
                }
            
            }
            
        }
         $db->setQuery(
            $db->getQuery(true)
                ->update('#__categories')
                ->set('extension=CONCAT('.$db->q('!').',extension,'.$db->q('!').')')
                ->where('extension='.$db->q('com_mymaplocations'))
        )->execute();
        }
    

}

