<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// No direct access
defined('_JEXEC') or die;
use Joomla\Utilities\ArrayHelper;

/**
 * location Table class
 */
class MyMaplocationsTablelocation extends JTable {
    
    protected $tagsHelper = null;

    /**
     * Constructor
     *
     * @param JDatabase A database connector object
     */
    public function __construct(&$db) {
        parent::__construct('#__mymaplocations_location', 'id', $db);
        $this->setColumnAlias('published', 'state');
        if (version_compare(JVERSION, '4.0', 'ge'))
				{
                    $this->tagsHelper = new JHelperTags();
                    $this->tagsHelper->typeAlias = 'com_mymaplocations.location';
                    }else{
        JTableObserverTags::createObserver($this, array('typeAlias' => 'com_mymaplocations.location'));
		JTableObserverContenthistory::createObserver($this, array('typeAlias' => 'com_mymaplocations.location'));
                }
    }

    /**
     * Overloaded bind function to pre-process the params.
     *
     * @param	array		Named array
     * @return	null|string	null is operation was satisfactory, otherwise returns an error
     * @see		JTable:bind
     * @since	1.5
     */
    public function bind($array, $ignore = '') {


        if (isset($array['params']) && is_array($array['params'])) {
            $registry = new JRegistry();
            $registry->loadArray($array['params']);
            $array['params'] = (string) $registry;
        }

        if (isset($array['metadata']) && is_array($array['metadata'])) {
            $registry = new JRegistry();
            $registry->loadArray($array['metadata']);
            $array['metadata'] = (string) $registry;
        }

        //Bind the rules for ACL where supported.
        if (isset($array['rules']) && is_array($array['rules'])) {
            $this->setRules($array['rules']);
        }
        if (!isset($array['component'])||$array['component']=='')
        {
            $array['component']="com_mymaplocations";
        }
        if (!isset($array['description'])||$array['description']==null)
        {
            $array['description']="";
        }
        if (!isset($array['logo'])||$array['logo']==null)
        {
            $array['logo']="";
        }
        if (!isset($array['icon'])||$array['icon']==null)
        {
            $array['icon']="";
        }
        if (!isset($array['markercolor'])||$array['markercolor']==null)
        {
            $array['markercolor']="";
        }
         if (!isset($array['metakey'])||$array['metakey']==null)
        {
            $array['metakey']="";
        }
           if (!isset($array['metadesc'])||$array['metadesc']==null)
        {
            $array['metadesc']="";
        }
        if (!isset($array['exturl'])||$array['exturl']==null)
        {
            $array['exturl']="";
        }
        if (!isset($array['extlink'])||$array['extlink']==null)
        {
            $array['extlink']="";
        }
        if (!isset($array['featured'])||$array['featured']=='')
        {
            $array['featured']=0;
        }
        if (!isset($array['place_id'])||$array['place_id']=='')
        {
            $array['place_id']='';
        }
        if (!isset($array['use_category_image'])||$array['use_category_image']=='')
        {
            $array['use_category_image']=0;
        }
         if (!isset($array['extra_id'])||$array['extra_id']=='')
        {
            $array['extra_id']=0;
        }
        if (!isset($array['maptype']))
        {
            $array['maptype']='';
        }
        if (!isset($array['icon']))
        {
            $array['icon']='';
        }
        if (!isset($array['contactlink']))
        {
            $array['contactlink']='';
        }
          if (!isset($array['checked_out'])||$array['checked_out']=='')
         {
            $array['checked_out'] = 0;
         }
                   if (!isset($array['created_by'])||$array['created_by']=='')
         {
            $array['created_by'] = JFactory::getUser()->id;
         }
        return parent::bind($array, $ignore);
    }

    /**
     * Overloaded check function
     */
    public function check() {

        //If there is an ordering column and this is a new row then get the next ordering value
        if (property_exists($this, 'ordering') && $this->id == 0) {
            $this->ordering = self::getNextOrder();
        }
        if (empty($this->alias)) {
            $this->alias = $this->name;
        }
        $this->alias = JApplicationHelper::stringURLSafe($this->alias);
        if (trim(str_replace('-', '', $this->alias)) == '') {
            $this->alias = JFactory::getDate()->format("Y-m-d-H-i-s");
        }
        return parent::check();
    }

    /**
     * locations a contact
     *
     * @param	boolean	True to update fields even if they are null.
     * @return	boolean	True on success, false on failure.
     * @since	1.6
     */
    public function store($updateNulls = false) {
        // Verify that the alias is unique
        $table = JTable::getInstance('location', 'MyMaplocationsTable');
        if ($table->load(array('alias' => $this->alias, 'catid' => $this->catid)) && ($table->id != $this->id || $this->id == 0)) {
            $this->alias= $this->alias."-".JFactory::getDate()->format("Y-m-d-H-i-s");
        }
        if (version_compare(JVERSION, '4.0', 'ge'))
				{
                    $this->tagsHelper->preStoreProcess($this);
                    $result = parent::store($updateNulls);
                	return $result && $this->tagsHelper->postStoreProcess($this);	
                }
                else
                {
                        $store= parent::store($updateNulls);
    
                }
                return $store;
    }

    /**
     * Method to set the publishing state for a row or list of rows in the database
     * table.  The method respects checked out rows by other users and will attempt
     * to checkin rows that it can after adjustments are made.
     *
     * @param    mixed    An optional array of primary key values to update.  If not
     *                    set the instance property value is used.
     * @param    integer The publishing state. eg. [0 = unpublished, 1 = published]
     * @param    integer The user id of the user performing the operation.
     * @return    boolean    True on success.
     * @since    1.0.4
     */
    public function publish($pks = null, $state = 1, $userId = 0) {
        // Initialise variables.
        $k = $this->_tbl_key;

        // Sanitize input.
        ArrayHelper::toInteger($pks);
        $userId = (int) $userId;
        $state = (int) $state;

        // If there are no primary keys set check to see if the instance key is set.
        if (empty($pks)) {
            if ($this->$k) {
                $pks = array($this->$k);
            }
            // Nothing to set publishing state on, return false.
            else {
                JFactory::getApplication()->enqueueMessage(JText::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));
                return false;
            }
        }

        // Build the WHERE clause for the primary keys.
        $where = $k . '=' . implode(' OR ' . $k . '=', $pks);

        // Determine if there is checkin support for the table.
        if (!property_exists($this, 'checked_out') || !property_exists($this, 'checked_out_time')) {
            $checkin = '';
        } else {
            $checkin = ' AND (checked_out = 0 OR checked_out = ' . (int) $userId . ')';
        }

        // Update the publishing state for rows with the given primary keys.
        $this->_db->setQuery(
                'UPDATE `' . $this->_tbl . '`' .
                ' SET `state` = ' . (int) $state .
                ' WHERE (' . $where . ')' .
                $checkin
        );
         try{
				$this->_db->execute();
				}
						catch (Exception $e)
						{
            $this->setError($this->_db->getErrorMsg());
            return false;
            			}

        // If checkin is supported and all rows were adjusted, check them in.
        if ($checkin && (count($pks) == $this->_db->getAffectedRows())) {
            // Checkin each row.
            foreach ($pks as $pk) {
                $this->checkin($pk);
            }
        }

        // If the JTable instance value is in the list of primary keys that were set, set the instance.
        if (in_array($this->$k, $pks)) {
            $this->state = $state;
        }

        $this->setError('');
        return true;
    }
    /**
	 * Override parent delete method to delete tags information.
	 *
	 * @param   integer  $pk  Primary key to delete.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   3.1
	 * @throws  UnexpectedValueException
	 */
    public function delete($pk = null)
	{
		$result = parent::delete($pk);
        if (version_compare(JVERSION, '4.0', 'ge'))
				{
                    $this->tagsHelper->deleteTagData($this, $pk);
                }
		return $result;
	}

}
