<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('behavior.multiselect');
JHtml::_('dropdown.init');


JHTML::_('script', 'system/multiselect.js', false, true);
// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_mymaplocations/assets/css/mymaplocations.css');
$document->addStyleSheet(JURI::root() . '/components/com_mymaplocations/assets/css/materialize.css');

$user = JFactory::getUser();
$userId = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
$archived = $this->state->get('filter.published') == 2 ? true : false;
$trashed = $this->state->get('filter.published') == -2 ? true : false;
$canOrder = $user->authorise('core.edit.state', 'com_mymaplocations.category');
$saveOrder = $listOrder == 'a.ordering';
if ($saveOrder) {
    $saveOrderingUrl = 'index.php?option=com_mymaplocations&task=locations.saveOrderAjax&tmpl=component';
    JHtml::_('sortablelist.sortable', 'articleList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}
$sortFields = $this->getSortFields();
$params=JComponentHelper::getParams('com_mymaplocations');
	$googleapi=$params->get('googleapi');
	$autocomplete_type = $params->get('autocomplete_type', 1);
   $map = $params->get('map', 1);
   if(($map==0)&&((!$googleapi)))
   {
   	JFactory::getApplication()->enqueueMessage( JText::_('COM_MYMAPLOCATIONS_MAP_ERROR'), 'error');   
   }
	if(($autocomplete_type==1)&&((!$googleapi)))
	{
		JFactory::getApplication()->enqueueMessage( JText::_('COM_MYMAPLOCATIONS_MAP_AUTO_ERROR'), 'error');
	}
?>
<script type="text/javascript">
    Joomla.orderTable = function() {
        table = document.getElementById("sortTable");
        direction = document.getElementById("directionTable");
        order = table.options[table.selectedIndex].value;
        if (order != '<?php echo $listOrder; ?>') {
            dirn = 'asc';
        } else {
            dirn = direction.options[direction.selectedIndex].value;
        }
        Joomla.tableOrdering(order, dirn, '');
    }
</script>

<form action="<?php echo JRoute::_('index.php?option=com_mymaplocations&view=locations'); ?>" method="post" name="adminForm" id="adminForm">
<?php if (!empty($this->sidebar)): ?>
        <div id="j-sidebar-container" class="span2">
        <?php echo $this->sidebar; ?>
        </div>
        <div id="j-main-container" class="span10">
        <?php else : ?>
            <div id="j-main-container">
        <?php endif; ?>

            <div id="filter-bar" class="btn-toolbar">
                <div class="filter-search btn-group pull-left input-group">
                    <label for="filter_search" class="element-invisible"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
                    <input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('Search'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('JGLOBAL_TITLE'); ?>" />
                </div>
                <div class="btn-group pull-left">
                    <button class="btn hasTooltip btn-primary" type="submit" title="<?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i></button>
                    <button class="btn hasTooltip btn-danger" type="button" title="<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
                </div>
      
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
<?php echo $this->pagination->getLimitBox(); ?>
                </div>
               
            <div class="btn-group pull-right hidden-phone">
					<label for="published"
						   class="element-invisible">
						<?php echo JText::_('COM_MYMAPLOCATIONS_MAP_COMPONENT_LABEL'); ?>
					</label>
					<select name="filter_published" id="filter_published" class="span12 small form-select" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), "value", "text", $this->state->get('filter.state'), true); ?>
					</select>
				</div>
            <div class="btn-group pull-right hidden-phone">
					<label for="category"
						   class="element-invisible">
						<?php echo JText::_('JOPTION_SELECT_CATEGORY'); ?>
					</label>
					<select name="filter_category_id" id="filter_category_id" class="span12 small form-select" onchange="this.form.submit()">
                   <option value=""><?php echo JText::_('JOPTION_SELECT_CATEGORY'); ?></option>
					<?php echo JHtml::_('select.options', JHtml::_('category.options', 'com_mymaplocations'), 'value', 'text', $this->state->get('filter.category_id')); ?>
					</select>
				</div>
             <div class="btn-group pull-right hidden-phone">
					<label for="published"
						   class="element-invisible">
						<?php echo JText::_('JOPTION_SELECT_PUBLISHED'); ?>
					</label>
					<select name="filter_component" id="filter_component" class="span12 small form-select" onchange="this.form.submit()">
					<?php
                $options = array();
        $options[] = JHtml::_('select.option', 'com_mymaplocations', JText::_('COM_MYMAPLOCATIONS_COMPONENT_MYMAP'));
        $options[] = JHtml::_('select.option', 'com_k2', JText::_('K2'));
        $options[] = JHtml::_('select.option', 'com_zoo', JText::_('Zoo'));
        $options[] = JHtml::_('select.option', 'com_hikashop', JText::_('Hikashop Vendor'));
         $options[] = JHtml::_('select.option', 'com_comprofiler', JText::_('Community Builder User'));
               echo JHtml::_('select.options',$options, "value", "text", $this->state->get('filter.component'), true); ?>
					</select>
				</div>
              <div class="btn-group pull-right hidden-phone">
                    <label for="directionTable" class="element-invisible"><?php echo JText::_('JFIELD_ORDERING_DESC'); ?></label>
                    <select name="directionTable" id="directionTable" class="input-medium form-select" onchange="Joomla.orderTable()">
                        <option value=""><?php echo JText::_('JFIELD_ORDERING_DESC'); ?></option>
                        <option value="asc" <?php if ($listDirn == 'asc') echo 'selected="selected"'; ?>><?php echo JText::_('JGLOBAL_ORDER_ASCENDING'); ?></option>
                        <option value="desc" <?php if ($listDirn == 'desc') echo 'selected="selected"'; ?>><?php echo JText::_('JGLOBAL_ORDER_DESCENDING'); ?></option>
                    </select>
                </div>
                <div class="btn-group pull-right">
                    <label for="sortTable" class="element-invisible"><?php echo JText::_('JGLOBAL_SORT_BY'); ?></label>
                    <select name="sortTable" id="sortTable" class="input-medium form-select" onchange="Joomla.orderTable()">
                        <option value=""><?php echo JText::_('JGLOBAL_SORT_BY'); ?></option>
<?php echo JHtml::_('select.options', $sortFields, 'value', 'text', $listOrder); ?>
                    </select>
                </div>
            </div>
            <div class="clearfix"> </div>

            <div class="clr"> </div>
            <table class="table table-striped" id="articleList">
                <thead>
                    <tr>
                    <tr>
                        <th width="1%" class="nowrap center hidden-phone">
<?php echo JHtml::_('grid.sort', '<i class="icon-menu-2"></i>', 'a.ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING'); ?>
                        </th>
                        <th width="1%" class="hidden-phone">
                            <input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
                        </th>
                        <th width="1%" style="min-width:55px" class="nowrap center">
<?php echo JHtml::_('grid.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
                        </th>
                        <th>
                            <?php echo JHtml::_('grid.sort', 'JGLOBAL_TITLE', 'a.name', $listDirn, $listOrder); ?>
                        </th>
                        <th class="nowrap hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'COM_MYMAPLOCATIONS_LOCATIONS_CREATED_BY', 'a.created_by', $listDirn, $listOrder); ?>
                        </th>
                        <th width="5%" class="nowrap hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'COM_MYMAPLOCATIONS_LOCATIONS_POSTAL', 'a.postal', $listDirn, $listOrder); ?>
                        </th>
                        <th width="5%" class="nowrap hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'JGRID_HEADING_LANGUAGE', 'a.language', $listDirn, $listOrder); ?>
                        </th>
                        <th width="1%" class="nowrap center hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                </thead>
                <tbody>
<?php
$n = count($this->items);
foreach ($this->items as $i => $item) :
    $ordering = $listOrder == 'a.ordering';
    $canCreate = $user->authorise('core.create', 'com_mymaplocations.category.' . $item->catid);
    $canEdit = $user->authorise('core.edit', 'com_mymaplocations.category.' . $item->catid);
    $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $userId || $item->checked_out == 0;
    $canEditOwn = $user->authorise('core.edit.own', 'com_mymaplocations.category.' . $item->catid) && $item->created_by == $userId;
    $canChange = $user->authorise('core.edit.state', 'com_mymaplocations.category.' . $item->catid) && $canCheckin;

    $item->cat_link = JRoute::_('index.php?option=com_categories&extension=com_mymaplocations&task=edit&type=other&id=' . $item->catid);
    ?>
                        <tr class="row<?php echo $i % 2; ?>" sortable-group-id="<?php echo $item->catid ?>">
                            <td class="order nowrap center hidden-phone">
                        <?php
                        if ($canChange) :
                            $disableClassName = '';
                            $disabledLabel = '';
                            if (!$saveOrder) :
                                $disabledLabel = JText::_('JORDERINGDISABLED');
                                $disableClassName = 'inactive tip-top';
                            endif;
                            ?>
                                    <span class="sortable-handler hasTooltip<?php echo $disableClassName ?>" title="<?php echo $disabledLabel ?>">
                                        <i class="icon-menu"></i>
                                    </span>
                                    <input type="text" style="display:none" name="order[]" size="5"
                                           value="<?php echo $item->ordering; ?>" class="width-20 text-area-order " />
                                       <?php else : ?>
                                    <span class="sortable-handler inactive" >
                                        <i class="icon-menu"></i>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="center hidden-phone">
                                <?php echo JHtml::_('grid.id', $i, $item->id); ?>
                            </td>
                            <td class="center">
                                <?php echo JHtml::_('jgrid.published', $item->state, $i, 'locations.', $canChange, 'cb', $item->state); ?>
                            </td>
                            <td class="nowrap has-context">
                                <div class="pull-left">
                                    <?php if ($item->checked_out) : ?>
                                        <?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'locations.', $canCheckin); ?>
                                    <?php endif; ?>
                                    <?php if ($canEdit || $canEditOwn) : ?>
                                        <a href="<?php echo JRoute::_('index.php?option=com_mymaplocations&amp;task=location.edit&amp;id=' . (int) $item->id); ?>">
                                            <?php echo $this->escape($item->name); ?></a>
                                        <?php else : ?>
                                        <?php echo $this->escape($item->name); ?>
                                    <?php endif; ?>
                                    <span class="small">
                                        <?php echo JText::sprintf('JGLOBAL_LIST_ALIAS', $this->escape($item->alias)); ?>
                                    </span>
                                    <div class="small">
                                        <?php echo $item->category_title; ?>
                                    </div>
                                </div>
                                <div class="pull-left">
                                    <?php
                                    // Create dropdown items
                                    JHtml::_('dropdown.edit', $item->id, 'location.');
                                    JHtml::_('dropdown.divider');
                                    if ($item->state) :
                                        JHtml::_('dropdown.unpublish', 'cb' . $i, 'locations.');
                                    else :
                                        JHtml::_('dropdown.publish', 'cb' . $i, 'locations.');
                                    endif;

                                    JHtml::_('dropdown.divider');

                                    if ($archived) :
                                        JHtml::_('dropdown.unarchive', 'cb' . $i, 'locations.');
                                    else :
                                        JHtml::_('dropdown.archive', 'cb' . $i, 'locations.');
                                    endif;

                                    if ($item->checked_out) :
                                        JHtml::_('dropdown.checkin', 'cb' . $i, 'locations.');
                                    endif;

                                    if ($trashed) :
                                        JHtml::_('dropdown.untrash', 'cb' . $i, 'locations.');
                                    else :
                                        JHtml::_('dropdown.trash', 'cb' . $i, 'locations.');
                                    endif;

                                    // render dropdown list
                                    echo JHtml::_('dropdown.render');
                                    ?>
                                </div>
                            </td>
                            <td align="small hidden-phone">
                                <?php echo $item->created_by; ?>
                            </td>
                            <td class="center hidden-phone">
                                <?php echo $item->postal; ?>
                            </td>
                            <td class="small hidden-phone">
                                <?php if ($item->language == '*'): ?>
                                    <?php echo JText::alt('JALL', 'language'); ?>
                                <?php else: ?>
                                    <?php echo $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
                                <?php endif; ?>
                            </td>
                            <td align="center hidden-phone">
                                <?php echo $item->id; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="10">
                            <?php echo $this->pagination->getListFooter(); ?>
                        </td>
                    </tr>
                </tfoot>

            </table>

            <div>
                <input type="hidden" name="task" value="" />
                <input type="hidden" name="boxchecked" value="0" />
                <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
                <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
                <?php echo JHtml::_('form.token'); ?>
            </div>
            </form>