<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('behavior.multiselect');
JHtml::_('dropdown.init');


JHTML::_('script', 'system/multiselect.js', false, true);
// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_mymaplocations/assets/css/mymaplocations.css');
$document->addScript('components/com_mymaplocations/assets/script.js');
$document->addStyleSheet(JURI::root() . '/components/com_mymaplocations/assets/css/materialize.css');

$user = JFactory::getUser();
$userId = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
$archived = $this->state->get('filter.published') == 2 ? true : false;
$trashed = $this->state->get('filter.published') == -2 ? true : false;
$canOrder = $user->authorise('core.edit.state', 'com_mymaplocations.category');
$saveOrder = $listOrder == 'a.ordering';
if ($saveOrder) {
    $saveOrderingUrl = 'index.php?option=com_mymaplocations&task=locations.saveOrderAjax&tmpl=component';
    JHtml::_('sortablelist.sortable', 'articleList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}
$sortFields = $this->getSortFields();
$params=JComponentHelper::getParams('com_mymaplocations');

$params = JComponentHelper::getParams('com_mymaplocations');
// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_mymaplocations/assets/css/mymaplocations.css');

$user = JFactory::getUser();
$userId = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn = $this->state->get('list.direction');
$canOrder = $user->authorise('core.edit.state', 'com_mymaplocations');
$saveOrder = $listOrder == 'a.ordering';
$function = JFactory::getApplication()->input->getString('function', 'jSelectContact');
$input = JFactory::getApplication()->input;
?>
<script type="text/javascript">
    Joomla.orderTable = function() {
        table = document.getElementById("sortTable");
        direction = document.getElementById("directionTable");
        order = table.options[table.selectedIndex].value;
        if (order != '<?php echo $listOrder; ?>') {
            dirn = 'asc';
        } else {
            dirn = direction.options[direction.selectedIndex].value;
        }
        Joomla.tableOrdering(order, dirn, '');
    }
</script>
<?php
$data = JFactory::getApplication()->input->getString('data', '');
if ($data == "bulk") {
    ?>
        <style type="text/css">
            .data{
                -moz-border-bottom-colors: none;
                -moz-border-left-colors: none;
                -moz-border-right-colors: none;
                -moz-border-top-colors: none;
                background-color: #F5F5F5;
                background-image: linear-gradient(to bottom, #FFFFFF, #E6E6E6);
                background-repeat: repeat-x;
                border-color: #BBBBBB #BBBBBB #A2A2A2;
                border-image: none;
                border-radius: 4px 4px 4px 4px;
                border-style: solid;
                border-width: 1px;
                box-shadow: 0 1px 0 rgba(255, 255, 255, 0.2) inset, 0 1px 2px rgba(0, 0, 0, 0.05);
                color: #333333;
                cursor: pointer;
                display: inline-block;
                font-size: 13px;
                line-height: 18px;
                margin-bottom: 0;
                padding: 4px 12px;
                text-align: center;
                text-shadow: 0 1px 1px rgba(255, 255, 255, 0.75);
                vertical-align: middle;
            }
        </style>
        <div class="row">
    <?php echo JText::_('COM_MYMAPLOCATIONS_HEIGHT_TEXT'); ?>:<input type="text" id="plug_height" name="plug_height" value="<?php echo $params->get('height', '400px'); ?>" class="span2 col-md-2"/> <?php echo JText::_('COM_MYMAPLOCATIONS_WIDTH_TEXT'); ?>:<input type="text" name="plug_width" id="plug_width" value="<?php echo $params->get('width', '58%'); ?>" class="span2 col-md-2"/> <?php echo JText::_('COM_MYMAPLOCATIONS_ZOOM_TEXT'); ?>:<input type="text" id="plug_zoom" name="plug_zoom" value="<?php echo $params->get('zoom', '11'); ?>" class="span2 col-md-2"/>
        <?php echo JText::_('COM_MYMAPLOCATIONS_TYPE_TEXT'); ?>:<select name="plug_type" id="plug_type" class="col-md-2" default="google"><option value="google"><?php echo JText::_('COM_MYMAPLOCATIONS_MAP_GOOGLE'); ?></option><option value="bing"><?php echo JText::_('COM_MYMAPLOCATIONS_MAP_BING'); ?></option><option value="mapbox"><?php echo JText::_('Map Box'); ?></option></select>
        <br/><a class="pointer btn data col-md-4" onclick="javascript:checkMultiple()"><?php echo JText::_('COM_MYMAPLOCATIONS_MULTIPLE_ADD'); ?></a>
        </div>
        <script type="text/javascript">
            function checkMultiple()
            {
                var chk_arr =  document.getElementsByName("cid[]");
                var chklength = chk_arr.length;
                var plugin="";
                for(k=0;k< chklength;k++)
                {
    				
                    if(chk_arr[k].checked==true)
                    {
                        plugin=plugin+","+(chk_arr[k].value);
                    }
    			
                }
                plugin=plugin.slice(1);
                var height=document.getElementById("plug_height").value;
                var width=document.getElementById("plug_width").value;
                var zoom=document.getElementById("plug_zoom").value;
                var type=document.getElementById("plug_type").value;
                plugin=plugin+" width="+width+" height="+height+" zoom="+zoom+" type="+type+" ";
                if (window.parent) window.parent.<?php echo $this->escape($function); ?>(plugin, 'bulk');
            }
        </script>
<?php } ?>
<form action="<?php echo JRoute::_('index.php?option=com_mymaplocations&view=locations&layout=modal&tmpl=component&data=bulk&function='.$function); ?>" method="post" name="adminForm" id="adminForm">
<?php if (!empty($this->sidebar)): ?>
        <div id="j-sidebar-container" class="span2 col-md-2">
        <?php echo $this->sidebar; ?>
        </div>
        <div id="j-main-container" class="span10">
        <?php else : ?>
            <div id="j-main-container">
        <?php endif; ?>

            <div id="filter-bar" class="btn-toolbar">
                <div class="filter-search btn-group pull-left input-group">
                    <label for="filter_search" class="element-invisible"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
                    <input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('Search'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('JGLOBAL_TITLE'); ?>" />
                </div>
                <div class="btn-group pull-left">
                    <button class="btn hasTooltip btn-primary" type="submit" title="<?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i></button>
                    <button class="btn hasTooltip btn-danger" type="button" title="<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
                </div>
      
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
<?php echo $this->pagination->getLimitBox(); ?>
                </div>
                <div class="btn-group pull-right hidden-phone">
                    <label for="directionTable" class="element-invisible"><?php echo JText::_('JFIELD_ORDERING_DESC'); ?></label>
                    <select name="directionTable" id="directionTable" class="input-medium" onchange="Joomla.orderTable()">
                        <option value=""><?php echo JText::_('JFIELD_ORDERING_DESC'); ?></option>
                        <option value="asc" <?php if ($listDirn == 'asc') echo 'selected="selected"'; ?>><?php echo JText::_('JGLOBAL_ORDER_ASCENDING'); ?></option>
                        <option value="desc" <?php if ($listDirn == 'desc') echo 'selected="selected"'; ?>><?php echo JText::_('JGLOBAL_ORDER_DESCENDING'); ?></option>
                    </select>
                </div>
                <div class="btn-group pull-right">
                    <label for="sortTable" class="element-invisible"><?php echo JText::_('JGLOBAL_SORT_BY'); ?></label>
                    <select name="sortTable" id="sortTable" class="input-medium" onchange="Joomla.orderTable()">
                        <option value=""><?php echo JText::_('JGLOBAL_SORT_BY'); ?></option>
<?php echo JHtml::_('select.options', $sortFields, 'value', 'text', $listOrder); ?>
                    </select>
                </div>
            <div class="btn-group pull-right hidden-phone">
					<label for="published"
						   class="element-invisible">
						<?php echo JText::_('JOPTION_SELECT_PUBLISHED'); ?>
					</label>
					<select name="filter_published" id="filter_published" class="span12 small" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), "value", "text", $this->state->get('filter.state'), true); ?>
					</select>
				</div>
            </div>
            <div class="clearfix"> </div>

            <div class="clr"> </div>
            <table class="table table-striped" id="articleList">
                <thead>
                    <tr>
                     <th width="1%">
                        </th>
                        <th>
                            <?php echo JHtml::_('grid.sort', 'JGLOBAL_TITLE', 'a.name', $listDirn, $listOrder); ?>
                        </th>
                        <th class="nowrap hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'COM_MYMAPLOCATIONS_LOCATIONS_CREATED_BY', 'a.created_by', $listDirn, $listOrder); ?>
                        </th>
                        <th width="5%" class="nowrap hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'COM_MYMAPLOCATIONS_LOCATIONS_POSTAL', 'a.postal', $listDirn, $listOrder); ?>
                        </th>
                        <th width="5%" class="nowrap hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'JGRID_HEADING_LANGUAGE', 'a.language', $listDirn, $listOrder); ?>
                        </th>
                        <th width="1%" class="nowrap center hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                </thead>
                <tbody>
<?php
$n = count($this->items);
foreach ($this->items as $i => $item) :
    $ordering = $listOrder == 'a.ordering';
    $canCreate = $user->authorise('core.create', 'com_mymaplocations.category.' . $item->catid);
    $canEdit = $user->authorise('core.edit', 'com_mymaplocations.category.' . $item->catid);
    $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $userId || $item->checked_out == 0;
    $canEditOwn = $user->authorise('core.edit.own', 'com_mymaplocations.category.' . $item->catid) && $item->created_by == $userId;
    $canChange = $user->authorise('core.edit.state', 'com_mymaplocations.category.' . $item->catid) && $canCheckin;

    $item->cat_link = JRoute::_('index.php?option=com_categories&extension=com_mymaplocations&task=edit&type=other&id=' . $item->catid);
    ?>
                        <tr class="row<?php echo $i % 2; ?>" sortable-group-id="<?php echo $item->catid ?>">
                             <td class="center">
                        <?php echo JHtml::_('grid.id', $i, $item->id); ?>
                    </td>

                            <td class="nowrap has-context">
                                <div class="pull-left">
                                   
                                    <a class="pointer" onclick="if (window.parent) window.parent.<?php echo $this->escape($function); ?>('<?php echo $item->id; ?>', '<?php echo $this->escape(addslashes($item->name)); ?>');"><?php echo $this->escape($item->name); ?></a>
                                    <span class="small">
                                        <?php echo JText::sprintf('JGLOBAL_LIST_ALIAS', $this->escape($item->alias)); ?>
                                    </span>
                                    <div class="small">
                                        <?php echo $item->category_title; ?>
                                    </div>
                                </div>
                            </td>
                            <td align="small hidden-phone">
                                <?php echo $item->created_by; ?>
                            </td>
                            <td class="center hidden-phone">
                                <?php echo $item->postal; ?>
                            </td>
                            <td class="small hidden-phone">
                                <?php if ($item->language == '*'): ?>
                                    <?php echo JText::alt('JALL', 'language'); ?>
                                <?php else: ?>
                                    <?php echo $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
                                <?php endif; ?>
                            </td>
                            <td align="center hidden-phone">
                                <?php echo $item->id; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="10">
                            <?php echo $this->pagination->getListFooter(); ?>
                        </td>
                    </tr>
                </tfoot>

            </table>

            <div>
                <input type="hidden" name="task" value="" />
                <input type="hidden" name="boxchecked" value="0" />
                <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
                <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
                <?php echo JHtml::_('form.token'); ?>
            </div>
            </form>