<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// no direct access
defined('_JEXEC') or die;

$document = JFactory::getDocument();
$document->addStyleSheet('components/com_mymaplocations/assets/css/mymaplocations.css');

$document->addStyleSheet(JURI::root() . '/components/com_mymaplocations/assets/css/materialize.css');
$term=JFactory::getApplication()->input->getString('term');
$latlng=MyMaplocationsHelper::getLatLongFromPostcode($term);
$locations=MyMaplocationsBackendHelper::getNearLocations($latlng);
$params = JComponentHelper::getParams('com_mymaplocations');
            $type = $params->get('distance_type', 1);
            if ($type == 1) {
                $distance_unit = JText::_('COM_MYMAPLOCATIONS_MILES');
            } else {
                $distance_unit = JText::_('COM_MYMAPLOCATIONS_KM');
            }
       
?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.2.0/dist/leaflet.css">
<script src="https://unpkg.com/leaflet@1.2.0/dist/leaflet-src.js"></script>

<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<?php if (!empty($this->sidebar)): ?>
        <div id="j-sidebar-container" class="span2">
        <?php echo $this->sidebar; ?>
        </div>
        <div id="j-main-container" class="span10">
        <?php else : ?>
            <div id="j-main-container">
        <?php endif; ?>
        <?php ?>
        <h1><?php echo Jtext::_('COM_MYMAPLOCATIONS_REPORT_NEAR');?>:<?php echo $term; ?></h1>
<?php if(count($locations)!=0){ ?>
	<script type="text/javascript">
      google.charts.load('current', {'packages':['table']});
      google.charts.setOnLoadCallback(drawTable);

      function drawTable() {
        var data = new google.visualization.DataTable();
        data.addColumn('string', '<?php echo JTEXT::_('COM_MYMAPLOCATIONS_TITLE_STORES');?>');
        data.addColumn('number', '<?php echo JTEXT::_('COM_MYMAPLOCATIONS_DISTREPORT')." ".$distance_unit ;?>');
        data.addColumn('string', '<?php echo JTEXT::_('COM_MYMAPLOCATIONS_FORM_LBL_STORE_TOWN');?>');
        data.addColumn('string', '<?php echo JTEXT::_('COM_MYMAPLOCATIONS_FORM_LBL_STORE_STORESTATE');?>');
        data.addColumn('string', '<?php echo JTEXT::_('COM_MYMAPLOCATIONS_FORM_LBL_STORE_COUNTRY');?>');
        data.addRows([
	
        <?php foreach($locations as $location) {?>
          ['<?php echo str_replace(array('"',"'"),array("",""),$location->name);?>', {v: <?php echo (int)$location->distance;?>, f: '<?php echo (int)$location->distance.' '.$distance_unit;?>'},'<?php echo  str_replace(array('"',"'"),array("",""),$location->town);?>','<?php echo str_replace(array('"',"'"),array("",""),$location->locationstate);?>','<?php echo str_replace(array('"',"'"),array("",""),$location->country);?>',],
        <?php }?>

        ]);

        var table = new google.visualization.Table(document.getElementById('table_div'));

        table.draw(data, {showRowNumber: true, width: '100%', height: '100%'});
      }
        
								
    </script>
        <div class="span12 row-fluid"><div id="map" style="height:350px;"></div></div>
<div class="span12 row-fluid row">
	<h3><?php echo JText::_('COM_MYMAPLOCATIONS_DISTNEAR');?>:<?php echo $term; ?> <a href="index.php?option=com_mymaplocations&view=map&task=export_log_csv" class="btn btn-small btn-primary btn-large btn-export"><?php echo JText::_('JTOOLBAR_EXPORT');?></a></h3>
	<div id="table_div"></div></div>
            <script type="text/javascript"> var pointsForJson = [
													[<?php echo $latlng['lang'].",".$latlng['lat'] ?>],
													<?php
													$m=0;
													foreach($locations as $location) {?>
													[<?php echo $location->longitude.",".$location->latitude ?>],
													<?php
													$m++;
													} ?>
];


var map = L.map('map');


var polyline = L.polyline(lngLatArrayToLatLng(pointsForJson));

	<?php
													$l=0;
													$str="";
													foreach($locations as $location) {?>
													var latlngs<?php echo $l;?> = [
    [<?php echo $latlng['lat'].",".$latlng['lang'] ?>],
    [<?php echo $location->latitude.",".$location->longitude ?>]];
	var polyline<?php echo $l;?> = L.polyline(latlngs<?php echo $l;?>, {color: 'red'}).addTo(map);
var m<?php echo $l;?> = L.marker([<?php echo $location->latitude.",".$location->longitude ?>]).bindPopup('<?php echo Jtext::_('COM_MYMAPLOCATIONS_DIST').":".(int)$location->distance. $distance_unit;?>');
													<?php
													$str.="m".$l.",";
													$l++;
													} ?>
													
													var markerGroup = L.featureGroup([<?php echo $str;?>]).addTo(map);
													markerGroup.eachLayer(function(layer) {
  layer.openPopup();
});


L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
  attribution: '&copy; <a href="http://osm.org/copyright">OpenStreetMap</a> contributors'
}).addTo(map);

L.circle([<?php echo $latlng['lat'].",".$latlng['lang'] ?>], {radius: <?php echo $locations[$m-1]->distance*1000;?>}).addTo(map);


map.fitBounds(polyline.getBounds());

function lngLatArrayToLatLng(lngLatArray) {
  return lngLatArray.map(lngLatToLatLng);
}

function lngLatToLatLng(lngLat) {
  return [lngLat[1], lngLat[0]];
}
</script>
												<?php } ?>