<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('behavior.multiselect');
JHtml::_('dropdown.init');


JHTML::_('script', 'system/multiselect.js', false, true);
$user = JFactory::getUser();
$userId = $user->get('id');
$document = JFactory::getDocument();
$document->addStyleSheet(JURI::root() . '/components/com_mymaplocations/assets/css/materialize.css');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
$archived = $this->state->get('filter.published') == 2 ? true : false;
$trashed = $this->state->get('filter.published') == -2 ? true : false;
$canOrder = $user->authorise('core.edit.state', 'com_mymaplocations.category');
$saveOrder = $listOrder == 'a.ordering';
$params = JComponentHelper::getParams('com_mymaplocations');
$stats=$params->get('stats',0);
if ($saveOrder) {
    $saveOrderingUrl = 'index.php?option=com_mymaplocations&task=locations.saveOrderAjax&tmpl=component';
    JHtml::_('sortablelist.sortable', 'articleList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}
$sortFields = $this->getSortFields();
$document = JFactory::getDocument();
if($stats==true)
{
$document->addScript('https://www.gstatic.com/charts/loader.js');
}
$document->addStyleSheet('components/com_mymaplocations/assets/css/mymaplocations.css');
$n = count($this->items);
$chartdatas=MyMaplocationsBackendHelper::getReportChart($this->state->get('filter.cal_event_date'),$this->state->get('filter.cal_event_enddate'),$this->state->get('filter.filter_component'));

?>
<script type="text/javascript">
    Joomla.orderTable = function() {
        table = document.getElementById("sortTable");
        direction = document.getElementById("directionTable");
        order = table.options[table.selectedIndex].value;
        if (order != '<?php echo $listOrder; ?>') {
            dirn = 'asc';
        } else {
            dirn = direction.options[direction.selectedIndex].value;
        }
        Joomla.tableOrdering(order, dirn, '');
    }
</script>

<?php if (!empty($this->sidebar)): ?>
        <div id="j-sidebar-container" class="span2">
        <?php echo $this->sidebar; ?>
        </div>
        <div id="j-main-container" class="span10">
        <?php else : ?>
            <div id="j-main-container">
        <?php endif; ?>
                    <?php if($stats==0) {?>
                    <h2><?php echo JText::_('COM_MYMAPLOCATIONS_STATS_ERROR'); ?></h2>
<?php }else {?>
<form action="<?php echo JRoute::_('index.php?option=com_mymaplocations&view=statistics'); ?>" method="post" name="adminForm" id="adminForm">

            <div id="filter-bar" class="btn-toolbar">
                <div class="filter-search btn-group pull-left input-group">
                    <label for="filter_search" class="element-invisible"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
                       <?php
                            echo JHTML::calendar($this->state->get('filter.cal_event_date'),'cal_event_date','cal_event_id','%Y-%m-%d');
                            echo JHTML::calendar($this->state->get('filter.cal_event_enddate'),'cal_event_enddate','cal_event_endid','%Y-%m-%d');
                        ?>
                </div>
                <div class="btn-group pull-left">
                    <button class="btn hasTooltip btn-primary" type="submit" title="<?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i></button>
                    <button class="btn hasTooltip btn-danger" type="button" title="<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
                </div>
                
      
                <div class="btn-group pull-right hidden-phone">
                 
                    <?php echo MyMaplocationsBackendHelper::getExtensionData($this->state->get('filter.filter_component'));?>
                </div>
            </div>
            <div class="clearfix"> </div>
        <?php if(count($chartdatas)!=0) {?>
    <script type="text/javascript">
		 
     google.charts.load("current", {packages:["corechart"]});
      google.charts.setOnLoadCallback(drawChart);
function drawChart() {
	
		var data = new google.visualization.DataTable();
		data.addColumn('date', 'Month');
      data.addColumn('number', "<?php echo JText::_('COM_MYMAPLOCATIONS_MONTHLY_HITS');?>");

      data.addRows([
				<?php
		foreach($chartdatas as $chartdata) {
			?>
        [new Date(<?php echo JFactory::getDate($chartdata->updated)->format('Y ').",".(JFactory::getDate($chartdata->updated)->format('m')-1).",".JFactory::getDate($chartdata->updated)->format('d');?>), <?php echo $chartdata->count?>],
		<?php } ?>
      ]);
	  
		var dateFormatter = new google.visualization.DateFormat({pattern: 'MMM-YYYY'});
		  dateFormatter.format(data, 0);
    
    var options = {
        title : '<?php echo JText::_('COM_MYMAPLOCATIONS_YEARLY_HITS');?>',
        legend : {
            position : 'bottom'
        },
        height : 400,
        interpolateNulls : true,
        pointSize : 5,
        
        vAxis : {
            title : "Count",
            minValue : 0,
        },
        hAxis: {
            format: 'MMM-YYYY',
             ticks: [new Date(<?php echo JFactory::getDate($this->state->get('filter.cal_event_date'))->format('Y ').",".(JFactory::getDate($this->state->get('filter.cal_event_date'))->format('m')-1).",".JFactory::getDate($this->state->get('filter.cal_event_date'))->format('d');?>),
                     <?php
		foreach($chartdatas as $chartdata) {
			?>
            new Date(<?php echo JFactory::getDate($chartdata->updated)->format('Y ').",".(JFactory::getDate($chartdata->updated)->format('m')-1).",".JFactory::getDate($chartdata->updated)->format('d');?>),
		<?php } ?>
		            new Date(<?php echo JFactory::getDate($this->state->get('filter.cal_event_enddate'))->format('Y ').",".(JFactory::getDate($this->state->get('filter.cal_event_enddate'))->format('m')-1).",".JFactory::getDate($this->state->get('filter.cal_event_enddate'))->format('d');?>)],
        },
        animation : {
            duration : 1000,
            easing : 'in'
        },
         annotations: {
        textStyle: {
            fontSize: 13,
        }
        },
          pointSize: 20
    };
    

        var chart = new google.visualization.LineChart(document.getElementById('chart_div'));
        chart.draw(data, options);
}
	
    </script>

<div id="chart_div" style="width: 100%; height: 500px"></div>
<?php } ?>

<div class="clr"> </div>
            <h2><?php echo JText::_('COM_MYMAPLOCATIONS_PERIODTOPLOCATION');?><a href="index.php?option=com_mymaplocations&view=map&task=export_log_csv" class="btn btn-export btn-small btn-primary btn-large"><?php echo JText::_('JTOOLBAR_EXPORT');?></a></h2>
            <table class="table table-striped" id="articleList">
                <thead>
                    <tr>
                    <tr>
                        <th>
                            <?php echo JHtml::_('grid.sort', 'COM_MYMAPLOCATIONS_SEASRCHAREA', 'a.term', $listDirn, $listOrder); ?>
                        </th>
                        <th class="nowrap hidden-phone">
                            <?php echo JText::_('COM_MYMAPLOCATIONS_OVERALL_HITS'); ?>
                        </th>
                        <th width="1%" class="nowrap center hidden-phone">
                            <?php echo JText::_('JGRID_HEADING_ID'); ?>
                        </th>
                    </tr>
                </thead>
                <tbody>
<?php
foreach ($this->items as $i => $item) :
    $ordering = $listOrder == 'a.ordering';
	 ?>
                        <tr class="row<?php echo $i % 2; ?>">
                            <td class="nowrap has-context">
                                <div class="pull-left">
									<a href="<?php echo JRoute::_('index.php?option=com_mymaplocations&view=statistic&term='.$item->term); ?>"><?php echo $this->escape($item->term); ?></a>
                                </div>
                            </td>
                            <td align="small hidden-phone">
								<?php echo $item->count; ?>
                            </td>
                            <td align="center hidden-phone">
                                <?php echo $item->id; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="10">
                            <?php echo $this->pagination->getListFooter(); ?>
                        </td>
                    </tr>
                </tfoot>

            </table>

            <div>
                <input type="hidden" name="task" value="" />
                <input type="hidden" name="boxchecked" value="0" />
                <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
                <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
                <?php echo JHtml::_('form.token'); ?>
                                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible"><?php echo JText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
<?php echo $this->pagination->getLimitBox(); ?></div>
            </form>
            <?php } ?>
			</div>
            