<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of Mymaplocations.
 *
 * @since  1.6
 */
class MymaplocationsViewStatistics extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template name
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	public function display($tpl = null)
	{
		$this->state = $this->get('State');
		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');
        require_once JPATH_COMPONENT_ADMINISTRATOR. '/helpers/mymaplocations.php';
        MyMaplocationsBackendHelper::loadLanguage();
        $user = JFactory::getUser();
        $isroot = $user->authorise('core.manage');
        if(!$isroot)
        {
           JFactory::getApplication()->enqueueMessage('No Authorized', 'error');
            $redir = 'index.php?option=com_mymaplocations';
            JFactory::getApplication()->redirect($redir);
        }
        $this->year=JFactory::getDate()->format("Y");
		$this->month=JFactory::getDate()->format("m");
		JToolBarHelper::title(JText::_('COM_MYMAPLOCATIONS_REPORT'));
        $this->addToolbar();
		if (!version_compare(JVERSION, '4.0', 'ge'))
		$this->sidebar = JHtmlSidebar::render();
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors));
		}
		parent::display($tpl);
	}
	protected function addToolbar() {
	  $toolbar = JToolBar::getInstance('toolbar');
	  
			$button = '<a onclick="return confirm(\''.Jtext::_('JGLOBAL_CONFIRM_DELETE').'\')" href="index.php?option=com_mymaplocations&task=delete_log" class="btn btn-small btn-danger  btn-large"></i>'.JText::_('COM_MYMAPLOCATIONS_REPORT_DELETE').'</a>';
            $toolbar->appendButton('Custom', $button);
								
            JToolBarHelper::preferences('com_mymaplocations');
	 }

	
	/**
	 * Method to order fields 
	 *
	 * @return void 
	 */
	protected function getSortFields()
	{
		return array(
			'a.`id`' => JText::_('JGRID_HEADING_ID'),
			'a.`term`' => JText::_('COM_MYMAPLOCATIONS_STATISTICS_TERM'),
		);
	}

    /**
     * Check if state is set
     *
     * @param   mixed  $state  State
     *
     * @return bool
     */
    public function getState($state)
    {
        return isset($this->state->{$state}) ? $this->state->{$state} : false;
    }
}
