<?php

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\Adapter\ModuleAdapter;

defined( '_JEXEC' ) or die( 'Restricted Access' );

class Mod_JchmodeswitcherInstallerScript
{
	protected $moduleClient = 'administrator';

	protected $moduleName = 'mod_jchmodeswitcher';

	public function postflight( string $type, ModuleAdapter $parent ): void
	{
		if ( $type == 'install' || $type == 'update' )
		{
			$this->publishModule();
		}
	}

	private function publishModule()
	{
		$oDb = Factory::getDbo();

		//get module id
		$oQuery = $oDb->getQuery( true )
			->select( $oDb->quoteName( 'id' ) )
			->from( '#__modules' )
			->where( $oDb->quoteName( 'module' ) . ' = ' . $oDb->quote( 'mod_jchmodeswitcher' ) )
			->where( $oDb->quoteName( 'client_id' ) . ' = 1' );
		$oDb->setQuery( $oQuery, 0, 1 );
		$iId = $oDb->loadResult();

		if ( ! $iId )
		{
			return;
		}

		//Check if module in modules_menu table
		$oQuery->clear()
			->select( $oDb->quoteName( 'moduleid' ) )
			->from( '#__modules_menu' )
			->where( $oDb->quoteName( 'moduleid' ) . ' = ' . (int)$iId );
		$oDb->setQuery( $oQuery, 0, 1 );

		if ( $oDb->loadResult() )
		{
			return;
		}

		//Get highest order
		$oQuery->clear()
			->select( $oDb->quoteName( 'ordering' ) )
			->from( '#__modules' )
			->where( $oDb->quoteName( 'position' ) . ' = ' . $oDb->quote( 'status' ) )
			->where( $oDb->quoteName( 'client_id' ) . ' = 1' )
			->order( 'ordering DESC' );
		$oDb->setQuery( $oQuery, 0, 1 );
		$iOrdering = $oDb->loadResult();
		$iOrdering++;

		//publish module
		$oQuery->clear()
			->update( '#__modules' )
			->set( $oDb->quoteName( 'published' ) . ' = 1' )
			->set( $oDb->quoteName( 'ordering' ) . ' = ' . (int)$iOrdering )
			->set( $oDb->quoteName( 'position' ) . ' = ' . $oDb->quote( 'status' ) )
			->set( $oDb->quoteName( 'access' ) . ' = 2' )
			->where( $oDb->quoteName( 'id' ) . ' = ' . (int)$iId );
		$oDb->setQuery( $oQuery );
		$oDb->execute();

		//add module to the modules_menu table
		$oQuery->clear()
			->insert( '#__modules_menu' )
			->columns( [ $oDb->quoteName( 'moduleid' ), $oDb->quoteName( 'menuid' ) ] )
			->values( (int)$iId . ',  0' );
		$oDb->setQuery( $oQuery );
		$oDb->execute();
	}
}