<?php
/**
 * @package     MPF
 * @subpackage  UI
 *
 * @copyright   Copyright (C) 2016 - 2018 Ossolution Team, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
defined('_JEXEC') or die;


/**
 * Base class for a Joomla Administrator Controller. It handles add, edit, delete, publish, unpublish records....
 *
 * @package       MPF
 * @subpackage    UI
 * @since         2.0
 */
class RADUiBootstrap4 extends RADUiAbstract implements RADUiInterface
{
	/**
	 * Constructor
	 *
	 * @param array $classMaps
	 */
	public function __construct($classMaps = array())
	{
		if (empty($classMaps))
		{
			$classMaps = [
				'row-fluid'          => 'row',
				'span1'              => 'col-lg-1',
				'span2'              => 'col-lg-2',
				'span3'              => 'col-lg-3',
				'span4'              => 'col-lg-4',
				'span5'              => 'col-lg-5',
				'span6'              => 'col-lg-6',
				'span7'              => 'col-lg-7',
				'span8'              => 'col-lg-8',
				'span9'              => 'col-lg-9',
				'span10'             => 'col-lg-10',
				'span11'             => 'col-lg-11',
				'span12'             => 'col-lg-12',
				'pull-left'          => 'float-left',
				'pull-right'         => 'float-right',
				'btn'                => 'btn btn-secondary',
				'btn-mini'           => 'btn-xs',
				'btn-small'          => 'btn-sm',
				'btn-large'          => 'btn-lg',
				'btn-inverse'        => 'btn-primary',
				'visible-phone'      => 'd-block d-sm-none',
				'visible-tablet'     => 'visible-sm',
				'visible-desktop'    => 'd-block d-md-none',
				'hidden-phone'       => 'd-none',
				'hidden-tablet'      => 'd-sm-none',
				'hidden-desktop'     => 'd-md-none hidden-lg',
				'control-group'      => 'form-group form-row',
				'input-prepend'      => 'input-group-prepend',
				'input-append'       => 'input-group-append',
				'add-on'             => 'input-group-text',
				'img-polaroid'       => 'img-thumbnail',
				'control-label'      => 'col-md-3 form-control-label',
				'controls'           => 'col-md-9',
				'btn btn-primary'    => 'btn btn-primary',
				'row-fluid clearfix' => 'row clearfix',
			];
		}

		$this->classMaps = $classMaps;
	}

	/**
	 * Get the mapping of a given class
	 *
	 * @param string $class The input class
	 *
	 * @return string The mapped class
	 */
	public function getClassMapping($class)
	{
		$mappedClass = parent::getClassMapping($class);

		if ($mappedClass !== null)
		{
			return $mappedClass;
		}

		// Handle icon class
		if (strpos($class, 'icon-') !== false)
		{
			$icon = substr($class, 5);

			return 'fa fa-' . $icon;
		}

		// If no class found, return original class
		return $class;
	}

	/**
	 * Method to render input with prepend add-on
	 *
	 * @param string $input
	 * @param string $addOn
	 *
	 * @return string
	 */
	public function getPrependAddon($input, $addOn)
	{
		$html   = [];
		$html[] = '<div class="input-group">';
		$html[] = '<div class="input-group-prepend">';
		$html[] = '<span class="input-group-text">' . $addOn . '</span>';
		$html[] = '</div>';
		$html[] = $input;
		$html[] = '</div>';

		return implode("\n", $html);
	}

	/**
	 * Method to render input with append add-on
	 *
	 * @param string $input
	 * @param string $addOn
	 *
	 * @return string
	 */
	public function getAppendAddon($input, $addOn)
	{
		$html   = [];
		$html[] = '<div class="input-group">';
		$html[] = $input;
		$html[] = '<div class="input-group-append">';
		$html[] = '<span class="input-group-text">' . $addOn . '</span>';
		$html[] = '</div>';
		$html[] = '</div>';

		return implode("\n", $html);
	}
}