CREATE TABLE IF NOT EXISTS `#__eb_agendas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(10) UNSIGNED DEFAULT '0',
  `time` varchar(100) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_event_id` (`event_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `layout` varchar(50) DEFAULT NULL,
  `description` text,
  `ordering` int(11) DEFAULT NULL,
  `access` int(11) NOT NULL DEFAULT '1',
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `page_title` varchar(255) DEFAULT NULL,
  `page_heading` varchar(255) DEFAULT NULL,
  `meta_keywords` varchar(255) DEFAULT NULL,
  `meta_description` varchar(255) DEFAULT NULL,
  `image` varchar(250) DEFAULT NULL,
  `submit_event_access` int(11) NOT NULL DEFAULT '1',
  `color_code` varchar(20) DEFAULT NULL,
  `text_color` varchar(20) DEFAULT NULL,
  `language` varchar(50) DEFAULT '*',
  `level` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_parent` (`parent`),
  KEY `idx_access` (`access`),
  KEY `idx_published` (`published`),
  KEY `idx_alias` (`alias`(191))
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `config_key` varchar(100) DEFAULT NULL,
  `config_value` text,
  `language` varchar(50) DEFAULT '*',
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=238 CHARACTER SET `utf8`;
INSERT IGNORE INTO `#__eb_configs` (`id`, `config_key`, `config_value`, `language`) VALUES
(1, 'option', 'com_eventbooking', '*'),
(2, 'view', 'configuration', '*'),
(3, 'download_id', '', '*'),
(4, 'custom_field_by_category', '0', '*'),
(5, 'load_bootstrap_css_in_frontend', '1', '*'),
(6, 'twitter_bootstrap_version', '2', '*'),
(7, 'load_font_awesome', '1', '*'),
(8, 'activate_recurring_event', '0', '*'),
(9, 'show_children_events_under_parent_event', '0', '*'),
(10, 'max_number_of_children_events', '30', '*'),
(11, 'use_https', '0', '*'),
(12, 'category_dropdown_ordering', 'name', '*'),
(13, 'hide_past_events', '0', '*'),
(14, 'show_until_end_date', '0', '*'),
(15, 'hide_past_events_from_events_dropdown', '0', '*'),
(16, 'date_format', 'm-d-Y', '*'),
(17, 'event_date_format', 'm-d-Y g:i a', '*'),
(18, 'event_time_format', 'g:i a', '*'),
(19, 'date_field_format', '%Y-%m-%d', '*'),
(20, 'currency_code', 'USD', '*'),
(21, 'currency_symbol', '$', '*'),
(22, 'decimals', '2', '*'),
(23, 'dec_point', '.', '*'),
(24, 'thousands_sep', ',', '*'),
(25, 'currency_position', '', '*'),
(26, 'event_custom_field', '0', '*'),
(27, 'only_show_registrants_of_event_owner', '0', '*'),
(28, 'enable_delete_registrants', '1', '*'),
(29, 'show_all_locations_in_event_submission_form', '0', '*'),
(30, 'submit_event_redirect_url', '', '*'),
(31, 'search_events', 'exact', '*'),
(32, 'radius_search_distance', 'KM', '*'),
(33, 'default_country', 'United States', '*'),
(34, 'show_feed_link', '1', '*'),
(35, 'send_emails', '0', '*'),
(36, 'from_name', '', '*'),
(37, 'from_email', '', '*'),
(38, 'reply_to_email', '', '*'),
(39, 'notification_emails', '', '*'),
(40, 'send_email_to_event_creator', '1', '*'),
(41, 'send_email_to_group_members', '0', '*'),
(42, 'send_attachments_to_admin', '0', '*'),
(43, 'map_provider', 'googlemap', '*'),
(44, 'map_api_key', '', '*'),
(45, 'center_coordinates', '', '*'),
(46, 'zoom_level', '10', '*'),
(47, 'map_width', '600', '*'),
(48, 'map_height', '480', '*'),
(49, 'user_registration', '0', '*'),
(50, 'auto_populate_form_data', '1', '*'),
(51, 'populate_group_members_data', '0', '*'),
(52, 'allow_populate_group_member_data', '0', '*'),
(53, 'multiple_booking', '0', '*'),
(54, 'collect_member_information_in_cart', '0', '*'),
(55, 'collect_member_information', '1', '*'),
(56, 'auto_populate_billing_data', '', '*'),
(57, 'prevent_duplicate_registration', '0', '*'),
(58, 'simply_registration_process', '0', '*'),
(59, 'activate_deposit_feature', '0', '*'),
(60, 'default_payment_type', '0', '*'),
(61, 'activate_waitinglist_feature', '0', '*'),
(62, 'enable_waiting_list_payment', '0', '*'),
(63, 'unpublish_event_when_full', '0', '*'),
(64, 'send_ics_file', '0', '*'),
(65, 'enable_captcha', '0', '*'),
(66, 'bypass_captcha_for_registered_user', '0', '*'),
(67, 'enable_coupon', '0', '*'),
(68, 'show_pending_registrants', '0', '*'),
(69, 'show_price_including_tax', '0', '*'),
(70, 'setup_price', '0', '*'),
(71, 'include_group_billing_in_registrants', '1', '*'),
(72, 'include_group_members_in_registrants', '0', '*'),
(73, 'include_group_billing_in_registrants_list', '1', '*'),
(74, 'include_group_members_in_registrants_list', '0', '*'),
(75, 'show_billing_step_for_free_events', '0', '*'),
(76, 'activate_checkin_registrants', '0', '*'),
(77, 'accept_term', '0', '*'),
(78, 'article_id', '', '*'),
(79, 'show_available_number_for_each_quantity_option', '0', '*'),
(80, 'display_field_description', 'use_tooltip', '*'),
(81, 'show_privacy_policy_checkbox', '0', '*'),
(82, 'privacy_policy_article_id', '', '*'),
(83, 'privacy_policy_url', '', '*'),
(84, 'show_subscribe_newsletter_checkbox', '0', '*'),
(85, 'show_agreement_on_email', '0', '*'),
(86, 'store_user_ip', '1', '*'),
(87, 'store_images_in_user_folder', '0', '*'),
(88, 'resize_image_method', 'resize', '*'),
(89, 'thumb_width', '200', '*'),
(90, 'thumb_height', '200', '*'),
(91, 'category_thumb_width', '', '*'),
(92, 'category_thumb_height', '', '*'),
(93, 'image_max_file_size', '', '*'),
(94, 'image_max_width', '', '*'),
(95, 'image_max_height', '', '*'),
(96, 'registration_type', '0', '*'),
(97, 'access', '1', '*'),
(98, 'registration_access', '1', '*'),
(99, 'default_event_status', '0', '*'),
(100, 'attachment_file_types', 'bmp|gif|jpg|png|swf|zip|doc|pdf|xls', '*'),
(101, 'upload_max_file_size', '', '*'),
(102, 'csv_delimiter', ',', '*'),
(103, 'export_data_format', 'xlsx', '*'),
(104, 'checkin_api_key', '', '*'),
(105, 'conversion_tracking_code', '', '*'),
(106, 'qrcode_size', '3', '*'),
(107, 'check_new_version_in_dashboard', '1', '*'),
(108, 'debug', '0', '*'),
(109, 'calendar_theme', 'default', '*'),
(110, 'calendar_start_date', '0', '*'),
(111, 'activate_weekly_calendar_view', '1', '*'),
(112, 'activate_daily_calendar_view', '0', '*'),
(113, 'show_thumb_in_calendar', '0', '*'),
(114, 'show_event_time', '0', '*'),
(115, 'display_event_in_tooltip', '0', '*'),
(116, 'show_calendar_legend', '0', '*'),
(117, 'show_multiple_days_event_in_calendar', '0', '*'),
(118, 'number_categories', '10', '*'),
(119, 'show_empty_cat', '1', '*'),
(120, 'show_number_events', '1', '*'),
(121, 'show_image_in_event_detail', '1', '*'),
(122, 'display_large_image', '0', '*'),
(123, 'large_image_width', '', '*'),
(124, 'large_image_height', '', '*'),
(125, 'show_fb_like_button', '1', '*'),
(126, 'show_location_info_in_event_details', '0', '*'),
(127, 'show_invite_friend', '1', '*'),
(128, 'show_save_to_personal_calendar', '0', '*'),
(129, 'show_social_bookmark', '1', '*'),
(130, 'submit_event_form_layout', '', '*'),
(131, 'process_plugin', '1', '*'),
(132, 'show_attachment_in_frontend', '0', '*'),
(133, 'show_search_bar', '0', '*'),
(134, 'display_message_for_full_event', '1', '*'),
(135, 'show_print_button', '1', '*'),
(136, 'show_event_location_in_email', '0', '*'),
(137, 'show_event_date', '0', '*'),
(138, 'show_coupon_code_in_registrant_list', '0', '*'),
(139, 'number_speakers_per_row', '4', '*'),
(140, 'number_sponsors_per_row', '4', '*'),
(141, 'number_events', '10', '*'),
(142, 'order_events', '2', '*'),
(143, 'order_direction', 'asc', '*'),
(144, 'display_featured_events_on_top', '0', '*'),
(145, 'register_buttons_position', '0', '*'),
(146, 'hide_detail_button', '0', '*'),
(147, 'show_events_from_all_children_categories', '0', '*'),
(148, 'show_event_custom_field_in_category_layout', '0', '*'),
(149, 'show_location_in_category_view', '0', '*'),
(150, 'show_cat_decription_in_table_layout', '1', '*'),
(151, 'show_image_in_table_layout', '0', '*'),
(152, 'show_event_end_date_in_table_layout', '0', '*'),
(153, 'show_price_in_table_layout', '0', '*'),
(154, 'link_thumb_to_event_detail_page', '1', '*'),
(155, 'enable_add_multiple_events_to_cart', '0', '*'),
(156, 'show_actions_button', '1', '*'),
(157, 'show_event_end_date', '1', '*'),
(158, 'show_cut_off_date', '1', '*'),
(159, 'show_registration_start_date', '1', '*'),
(160, 'show_price_for_free_event', '1', '*'),
(161, 'show_discounted_price', '0', '*'),
(162, 'show_capacity', '1', '*'),
(163, 'show_registered', '1', '*'),
(164, 'show_available_place', '1', '*'),
(165, 'show_list_of_registrants', '1', '*'),
(166, 'show_event_creator', '0', '*'),
(167, 'show_event_categories', '0', '*'),
(168, 'default_menu_item', '', '*'),
(169, 'insert_event_id', '0', '*'),
(170, 'insert_category', '0', '*'),
(171, 'activate_invoice_feature', '0', '*'),
(172, 'always_generate_invoice', '0', '*'),
(173, 'generated_invoice_for_paid_registration_only', '0', '*'),
(174, 'send_invoice_to_customer', '0', '*'),
(175, 'send_invoice_to_admin', '0', '*'),
(176, 'invoice_start_number', '1', '*'),
(177, 'reset_invoice_number', '0', '*'),
(178, 'invoice_prefix', 'IV', '*'),
(179, 'invoice_number_length', '5', '*'),
(180, 'pdf_font', 'times', '*'),
(181, 'invoice_format', '<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" width=\"100%\">\r\n<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td width=\"100%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Company Name:</td>\r\n<td align=\"left\">Ossolution Team</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">URL:</td>\r\n<td align=\"left\">http://www.joomdonation.com</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Phone:</td>\r\n<td align=\"left\">84-972409994</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">E-mail:</td>\r\n<td align=\"left\">contact@joomdonation.com</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Address:</td>\r\n<td align=\"left\">Lang Ha - Ba Dinh - Ha Noi</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align=\"right\" valign=\"middle\" width=\"50%\"><img style=\"border: 0;\" src=\"media/com_eventbooking/invoice_logo.png\" alt=\"\" /></td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"2\" align=\"left\" width=\"100%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td style=\"background-color: #d6d6d6;\" colspan=\"2\" align=\"left\">\r\n<h4 style=\"margin: 0px;\">Customer Information</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Name:</td>\r\n<td align=\"left\">[NAME]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Company:</td>\r\n<td align=\"left\">[ORGANIZATION]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Phone:</td>\r\n<td align=\"left\">[PHONE]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Email:</td>\r\n<td align=\"left\">[EMAIL]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Address:</td>\r\n<td align=\"left\">[ADDRESS], [CITY], [STATE], [COUNTRY]</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td style=\"background-color: #d6d6d6;\" colspan=\"2\" align=\"left\">\r\n<h4 style=\"margin: 0px;\">Invoice Information</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Invoice Number:</td>\r\n<td align=\"left\">[INVOICE_NUMBER]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Invoice Date:</td>\r\n<td align=\"left\">[INVOICE_DATE]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Invoice Status:</td>\r\n<td align=\"left\">[INVOICE_STATUS]</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td style=\"background-color: #d6d6d6;\" colspan=\"2\" align=\"left\">\r\n<h4 style=\"margin: 0px;\">Order Items</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"2\" align=\"left\" width=\"100%\">\r\n<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" valign=\"top\" width=\"10%\">#</td>\r\n<td align=\"left\" valign=\"top\" width=\"60%\">Name</td>\r\n<td align=\"right\" valign=\"top\" width=\"20%\">Price</td>\r\n<td align=\"left\" valign=\"top\" width=\"10%\">Sub Total</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" valign=\"top\" width=\"10%\">1</td>\r\n<td align=\"left\" valign=\"top\" width=\"60%\">[ITEM_NAME]</td>\r\n<td align=\"right\" valign=\"top\" width=\"20%\">[ITEM_AMOUNT]</td>\r\n<td align=\"left\" valign=\"top\" width=\"10%\">[ITEM_SUB_TOTAL]</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"3\" align=\"right\" valign=\"top\" width=\"90%\">Discount :</td>\r\n<td align=\"left\" valign=\"top\" width=\"10%\">[DISCOUNT_AMOUNT]</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"3\" align=\"right\" valign=\"top\" width=\"90%\">Subtotal :</td>\r\n<td align=\"left\" valign=\"top\" width=\"10%\">[SUB_TOTAL]</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"3\" align=\"right\" valign=\"top\" width=\"90%\">Tax :</td>\r\n<td align=\"left\" valign=\"top\" width=\"10%\">[TAX_AMOUNT]</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"3\" align=\"right\" valign=\"top\" width=\"90%\">Total :</td>\r\n<td align=\"left\" valign=\"top\" width=\"10%\">[TOTAL_AMOUNT]</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '*'),
(182, 'invoice_format_cart', '<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" width=\"100%\">\r\n<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td width=\"100%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Company Name:</td>\r\n<td align=\"left\">Ossolution Team</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">URL:</td>\r\n<td align=\"left\">http://www.joomdonation.com</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Phone:</td>\r\n<td align=\"left\">84-972409994</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">E-mail:</td>\r\n<td align=\"left\">contact@joomdonation.com</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Address:</td>\r\n<td align=\"left\">Lang Ha - Ba Dinh - Ha Noi</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align=\"right\" valign=\"middle\" width=\"50%\"><img style=\"border: 0;\" src=\"media/com_eventbooking/invoice_logo.png\" alt=\"\" /></td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"2\" align=\"left\" width=\"100%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td style=\"background-color: #d6d6d6;\" colspan=\"2\" align=\"left\">\r\n<h4 style=\"margin: 0px;\">Customer Information</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Name:</td>\r\n<td align=\"left\">[NAME]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Company:</td>\r\n<td align=\"left\">[ORGANIZATION]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Phone:</td>\r\n<td align=\"left\">[PHONE]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Email:</td>\r\n<td align=\"left\">[EMAIL]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Address:</td>\r\n<td align=\"left\">[ADDRESS], [CITY], [STATE], [COUNTRY]</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td style=\"background-color: #d6d6d6;\" colspan=\"2\" align=\"left\">\r\n<h4 style=\"margin: 0px;\">Invoice Information</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Invoice Number:</td>\r\n<td align=\"left\">[INVOICE_NUMBER]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Invoice Date:</td>\r\n<td align=\"left\">[INVOICE_DATE]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Invoice Status:</td>\r\n<td align=\"left\">[INVOICE_STATUS]</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td style=\"background-color: #d6d6d6;\" colspan=\"2\" align=\"left\">\r\n<h4 style=\"margin: 0px;\">Order Items</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"2\" align=\"left\" width=\"100%\">[EVENTS_LIST]</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '*'),
(183, 'activate_tickets_pdf', '0', '*'),
(184, 'send_tickets_via_email', '1', '*'),
(185, 'ticket_number_length', '5', '*'),
(186, 'ticket_page_orientation', 'P', '*'),
(187, 'ticket_page_format', 'A4', '*'),
(188, 'default_ticket_bg_image', '', '*'),
(189, 'default_ticket_bg_left', '0', '*'),
(190, 'default_ticket_bg_top', '0', '*'),
(191, 'default_ticket_bg_width', '210', '*'),
(192, 'default_ticket_bg_height', '297', '*'),
(193, 'default_ticket_layout', '<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" width=\"100%\">\r\n<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td width=\"100%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Company Name:</td>\r\n<td align=\"left\">Ossolution Team</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">URL:</td>\r\n<td align=\"left\">http://www.joomdonation.com</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Phone:</td>\r\n<td align=\"left\">84-972409994</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">E-mail:</td>\r\n<td align=\"left\">contact@joomdonation.com</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Address:</td>\r\n<td align=\"left\">Lang Ha - Ba Dinh - Ha Noi</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align=\"right\" valign=\"middle\" width=\"50%\"><img style=\"border: 0;\" src=\"media/com_eventbooking/invoice_logo.png\" alt=\"\" /></td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"2\" align=\"left\" width=\"100%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td style=\"background-color: #d6d6d6;\" colspan=\"2\" align=\"left\">\r\n<h4 style=\"margin: 0px;\">Registrant Information</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Name:</td>\r\n<td align=\"left\">[NAME]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Company:</td>\r\n<td align=\"left\">[ORGANIZATION]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Phone:</td>\r\n<td align=\"left\">[PHONE]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Email:</td>\r\n<td align=\"left\">[EMAIL]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Address:</td>\r\n<td align=\"left\">[ADDRESS], [CITY], [STATE], [COUNTRY]</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td style=\"background-color: #d6d6d6;\" colspan=\"2\" align=\"left\">\r\n<h4 style=\"margin: 0px;\">Event Information</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Event Title:</td>\r\n<td align=\"left\">[EVENT_TITLE]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Event Date:</td>\r\n<td align=\"left\">[EVENT_DATE]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Event End Date:</td>\r\n<td align=\"left\">[EVENT_END_DATE]</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '*'),
(194, 'activate_certificate_feature', '0', '*'),
(195, 'download_certificate_if_checked_in', '0', '*'),
(196, 'certificate_prefix', 'CT', '*'),
(197, 'certificate_number_length', '5', '*'),
(198, 'certificate_page_orientation', 'P', '*'),
(199, 'certificate_page_format', 'A4', '*'),
(200, 'default_certificate_bg_image', '', '*'),
(201, 'default_certificate_bg_left', '0', '*'),
(202, 'default_certificate_bg_top', '0', '*'),
(203, 'default_certificate_bg_width', '210', '*'),
(204, 'default_certificate_bg_height', '297', '*'),
(205, 'certificate_layout', '<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" width=\"100%\">\r\n<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td width=\"100%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Company Name:</td>\r\n<td align=\"left\">Ossolution Team</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">URL:</td>\r\n<td align=\"left\">http://www.joomdonation.com</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Phone:</td>\r\n<td align=\"left\">84-972409994</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">E-mail:</td>\r\n<td align=\"left\">contact@joomdonation.com</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Address:</td>\r\n<td align=\"left\">Lang Ha - Ba Dinh - Ha Noi</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align=\"right\" valign=\"middle\" width=\"50%\"><img style=\"border: 0;\" src=\"media/com_eventbooking/invoice_logo.png\" alt=\"\" /></td>\r\n</tr>\r\n<tr>\r\n<td colspan=\"2\" align=\"left\" width=\"100%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td style=\"background-color: #d6d6d6;\" colspan=\"2\" align=\"left\">\r\n<h4 style=\"margin: 0px;\">Registrant Information</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Name:</td>\r\n<td align=\"left\">[NAME]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Company:</td>\r\n<td align=\"left\">[ORGANIZATION]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Phone:</td>\r\n<td align=\"left\">[PHONE]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Email:</td>\r\n<td align=\"left\">[EMAIL]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Address:</td>\r\n<td align=\"left\">[ADDRESS], [CITY], [STATE], [COUNTRY]</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n<td align=\"left\" valign=\"top\" width=\"50%\">\r\n<table style=\"width: 100%;\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\r\n<tbody>\r\n<tr>\r\n<td style=\"background-color: #d6d6d6;\" colspan=\"2\" align=\"left\">\r\n<h4 style=\"margin: 0px;\">Event Information</h4>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Event Title:</td>\r\n<td align=\"left\">[EVENT_TITLE]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Event Date:</td>\r\n<td align=\"left\">[EVENT_DATE]</td>\r\n</tr>\r\n<tr>\r\n<td align=\"left\" width=\"50%\">Event End Date:</td>\r\n<td align=\"left\">[EVENT_END_DATE]</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>', '*'),
(206, 'fes_show_additional_categories', '1', '*'),
(207, 'fes_show_event_end_date', '1', '*'),
(208, 'fes_show_registration_start_date', '1', '*'),
(209, 'fes_show_cut_off_date', '1', '*'),
(210, 'fes_show_price', '1', '*'),
(211, 'fes_show_price_text', '1', '*'),
(212, 'fes_show_capacity', '1', '*'),
(213, 'fes_show_registration_type', '1', '*'),
(214, 'fes_show_custom_registration_handle_url', '1', '*'),
(215, 'fes_show_notification_emails', '1', '*'),
(216, 'fes_show_paypal_email', '1', '*'),
(217, 'fes_show_access', '1', '*'),
(218, 'fes_show_registration_access', '1', '*'),
(219, 'fes_show_published', '1', '*'),
(220, 'fes_show_short_description', '1', '*'),
(221, 'fes_show_description', '1', '*'),
(222, 'export_group_billing_records', '1', '*'),
(223, 'export_group_member_records', '0', '*'),
(224, 'export_event_end_date', '0', '*'),
(225, 'export_user_id', '1', '*'),
(226, 'export_number_registrants', '1', '*'),
(227, 'export_amount', '1', '*'),
(228, 'export_discount_amount', '1', '*'),
(229, 'export_late_fee', '1', '*'),
(230, 'export_tax_amount', '1', '*'),
(231, 'export_gross_amount', '1', '*'),
(232, 'export_registration_date', '1', '*'),
(233, 'export_payment_method', '1', '*'),
(234, 'export_transaction_id', '1', '*'),
(235, 'export_payment_status', '1', '*'),
(236, 'custom_css', '', '*'),
(237, 'task', 'apply', '*');
CREATE TABLE IF NOT EXISTS `#__eb_countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_id` int(11) NOT NULL DEFAULT '1',
  `name` varchar(64) DEFAULT NULL,
  `country_3_code` char(3) DEFAULT NULL,
  `country_2_code` char(2) DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `country_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_country_name` (`name`)
) AUTO_INCREMENT=246 CHARACTER SET `utf8`;
INSERT IGNORE INTO `#__eb_countries` (`id`, `zone_id`, `name`, `country_3_code`, `country_2_code`, `published`, `country_id`) VALUES
(1, 1, 'Afghanistan', 'AFG', 'AF', 1, 1),
(2, 1, 'Albania', 'ALB', 'AL', 1, 2),
(3, 1, 'Algeria', 'DZA', 'DZ', 1, 3),
(4, 1, 'American Samoa', 'ASM', 'AS', 1, 4),
(5, 1, 'Andorra', 'AND', 'AD', 1, 5),
(6, 1, 'Angola', 'AGO', 'AO', 1, 6),
(7, 1, 'Anguilla', 'AIA', 'AI', 1, 7),
(8, 1, 'Antarctica', 'ATA', 'AQ', 1, 8),
(9, 1, 'Antigua and Barbuda', 'ATG', 'AG', 1, 9),
(10, 1, 'Argentina', 'ARG', 'AR', 1, 10),
(11, 1, 'Armenia', 'ARM', 'AM', 1, 11),
(12, 1, 'Aruba', 'ABW', 'AW', 1, 12),
(13, 1, 'Australia', 'AUS', 'AU', 1, 13),
(14, 1, 'Austria', 'AUT', 'AT', 1, 14),
(15, 1, 'Azerbaijan', 'AZE', 'AZ', 1, 15),
(16, 1, 'Bahamas', 'BHS', 'BS', 1, 16),
(17, 1, 'Bahrain', 'BHR', 'BH', 1, 17),
(18, 1, 'Bangladesh', 'BGD', 'BD', 1, 18),
(19, 1, 'Barbados', 'BRB', 'BB', 1, 19),
(20, 1, 'Belarus', 'BLR', 'BY', 1, 20),
(21, 1, 'Belgium', 'BEL', 'BE', 1, 21),
(22, 1, 'Belize', 'BLZ', 'BZ', 1, 22),
(23, 1, 'Benin', 'BEN', 'BJ', 1, 23),
(24, 1, 'Bermuda', 'BMU', 'BM', 1, 24),
(25, 1, 'Bhutan', 'BTN', 'BT', 1, 25),
(26, 1, 'Bolivia', 'BOL', 'BO', 1, 26),
(27, 1, 'Bosnia and Herzegowina', 'BIH', 'BA', 1, 27),
(28, 1, 'Botswana', 'BWA', 'BW', 1, 28),
(29, 1, 'Bouvet Island', 'BVT', 'BV', 1, 29),
(30, 1, 'Brazil', 'BRA', 'BR', 1, 30),
(31, 1, 'British Indian Ocean Territory', 'IOT', 'IO', 1, 31),
(32, 1, 'Brunei Darussalam', 'BRN', 'BN', 1, 32),
(33, 1, 'Bulgaria', 'BGR', 'BG', 1, 33),
(34, 1, 'Burkina Faso', 'BFA', 'BF', 1, 34),
(35, 1, 'Burundi', 'BDI', 'BI', 1, 35),
(36, 1, 'Cambodia', 'KHM', 'KH', 1, 36),
(37, 1, 'Cameroon', 'CMR', 'CM', 1, 37),
(38, 1, 'Canada', 'CAN', 'CA', 1, 38),
(39, 1, 'Cape Verde', 'CPV', 'CV', 1, 39),
(40, 1, 'Cayman Islands', 'CYM', 'KY', 1, 40),
(41, 1, 'Central African Republic', 'CAF', 'CF', 1, 41),
(42, 1, 'Chad', 'TCD', 'TD', 1, 42),
(43, 1, 'Chile', 'CHL', 'CL', 1, 43),
(44, 1, 'China', 'CHN', 'CN', 1, 44),
(45, 1, 'Christmas Island', 'CXR', 'CX', 1, 45),
(46, 1, 'Cocos (Keeling) Islands', 'CCK', 'CC', 1, 46),
(47, 1, 'Colombia', 'COL', 'CO', 1, 47),
(48, 1, 'Comoros', 'COM', 'KM', 1, 48),
(49, 1, 'Congo', 'COG', 'CG', 1, 49),
(50, 1, 'Cook Islands', 'COK', 'CK', 1, 50),
(51, 1, 'Costa Rica', 'CRI', 'CR', 1, 51),
(52, 1, 'Cote D\'Ivoire', 'CIV', 'CI', 1, 52),
(53, 1, 'Croatia', 'HRV', 'HR', 1, 53),
(54, 1, 'Cuba', 'CUB', 'CU', 1, 54),
(55, 1, 'Cyprus', 'CYP', 'CY', 1, 55),
(56, 1, 'Czech Republic', 'CZE', 'CZ', 1, 56),
(57, 1, 'Denmark', 'DNK', 'DK', 1, 57),
(58, 1, 'Djibouti', 'DJI', 'DJ', 1, 58),
(59, 1, 'Dominica', 'DMA', 'DM', 1, 59),
(60, 1, 'Dominican Republic', 'DOM', 'DO', 1, 60),
(61, 1, 'East Timor', 'TMP', 'TP', 1, 61),
(62, 1, 'Ecuador', 'ECU', 'EC', 1, 62),
(63, 1, 'Egypt', 'EGY', 'EG', 1, 63),
(64, 1, 'El Salvador', 'SLV', 'SV', 1, 64),
(65, 1, 'Equatorial Guinea', 'GNQ', 'GQ', 1, 65),
(66, 1, 'Eritrea', 'ERI', 'ER', 1, 66),
(67, 1, 'Estonia', 'EST', 'EE', 1, 67),
(68, 1, 'Ethiopia', 'ETH', 'ET', 1, 68),
(69, 1, 'Falkland Islands (Malvinas)', 'FLK', 'FK', 1, 69),
(70, 1, 'Faroe Islands', 'FRO', 'FO', 1, 70),
(71, 1, 'Fiji', 'FJI', 'FJ', 1, 71),
(72, 1, 'Finland', 'FIN', 'FI', 1, 72),
(73, 1, 'France', 'FRA', 'FR', 1, 73),
(74, 1, 'France, Metropolitan', 'FXX', 'FX', 1, 74),
(75, 1, 'French Guiana', 'GUF', 'GF', 1, 75),
(76, 1, 'French Polynesia', 'PYF', 'PF', 1, 76),
(77, 1, 'French Southern Territories', 'ATF', 'TF', 1, 77),
(78, 1, 'Gabon', 'GAB', 'GA', 1, 78),
(79, 1, 'Gambia', 'GMB', 'GM', 1, 79),
(80, 1, 'Georgia', 'GEO', 'GE', 1, 80),
(81, 1, 'Germany', 'DEU', 'DE', 1, 81),
(82, 1, 'Ghana', 'GHA', 'GH', 1, 82),
(83, 1, 'Gibraltar', 'GIB', 'GI', 1, 83),
(84, 1, 'Greece', 'GRC', 'GR', 1, 84),
(85, 1, 'Greenland', 'GRL', 'GL', 1, 85),
(86, 1, 'Grenada', 'GRD', 'GD', 1, 86),
(87, 1, 'Guadeloupe', 'GLP', 'GP', 1, 87),
(88, 1, 'Guam', 'GUM', 'GU', 1, 88),
(89, 1, 'Guatemala', 'GTM', 'GT', 1, 89),
(90, 1, 'Guinea', 'GIN', 'GN', 1, 90),
(91, 1, 'Guinea-bissau', 'GNB', 'GW', 1, 91),
(92, 1, 'Guyana', 'GUY', 'GY', 1, 92),
(93, 1, 'Haiti', 'HTI', 'HT', 1, 93),
(94, 1, 'Heard and Mc Donald Islands', 'HMD', 'HM', 1, 94),
(95, 1, 'Honduras', 'HND', 'HN', 1, 95),
(96, 1, 'Hong Kong', 'HKG', 'HK', 1, 96),
(97, 1, 'Hungary', 'HUN', 'HU', 1, 97),
(98, 1, 'Iceland', 'ISL', 'IS', 1, 98),
(99, 1, 'India', 'IND', 'IN', 1, 99),
(100, 1, 'Indonesia', 'IDN', 'ID', 1, 100),
(101, 1, 'Iran (Islamic Republic of)', 'IRN', 'IR', 1, 101),
(102, 1, 'Iraq', 'IRQ', 'IQ', 1, 102),
(103, 1, 'Ireland', 'IRL', 'IE', 1, 103),
(104, 1, 'Israel', 'ISR', 'IL', 1, 104),
(105, 1, 'Italy', 'ITA', 'IT', 1, 105),
(106, 1, 'Jamaica', 'JAM', 'JM', 1, 106),
(107, 1, 'Japan', 'JPN', 'JP', 1, 107),
(108, 1, 'Jordan', 'JOR', 'JO', 1, 108),
(109, 1, 'Kazakhstan', 'KAZ', 'KZ', 1, 109),
(110, 1, 'Kenya', 'KEN', 'KE', 1, 110),
(111, 1, 'Kiribati', 'KIR', 'KI', 1, 111),
(112, 1, 'Korea, Democratic People\'s Republic of', 'PRK', 'KP', 1, 112),
(113, 1, 'Korea, Republic of', 'KOR', 'KR', 1, 113),
(114, 1, 'Kuwait', 'KWT', 'KW', 1, 114),
(115, 1, 'Kyrgyzstan', 'KGZ', 'KG', 1, 115),
(116, 1, 'Lao People\'s Democratic Republic', 'LAO', 'LA', 1, 116),
(117, 1, 'Latvia', 'LVA', 'LV', 1, 117),
(118, 1, 'Lebanon', 'LBN', 'LB', 1, 118),
(119, 1, 'Lesotho', 'LSO', 'LS', 1, 119),
(120, 1, 'Liberia', 'LBR', 'LR', 1, 120),
(121, 1, 'Libyan Arab Jamahiriya', 'LBY', 'LY', 1, 121),
(122, 1, 'Liechtenstein', 'LIE', 'LI', 1, 122),
(123, 1, 'Lithuania', 'LTU', 'LT', 1, 123),
(124, 1, 'Luxembourg', 'LUX', 'LU', 1, 124),
(125, 1, 'Macau', 'MAC', 'MO', 1, 125),
(126, 1, 'Macedonia, The Former Yugoslav Republic of', 'MKD', 'MK', 1, 126),
(127, 1, 'Madagascar', 'MDG', 'MG', 1, 127),
(128, 1, 'Malawi', 'MWI', 'MW', 1, 128),
(129, 1, 'Malaysia', 'MYS', 'MY', 1, 129),
(130, 1, 'Maldives', 'MDV', 'MV', 1, 130),
(131, 1, 'Mali', 'MLI', 'ML', 1, 131),
(132, 1, 'Malta', 'MLT', 'MT', 1, 132),
(133, 1, 'Marshall Islands', 'MHL', 'MH', 1, 133),
(134, 1, 'Martinique', 'MTQ', 'MQ', 1, 134),
(135, 1, 'Mauritania', 'MRT', 'MR', 1, 135),
(136, 1, 'Mauritius', 'MUS', 'MU', 1, 136),
(137, 1, 'Mayotte', 'MYT', 'YT', 1, 137),
(138, 1, 'Mexico', 'MEX', 'MX', 1, 138),
(139, 1, 'Micronesia, Federated States of', 'FSM', 'FM', 1, 139),
(140, 1, 'Moldova, Republic of', 'MDA', 'MD', 1, 140),
(141, 1, 'Monaco', 'MCO', 'MC', 1, 141),
(142, 1, 'Mongolia', 'MNG', 'MN', 1, 142),
(143, 1, 'Montserrat', 'MSR', 'MS', 1, 143),
(144, 1, 'Morocco', 'MAR', 'MA', 1, 144),
(145, 1, 'Mozambique', 'MOZ', 'MZ', 1, 145),
(146, 1, 'Myanmar', 'MMR', 'MM', 1, 146),
(147, 1, 'Namibia', 'NAM', 'NA', 1, 147),
(148, 1, 'Nauru', 'NRU', 'NR', 1, 148),
(149, 1, 'Nepal', 'NPL', 'NP', 1, 149),
(150, 1, 'Netherlands', 'NLD', 'NL', 1, 150),
(151, 1, 'Netherlands Antilles', 'ANT', 'AN', 1, 151),
(152, 1, 'New Caledonia', 'NCL', 'NC', 1, 152),
(153, 1, 'New Zealand', 'NZL', 'NZ', 1, 153),
(154, 1, 'Nicaragua', 'NIC', 'NI', 1, 154),
(155, 1, 'Niger', 'NER', 'NE', 1, 155),
(156, 1, 'Nigeria', 'NGA', 'NG', 1, 156),
(157, 1, 'Niue', 'NIU', 'NU', 1, 157),
(158, 1, 'Norfolk Island', 'NFK', 'NF', 1, 158),
(159, 1, 'Northern Mariana Islands', 'MNP', 'MP', 1, 159),
(160, 1, 'Norway', 'NOR', 'NO', 1, 160),
(161, 1, 'Oman', 'OMN', 'OM', 1, 161),
(162, 1, 'Pakistan', 'PAK', 'PK', 1, 162),
(163, 1, 'Palau', 'PLW', 'PW', 1, 163),
(164, 1, 'Panama', 'PAN', 'PA', 1, 164),
(165, 1, 'Papua New Guinea', 'PNG', 'PG', 1, 165),
(166, 1, 'Paraguay', 'PRY', 'PY', 1, 166),
(167, 1, 'Peru', 'PER', 'PE', 1, 167),
(168, 1, 'Philippines', 'PHL', 'PH', 1, 168),
(169, 1, 'Pitcairn', 'PCN', 'PN', 1, 169),
(170, 1, 'Poland', 'POL', 'PL', 1, 170),
(171, 1, 'Portugal', 'PRT', 'PT', 1, 171),
(172, 1, 'Puerto Rico', 'PRI', 'PR', 1, 172),
(173, 1, 'Qatar', 'QAT', 'QA', 1, 173),
(174, 1, 'Reunion', 'REU', 'RE', 1, 174),
(175, 1, 'Romania', 'ROM', 'RO', 1, 175),
(176, 1, 'Russian Federation', 'RUS', 'RU', 1, 176),
(177, 1, 'Rwanda', 'RWA', 'RW', 1, 177),
(178, 1, 'Saint Kitts and Nevis', 'KNA', 'KN', 1, 178),
(179, 1, 'Saint Lucia', 'LCA', 'LC', 1, 179),
(180, 1, 'Saint Vincent and the Grenadines', 'VCT', 'VC', 1, 180),
(181, 1, 'Samoa', 'WSM', 'WS', 1, 181),
(182, 1, 'San Marino', 'SMR', 'SM', 1, 182),
(183, 1, 'Sao Tome and Principe', 'STP', 'ST', 1, 183),
(184, 1, 'Saudi Arabia', 'SAU', 'SA', 1, 184),
(185, 1, 'Senegal', 'SEN', 'SN', 1, 185),
(186, 1, 'Seychelles', 'SYC', 'SC', 1, 186),
(187, 1, 'Sierra Leone', 'SLE', 'SL', 1, 187),
(188, 1, 'Singapore', 'SGP', 'SG', 1, 188),
(189, 1, 'Slovakia (Slovak Republic)', 'SVK', 'SK', 1, 189),
(190, 1, 'Slovenia', 'SVN', 'SI', 1, 190),
(191, 1, 'Solomon Islands', 'SLB', 'SB', 1, 191),
(192, 1, 'Somalia', 'SOM', 'SO', 1, 192),
(193, 1, 'South Africa', 'ZAF', 'ZA', 1, 193),
(194, 1, 'South Georgia and the South Sandwich Islands', 'SGS', 'GS', 1, 194),
(195, 1, 'Spain', 'ESP', 'ES', 1, 195),
(196, 1, 'Sri Lanka', 'LKA', 'LK', 1, 196),
(197, 1, 'St. Helena', 'SHN', 'SH', 1, 197),
(198, 1, 'St. Pierre and Miquelon', 'SPM', 'PM', 1, 198),
(199, 1, 'Sudan', 'SDN', 'SD', 1, 199),
(200, 1, 'Suriname', 'SUR', 'SR', 1, 200),
(201, 1, 'Svalbard and Jan Mayen Islands', 'SJM', 'SJ', 1, 201),
(202, 1, 'Swaziland', 'SWZ', 'SZ', 1, 202),
(203, 1, 'Sweden', 'SWE', 'SE', 1, 203),
(204, 1, 'Switzerland', 'CHE', 'CH', 1, 204),
(205, 1, 'Syrian Arab Republic', 'SYR', 'SY', 1, 205),
(206, 1, 'Taiwan', 'TWN', 'TW', 1, 206),
(207, 1, 'Tajikistan', 'TJK', 'TJ', 1, 207),
(208, 1, 'Tanzania, United Republic of', 'TZA', 'TZ', 1, 208),
(209, 1, 'Thailand', 'THA', 'TH', 1, 209),
(210, 1, 'Togo', 'TGO', 'TG', 1, 210),
(211, 1, 'Tokelau', 'TKL', 'TK', 1, 211),
(212, 1, 'Tonga', 'TON', 'TO', 1, 212),
(213, 1, 'Trinidad and Tobago', 'TTO', 'TT', 1, 213),
(214, 1, 'Tunisia', 'TUN', 'TN', 1, 214),
(215, 1, 'Turkey', 'TUR', 'TR', 1, 215),
(216, 1, 'Turkmenistan', 'TKM', 'TM', 1, 216),
(217, 1, 'Turks and Caicos Islands', 'TCA', 'TC', 1, 217),
(218, 1, 'Tuvalu', 'TUV', 'TV', 1, 218),
(219, 1, 'Uganda', 'UGA', 'UG', 1, 219),
(220, 1, 'Ukraine', 'UKR', 'UA', 1, 220),
(221, 1, 'United Arab Emirates', 'ARE', 'AE', 1, 221),
(222, 1, 'United Kingdom', 'GBR', 'GB', 1, 222),
(223, 1, 'United States', 'USA', 'US', 1, 223),
(224, 1, 'United States Minor Outlying Islands', 'UMI', 'UM', 1, 224),
(225, 1, 'Uruguay', 'URY', 'UY', 1, 225),
(226, 1, 'Uzbekistan', 'UZB', 'UZ', 1, 226),
(227, 1, 'Vanuatu', 'VUT', 'VU', 1, 227),
(228, 1, 'Vatican City State (Holy See)', 'VAT', 'VA', 1, 228),
(229, 1, 'Venezuela', 'VEN', 'VE', 1, 229),
(230, 1, 'Viet Nam', 'VNM', 'VN', 1, 230),
(231, 1, 'Virgin Islands (British)', 'VGB', 'VG', 1, 231),
(232, 1, 'Virgin Islands (U.S.)', 'VIR', 'VI', 1, 232),
(233, 1, 'Wallis and Futuna Islands', 'WLF', 'WF', 1, 233),
(234, 1, 'Western Sahara', 'ESH', 'EH', 1, 234),
(235, 1, 'Yemen', 'YEM', 'YE', 1, 235),
(236, 1, 'Serbia', 'SRB', 'RS', 1, 236),
(237, 1, 'The Democratic Republic of Congo', 'DRC', 'DC', 1, 237),
(238, 1, 'Zambia', 'ZMB', 'ZM', 1, 238),
(239, 1, 'Zimbabwe', 'ZWE', 'ZW', 1, 239),
(240, 1, 'East Timor', 'XET', 'XE', 1, 240),
(241, 1, 'Jersey', 'XJE', 'XJ', 1, 241),
(242, 1, 'St. Barthelemy', 'XSB', 'XB', 1, 242),
(243, 1, 'St. Eustatius', 'XSE', 'XU', 1, 243),
(244, 1, 'Canary Islands', 'XCA', 'XC', 1, 244),
(245, 1, 'Montenegro', 'MNE', 'ME', 1, 245);
CREATE TABLE IF NOT EXISTS `#__eb_coupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) DEFAULT NULL,
  `coupon_type` tinyint(3) UNSIGNED DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT NULL,
  `event_id` int(11) NOT NULL DEFAULT '0',
  `times` int(11) NOT NULL DEFAULT '0',
  `used` int(11) DEFAULT '0',
  `valid_from` datetime DEFAULT NULL,
  `valid_to` datetime DEFAULT NULL,
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `max_usage_per_user` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '-1',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `apply_to` int(11) NOT NULL DEFAULT '0',
  `max_number_registrants` int(11) NOT NULL DEFAULT '0',
  `min_number_registrants` int(11) NOT NULL DEFAULT '0',
  `note` varchar(255) DEFAULT NULL,
  `enable_for` int(11) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  `used_amount` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `idx_code` (`code`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_coupon_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) DEFAULT '0',
  `category_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_coupon_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` int(11) DEFAULT NULL,
  `event_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_coupon_id` (`coupon_id`),
  KEY `idx_event_id` (`event_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_code` varchar(10) DEFAULT NULL,
  `currency_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=25 CHARACTER SET `utf8`;
INSERT IGNORE INTO `#__eb_currencies` (`id`, `currency_code`, `currency_name`) VALUES
(1, 'CAD', 'Canadian Dollars'),
(2, 'EUR', 'Euros'),
(3, 'GBP', 'Pounds Sterling'),
(4, 'USD', 'U.S. Dollars'),
(5, 'JPY', 'Japanese Yen'),
(6, 'AUD', 'Australian Dollars'),
(7, 'NZD', 'New Zealand Dollars'),
(8, 'CHF', 'Swiss Francs'),
(9, 'HKD', 'Hong Kong Dollars'),
(10, 'SGD', 'Singapore Dollars'),
(11, 'SEK', 'Swedish Kronor'),
(12, 'DKK', 'Danish Kroner'),
(13, 'PLN', 'Polish Zloty'),
(14, 'NOK', 'Norwegian Kroner'),
(15, 'HUF', 'Hungarian Forint'),
(16, 'CZK', 'Czech Koruna'),
(17, 'ILS', 'Israeli Shekel'),
(18, 'BRL', 'Brazilian Real'),
(19, 'MYR', 'Malaysian Ringgit'),
(20, 'MXN', 'Mexican Peso'),
(21, 'PHP', 'Philippine Peso'),
(22, 'TWD', 'Taiwan New Dollar'),
(23, 'THB', 'Thai Baht'),
(24, 'RUB', 'Russian Rubles');
CREATE TABLE IF NOT EXISTS `#__eb_discounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `event_ids` tinytext,
  `discount_amount` decimal(10,2) DEFAULT NULL,
  `from_date` datetime DEFAULT NULL,
  `to_date` datetime DEFAULT NULL,
  `times` int(11) NOT NULL DEFAULT '0',
  `used` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_discount_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_id` int(11) NOT NULL DEFAULT '0',
  `event_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_type` varchar(50) DEFAULT NULL,
  `sent_at` datetime DEFAULT NULL,
  `sent_to` tinyint(4) NOT NULL DEFAULT '0',
  `email` varchar(100) DEFAULT '0',
  `subject` varchar(255) DEFAULT NULL,
  `body` text,
  PRIMARY KEY (`id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `event_type` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `event_date` datetime DEFAULT NULL,
  `event_end_date` datetime DEFAULT NULL,
  `short_description` mediumtext,
  `description` text,
  `access` int(11) NOT NULL DEFAULT '1',
  `registration_access` int(11) NOT NULL DEFAULT '1',
  `individual_price` decimal(10,2) DEFAULT NULL,
  `event_capacity` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT '0',
  `cut_off_date` datetime DEFAULT NULL,
  `registration_type` tinyint(3) UNSIGNED DEFAULT NULL,
  `max_group_number` int(11) DEFAULT NULL,
  `discount_type` int(11) DEFAULT NULL,
  `discount` decimal(10,2) DEFAULT '0.00',
  `early_bird_discount_type` tinyint(3) UNSIGNED DEFAULT NULL,
  `early_bird_discount_date` datetime DEFAULT NULL,
  `early_bird_discount_amount` decimal(10,2) DEFAULT NULL,
  `enable_cancel_registration` tinyint(3) UNSIGNED DEFAULT NULL,
  `cancel_before_date` datetime DEFAULT NULL,
  `registrant_edit_close_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `enable_auto_reminder` tinyint(3) UNSIGNED DEFAULT NULL,
  `remind_before_x_days` tinyint(3) UNSIGNED DEFAULT NULL,
  `recurring_type` tinyint(3) UNSIGNED DEFAULT NULL,
  `recurring_frequency` int(11) DEFAULT NULL,
  `weekdays` varchar(50) DEFAULT NULL,
  `monthdays` varchar(50) DEFAULT NULL,
  `recurring_end_date` datetime DEFAULT NULL,
  `recurring_occurrencies` int(11) DEFAULT NULL,
  `paypal_email` varchar(255) DEFAULT NULL,
  `notification_emails` varchar(255) DEFAULT NULL,
  `admin_email_body` text,
  `user_email_body` text,
  `user_email_body_offline` text,
  `thanks_message` text,
  `thanks_message_offline` text,
  `params` text,
  `ordering` int(11) DEFAULT NULL,
  `published` int(11) DEFAULT NULL,
  `custom_fields` text,
  `from_name` varchar(100) DEFAULT NULL,
  `from_email` varchar(100) DEFAULT NULL,
  `send_first_reminder` int(11) NOT NULL DEFAULT '0',
  `send_second_reminder` int(11) NOT NULL DEFAULT '0',
  `second_reminder_email_body` text,
  `free_event_registration_status` tinyint(4) NOT NULL DEFAULT '1',
  `members_discount_apply_for` tinyint(4) NOT NULL DEFAULT '0',
  `send_emails` tinyint(4) NOT NULL DEFAULT '-1',
  `page_title` varchar(255) DEFAULT NULL,
  `page_heading` varchar(255) DEFAULT NULL,
  `collect_member_information` char(1) NOT NULL DEFAULT '',
  `prevent_duplicate_registration` char(1) NOT NULL DEFAULT '',
  `image` varchar(255) DEFAULT NULL,
  `featured` tinyint(4) NOT NULL DEFAULT '0',
  `hidden` tinyint(4) NOT NULL DEFAULT '0',
  `has_multiple_ticket_types` tinyint(4) NOT NULL DEFAULT '0',
  `discount_groups` varchar(255) DEFAULT NULL,
  `discount_amounts` varchar(255) DEFAULT NULL,
  `registration_start_date` datetime DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `max_end_date` datetime DEFAULT '0000-00-00 00:00:00',
  `activate_tickets_pdf` tinyint(4) NOT NULL DEFAULT '0',
  `ticket_start_number` int(11) NOT NULL DEFAULT '1',
  `ticket_prefix` varchar(10) DEFAULT NULL,
  `ticket_bg_image` varchar(255) DEFAULT NULL,
  `ticket_bg_top` int(11) NOT NULL DEFAULT '0',
  `ticket_bg_left` int(11) NOT NULL DEFAULT '0',
  `ticket_bg_width` int(11) NOT NULL DEFAULT '0',
  `ticket_bg_height` int(11) NOT NULL DEFAULT '0',
  `ticket_layout` text,
  `invoice_format` text,
  `min_group_number` tinyint(4) NOT NULL DEFAULT '0',
  `registration_handle_url` varchar(255) DEFAULT NULL,
  `api_login` varchar(255) DEFAULT NULL,
  `transaction_key` varchar(255) DEFAULT NULL,
  `fixed_group_price` decimal(10,2) DEFAULT '0.00',
  `attachment` varchar(255) DEFAULT NULL,
  `registration_form_message` text,
  `registration_form_message_group` text,
  `hits` int(11) NOT NULL DEFAULT '0',
  `late_fee_type` tinyint(4) NOT NULL DEFAULT '0',
  `late_fee_date` datetime DEFAULT NULL,
  `late_fee_amount` decimal(10,2) DEFAULT '0.00',
  `is_additional_date` tinyint(4) NOT NULL DEFAULT '0',
  `article_id` int(11) NOT NULL DEFAULT '0',
  `deposit_type` tinyint(4) NOT NULL DEFAULT '0',
  `deposit_amount` decimal(10,2) DEFAULT '0.00',
  `custom_field_ids` varchar(255) DEFAULT NULL,
  `event_password` varchar(255) DEFAULT NULL,
  `payment_methods` varchar(255) DEFAULT NULL,
  `currency_code` varchar(10) DEFAULT NULL,
  `currency_symbol` varchar(20) DEFAULT NULL,
  `thumb` varchar(60) DEFAULT NULL,
  `registration_approved_email_body` text,
  `fixed_daylight_saving_time` tinyint(4) NOT NULL DEFAULT '0',
  `language` varchar(50) DEFAULT '*',
  `meta_keywords` varchar(255) DEFAULT NULL,
  `meta_description` varchar(255) DEFAULT NULL,
  `reminder_email_body` text,
  `enable_coupon` tinyint(4) NOT NULL DEFAULT '0',
  `tax_rate` decimal(10,2) DEFAULT '0.00',
  `activate_waiting_list` tinyint(4) NOT NULL DEFAULT '2',
  `price_text` varchar(255) DEFAULT NULL,
  `registration_complete_url` text,
  `offline_payment_registration_complete_url` text,
  `activate_certificate_feature` tinyint(4) NOT NULL DEFAULT '0',
  `certificate_layout` text,
  `certificate_bg_image` varchar(255) DEFAULT NULL,
  `certificate_bg_left` int(11) NOT NULL DEFAULT '0',
  `certificate_bg_top` int(11) NOT NULL DEFAULT '0',
  `certificate_bg_width` int(11) NOT NULL DEFAULT '0',
  `certificate_bg_height` int(11) NOT NULL DEFAULT '0',
  `enable_terms_and_conditions` tinyint(4) NOT NULL DEFAULT '2',
  `main_category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_category_id` (`category_id`),
  KEY `idx_location_id` (`location_id`),
  KEY `idx_parent_id` (`parent_id`),
  KEY `idx_access` (`access`),
  KEY `idx_published` (`published`),
  KEY `idx_event_date` (`event_date`),
  KEY `idx_event_end_date` (`event_end_date`),
  KEY `idx_alias` (`alias`(191))
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_event_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `main_category` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_category_id` (`category_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_event_group_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) DEFAULT NULL,
  `registrant_number` int(11) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `#__eb_event_prices_FKIndex1` (`event_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_event_speakers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) DEFAULT NULL,
  `speaker_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_speaker_id` (`speaker_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_event_sponsors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) DEFAULT NULL,
  `sponsor_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_sponsor_id` (`sponsor_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` mediumtext,
  `field_type` int(11) DEFAULT NULL,
  `required` tinyint(3) UNSIGNED DEFAULT NULL,
  `values` text,
  `default_values` text,
  `fee_field` tinyint(3) UNSIGNED DEFAULT NULL,
  `fee_values` text,
  `fee_formula` varchar(255) DEFAULT NULL,
  `display_in` tinyint(3) UNSIGNED DEFAULT NULL,
  `rows` tinyint(3) UNSIGNED DEFAULT NULL,
  `cols` tinyint(3) UNSIGNED DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `css_class` varchar(50) DEFAULT NULL,
  `field_mapping` varchar(100) DEFAULT NULL,
  `access` int(11) NOT NULL DEFAULT '1',
  `ordering` int(11) DEFAULT NULL,
  `show_on_public_registrants_list` tinyint(3) UNSIGNED DEFAULT '0',
  `show_on_registration_type` tinyint(3) UNSIGNED DEFAULT '0',
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `filterable` tinyint(4) NOT NULL DEFAULT '0',
  `hide_for_first_group_member` tinyint(4) NOT NULL DEFAULT '0',
  `not_required_for_first_group_member` tinyint(4) NOT NULL DEFAULT '0',
  `newsletter_field_mapping` varchar(100) DEFAULT '',
  `server_validation_rules` varchar(255) DEFAULT '',
  `language` varchar(50) DEFAULT '*',
  `datatype_validation` tinyint(4) NOT NULL DEFAULT '0',
  `discountable` tinyint(4) NOT NULL DEFAULT '1',
  `extra_attributes` varchar(255) DEFAULT NULL,
  `show_in_list_view` tinyint(4) NOT NULL DEFAULT '0',
  `depend_on_field_id` int(11) NOT NULL DEFAULT '0',
  `depend_on_options` text,
  `max_length` int(11) NOT NULL DEFAULT '0',
  `place_holder` varchar(255) DEFAULT NULL,
  `multiple` tinyint(4) NOT NULL DEFAULT '0',
  `validation_rules` varchar(255) DEFAULT NULL,
  `validation_error_message` varchar(255) DEFAULT NULL,
  `quantity_field` tinyint(4) NOT NULL DEFAULT '0',
  `quantity_values` text,
  `only_show_for_first_member` tinyint(4) NOT NULL DEFAULT '0',
  `only_require_for_first_member` tinyint(4) NOT NULL DEFAULT '0',
  `hide_on_email` tinyint(4) NOT NULL DEFAULT '0',
  `hide_on_export` tinyint(4) NOT NULL DEFAULT '0',
  `show_on_registrants` tinyint(4) NOT NULL DEFAULT '0',
  `receive_confirmation_email` tinyint(4) NOT NULL DEFAULT '0',
  `pattern` varchar(255) DEFAULT NULL,
  `min` int(11) NOT NULL DEFAULT '0',
  `max` int(11) NOT NULL DEFAULT '0',
  `step` int(11) NOT NULL DEFAULT '0',
  `is_searchable` tinyint(4) NOT NULL DEFAULT '0',
  `is_core` tinyint(4) NOT NULL DEFAULT '0',
  `fieldtype` varchar(50) DEFAULT NULL,
  `category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access_id` (`access`),
  KEY `idx_published` (`published`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
INSERT IGNORE INTO `#__eb_fields` (`id`, `event_id`, `name`, `title`, `description`, `field_type`, `required`, `values`, `default_values`, `fee_field`, `fee_values`, `fee_formula`, `display_in`, `rows`, `cols`, `size`, `css_class`, `field_mapping`, `access`, `ordering`, `show_on_public_registrants_list`, `published`, `filterable`, `hide_for_first_group_member`, `not_required_for_first_group_member`, `newsletter_field_mapping`, `server_validation_rules`, `language`, `datatype_validation`, `discountable`, `extra_attributes`, `show_in_list_view`, `depend_on_field_id`, `depend_on_options`, `max_length`, `place_holder`, `multiple`, `validation_rules`, `validation_error_message`, `quantity_field`, `quantity_values`, `only_show_for_first_member`, `only_require_for_first_member`, `hide_on_email`, `hide_on_export`, `show_on_registrants`, `receive_confirmation_email`, `pattern`, `min`, `max`, `step`, `is_searchable`, `is_core`, `fieldtype`, `category_id`) VALUES
(1, -1, 'first_name', 'First Name', '', 1, 1, '', '', 0, '', '', 0, 0, 0, 0, 'input-large', '', 1, 1, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '', 0, '', 0, 'validate[required]', '', 0, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Text', -1),
(2, -1, 'last_name', 'Last Name', '', 1, 1, '', '', 0, '', '', 0, 0, 0, 0, '', NULL, 1, 2, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '[]', 0, '', 0, '', '', 0, '', 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Text', -1),
(3, -1, 'organization', 'Organization', '', 1, 0, '', '', 0, '', '', 3, 0, 0, 0, 'input-large', NULL, 1, 3, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '', 0, '', 0, '', '', 0, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Text', -1),
(4, -1, 'address', 'Address', '', 1, 1, '', '', 0, '', '', 3, 0, 0, 0, 'input-large', NULL, 1, 4, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '', 0, NULL, 0, '', NULL, 0, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Text', -1),
(5, -1, 'address2', 'Address 2', '', 1, 0, '', '', 0, '', '', 3, 0, 0, 0, 'input-large', NULL, 1, 5, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '', 0, NULL, 0, '', NULL, 0, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Text', -1),
(6, -1, 'city', 'City', '', 1, 1, '', '', 0, '', '', 3, 0, 0, 0, 'input-large', NULL, 1, 6, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '', 0, NULL, 0, '', NULL, 0, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Text', -1),
(7, -1, 'zip', 'Zip', '', 1, 1, '', '', 0, '', '', 3, 0, 0, 0, 'input-large', NULL, 1, 7, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '', 0, NULL, 0, '', NULL, 0, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Text', -1),
(8, -1, 'country', 'Country', '', 3, 1, '', '', 0, '', '', 3, 0, 0, 0, 'input-large', NULL, 1, 8, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '', 0, NULL, 0, '', NULL, 0, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Countries', -1),
(9, -1, 'state', 'State', '', 1, 0, '', '', 0, '', '', 3, 0, 0, 0, 'input-large', NULL, 1, 9, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '[]', 0, '', 0, '', '', 0, '', 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'State', -1),
(10, -1, 'phone', 'Phone', '', 1, 0, '', '', 0, '', '', 3, 0, 0, 0, 'input-large', NULL, 1, 10, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '', 0, '', 0, '', '', 0, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Text', -1),
(11, -1, 'fax', 'Fax', '', 1, 0, '', '', 0, '', '', 3, 0, 0, 0, 'input-large', NULL, 1, 11, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '', 0, '', 0, '', '', 0, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Text', -1),
(12, -1, 'email', 'Email', '', 1, 1, '', '', 0, '', '', 3, 0, 0, 0, 'input-large', NULL, 1, 12, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '[]', 0, '', 0, 'validate[required,custom[email],ajax[ajaxEmailCall]]', '', 0, '', 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Text', -1),
(13, -1, 'comment', 'Comment', '', 2, 0, '', '', 0, '', '', 3, 7, 0, 0, 'input-large', NULL, 1, 13, 0, 1, 0, 0, 0, '', '', '*', 0, 1, '', 0, 0, '', 0, '', 0, '', '', 0, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 1, 'Textarea', -1);
CREATE TABLE IF NOT EXISTS `#__eb_field_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_field_id` (`field_id`),
  KEY `idx_category_id` (`category_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_field_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_id` int(11) DEFAULT NULL,
  `event_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_field_id` (`field_id`),
  KEY `idx_event_id` (`event_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `registrant_id` int(11) DEFAULT NULL,
  `field_id` int(11) DEFAULT NULL,
  `field_value` text,
  PRIMARY KEY (`id`),
  KEY `idx_registrant_id` (`registrant_id`),
  KEY `idx_field_id` (`field_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_galleries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(10) UNSIGNED DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `ordering` int(11) UNSIGNED DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_event_id` (`event_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `lat` decimal(10,6) DEFAULT '0.000000',
  `long` decimal(10,6) DEFAULT '0.000000',
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(50) DEFAULT '*',
  `layout` varchar(50) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `description` text,
  `alias` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(255) DEFAULT NULL,
  `menu_parent_id` int(11) DEFAULT NULL,
  `menu_link` varchar(255) DEFAULT NULL,
  `published` tinyint(1) UNSIGNED DEFAULT NULL,
  `ordering` int(11) DEFAULT NULL,
  `menu_class` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=34 CHARACTER SET `utf8`;
INSERT IGNORE INTO `#__eb_menus` (`id`, `menu_name`, `menu_parent_id`, `menu_link`, `published`, `ordering`, `menu_class`) VALUES
(1, 'EB_DASHBOARD', 0, 'index.php?option=com_eventbooking&view=dashboard', 1, 1, 'home'),
(2, 'EB_SETUP', 0, NULL, 1, 2, 'list-view'),
(3, 'EB_CATEGORIES', 2, 'index.php?option=com_eventbooking&view=categories', 1, 1, 'folder-open'),
(5, 'EB_CUSTOM_FIELDS', 2, 'index.php?option=com_eventbooking&view=fields', 1, 2, 'list'),
(6, 'EB_LOCATIONS', 2, 'index.php?option=com_eventbooking&view=locations', 1, 3, 'location'),
(7, 'EB_COUNTRIES', 2, 'index.php?option=com_eventbooking&view=countries', 1, 5, 'flag'),
(8, 'EB_STATES', 2, 'index.php?option=com_eventbooking&view=states', 1, 6, 'book'),
(9, 'EB_REGISTRANTS', 0, NULL, 1, 4, 'user'),
(10, 'EB_COUPONS', 0, NULL, 1, 5, 'tags'),
(11, 'EB_COUPONS', 10, 'index.php?option=com_eventbooking&view=coupons', 1, 1, 'tags'),
(12, 'EB_IMPORT', 10, 'index.php?option=com_eventbooking&view=coupon&layout=import', 1, 2, 'upload'),
(13, 'EB_EXPORT', 10, 'index.php?option=com_eventbooking&task=coupon.export', 1, 3, 'download'),
(14, 'EB_BATCH', 10, 'index.php?option=com_eventbooking&view=coupon&layout=batch', 1, 4, 'list'),
(15, 'EB_PAYMENT_PLUGINS', 0, 'index.php?option=com_eventbooking&view=plugins', 1, 6, 'wrench'),
(16, 'EB_EMAIL_MESSAGES', 0, 'index.php?option=com_eventbooking&view=message', 1, 7, 'envelope'),
(17, 'EB_TRANSLATION', 0, 'index.php?option=com_eventbooking&view=language', 1, 8, 'flag'),
(18, 'EB_CONFIGURATION', 0, 'index.php?option=com_eventbooking&view=configuration', 1, 9, 'cog'),
(19, 'EB_TOOLS', 0, NULL, 1, 10, 'tools'),
(20, 'EB_PURGE_URLS', 19, 'index.php?option=com_eventbooking&task=tool.reset_urls', 1, 1, 'refresh'),
(21, 'EB_FIX_DATABASE', 19, 'index.php?option=com_eventbooking&task=update.update', 1, 2, 'ok'),
(22, 'EB_SHARE_TRANSLATION', 19, 'index.php?option=com_eventbooking&task=tool.share_translation', 1, 4, 'heart'),
(23, 'EB_DISCOUNT_BUNDLES', 2, 'index.php?option=com_eventbooking&view=discounts', 1, 4, 'tags'),
(24, 'EB_EVENTS', 0, NULL, 1, 3, 'calendar'),
(25, 'EB_EVENTS', 24, 'index.php?option=com_eventbooking&view=events', 1, 1, 'calendar'),
(26, 'EB_IMPORT', 24, 'index.php?option=com_eventbooking&view=event&layout=import', 1, 2, 'upload'),
(27, 'EB_EXPORT', 24, 'index.php?option=com_eventbooking&task=event.export', 1, 3, 'download'),
(28, 'EB_REGISTRANTS', 9, 'index.php?option=com_eventbooking&view=registrants', 1, 1, 'user'),
(29, 'EB_IMPORT_TEMPLATE', 9, 'index.php?option=com_eventbooking&task=registrant.import_template', 1, 2, 'list'),
(30, 'EB_IMPORT', 9, 'index.php?option=com_eventbooking&view=registrant&layout=import', 1, 3, 'upload'),
(31, 'EB_EXPORT', 9, 'index.php?option=com_eventbooking&task=registrant.export', 1, 4, 'download'),
(32, 'EB_EMAILS_LOG', 19, 'index.php?option=com_eventbooking&view=emails', 1, 3, 'envelope'),
(33, 'EB_THEMES', 2, 'index.php?option=com_eventbooking&view=themes', 1, 7, 'tablet');
CREATE TABLE IF NOT EXISTS `#__eb_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_key` varchar(50) DEFAULT NULL,
  `message` text,
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=60 CHARACTER SET `utf8`;
INSERT IGNORE INTO `#__eb_messages` (`id`, `message_key`, `message`) VALUES
(1, 'intro_text', ''),
(2, 'registration_form_message', '<p>Please enter information in the form below to process registration for event <strong>[EVENT_TITLE]</strong>.</p>'),
(3, 'registration_form_message_group', '<p>Please enter information in the form below to complete group registration for event <strong>[EVENT_TITLE]</strong>.</p>'),
(4, 'number_members_form_message', '<p>Please enter number of members for your group registration. Number of members need to be greater than or equal 2. You can enter detail information of these members in the next step.</p>'),
(5, 'member_information_form_message', '<p>Please enter information of this member in the form below . All fields marked with (<span class=\"required\">*</span>) is required .</p>'),
(6, 'thanks_message', '<p>Thanks for registering for event <strong>[EVENT_TITLE]</strong>. Your registration detail is as follow :</p>\r\n<p>[REGISTRATION_DETAIL]</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(7, 'thanks_message_offline', '<p>Thanks for registering for event <strong>[EVENT_TITLE]</strong>. Your registration detail is as follow :</p>\r\n<p>[REGISTRATION_DETAIL]</p>\r\n<p>Please send the offline payment via our bank account . Information of our bank account is as follow :</p>\r\n<p>Account Holder Name, Bank Name, Account Number XXXYYYZZZZ</p>\r\n<p>If we don\'t receive your payment within 3 days, we will cancel the registration and you cannot attend to this event .</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(8, 'cancel_message', '<p>Your registration for event <strong>[EVENT_TITLE]</strong> was cancelled.</p>'),
(9, 'certificate_email_subject', 'Your certificate for [EVENT_TITLE]'),
(10, 'certificate_email_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>Thanks for attending our event <strong>[EVENT_TITLE] </strong>on <strong>[EVENT_DATE]</strong>. Please get your certificate in the attachment of this email.</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(11, 'admin_email_subject', 'New Registration For Event : [EVENT_TITLE]'),
(12, 'admin_email_body', '<p>Dear administrator</p>\r\n<p>User [FIRST_NAME] [LAST_NAME] has just registered for event <strong>[EVENT_TITLE]</strong>. The registration detail is as follow :</p>\r\n<p>[REGISTRATION_DETAIL]</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>\r\n<p> </p>'),
(13, 'user_email_subject', 'Event registration confirmation'),
(14, 'user_email_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>You have just registered for event <strong>[EVENT_TITLE]</strong>. The registration detail is as follow :</p>\r\n<p>[REGISTRATION_DETAIL]</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(15, 'user_email_body_offline', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>You have just registered for event <strong>[EVENT_TITLE]</strong>. The registration detail is as follow :</p>\r\n<p>[REGISTRATION_DETAIL] .</p>\r\n<p>Please send the offline payment via our bank account . Information of our bank account is as follow :</p>\r\n<p>Account Holder Name, Bank Name, Account Number XXXYYYZZZZ</p>\r\n<p>If we don\'t receive your payment within 3 days, we will cacel the registration and you cannot attend to this event .</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(16, 'group_member_email_subject', 'Event registration confirmation'),
(17, 'group_member_email_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>You have just been registered for event <strong>[EVENT_TITLE] </strong>as a group member. Your registration details is as follow:</p>\r\n<p>[MEMBER_DETAIL]</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(18, 'registration_approved_email_subject', 'Your registration for event [EVENT_TITLE] approved'),
(19, 'registration_approved_email_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>Your registration for event <strong>[EVENT_TITLE]</strong> has just approved by our administrator team. Your registration details is as follow:</p>\r\n<p>[REGISTRATION_DETAIL]</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(20, 'reminder_email_subject', 'Reminder for event [EVENT_TITLE]'),
(21, 'reminder_email_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>This email is used to remind you that you have registered for event <strong>[EVENT_TITLE]</strong>. The event will occur on <strong>[EVENT_DATE]</strong>, so please come and attend the event on time.</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(22, 'second_reminder_email_subject', 'Second reminder for event [EVENT_TITLE]'),
(23, 'second_reminder_email_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>This is second reminder to remind you that you have registered for event <strong>[EVENT_TITLE]</strong>. The event will occur on <strong>[EVENT_DATE]</strong>, so please come and attend the event on time.</p>\r\n<p>Regards,</p>\r\n<p>Website Administrator Team</p>'),
(24, 'registration_cancel_confirmation_message', '<p>Please click on the Process button below to cancel your registration for event [EVENT_TITLE].</p>'),
(25, 'registration_cancel_message_free', '<p>You have just cancel your registration for event [EVENT_TITLE]</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>\r\n<p> </p>'),
(26, 'registration_cancel_message_paid', '<p>Your registration for event <strong>[EVENT_TITLE]</strong> has successfully cancelled. Our event registration team will check your registration and process the refund within 24 hours from now.</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>\r\n<p> </p>'),
(27, 'registration_cancel_confirmation_email_subject', 'Your registration for event [EVENT_TITLE] was cancelled'),
(28, 'registration_cancel_confirmation_email_body', '<p>You just cancelled your registration for event [EVENT_TITLE]</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(29, 'registration_cancel_email_subject', 'Registration Cancel for even [EVENT_TITLE]'),
(30, 'registration_cancel_email_body', '<p>Dear administrator</p>\r\n<p>User <strong>[FIRST_NAME] [LAST_NAME]</strong> has just cancel their registration for event <strong>[EVENT_TITLE]</strong> . You can login to back-end of your site to see the detail and process the refund if needed .</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(31, 'user_registration_cancel_subject', 'Your registration for event [EVENT_TITLE] was cancelled'),
(32, 'user_registration_cancel_message', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>We want to inform you want your registration for event <strong>[EVENT_TITLE] </strong>was cancelled by administrator.</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(33, 'submit_event_user_email_subject', 'Event submission confirmation'),
(34, 'submit_event_user_email_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>We received your event submission <strong>[EVENT_TITLE] [EVENT_DATE]</strong>. Our administrators will check and approve your submission ASAP</p>\r\n<p>Regards,</p>\r\n<p>Website administrator team</p>\r\n<p> </p>'),
(35, 'submit_event_admin_email_subject', 'New event subission received'),
(36, 'submit_event_admin_email_body', '<p>Dear administrator</p>\r\n<p>User <strong>[NAME]</strong> (<strong>[USERNAME]</strong>) has just submitted event <strong>[EVENT_TILE]</strong> from frontend of your site. Please login to administrator area to check and approve the event. You can click on the link below to access to see the submission details</p>\r\n<p>[EVENT_LINK]</p>\r\n<p>Regards,</p>\r\n<p>Website administrator team</p>'),
(37, 'invitation_form_message', '<p>Please enter information in the form below to send invitation to your friends to invite them to register for the event <strong>[EVENT_TITLE]</strong></p>'),
(38, 'invitation_complete', '<p>The invitation was sent to your friends. Thank you !</p>'),
(39, 'invitation_email_subject', 'Invitation to register for event [EVENT_TITLE]'),
(40, 'invitation_email_body', '<p>Dear <strong>[NAME]</strong></p>\r\n<p>Your friend <strong>[SENDER_NAME]</strong> has suggested you to view and register for the event <strong>[EVENT_TITLE]</strong> in our site. Please access to <strong>[EVENT_DETAIL_LINK]</strong> to view and register for the event.</p>\r\n<p>Note from <strong>[SENDER_NAME]</strong>:</p>\r\n<p><em>[PERSONAL_MESSAGE]</em></p>\r\n<p>Regards,</p>\r\n<p>Events manager team</p>\r\n<p> </p>'),
(41, 'waitinglist_form_message', '<p>This event is full at the moment. Please enter information in the form below to join waiting list for event <strong>[EVENT_TITLE]</strong>.  If someone cancel their registration for the event, we will inform you so that you can join this event.</p>'),
(42, 'waitinglist_complete_message', '<p>Thanks for joiing waitinglist of event <strong>[EVENT_TITLE] . </strong>We will email you if there is anyone cancel their registration.</p>'),
(43, 'watinglist_confirmation_subject', 'Your joined waitinglist for [EVENT_TITLE]'),
(44, 'watinglist_confirmation_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>Thanks for joining waitinglist of our event <strong>[EVENT_TITLE]</strong>. We will inform you as if there is someone cancel their registration and you can attend the event.</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(45, 'watinglist_notification_subject', 'Waitinglist Notification'),
(46, 'watinglist_notification_body', '<p>Dear Administrator</p>\r\n<p>User <strong>[FIRST_NAME] [LAST_NAME] </strong>has just joined waitinglist for event <strong>[EVENT_TITLE]. </strong></p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(47, 'registrant_waitinglist_notification_subject', 'Someone cancel the registration'),
(48, 'registrant_waitinglist_notification_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>The registrant <strong>[REGISTRANT_FIRST_NAME] [REGISTRANT_LAST_NAME]</strong> has just cancelled his registration for the event <strong>[EVENT_TITLE]</strong></p>\r\n<p>If you still want to attend to this event, please click on the link below to view and register for the event.</p>\r\n<p><strong>[EVENT_LINK]</strong></p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(49, 'request_payment_email_subject', 'Please make payment for your registration #[ID]'),
(50, 'request_payment_email_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>Your joined waiting list for our event <strong>[EVENT_TITLE]</strong>. Recently, one of our registrant cancelled their registration, so we happy to inform that you can make payment to become registrant of the event. Please click on the link below to process payment:</p>\r\n<p>[PAYMENT_LINK]</p>\r\n<p>If we don\'t receive payment within one day, we will give it to the next waiting list user</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(51, 'registration_payment_form_message', '<p>Please enter information in the form below to process payment for registration <strong>#[REGISTRATION_ID]</strong> of the event <strong>[EVENT_TITLE]</strong>. After payment completes, you will become registrant of this event.</p>\r\n<p> </p>'),
(52, 'deposit_payment_form_message', '<p>Please enter information in the form below to complete payment your registration <strong>#[REGISTRATION_ID]</strong>. The amount you have to pay is <strong>[AMOUNT]</strong></p>'),
(53, 'deposit_payment_thanks_message', '<p>Thanks for complete payment for your registration #<strong>[REGISTRATION_ID]</strong>. The amount you paid is <strong>[AMOUNT] </strong>and the Transaction ID is <strong>[TRANSACTION_ID]</strong></p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(54, 'deposit_payment_admin_email_subject', 'New Deposit payment for registration #[REGISTRATION_ID]'),
(55, 'deposit_payment_admin_email_body', '<p>Dear administrator</p>\r\n<p>Registrant <strong>[FIRST_NAME] [LAST_NAME]</strong> has just completed payment for the registration record <strong>#[REGISTRATION_ID] </strong>using <strong>[PAYMENT_METHOD]</strong> payment method. The payment amount is <strong>[AMOUNT] </strong>and the Transaction ID is <strong>[TRANSACTION_ID]</strong>.<strong> </strong></p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>'),
(56, 'deposit_payment_user_email_subject', 'Payment for registration #[REGISTRATION_ID] confirmation'),
(57, 'deposit_payment_user_email_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>Thanks for completing payment for your registration #<strong>[REGISTRATION_ID]</strong>. The amount you paid is <strong>[AMOUNT] </strong>and the Transaction ID is <strong>[TRANSACTION_ID]</strong></p>\r\n<p>Regards,</p>\r\n<p>Wesite administrator team</p>'),
(58, 'deposit_payment_reminder_email_subject', 'Deposit Payment Reminder'),
(59, 'deposit_payment_reminder_email_body', '<p>Dear <strong>[FIRST_NAME] [LAST_NAME]</strong></p>\r\n<p>Please access to  <strong>[DEPOSIT_PAYMENT_LINK] </strong>to complete pay for your registration <strong>#[REGISTRATION_ID] </strong>of event <strong>[EVENT_TITLE]</strong>. The amount you have to pay is <strong>[AMOUNT]</strong>.</p>\r\n<p>Regards,</p>\r\n<p>Events Management Team</p>');
CREATE TABLE IF NOT EXISTS `#__eb_payment_plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `creation_date` varchar(50) DEFAULT NULL,
  `copyright` varchar(255) DEFAULT NULL,
  `license` varchar(255) DEFAULT NULL,
  `author_email` varchar(50) DEFAULT NULL,
  `author_url` varchar(50) DEFAULT NULL,
  `version` varchar(20) DEFAULT NULL,
  `description` text,
  `params` text,
  `ordering` int(11) DEFAULT NULL,
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
INSERT IGNORE INTO `#__eb_payment_plugins` (`id`, `name`, `title`, `author`, `creation_date`, `copyright`, `license`, `author_email`, `author_url`, `version`, `description`, `params`, `ordering`, `published`, `access`) VALUES
(1, 'os_paypal', 'Paypal', 'Tuan Pham Ngoc', '09-03-2010', 'Copyright 2007-2010 Ossolution Team', 'http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2', 'tuanpn@joomdonation.com', 'www.joomdonation.com', '1.0', 'Paypal Payment Plugin For Events Booking Extension', '', 1, 1, 1),
(2, 'os_authnet', 'Authorize.net', 'Tuan Pham Ngoc', '09-03-2010', 'Copyright 2007-2010 Ossolution Team', 'http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2', 'tuanpn@joomdonation.com', 'www.joomdonation.com', '1.0', 'Authorize.net Payment Plugin For Events Booking Extension', '', 2, 1, 1),
(3, 'os_eway', 'Eway', 'Tuan Pham Ngoc', '09-03-2010', 'Copyright 2007-2010 Ossolution Team', 'http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2', 'tuanpn@joomdonation.com', 'www.joomdonation.com', '1.0', 'Eway Payment Plugin For Events Booking Extension', '', 3, 0, 1),
(4, 'os_worldpay', 'Worldpay', 'Tuan Pham Ngoc', '09-03-2010', 'Copyright 2007-2010 Ossolution Team', 'http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2', 'tuanpn@joomdonation.com', 'www.joomdonation.com', '1.0', 'Worldpay Payment Plugin For Events Booking Extension', '', 4, 1, 1),
(5, 'os_offline', 'Offline Payment', 'Tuan Pham Ngoc', '09-03-2010', 'Copyright 2007-2010 Ossolution Team', 'http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2', 'tuanpn@joomdonation.com', 'www.joomdonation.com', '1.0', 'Offline Payment Plugin For Events Booking Extension', NULL, 5, 1, 1);
CREATE TABLE IF NOT EXISTS `#__eb_registrants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `group_id` int(11) DEFAULT '0',
  `first_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `organization` varchar(100) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `address2` varchar(255) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `zip` varchar(15) DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `fax` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `number_registrants` int(11) DEFAULT NULL,
  `total_amount` decimal(10,2) DEFAULT NULL,
  `discount_amount` decimal(10,2) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `register_date` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `comment` text,
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `cart_id` int(11) NOT NULL DEFAULT '0',
  `invoice_year` int(11) NOT NULL DEFAULT '0',
  `coupon_usage_restored` tinyint(4) NOT NULL DEFAULT '0',
  `checked_in_at` datetime DEFAULT NULL,
  `checked_out_at` datetime DEFAULT NULL,
  `subscribe_newsletter` tinyint(4) NOT NULL DEFAULT '1',
  `agree_privacy_policy` tinyint(4) NOT NULL DEFAULT '1',
  `coupon_usage_times` int(11) NOT NULL DEFAULT '1',
  `auto_coupon_coupon_id` int(11) NOT NULL DEFAULT '0',
  `deposit_payment_processing_fee` decimal(10,6) DEFAULT '0.000000',
  `payment_amount` decimal(10,6) DEFAULT '0.000000',
  `payment_currency` varchar(15) DEFAULT NULL,
  `payment_processing_fee` decimal(10,6) DEFAULT '0.000000',
  `coupon_discount_amount` decimal(10,6) DEFAULT '0.000000',
  `late_fee` decimal(10,6) DEFAULT '0.000000',
  `notified` tinyint(4) NOT NULL DEFAULT '0',
  `checked_in` tinyint(4) NOT NULL DEFAULT '0',
  `coupon_usage_calculated` tinyint(4) NOT NULL DEFAULT '0',
  `checked_in_count` tinyint(4) NOT NULL DEFAULT '0',
  `deposit_amount` decimal(10,2) DEFAULT '0.00',
  `payment_status` tinyint(4) NOT NULL DEFAULT '1',
  `coupon_id` int(11) NOT NULL DEFAULT '0',
  `check_coupon` tinyint(4) NOT NULL DEFAULT '0',
  `tax_amount` decimal(10,2) DEFAULT '0.00',
  `registration_code` varchar(15) DEFAULT NULL,
  `params` text,
  `is_reminder_sent` tinyint(4) NOT NULL DEFAULT '0',
  `is_second_reminder_sent` tinyint(4) NOT NULL DEFAULT '0',
  `is_deposit_payment_reminder_sent` tinyint(4) NOT NULL DEFAULT '0',
  `is_offline_payment_reminder_sent` tinyint(4) NOT NULL DEFAULT '0',
  `process_deposit_payment` tinyint(4) NOT NULL DEFAULT '0',
  `deposit_payment_transaction_id` varchar(100) DEFAULT NULL,
  `user_ip` varchar(100) DEFAULT NULL,
  `deposit_payment_method` varchar(100) DEFAULT NULL,
  `is_group_billing` tinyint(4) NOT NULL DEFAULT '0',
  `language` varchar(50) DEFAULT '*',
  `ticket_number` int(11) NOT NULL DEFAULT '0',
  `ticket_code` varchar(40) DEFAULT NULL,
  `ticket_qrcode` varchar(40) DEFAULT NULL,
  `invoice_number` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_published` (`published`),
  KEY `idx_first_name` (`first_name`),
  KEY `idx_last_name` (`last_name`),
  KEY `idx_email` (`email`),
  KEY `idx_transaction_id` (`transaction_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_registrant_tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `registrant_id` int(11) DEFAULT NULL,
  `ticket_type_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_speakers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(10) UNSIGNED DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `description` text,
  `url` varchar(255) DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_sponsors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(10) UNSIGNED DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_event_id` (`event_id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_states` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL DEFAULT '1',
  `state_name` varchar(64) DEFAULT NULL,
  `state_3_code` char(3) DEFAULT NULL,
  `state_2_code` char(2) DEFAULT NULL,
  `state_id` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `state_3_code` (`country_id`,`state_3_code`),
  UNIQUE KEY `state_2_code` (`country_id`,`state_2_code`),
  KEY `idx_country_id` (`country_id`)
) AUTO_INCREMENT=449 CHARACTER SET `utf8`;
INSERT IGNORE INTO `#__eb_states` (`id`, `country_id`, `state_name`, `state_3_code`, `state_2_code`, `state_id`, `published`) VALUES
(1, 223, 'Alabama', 'ALA', 'AL', 1, 1),
(2, 223, 'Alaska', 'ALK', 'AK', 2, 1),
(3, 223, 'Arizona', 'ARZ', 'AZ', 3, 1),
(4, 223, 'Arkansas', 'ARK', 'AR', 4, 1),
(5, 223, 'California', 'CAL', 'CA', 5, 1),
(6, 223, 'Colorado', 'COL', 'CO', 6, 1),
(7, 223, 'Connecticut', 'CCT', 'CT', 7, 1),
(8, 223, 'Delaware', 'DEL', 'DE', 8, 1),
(9, 223, 'District Of Columbia', 'DOC', 'DC', 9, 1),
(10, 223, 'Florida', 'FLO', 'FL', 10, 1),
(11, 223, 'Georgia', 'GEA', 'GA', 11, 1),
(12, 223, 'Hawaii', 'HWI', 'HI', 12, 1),
(13, 223, 'Idaho', 'IDA', 'ID', 13, 1),
(14, 223, 'Illinois', 'ILL', 'IL', 14, 1),
(15, 223, 'Indiana', 'IND', 'IN', 15, 1),
(16, 223, 'Iowa', 'IOA', 'IA', 16, 1),
(17, 223, 'Kansas', 'KAS', 'KS', 17, 1),
(18, 223, 'Kentucky', 'KTY', 'KY', 18, 1),
(19, 223, 'Louisiana', 'LOA', 'LA', 19, 1),
(20, 223, 'Maine', 'MAI', 'ME', 20, 1),
(21, 223, 'Maryland', 'MLD', 'MD', 21, 1),
(22, 223, 'Massachusetts', 'MSA', 'MA', 22, 1),
(23, 223, 'Michigan', 'MIC', 'MI', 23, 1),
(24, 223, 'Minnesota', 'MIN', 'MN', 24, 1),
(25, 223, 'Mississippi', 'MIS', 'MS', 25, 1),
(26, 223, 'Missouri', 'MIO', 'MO', 26, 1),
(27, 223, 'Montana', 'MOT', 'MT', 27, 1),
(28, 223, 'Nebraska', 'NEB', 'NE', 28, 1),
(29, 223, 'Nevada', 'NEV', 'NV', 29, 1),
(30, 223, 'New Hampshire', 'NEH', 'NH', 30, 1),
(31, 223, 'New Jersey', 'NEJ', 'NJ', 31, 1),
(32, 223, 'New Mexico', 'NEM', 'NM', 32, 1),
(33, 223, 'New York', 'NEY', 'NY', 33, 1),
(34, 223, 'North Carolina', 'NOC', 'NC', 34, 1),
(35, 223, 'North Dakota', 'NOD', 'ND', 35, 1),
(36, 223, 'Ohio', 'OHI', 'OH', 36, 1),
(37, 223, 'Oklahoma', 'OKL', 'OK', 37, 1),
(38, 223, 'Oregon', 'ORN', 'OR', 38, 1),
(39, 223, 'Pennsylvania', 'PEA', 'PA', 39, 1),
(40, 223, 'Rhode Island', 'RHI', 'RI', 40, 1),
(41, 223, 'South Carolina', 'SOC', 'SC', 41, 1),
(42, 223, 'South Dakota', 'SOD', 'SD', 42, 1),
(43, 223, 'Tennessee', 'TEN', 'TN', 43, 1),
(44, 223, 'Texas', 'TXS', 'TX', 44, 1),
(45, 223, 'Utah', 'UTA', 'UT', 45, 1),
(46, 223, 'Vermont', 'VMT', 'VT', 46, 1),
(47, 223, 'Virginia', 'VIA', 'VA', 47, 1),
(48, 223, 'Washington', 'WAS', 'WA', 48, 1),
(49, 223, 'West Virginia', 'WEV', 'WV', 49, 1),
(50, 223, 'Wisconsin', 'WIS', 'WI', 50, 1),
(51, 223, 'Wyoming', 'WYO', 'WY', 51, 1),
(52, 38, 'Alberta', 'ALB', 'AB', 52, 1),
(53, 38, 'British Columbia', 'BRC', 'BC', 53, 1),
(54, 38, 'Manitoba', 'MAB', 'MB', 54, 1),
(55, 38, 'New Brunswick', 'NEB', 'NB', 55, 1),
(56, 38, 'Newfoundland and Labrador', 'NFL', 'NL', 56, 1),
(57, 38, 'Northwest Territories', 'NWT', 'NT', 57, 1),
(58, 38, 'Nova Scotia', 'NOS', 'NS', 58, 1),
(59, 38, 'Nunavut', 'NUT', 'NU', 59, 1),
(60, 38, 'Ontario', 'ONT', 'ON', 60, 1),
(61, 38, 'Prince Edward Island', 'PEI', 'PE', 61, 1),
(62, 38, 'Quebec', 'QEC', 'QC', 62, 1),
(63, 38, 'Saskatchewan', 'SAK', 'SK', 63, 1),
(64, 38, 'Yukon', 'YUT', 'YT', 64, 1),
(65, 222, 'England', 'ENG', 'EN', 65, 1),
(66, 222, 'Northern Ireland', 'NOI', 'NI', 66, 1),
(67, 222, 'Scotland', 'SCO', 'SD', 67, 1),
(68, 222, 'Wales', 'WLS', 'WS', 68, 1),
(69, 13, 'Australian Capital Territory', 'ACT', 'AC', 69, 1),
(70, 13, 'New South Wales', 'NSW', 'NS', 70, 1),
(71, 13, 'Northern Territory', 'NOT', 'NT', 71, 1),
(72, 13, 'Queensland', 'QLD', 'QL', 72, 1),
(73, 13, 'South Australia', 'SOA', 'SA', 73, 1),
(74, 13, 'Tasmania', 'TAS', 'TS', 74, 1),
(75, 13, 'Victoria', 'VIC', 'VI', 75, 1),
(76, 13, 'Western Australia', 'WEA', 'WA', 76, 1),
(77, 138, 'Aguascalientes', 'AGS', 'AG', 77, 1),
(78, 138, 'Baja California Norte', 'BCN', 'BN', 78, 1),
(79, 138, 'Baja California Sur', 'BCS', 'BS', 79, 1),
(80, 138, 'Campeche', 'CAM', 'CA', 80, 1),
(81, 138, 'Chiapas', 'CHI', 'CS', 81, 1),
(82, 138, 'Chihuahua', 'CHA', 'CH', 82, 1),
(83, 138, 'Coahuila', 'COA', 'CO', 83, 1),
(84, 138, 'Colima', 'COL', 'CM', 84, 1),
(85, 138, 'Distrito Federal', 'DFM', 'DF', 85, 1),
(86, 138, 'Durango', 'DGO', 'DO', 86, 1),
(87, 138, 'Guanajuato', 'GTO', 'GO', 87, 1),
(88, 138, 'Guerrero', 'GRO', 'GU', 88, 1),
(89, 138, 'Hidalgo', 'HGO', 'HI', 89, 1),
(90, 138, 'Jalisco', 'JAL', 'JA', 90, 1),
(91, 138, 'M�xico (Estado de)', 'EDM', 'EM', 91, 1),
(92, 138, 'Michoac�n', 'MCN', 'MI', 92, 1),
(93, 138, 'Morelos', 'MOR', 'MO', 93, 1),
(94, 138, 'Nayarit', 'NAY', 'NY', 94, 1),
(95, 138, 'Nuevo Le�n', 'NUL', 'NL', 95, 1),
(96, 138, 'Oaxaca', 'OAX', 'OA', 96, 1),
(97, 138, 'Puebla', 'PUE', 'PU', 97, 1),
(98, 138, 'Quer�taro', 'QRO', 'QU', 98, 1),
(99, 138, 'Quintana Roo', 'QUR', 'QR', 99, 1),
(100, 138, 'San Luis Potos�', 'SLP', 'SP', 100, 1),
(101, 138, 'Sinaloa', 'SIN', 'SI', 101, 1),
(102, 138, 'Sonora', 'SON', 'SO', 102, 1),
(103, 138, 'Tabasco', 'TAB', 'TA', 103, 1),
(104, 138, 'Tamaulipas', 'TAM', 'TM', 104, 1),
(105, 138, 'Tlaxcala', 'TLX', 'TX', 105, 1),
(106, 138, 'Veracruz', 'VER', 'VZ', 106, 1),
(107, 138, 'Yucat�n', 'YUC', 'YU', 107, 1),
(108, 138, 'Zacatecas', 'ZAC', 'ZA', 108, 1),
(109, 30, 'Acre', 'ACR', 'AC', 109, 1),
(110, 30, 'Alagoas', 'ALG', 'AL', 110, 1),
(111, 30, 'Amap�', 'AMP', 'AP', 111, 1),
(112, 30, 'Amazonas', 'AMZ', 'AM', 112, 1),
(113, 30, 'Bah�a', 'BAH', 'BA', 113, 1),
(114, 30, 'Cear�', 'CEA', 'CE', 114, 1),
(115, 30, 'Distrito Federal', 'DFB', 'DF', 115, 1),
(116, 30, 'Espirito Santo', 'ESS', 'ES', 116, 1),
(117, 30, 'Goi�s', 'GOI', 'GO', 117, 1),
(118, 30, 'Maranh�o', 'MAR', 'MA', 118, 1),
(119, 30, 'Mato Grosso', 'MAT', 'MT', 119, 1),
(120, 30, 'Mato Grosso do Sul', 'MGS', 'MS', 120, 1),
(121, 30, 'Minas Gera�s', 'MIG', 'MG', 121, 1),
(122, 30, 'Paran�', 'PAR', 'PR', 122, 1),
(123, 30, 'Para�ba', 'PRB', 'PB', 123, 1),
(124, 30, 'Par�', 'PAB', 'PA', 124, 1),
(125, 30, 'Pernambuco', 'PER', 'PE', 125, 1),
(126, 30, 'Piau�', 'PIA', 'PI', 126, 1),
(127, 30, 'Rio Grande do Norte', 'RGN', 'RN', 127, 1),
(128, 30, 'Rio Grande do Sul', 'RGS', 'RS', 128, 1),
(129, 30, 'Rio de Janeiro', 'RDJ', 'RJ', 129, 1),
(130, 30, 'Rond�nia', 'RON', 'RO', 130, 1),
(131, 30, 'Roraima', 'ROR', 'RR', 131, 1),
(132, 30, 'Santa Catarina', 'SAC', 'SC', 132, 1),
(133, 30, 'Sergipe', 'SER', 'SE', 133, 1),
(134, 30, 'S�o Paulo', 'SAP', 'SP', 134, 1),
(135, 30, 'Tocantins', 'TOC', 'TO', 135, 1),
(136, 44, 'Anhui', 'ANH', '34', 136, 1),
(137, 44, 'Beijing', 'BEI', '11', 137, 1),
(138, 44, 'Chongqing', 'CHO', '50', 138, 1),
(139, 44, 'Fujian', 'FUJ', '35', 139, 1),
(140, 44, 'Gansu', 'GAN', '62', 140, 1),
(141, 44, 'Guangdong', 'GUA', '44', 141, 1),
(142, 44, 'Guangxi Zhuang', 'GUZ', '45', 142, 1),
(143, 44, 'Guizhou', 'GUI', '52', 143, 1),
(144, 44, 'Hainan', 'HAI', '46', 144, 1),
(145, 44, 'Hebei', 'HEB', '13', 145, 1),
(146, 44, 'Heilongjiang', 'HEI', '23', 146, 1),
(147, 44, 'Henan', 'HEN', '41', 147, 1),
(148, 44, 'Hubei', 'HUB', '42', 148, 1),
(149, 44, 'Hunan', 'HUN', '43', 149, 1),
(150, 44, 'Jiangsu', 'JIA', '32', 150, 1),
(151, 44, 'Jiangxi', 'JIX', '36', 151, 1),
(152, 44, 'Jilin', 'JIL', '22', 152, 1),
(153, 44, 'Liaoning', 'LIA', '21', 153, 1),
(154, 44, 'Nei Mongol', 'NML', '15', 154, 1),
(155, 44, 'Ningxia Hui', 'NIH', '64', 155, 1),
(156, 44, 'Qinghai', 'QIN', '63', 156, 1),
(157, 44, 'Shandong', 'SNG', '37', 157, 1),
(158, 44, 'Shanghai', 'SHH', '31', 158, 1),
(159, 44, 'Shaanxi', 'SHX', '61', 159, 1),
(160, 44, 'Sichuan', 'SIC', '51', 160, 1),
(161, 44, 'Tianjin', 'TIA', '12', 161, 1),
(162, 44, 'Xinjiang Uygur', 'XIU', '65', 162, 1),
(163, 44, 'Xizang', 'XIZ', '54', 163, 1),
(164, 44, 'Yunnan', 'YUN', '53', 164, 1),
(165, 44, 'Zhejiang', 'ZHE', '33', 165, 1),
(166, 104, 'Israel', 'ISL', 'IL', 166, 1),
(167, 104, 'Gaza Strip', 'GZS', 'GZ', 167, 1),
(168, 104, 'West Bank', 'WBK', 'WB', 168, 1),
(169, 151, 'St. Maarten', 'STM', 'SM', 169, 1),
(170, 151, 'Bonaire', 'BNR', 'BN', 170, 1),
(171, 151, 'Curacao', 'CUR', 'CR', 171, 1),
(172, 175, 'Alba', 'ABA', 'AB', 172, 1),
(173, 175, 'Arad', 'ARD', 'AR', 173, 1),
(174, 175, 'Arges', 'ARG', 'AG', 174, 1),
(175, 175, 'Bacau', 'BAC', 'BC', 175, 1),
(176, 175, 'Bihor', 'BIH', 'BH', 176, 1),
(177, 175, 'Bistrita-Nasaud', 'BIS', 'BN', 177, 1),
(178, 175, 'Botosani', 'BOT', 'BT', 178, 1),
(179, 175, 'Braila', 'BRL', 'BR', 179, 1),
(180, 175, 'Brasov', 'BRA', 'BV', 180, 1),
(181, 175, 'Bucuresti', 'BUC', 'B', 181, 1),
(182, 175, 'Buzau', 'BUZ', 'BZ', 182, 1),
(183, 175, 'Calarasi', 'CAL', 'CL', 183, 1),
(184, 175, 'Caras Severin', 'CRS', 'CS', 184, 1),
(185, 175, 'Cluj', 'CLJ', 'CJ', 185, 1),
(186, 175, 'Constanta', 'CST', 'CT', 186, 1),
(187, 175, 'Covasna', 'COV', 'CV', 187, 1),
(188, 175, 'Dambovita', 'DAM', 'DB', 188, 1),
(189, 175, 'Dolj', 'DLJ', 'DJ', 189, 1),
(190, 175, 'Galati', 'GAL', 'GL', 190, 1),
(191, 175, 'Giurgiu', 'GIU', 'GR', 191, 1),
(192, 175, 'Gorj', 'GOR', 'GJ', 192, 1),
(193, 175, 'Hargita', 'HRG', 'HR', 193, 1),
(194, 175, 'Hunedoara', 'HUN', 'HD', 194, 1),
(195, 175, 'Ialomita', 'IAL', 'IL', 195, 1),
(196, 175, 'Iasi', 'IAS', 'IS', 196, 1),
(197, 175, 'Ilfov', 'ILF', 'IF', 197, 1),
(198, 175, 'Maramures', 'MAR', 'MM', 198, 1),
(199, 175, 'Mehedinti', 'MEH', 'MH', 199, 1),
(200, 175, 'Mures', 'MUR', 'MS', 200, 1),
(201, 175, 'Neamt', 'NEM', 'NT', 201, 1),
(202, 175, 'Olt', 'OLT', 'OT', 202, 1),
(203, 175, 'Prahova', 'PRA', 'PH', 203, 1),
(204, 175, 'Salaj', 'SAL', 'SJ', 204, 1),
(205, 175, 'Satu Mare', 'SAT', 'SM', 205, 1),
(206, 175, 'Sibiu', 'SIB', 'SB', 206, 1),
(207, 175, 'Suceava', 'SUC', 'SV', 207, 1),
(208, 175, 'Teleorman', 'TEL', 'TR', 208, 1),
(209, 175, 'Timis', 'TIM', 'TM', 209, 1),
(210, 175, 'Tulcea', 'TUL', 'TL', 210, 1),
(211, 175, 'Valcea', 'VAL', 'VL', 211, 1),
(212, 175, 'Vaslui', 'VAS', 'VS', 212, 1),
(213, 175, 'Vrancea', 'VRA', 'VN', 213, 1),
(214, 105, 'Agrigento', 'AGR', 'AG', 214, 1),
(215, 105, 'Alessandria', 'ALE', 'AL', 215, 1),
(216, 105, 'Ancona', 'ANC', 'AN', 216, 1),
(217, 105, 'Aosta', 'AOS', 'AO', 217, 1),
(218, 105, 'Arezzo', 'ARE', 'AR', 218, 1),
(219, 105, 'Ascoli Piceno', 'API', 'AP', 219, 1),
(220, 105, 'Asti', 'AST', 'AT', 220, 1),
(221, 105, 'Avellino', 'AVE', 'AV', 221, 1),
(222, 105, 'Bari', 'BAR', 'BA', 222, 1),
(223, 105, 'Belluno', 'BEL', 'BL', 223, 1),
(224, 105, 'Benevento', 'BEN', 'BN', 224, 1),
(225, 105, 'Bergamo', 'BEG', 'BG', 225, 1),
(226, 105, 'Biella', 'BIE', 'BI', 226, 1),
(227, 105, 'Bologna', 'BOL', 'BO', 227, 1),
(228, 105, 'Bolzano', 'BOZ', 'BZ', 228, 1),
(229, 105, 'Brescia', 'BRE', 'BS', 229, 1),
(230, 105, 'Brindisi', 'BRI', 'BR', 230, 1),
(231, 105, 'Cagliari', 'CAG', 'CA', 231, 1),
(232, 105, 'Caltanissetta', 'CAL', 'CL', 232, 1),
(233, 105, 'Campobasso', 'CBO', 'CB', 233, 1),
(234, 105, 'Carbonia-Iglesias', 'CAR', 'CI', 234, 1),
(235, 105, 'Caserta', 'CAS', 'CE', 235, 1),
(236, 105, 'Catania', 'CAT', 'CT', 236, 1),
(237, 105, 'Catanzaro', 'CTZ', 'CZ', 237, 1),
(238, 105, 'Chieti', 'CHI', 'CH', 238, 1),
(239, 105, 'Como', 'COM', 'CO', 239, 1),
(240, 105, 'Cosenza', 'COS', 'CS', 240, 1),
(241, 105, 'Cremona', 'CRE', 'CR', 241, 1),
(242, 105, 'Crotone', 'CRO', 'KR', 242, 1),
(243, 105, 'Cuneo', 'CUN', 'CN', 243, 1),
(244, 105, 'Enna', 'ENN', 'EN', 244, 1),
(245, 105, 'Ferrara', 'FER', 'FE', 245, 1),
(246, 105, 'Firenze', 'FIR', 'FI', 246, 1),
(247, 105, 'Foggia', 'FOG', 'FG', 247, 1),
(248, 105, 'Forli-Cesena', 'FOC', 'FC', 248, 1),
(249, 105, 'Frosinone', 'FRO', 'FR', 249, 1),
(250, 105, 'Genova', 'GEN', 'GE', 250, 1),
(251, 105, 'Gorizia', 'GOR', 'GO', 251, 1),
(252, 105, 'Grosseto', 'GRO', 'GR', 252, 1),
(253, 105, 'Imperia', 'IMP', 'IM', 253, 1),
(254, 105, 'Isernia', 'ISE', 'IS', 254, 1),
(255, 105, 'L\'Aquila', 'AQU', 'AQ', 255, 1),
(256, 105, 'La Spezia', 'LAS', 'SP', 256, 1),
(257, 105, 'Latina', 'LAT', 'LT', 257, 1),
(258, 105, 'Lecce', 'LEC', 'LE', 258, 1),
(259, 105, 'Lecco', 'LCC', 'LC', 259, 1),
(260, 105, 'Livorno', 'LIV', 'LI', 260, 1),
(261, 105, 'Lodi', 'LOD', 'LO', 261, 1),
(262, 105, 'Lucca', 'LUC', 'LU', 262, 1),
(263, 105, 'Macerata', 'MAC', 'MC', 263, 1),
(264, 105, 'Mantova', 'MAN', 'MN', 264, 1),
(265, 105, 'Massa-Carrara', 'MAS', 'MS', 265, 1),
(266, 105, 'Matera', 'MAA', 'MT', 266, 1),
(267, 105, 'Medio Campidano', 'MED', 'VS', 267, 1),
(268, 105, 'Messina', 'MES', 'ME', 268, 1),
(269, 105, 'Milano', 'MIL', 'MI', 269, 1),
(270, 105, 'Modena', 'MOD', 'MO', 270, 1),
(271, 105, 'Napoli', 'NAP', 'NA', 271, 1),
(272, 105, 'Novara', 'NOV', 'NO', 272, 1),
(273, 105, 'Nuoro', 'NUR', 'NU', 273, 1),
(274, 105, 'Ogliastra', 'OGL', 'OG', 274, 1),
(275, 105, 'Olbia-Tempio', 'OLB', 'OT', 275, 1),
(276, 105, 'Oristano', 'ORI', 'OR', 276, 1),
(277, 105, 'Padova', 'PDA', 'PD', 277, 1),
(278, 105, 'Palermo', 'PAL', 'PA', 278, 1),
(279, 105, 'Parma', 'PAA', 'PR', 279, 1),
(280, 105, 'Pavia', 'PAV', 'PV', 280, 1),
(281, 105, 'Perugia', 'PER', 'PG', 281, 1),
(282, 105, 'Pesaro e Urbino', 'PES', 'PU', 282, 1),
(283, 105, 'Pescara', 'PSC', 'PE', 283, 1),
(284, 105, 'Piacenza', 'PIA', 'PC', 284, 1),
(285, 105, 'Pisa', 'PIS', 'PI', 285, 1),
(286, 105, 'Pistoia', 'PIT', 'PT', 286, 1),
(287, 105, 'Pordenone', 'POR', 'PN', 287, 1),
(288, 105, 'Potenza', 'PTZ', 'PZ', 288, 1),
(289, 105, 'Prato', 'PRA', 'PO', 289, 1),
(290, 105, 'Ragusa', 'RAG', 'RG', 290, 1),
(291, 105, 'Ravenna', 'RAV', 'RA', 291, 1),
(292, 105, 'Reggio Calabria', 'REG', 'RC', 292, 1),
(293, 105, 'Reggio Emilia', 'REE', 'RE', 293, 1),
(294, 105, 'Rieti', 'RIE', 'RI', 294, 1),
(295, 105, 'Rimini', 'RIM', 'RN', 295, 1),
(296, 105, 'Roma', 'ROM', 'RM', 296, 1),
(297, 105, 'Rovigo', 'ROV', 'RO', 297, 1),
(298, 105, 'Salerno', 'SAL', 'SA', 298, 1),
(299, 105, 'Sassari', 'SAS', 'SS', 299, 1),
(300, 105, 'Savona', 'SAV', 'SV', 300, 1),
(301, 105, 'Siena', 'SIE', 'SI', 301, 1),
(302, 105, 'Siracusa', 'SIR', 'SR', 302, 1),
(303, 105, 'Sondrio', 'SOO', 'SO', 303, 1),
(304, 105, 'Taranto', 'TAR', 'TA', 304, 1),
(305, 105, 'Teramo', 'TER', 'TE', 305, 1),
(306, 105, 'Terni', 'TRN', 'TR', 306, 1),
(307, 105, 'Torino', 'TOR', 'TO', 307, 1),
(308, 105, 'Trapani', 'TRA', 'TP', 308, 1),
(309, 105, 'Trento', 'TRE', 'TN', 309, 1),
(310, 105, 'Treviso', 'TRV', 'TV', 310, 1),
(311, 105, 'Trieste', 'TRI', 'TS', 311, 1),
(312, 105, 'Udine', 'UDI', 'UD', 312, 1),
(313, 105, 'Varese', 'VAR', 'VA', 313, 1),
(314, 105, 'Venezia', 'VEN', 'VE', 314, 1),
(315, 105, 'Verbano Cusio Ossola', 'VCO', 'VB', 315, 1),
(316, 105, 'Vercelli', 'VER', 'VC', 316, 1),
(317, 105, 'Verona', 'VRN', 'VR', 317, 1),
(318, 105, 'Vibo Valenzia', 'VIV', 'VV', 318, 1),
(319, 105, 'Vicenza', 'VII', 'VI', 319, 1),
(320, 105, 'Viterbo', 'VIT', 'VT', 320, 1),
(321, 195, 'A Coru�a', 'ACO', '15', 321, 1),
(322, 195, 'Alava', 'ALA', '01', 322, 1),
(323, 195, 'Albacete', 'ALB', '02', 323, 1),
(324, 195, 'Alicante', 'ALI', '03', 324, 1),
(325, 195, 'Almeria', 'ALM', '04', 325, 1),
(326, 195, 'Asturias', 'AST', '33', 326, 1),
(327, 195, 'Avila', 'AVI', '05', 327, 1),
(328, 195, 'Badajoz', 'BAD', '06', 328, 1),
(329, 195, 'Baleares', 'BAL', '07', 329, 1),
(330, 195, 'Barcelona', 'BAR', '08', 330, 1),
(331, 195, 'Burgos', 'BUR', '09', 331, 1),
(332, 195, 'Caceres', 'CAC', '10', 332, 1),
(333, 195, 'Cadiz', 'CAD', '11', 333, 1),
(334, 195, 'Cantabria', 'CAN', '39', 334, 1),
(335, 195, 'Castellon', 'CAS', '12', 335, 1),
(336, 195, 'Ceuta', 'CEU', '51', 336, 1),
(337, 195, 'Ciudad Real', 'CIU', '13', 337, 1),
(338, 195, 'Cordoba', 'COR', '14', 338, 1),
(339, 195, 'Cuenca', 'CUE', '16', 339, 1),
(340, 195, 'Girona', 'GIR', '17', 340, 1),
(341, 195, 'Granada', 'GRA', '18', 341, 1),
(342, 195, 'Guadalajara', 'GUA', '19', 342, 1),
(343, 195, 'Guipuzcoa', 'GUI', '20', 343, 1),
(344, 195, 'Huelva', 'HUL', '21', 344, 1),
(345, 195, 'Huesca', 'HUS', '22', 345, 1),
(346, 195, 'Jaen', 'JAE', '23', 346, 1),
(347, 195, 'La Rioja', 'LRI', '26', 347, 1),
(348, 195, 'Las Palmas', 'LPA', '35', 348, 1),
(349, 195, 'Leon', 'LEO', '24', 349, 1),
(350, 195, 'Lleida', 'LLE', '25', 350, 1),
(351, 195, 'Lugo', 'LUG', '27', 351, 1),
(352, 195, 'Madrid', 'MAD', '28', 352, 1),
(353, 195, 'Malaga', 'MAL', '29', 353, 1),
(354, 195, 'Melilla', 'MEL', '52', 354, 1),
(355, 195, 'Murcia', 'MUR', '30', 355, 1),
(356, 195, 'Navarra', 'NAV', '31', 356, 1),
(357, 195, 'Ourense', 'OUR', '32', 357, 1),
(358, 195, 'Palencia', 'PAL', '34', 358, 1),
(359, 195, 'Pontevedra', 'PON', '36', 359, 1),
(360, 195, 'Salamanca', 'SAL', '37', 360, 1),
(361, 195, 'Santa Cruz de Tenerife', 'SCT', '38', 361, 1),
(362, 195, 'Segovia', 'SEG', '40', 362, 1),
(363, 195, 'Sevilla', 'SEV', '41', 363, 1),
(364, 195, 'Soria', 'SOR', '42', 364, 1),
(365, 195, 'Tarragona', 'TAR', '43', 365, 1),
(366, 195, 'Teruel', 'TER', '44', 366, 1),
(367, 195, 'Toledo', 'TOL', '45', 367, 1),
(368, 195, 'Valencia', 'VAL', '46', 368, 1),
(369, 195, 'Valladolid', 'VLL', '47', 369, 1),
(370, 195, 'Vizcaya', 'VIZ', '48', 370, 1),
(371, 195, 'Zamora', 'ZAM', '49', 371, 1),
(372, 195, 'Zaragoza', 'ZAR', '50', 372, 1),
(373, 11, 'Aragatsotn', 'ARG', 'AG', 373, 1),
(374, 11, 'Ararat', 'ARR', 'AR', 374, 1),
(375, 11, 'Armavir', 'ARM', 'AV', 375, 1),
(376, 11, 'Gegharkunik', 'GEG', 'GR', 376, 1),
(377, 11, 'Kotayk', 'KOT', 'KT', 377, 1),
(378, 11, 'Lori', 'LOR', 'LO', 378, 1),
(379, 11, 'Shirak', 'SHI', 'SH', 379, 1),
(380, 11, 'Syunik', 'SYU', 'SU', 380, 1),
(381, 11, 'Tavush', 'TAV', 'TV', 381, 1),
(382, 11, 'Vayots-Dzor', 'VAD', 'VD', 382, 1),
(383, 11, 'Yerevan', 'YER', 'ER', 383, 1),
(384, 99, 'Andaman & Nicobar Islands', 'ANI', 'AI', 384, 1),
(385, 99, 'Andhra Pradesh', 'AND', 'AN', 385, 1),
(386, 99, 'Arunachal Pradesh', 'ARU', 'AR', 386, 1),
(387, 99, 'Assam', 'ASS', 'AS', 387, 1),
(388, 99, 'Bihar', 'BIH', 'BI', 388, 1),
(389, 99, 'Chandigarh', 'CHA', 'CA', 389, 1),
(390, 99, 'Chhatisgarh', 'CHH', 'CH', 390, 1),
(391, 99, 'Dadra & Nagar Haveli', 'DAD', 'DD', 391, 1),
(392, 99, 'Daman & Diu', 'DAM', 'DA', 392, 1),
(393, 99, 'Delhi', 'DEL', 'DE', 393, 1),
(394, 99, 'Goa', 'GOA', 'GO', 394, 1),
(395, 99, 'Gujarat', 'GUJ', 'GU', 395, 1),
(396, 99, 'Haryana', 'HAR', 'HA', 396, 1),
(397, 99, 'Himachal Pradesh', 'HIM', 'HI', 397, 1),
(398, 99, 'Jammu & Kashmir', 'JAM', 'JA', 398, 1),
(399, 99, 'Jharkhand', 'JHA', 'JH', 399, 1),
(400, 99, 'Karnataka', 'KAR', 'KA', 400, 1),
(401, 99, 'Kerala', 'KER', 'KE', 401, 1),
(402, 99, 'Lakshadweep', 'LAK', 'LA', 402, 1),
(403, 99, 'Madhya Pradesh', 'MAD', 'MD', 403, 1),
(404, 99, 'Maharashtra', 'MAH', 'MH', 404, 1),
(405, 99, 'Manipur', 'MAN', 'MN', 405, 1),
(406, 99, 'Meghalaya', 'MEG', 'ME', 406, 1),
(407, 99, 'Mizoram', 'MIZ', 'MI', 407, 1),
(408, 99, 'Nagaland', 'NAG', 'NA', 408, 1),
(409, 99, 'Orissa', 'ORI', 'OR', 409, 1),
(410, 99, 'Pondicherry', 'PON', 'PO', 410, 1),
(411, 99, 'Punjab', 'PUN', 'PU', 411, 1),
(412, 99, 'Rajasthan', 'RAJ', 'RA', 412, 1),
(413, 99, 'Sikkim', 'SIK', 'SI', 413, 1),
(414, 99, 'Tamil Nadu', 'TAM', 'TA', 414, 1),
(415, 99, 'Tripura', 'TRI', 'TR', 415, 1),
(416, 99, 'Uttaranchal', 'UAR', 'UA', 416, 1),
(417, 99, 'Uttar Pradesh', 'UTT', 'UT', 417, 1),
(418, 99, 'West Bengal', 'WES', 'WE', 418, 1),
(419, 101, 'Ahmadi va Kohkiluyeh', 'BOK', 'BO', 419, 1),
(420, 101, 'Ardabil', 'ARD', 'AR', 420, 1),
(421, 101, 'Azarbayjan-e Gharbi', 'AZG', 'AG', 421, 1),
(422, 101, 'Azarbayjan-e Sharqi', 'AZS', 'AS', 422, 1),
(423, 101, 'Bushehr', 'BUS', 'BU', 423, 1),
(424, 101, 'Chaharmahal va Bakhtiari', 'CMB', 'CM', 424, 1),
(425, 101, 'Esfahan', 'ESF', 'ES', 425, 1),
(426, 101, 'Fars', 'FAR', 'FA', 426, 1),
(427, 101, 'Gilan', 'GIL', 'GI', 427, 1),
(428, 101, 'Gorgan', 'GOR', 'GO', 428, 1),
(429, 101, 'Hamadan', 'HAM', 'HA', 429, 1),
(430, 101, 'Hormozgan', 'HOR', 'HO', 430, 1),
(431, 101, 'Ilam', 'ILA', 'IL', 431, 1),
(432, 101, 'Kerman', 'KER', 'KE', 432, 1),
(433, 101, 'Kermanshah', 'BAK', 'BA', 433, 1),
(434, 101, 'Khorasan-e Junoubi', 'KHJ', 'KJ', 434, 1),
(435, 101, 'Khorasan-e Razavi', 'KHR', 'KR', 435, 1),
(436, 101, 'Khorasan-e Shomali', 'KHS', 'KS', 436, 1),
(437, 101, 'Khuzestan', 'KHU', 'KH', 437, 1),
(438, 101, 'Kordestan', 'KOR', 'KO', 438, 1),
(439, 101, 'Lorestan', 'LOR', 'LO', 439, 1),
(440, 101, 'Markazi', 'MAR', 'MR', 440, 1),
(441, 101, 'Mazandaran', 'MAZ', 'MZ', 441, 1),
(442, 101, 'Qazvin', 'QAS', 'QA', 442, 1),
(443, 101, 'Qom', 'QOM', 'QO', 443, 1),
(444, 101, 'Semnan', 'SEM', 'SE', 444, 1),
(445, 101, 'Sistan va Baluchestan', 'SBA', 'SB', 445, 1),
(446, 101, 'Tehran', 'TEH', 'TE', 446, 1),
(447, 101, 'Yazd', 'YAZ', 'YA', 447, 1),
(448, 101, 'Zanjan', 'ZAN', 'ZA', 448, 1);
CREATE TABLE IF NOT EXISTS `#__eb_themes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `creation_date` varchar(50) DEFAULT NULL,
  `copyright` varchar(255) DEFAULT NULL,
  `license` varchar(255) DEFAULT NULL,
  `author_email` varchar(50) DEFAULT NULL,
  `author_url` varchar(50) DEFAULT NULL,
  `version` varchar(20) DEFAULT NULL,
  `description` text,
  `params` text,
  `ordering` int(11) DEFAULT NULL,
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=2 CHARACTER SET `utf8`;
INSERT IGNORE INTO `#__eb_themes` (`id`, `name`, `title`, `author`, `creation_date`, `copyright`, `license`, `author_email`, `author_url`, `version`, `description`, `params`, `ordering`, `published`) VALUES
(1, 'default', 'Default Theme', 'Tuan Pham Ngoc', '08-06-2018', 'Copyright 2010-2018 Ossolution Team', 'http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2', 'tuanpn@joomdonation.com', 'www.joomdonation.com', '1.0', 'Default Theme For Events Booking Extension', '', 1, 1);
CREATE TABLE IF NOT EXISTS `#__eb_ticket_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `price` decimal(10,2) DEFAULT NULL,
  `capacity` int(11) DEFAULT NULL,
  `weight` int(11) NOT NULL DEFAULT '1',
  `max_tickets_per_booking` int(11) NOT NULL DEFAULT '0',
  `parent_ticket_type_id` int(11) NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) CHARACTER SET `utf8`;
CREATE TABLE IF NOT EXISTS `#__eb_urls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `md5_key` varchar(32) DEFAULT NULL,
  `query` text,
  `view` varchar(15) DEFAULT NULL,
  `record_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_md5_key` (`md5_key`)
) CHARACTER SET `utf8`;