/**
 * @package   	JCE
 * @copyright 	Copyright (c) 2009-2019 Ryan Demmer. All rights reserved.
 * @license   	GNU/GPL 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * JCE is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
(function ($) {
    var Wf = {};

    Wf.Help = {
        options: {
            url: '',
            key: [],
            pattern: ''
        },
        init: function (options) {
            var key, id, n, self = this;

            this.options = $.extend(this.options, options);

            $('#help-menu > li[id]').click(function (e) {                
                $('#help-menu').find('li').removeClass('loading').removeClass('active');

                var el = this;

                if (e.target.nodeName !== "LI") {
                    el = e.target.parentNode;
                }

                $(el).siblings().children('ul').addClass('hidden');

                $(el).addClass('active').children('ul').removeClass('hidden');

                if (!el.id && $(el).hasClass('subtopics')) {
                    el = $(el).find('li[id]').first();
                }

                self.loadItem(el);
            });

            $('#help-iframe').on('load', function () {
                $('.loading', '#help-menu').removeClass('loading');
            });

            key = this.options.key;

            // no key, or does not exist, click first menu item
            if (!key.length || !$('#' + key.join('.')).length) {
                $('#help-menu > li[id]').first().click();
            } else {                
                $('#' + key.join('.')).click();
            }

            $('[data-toggle]').click(function () {
                var n = this;

                $('nav').toggle();

                // resize frame
                self.resizeFrame();
            });
        },

        resizeFrame: function () {
            var self = this,
                s;

            $('#help-frame').parent().css('width', function () {
                if ($("#help-menu-toggle div.toggle-handle").hasClass('collapsed')) {
                    s = $("#help-menu-toggle").outerWidth(true);
                }

                return $('div.row-fluid').width() - self.getMenuSize(s) - 1;
            });
        },

        getMenuSize: function (pos) {
            if (typeof pos == 'undefined') {
                pos = $('#help-menu').parent().outerWidth() + 14;
            }

            return pos;
        },

        loadItem: function (el) {
            var s, n, keys, p, map;

            $(el).addClass('loading');
            var id = $(el).attr('id');

            if (this.options.pattern) {
                keys = id.split('.');
                map = {
                    'section': keys[0] || '',
                    'category': keys[1] || '',
                    'article': keys[2] || ''
                };
                p = this.options.pattern;
                s = p.replace(/\{\$([^\}]+)\}/g, function (a, b) {
                    return map[b] || '';
                });
            } else {
                s = id;
            }

            $('#help-iframe').attr('src', this.options.url + s);
        }
    }

    window.Wf = Wf;

})(jQuery);