<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
defined('_JEXEC') or die;

/**
 * Legacy routing rules class from com_mymaplocations
 *
 * @since       3.6
 * @deprecated  4.0
 */
class mymaplocationsRouterRulesLegacy implements JComponentRouterRulesInterface
{
	/**
	 * Constructor for this legacy router
	 *
	 * @param   JComponentRouterAdvanced  $router  The router this rule belongs to
	 *
	 * @since       3.6
	 * @deprecated  4.0
	 */
	public function __construct($router)
	{
		$this->router = $router;
	}

	/**
	 * Preprocess the route for the com_mymaplocations component
	 *
	 * @param   array  &$query  An array of URL arguments
	 *
	 * @return  void
	 *
	 * @since       3.6
	 * @deprecated  4.0
	 */
	public function preprocess(&$query)
	{
	}

	/**
	 * Build the route for the com_mymaplocations component
	 *
	 * @param   array  &$query     An array of URL arguments
	 * @param   array  &$segments  The URL arguments to use to assemble the subsequent URL.
	 *
	 * @return  void
	 *
	 * @since       3.6
	 * @deprecated  4.0
	 */
	public function build(&$query, &$segments)
	{
		$segments = array();
		$view     = null;
		if (empty($query['Itemid']))
		{
			$menuItem = $this->router->menu->getActive();
			$menuItemGiven = false;
		}
		else
		{
			$menuItem = $this->router->menu->getItem($query['Itemid']);
			$menuItemGiven = true;
		}
		
		if (isset($query['task']))
		{
			$taskParts  = explode('.', $query['task']);
			$segments[] = implode('/', $taskParts);
			$view       = $taskParts[0];
			unset($query['task']);
		}

		if (isset($query['view']))
		{
			if (!$menuItemGiven)
			{
				$segments[] = $query['view'];
			}
			$view = $query['view'];
			unset($query['view']);
		}
	
		if (isset($query['id']))
		{
			if ($view !== null)
			{
				
				if($view=="location")
				{
					$db = JFactory::getDbo();
					$squery = $db->getQuery(true)
						->select('*')
						->from('#__mymaplocations_location')
						->where($db->quoteName('id') . ' = ' . (int) $query['id']);
					$db->setQuery($squery);
					$data = $db->loadObject();
					$segments[] = JApplicationHelper::stringURLSafe($data->alias);					
				}
				else
				{
					$segments[] = $query['id'];
				}
			}
			else
			{
				
				$segments[] = $query['id'];
			}

			unset($query['id']);
		}
		else
		{
			if (isset($query['radius']))
			{
				unset($query['radius']);
			}
					if (isset($query['filter_order']))
			{
				unset($query['filter_order']);
			}
					if (isset($query['searchzip']))
			{
				unset($query['searchzip']);
			}
			
					if (isset($query['limit']))
			{
				unset($query['limit']);
			}
					
		}
		
		return $segments;
	}

	/**
	 * Parse the segments of a URL.
	 *
	 * @param   array  &$segments  The segments of the URL to parse.
	 * @param   array  &$vars      The URL attributes to be used by the application.
	 *
	 * @return  void
	 *
	 * @since       3.6
	 * @deprecated  4.0
	 */
	public function parse(&$segments, &$vars)
	{
		
		$vars = array();
		$item = $this->router->menu->getActive();
		// View is always the first element of the array
		$vars['view'] = array_shift($segments);
		$count=count(	$segments);
		
		if($vars['view']=="location")
		   {
					$db = JFactory::getDbo();
					$query = $db->getQuery(true)
						->select($db->quoteName('id'))
						->from('#__mymaplocations_location')
						->where($db->quoteName('alias') . ' = ' . $db->quote($segments[$count-1]));
					$db->setQuery($query);
					$nid = $db->loadResult();
					$segments[$count-1]=$nid;
		   }
		   else
		   {
					$db = JFactory::getDbo();
					$query = $db->getQuery(true)
						->select($db->quoteName('id'))
						->from('#__mymaplocations_location')
						->where($db->quoteName('alias') . ' = ' . $db->quote($vars['view']));
					$db->setQuery($query);
					$nid = $db->loadResult();
					if($nid)
					{
					$vars['view']="location";;
					$segments[0]=$nid;
					}
		   }
		while (!empty($segments))
		{
			$segment = array_pop($segments);

			// If it's the ID, let's put on the request
			if (is_numeric($segment))
			{
				$vars['id'] = $segment;
			}
			else
			{
				$vars['task'] = $vars['view'] . '.' . $segment;
			}
		}

		return $vars;
	}
}
