<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
defined('_JEXEC') or die;
jimport('joomla.filesystem.file');
$tpath= JPATH_SITE . DIRECTORY_SEPARATOR . "templates" . DIRECTORY_SEPARATOR . JFactory::getApplication()->getTemplate() . DIRECTORY_SEPARATOR . "html" . DIRECTORY_SEPARATOR . "com_mymaplocations" . DIRECTORY_SEPARATOR . "mymaplocations.php";
$current_path = __DIR__ . DIRECTORY_SEPARATOR . 'mymaplocations.php';
if ((JFile::exists($tpath)) && ($tpath != $current_path)) {
    JLoader::register('MyMaplocationsHelper', $tpath);
} else {
    abstract class MyMaplocationsHelper
    {
        
        static $result = 0;
        static $bresult = 0;
        static $mresult = 0;
        static $oresult = 0;
        static $qresult = 0;
        static $bdresult = 0;
        static $language = 0;
        static $s = 0;
        static $loadfield = 0;
        static $itemid = array();
        public static function loadGoogleJs($load = true)
        {
            if (self::$result == 0) {
                $params       = JComponentHelper::getParams('com_mymaplocations');
                $googleapi    = $params->get('googleapi', 'AIzaSyDyJXSfY3iyCQCku7oKqFiZMOV6aFXQxls');
                self::$result = self::$result + 1;
                $doc          = JFactory::getDocument();
                $url          = '//maps.googleapis.com/maps/api/js?libraries=places';
                if ($googleapi) {
                    $url .= '&key=' . $googleapi;
                }
                $url .= MyMaplocationsHelper::addLocalization();
                
                if ($load) {
                    $doc->addScript($url);
                } else {
                    return ' <script src="' . $url . '" type="text/javascript"></script>';
                }
                return;
                
            }
            return '';
        }
        public static function loadBingJs($load = true)
        {
            if (self::$bresult == 0) {
                $doc = JFactory::getDocument();
                 $params       = JComponentHelper::getParams('com_mymaplocations');
                $bingkey      = $params->get('bingapi', 'Asbsa_hzfHl69XF3wxBd_WbW0dLNTRUH3ZHQG9qcV5EFRLuWEaOP1hjWdZ0A0P17');
                $url = 'https://www.bing.com/api/maps/mapcontrol?s=1&key='.$bingkey;
                $url .= str_replace("language", "setLang", MyMaplocationsHelper::addLocalization());
                if ($load) {
                    $doc->addScript($url);
                } else {
                    return '<script src="' . $url . '" type="text/javascript"></script>';
                }
                self::$bresult = self::$bresult + 1;
                return;
                
            }
            return '';
        }
         public static function loadBaiduJs($load = true)
        {
            if (self::$bdresult == 0) {
                $doc = JFactory::getDocument();
                 $params       = JComponentHelper::getParams('com_mymaplocations');
                $baidukey      = $params->get('baiduapi', '');
                $url = 'https://api.map.baidu.com/api?v=2.0&s=1&ak='.$baidukey;
                $script1="https://api.map.baidu.com/library/TextIconOverlay/1.2/src/TextIconOverlay_min.js";
                $script2="https://api.map.baidu.com/library/MarkerClusterer/1.2/src/MarkerClusterer_min.js";
                
                if ($load) {
                    $doc->addScript($url);
                    $doc->addScript($script1);
                    $doc->addScript($script2);
                } else {
                    return '<script src="' . $url . '" type="text/javascript"></script><script src="' . $script1 . '" type="text/javascript"></script><script src="' . $script2 . '" type="text/javascript"></script>';
                }
                self::$bdresult = self::$bdresult + 1;
                return;
                
            }
            return '';
        }
        public static function loadMapboxJs($load = true)
        {
            if (self::$mresult == 0) {
                $doc  = JFactory::getDocument();
                $url  = '//api.tiles.mapbox.com/mapbox-gl-js/v0.35.1/mapbox-gl.js';
                $css  = '//api.tiles.mapbox.com/mapbox-gl-js/v0.35.1/mapbox-gl.css';
                $css3 = '//cdnjs.cloudflare.com/ajax/libs/leaflet.markercluster/1.0.4/MarkerCluster.css';
                $js2  = '//cdnjs.cloudflare.com/ajax/libs/leaflet.markercluster/1.0.4/leaflet.markercluster.js';
                $css2 = '//cdnjs.cloudflare.com/ajax/libs/leaflet.markercluster/1.0.4/MarkerCluster.Default.css';
                $js   = '//unpkg.com/leaflet/dist/leaflet.js';
                $css4 = '//unpkg.com/leaflet/dist/leaflet.css';
                $js3  = JURI::base() . 'components/com_mymaplocations/assets/js/leaflet-mapbox-gl.js';
                $js4  = JURI::base() . "components/com_mymaplocations/assets/js/Leaflet.fullscreen.js";
                $css5 = JURI::base() . "components/com_mymaplocations/assets/css/leaflet.fullscreen.css";
                $js5  = JURI::base() . "components/com_mymaplocations/assets/js/mapillary.min.js";
                $css6 = JURI::base() . "components/com_mymaplocations/assets/js/mapillary.min.css";
                $js6  = '//api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-directions/v3.1.1/mapbox-gl-directions.js';
                $css7 = '//api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-directions/v3.1.1/mapbox-gl-directions.css';
                
                if ($load) {
                    $doc->addScript($url);
                    $doc->addScript($js);
                    $doc->addScript($js2);
                    $doc->addScript($js3);
                    $doc->addScript($js4);
                    $doc->addScript($js5);
                    $doc->addScript($js6);
                    $doc->addStyleSheet($css);
                    $doc->addStyleSheet($css2);
                    $doc->addStyleSheet($css3);
                    $doc->addStyleSheet($css4);
                    $doc->addStyleSheet($css5);
                    $doc->addStyleSheet($css6);
                    $doc->addStyleSheet($css7);
                } else {
                    return '<script src="' . $url . '" type="text/javascript"></script><script src="' . $js . '" type="text/javascript"></script><script src="' . $js2 . '" type="text/javascript"></script><script src="' . $js3 . '" type="text/javascript"></script><script src="' . $js4 . '" type="text/javascript"><script src="' . $js5 . '" type="text/javascript"></script><script src="' . $js6 . '" type="text/javascript"></script><link href="' . $css . '" rel="stylesheet"/><link href="' . $css2 . '" rel="stylesheet"/><link href="' . $css3 . '" rel="stylesheet"/><link href="' . $css4 . '" rel="stylesheet"/><link href="' . $css5 . '" rel="stylesheet"/><link href="' . $css6 . '" rel="stylesheet"/><link href="' . $css7 . '" rel="stylesheet"/>';
                }
                self::$mresult = self::$mresult + 1;
                return;
                
            }
            return '';
        }
        public static function loadLeafletJs($load = true)
        {
            if (self::$oresult == 0) {
                $doc  = JFactory::getDocument();
                $url  = '//unpkg.com/leaflet/dist/leaflet-src.js';
                $css  = '//unpkg.com/leaflet@1.0.3/dist/leaflet.css';
                $css2 = '//unpkg.com/leaflet.markercluster/dist/MarkerCluster.css';
                $js   = '//unpkg.com/leaflet.markercluster/dist/leaflet.markercluster.js';
                $css3 = '//unpkg.com/leaflet.markercluster/dist/MarkerCluster.Default.css';
                $js2  = JURI::base() . "components/com_mymaplocations/assets/js/Leaflet.fullscreen.js";
                $css4 = JURI::base() . "components/com_mymaplocations/assets/css/leaflet.fullscreen.css";
                $js5  = JURI::base() . "components/com_mymaplocations/assets/js/mapillary.min.js";
                $css6 = JURI::base() . "components/com_mymaplocations/assets/js/mapillary.min.css";
                if ($load) {
                    $doc->addScript($url);
                    $doc->addScript($js);
                    $doc->addScript($js2);
                    $doc->addScript($js5);
                    $doc->addStyleSheet($css);
                    $doc->addStyleSheet($css2);
                    $doc->addStyleSheet($css3);
                    $doc->addStyleSheet($css4);
                    $doc->addStyleSheet($css6);
                    
                } else {
                    return '<script src="' . $url . '" type="text/javascript"></script><script src="' . $js . '" type="text/javascript"></script><script src="' . $js2 . '" type="text/javascript"></script><script src="' . $js5 . '" type="text/javascript"></script><link href="' . $css . '" rel="stylesheet"/><link href="' . $css2 . '" rel="stylesheet"/><link href="' . $css3 . '" rel="stylesheet"/><link href="' . $css4 . '" rel="stylesheet"/><link href="' . $css6 . '" rel="stylesheet"/>';
                }
                self::$oresult = self::$oresult + 1;
                return;
                
            }
            return '';
        }
        public static function loadMapQuestJs($load = true)
        {
            if (self::$qresult == 0) {
                $doc  = JFactory::getDocument();
                $url  = '//api.mqcdn.com/sdk/mapquest-js/v1.1.0/mapquest.js';
                $css  = "//api.mqcdn.com/sdk/mapquest-js/v1.1.0/mapquest.css";
                $js1  = "//unpkg.com/leaflet.markercluster/dist/leaflet.markercluster.js";
                $css1 = "//unpkg.com/leaflet.markercluster/dist/MarkerCluster.css";
                $css2 = "//unpkg.com/leaflet.markercluster/dist/MarkerCluster.Default.css";
                $js5  = JURI::base() . "components/com_mymaplocations/assets/js/mapillary.min.js";
                $css6 = JURI::base() . "components/com_mymaplocations/assets/js/mapillary.min.css";
                if ($load) {
                    $doc->addScript($url);
                    $doc->addScript($js1);
                    $doc->addScript($js5);
                    $doc->addStyleSheet($css);
                    $doc->addStyleSheet($css1);
                    $doc->addStyleSheet($css2);
                    $doc->addStyleSheet($css6);
                    
                } else {
                    return '<script src="' . $url . '" type="text/javascript"><script src="' . $js1 . '" type="text/javascript"></script><script src="' . $js5 . '" type="text/javascript"></script><link href="' . $css . '" rel="stylesheet"/><link href="' . $css1 . '" rel="stylesheet"/><link href="' . $css2 . '" rel="stylesheet"/><link href="' . $css6 . '" rel="stylesheet"/>';
                }
                self::$qresult = self::$qresult + 1;
                return;
                
            }
            return '';
        }
        
        
        public static function CreateJson($items, $search = null, $component = null, $pagination = null, $latitude = 0, $longitude = 0)
        {
            
            $geojson = array(
                'type' => 'FeatureCollection',
                'features' => array(),
                'pagination' => $pagination
            );
            
            if (count($items) == 0) {
                return json_encode($geojson, JSON_NUMERIC_CHECK);
            } else if ($items == false) {
                return json_encode($geojson, JSON_NUMERIC_CHECK);
            }
            $doc = JFactory::getDocument();
            MyMaplocationsHelper::loadLanguage();
            $params       = JComponentHelper::getParams('com_mymaplocations');
            $globalcolor  = $params->get('globalcolor', '#2980b9');
            $markercolor  = $params->get('markercolor', '#FFFFFF');
            $hidedistance = $params->get('hidedistance', 1);
            $filter_you   = $params->get('filter_you', 1);
            
            $iconimage     = $params->get('iconimage', null);
            $sidebarrating = $params->get('sidebarrating', true);
            $wordcount     = $params->get('wordcount', 30);
            $contactmymap  = $params->get('contact_button', true);
            $target        = $params->get('target', 1);
            $address       = null;
            $rating        = "";
            $q             = 0;
            $sidebar       = "";
            $fulladdress   = "";
            $content       = "";
            $distance_type = $params->get('distance_type', 1);
            if ($component == null) {
                $component = $items[0]->component;
            }
            
            if ($search) {
                $zip = MyMaplocationsHelper::getLatLongFromPostcode($search, $latitude, $longitude);
                
            }
            if ($component == "com_comprofiler") {
                global $_CB_framework, $ueConfig, $mainframe;
                if (defined('JPATH_ADMINISTRATOR')) {
                    if (!file_exists(JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php')) {
                        echo 'CB not installed!';
                        return;
                    }
                    include_once(JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php');
                } else {
                    if (!file_exists($mainframe->getCfg('absolute_path') . '/administrator/components/com_comprofiler/plugin.foundation.php')) {
                        echo 'CB not installed!';
                        return;
                    }
                    include_once($mainframe->getCfg('absolute_path') . '/administrator/components/com_comprofiler/plugin.foundation.php');
                }
                $mmlfield = MyMaplocationsHelper::getCbField();
            } else if ($component == "com_community") {
                include_once(JPATH_BASE . '/components/com_community/defines.community.php');
                require_once(JPATH_BASE . '/components/com_community/libraries/core.php');
                include_once JPATH_ROOT . '/components/com_community/libraries/messaging.php';
            } else if ($component == "com_easyblog") {
                require_once JPATH_ADMINISTRATOR . '/components/com_easyblog/includes/easyblog.php';
                $posts = EB::formatter('list', $items);
                $l     = 0;
                foreach ($items as $item) {
                    
                    $items[$l]->logo = $posts[$l]->image;
                    $items[$l]->icon = null;
                    $items[$l]->url  = str_replace("?format=json", "", $posts[$l]->permalink);
                    $l++;
                }
                
            } else if ($component == "com_djclassifieds") {
                
                require_once(JPATH_BASE . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_djclassifieds' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'djcategory.php');
                require_once(JPATH_BASE . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_djclassifieds' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'djseo.php');
                require_once(JPATH_BASE . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_djclassifieds' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'djtheme.php');
                require_once(JPATH_BASE . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_djclassifieds' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'djregion.php');
                require_once(JPATH_BASE . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_djclassifieds' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . 'djimage.php');
                require_once(JPATH_BASE . '/administrator/components/com_djclassifieds/lib/djseo.php');
            }
            else if($component=="com_virtuemart")
            {
                    if (!class_exists( 'VmConfig' )) require(JPATH_ROOT .'/administrator/components/com_virtuemart/helpers/config.php');
                    VmConfig::loadConfig();
                    if(!class_exists('CurrencyDisplay')) require(JPATH_ROOT .'/administrator/components/com_virtuemart/helpers/currencydisplay.php');
                    $product_model = VmModel::getModel('product');
                    vmJsApi::jPrice();
                    $currency = CurrencyDisplay::getInstance( );

            }
            else if ($component == "com_adsmanager") {
                require_once(JPATH_ROOT . "/components/com_adsmanager/lib/core.php");
            }
            if (empty($width)) {
                $width = MyMaplocationsHelper::formatField(JFactory::getApplication()->input->getString('viewwidth', ($params->get('viewwidth', '60%'))));
            } else {
                $width = MyMaplocationsHelper::formatField($width);
            }
            if (empty($height)) {
                $height = MyMaplocationsHelper::formatField(JFactory::getApplication()->input->getString('viewheight', ($params->get('viewheight', 400))));
            } else {
                $height = MyMaplocationsHelper::formatField($height);
            }
            $markeropen = $params->get('markeropen', 'click');
            if ($component == 'com_hikamarket') {
                require_once JPATH_ADMINISTRATOR . '/components/com_hikashop/helpers/helper.php';
                $config      = @hikashop::config();
                $vendor_menu = MyMaplocationsHelper::getMenuId('com_hikashop');
                $urlparam    = "";
                if ($vendor_menu['com_hikashop']) {
                    $urlparam = '&Itemid=' . $vendor_menu['com_hikashop'];
                }
                
            }
            if (($filter_you) && ($search)) {
                
                $youimage = $params->get('youimage', null);
                if($youimage)
                {
                    $youimage=JURI::base().$youimage;
                }
                else
                {
                    $youimage="data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2238%22%20height%3D%2238%22%20viewBox%3D%220%200%2038%2038%22%3E%3Cpath%20fill%3D%22%23" . str_replace("#", "", $globalcolor) . "%22%20stroke%3D%22%23ccc%22%20stroke-width%3D%22.5%22%20d%3D%22M34.305%2016.234c0%208.83-15.148%2019.158-15.148%2019.158S3.507%2025.065%203.507%2016.1c0-8.505%206.894-14.304%2015.4-14.304%208.504%200%2015.398%205.933%2015.398%2014.438z%22%2F%3E%3Ctext%20transform%3D%22translate%2819%2018.5%29%22%20fill%3D%22%23" . str_replace("#", "", $markercolor) . "%22%20style%3D%22font-family%3A%20Arial%2C%20sans-serif%3Bfont-weight%3Abold%3Btext-align%3Acenter%3B%22%20font-size%3D%2212%22%20text-anchor%3D%22middle%22%3E" . JTEXT::_('COM_MYMAPLOCATIONS_YOU') . "%3C%2Ftext%3E%3C%2Fsvg%3E";
                }
                $feature  = array(
                    'id' => 0,
                    'type' => 'Feature',
                    'geometry' => array(
                        'type' => 'Point',
                        # Pass Longitude and Latitude Columns here
                        'coordinates' => array(
                            $zip['lang'],
                            $zip['lat']
                        )
                    ),
                    # Pass other attribute columns here
                    'properties' => array(
                        'name' => MyMaplocationsHelper::formatJS($search),
                        'url' => '',
                        'description' => '<span class="location-title">' . MyMaplocationsHelper::formatJS($search) . '</span>',
                        'rating' => '',
                        'fulladdress' => '',
                        'content' => '',
                        'icon' => $youimage,
                        'itemid' => 0
                    )
                );
                array_push($geojson['features'], $feature);
            }
            foreach ($items as $item) {
                if (($item->latitude == 0) && ($item->longitude == 0)) {
                    continue;
                }
                if (($item->latitude == 255) && ($item->longitude == 255)) {
                    continue;
                }
                $address = "";
                
                $data = array();
                
                if (@$item->logo) {
                    if ((strpos($item->logo, "http")) !== false) {
                        
                    } else if ((substr($item->logo, 0, 2)) == "//") {
                        
                    } else {
                        $item->logo = JURI::base(true) . '/' . $item->logo;
                        
                    }
                }
                
                if ($component == "com_community") {
                    
                    $item->logo = MyMaplocationsHelper::getCommunityLogo($item->id);
                    $cuser      = CFactory::getUser($item->id);
                    if (@$item->address) {
                        
                    } else {
                        
                        
                        $item->address = MyMaplocationsHelper::getCommunityAddress($item->id);
                        
                        
                    }
                    $showjoomsocialicon = $params->get('showjoomsocialicon', 1);
                    if ($showjoomsocialicon) {
                        $item->icon = str_replace(JURI::base(), "", $item->logo);
                    }
                }
                else if($component == "com_virtuemart") {
                    
                    $product = $product_model->getProduct($item->extra_id,TRUE,TRUE,TRUE,1);
                    $product_model->addImages($product);
                    $item->name=$product->product_name;
                    $image = $product->images[0];
                    $item->logo=$image->file_url;
                    if(isset($product->prices)) {
                        if(!empty($product->prices['salesPrice'])) {
                                $price=  $currency->createPriceDiv( 'salesPrice', '', $product->prices, true );
						
                        }
                        }
                }
                else if ($component == "com_comprofiler") {
                    if (!empty($mmlfield)) {
                        $item->address = MyMaplocationsHelper::getCbAddress($item, $mmlfield);
                    }
                    $cbUser     = CBuser::getInstance((int) $item->extra_id);
                    $item->logo = $cbUser->getField('avatar', null, 'csv', 'none', 'icon');
                    $item->name = MyMaplocationsHelper::getNameFormatOnline($cbUser);
                    $showcbicon = $params->get('showcbicon', 1);
                    if ($showcbicon) {
                        $item->icon = str_replace(JURI::base(), "", $item->logo);
                    }
                } else if ($component == "com_mytestimonials") {
                    
                    $item->address = "<br/>" . $item->username;
                    if ($item->position) {
                        $item->address .= "<br/>" . $item->position;
                    }
                    if ($item->company) {
                        $item->address .= "," . $item->company;
                    }
                } else if ($component == "com_hikamarket") {
                    $uploadFolder   = ltrim(JPath::clean(html_entity_decode($config->get('uploadfolder'))), DIRECTORY_SEPARATOR);
                    $uploadFolder   = rtrim($uploadFolder, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;
                    $hikaiconheight = (int) $config->get('thumbnail_y');
                    $hikaiconwidth  = (int) $config->get('thumbnail_x');
                    $currencyClass  = hikashop_get('class.currency');
                    $hika_image     = hikashop_get('helper.image');
                    $f_image        = $hika_image->display($item->icon, false, $item->icon, '', '', $hikaiconwidth, $hikaiconheight);
                    preg_match_all("/<img .*?(?=src)src=\"([^\"]+)\"/si", $f_image, $m);
                    $item->logo   = str_replace(JURI::base(), '', $m[1][0]);
                    $showhikaicon = $params->get('showhikaicon', 1);
                    if ($showhikaicon) {
                        $item->icon = str_replace(JURI::base(), "", $item->logo);
                    } else {
                        $item->icon = null;
                    }
                    $price             = MyMaplocationsHelper::getHikaprice($item->product_id, $item->tax_id);
                    $item->contactlink = hikashop_completeLink('product&task=contact&cid=' . $item->product_id . '&tmpl=component');
                } else if ($component == "com_easysocial") {
                    $user       = Foundry::user($item->id);
                    $item->logo=$user->getAvatar(SOCIAL_AVATAR_SQUARE);
                    $item->icon=str_replace(JURI::base(),"",$user->getAvatar(SOCIAL_AVATAR_MEDIUM));         
                    $item->url     = $user->getPermalink();
                    $key           = "address";
                    $item->address = $user->getFieldValue($key);
                } else if ($component == "com_hikashop") {
                    
                    require_once JPATH_ADMINISTRATOR . '/components/com_hikashop/helpers/helper.php';
                    $config          = @hikashop::config();
                    $uploadFolder    = ltrim(JPath::clean(html_entity_decode($config->get('uploadfolder'))), DIRECTORY_SEPARATOR);
                    $uploadFolder    = rtrim($uploadFolder, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;
                    $hikaiconheight  = (int) $config->get('thumbnail_y');
                    $hikaiconwidth   = (int) $config->get('thumbnail_x');
                    $hika_image      = hikashop_get('helper.image');
                    $item->component = "com_hikashop";
                    $f_image         = $hika_image->display($item->icon, false, $item->icon, '', '', $hikaiconwidth, $hikaiconheight);
                    preg_match_all("/<img .*?(?=src)src=\"([^\"]+)\"/si", $f_image, $m);
                    $item->logo   = str_replace(JURI::base(), '', $m[1][0]);
                    $showhikaicon = $params->get('showhikaicon', 1);
                    if ($showhikaicon) {
                        $item->icon = str_replace(JURI::base(), "", $item->logo);
                    }else
                    {
                        $item->icon = null;
                    }
                    
                } else if ($component == "com_ohanah") {
                    $item->contactlink = "";
                    $item->icon        = null;
                    $item->address     = JHTML::_('date', $item->start, 'd M Y - H:i') . "  " . JHTML::_('date', $item->end, 'd M Y - H:i') . "<br/>" . $item->address;
                } else if ($component == "com_eventbooking") {
                    $item->contactlink = "";
                    $item->address     = JHTML::_('date', $item->start, 'd M Y - H:i') . "  " . JHTML::_('date', $item->end, 'd M Y - H:i') . "<br/>" . $item->address;
                    if ($item->thumb) {
                        $item->logo = JURI::root(true). '/media/com_eventbooking/images/' . $item->thumb;
                    } else {
                        $item->logo = null;
                    }
                    $item->icon = null;
                    
                } else if ($component == "com_k2") {
                    $showk2icon = $params->get('showk2icon', 1);
                    if ($item->logo) {
                    } else if (JFile::exists(JPATH_SITE . '/media/k2/items/cache/' . md5("Image" . $item->extra_id) . '_S.jpg')) {
                        $item->logo = JURI::root(true) . '/media/k2/items/cache/' . md5("Image" . $item->extra_id) . '_S.jpg';
                        
                    } else {
                        $item->logo = null;
                    }
                    if ($item->icon) {
                    } else if (($showk2icon) && (JFile::exists(JPATH_SITE . '/media/k2/items/cache/' . md5("Image" . $item->extra_id) . '_XS.jpg'))) {
                        $item->icon = JURI::root(true) . '/media/k2/items/cache/' . md5("Image" . $item->extra_id) . '_XS.jpg';
                    } else {
                        $item->icon = null;
                        
                    }
                } else if (($component == "com_mymaplocations") || ($component == "")) {
                    if ((@$item->use_category_image) && (@$item->catparams)) {
                        $catdata = json_decode($item->catparams);
                        if (@$catdata->icon) {
                            $item->icon = $catdata->icon;
                        }
                    }
                } else if ($component == "com_adsmanager") {
                    $item->component = "com_adsmanager";
                    if ((count($item->images) > 0)) {
                        
                        $img = json_decode($item->images);
                        if (@$img[0]->thumbnail) {
                            $item->logo = JURI_IMAGES_FOLDER . "/" . $img[0]->thumbnail;
                        } else {
                            $item->logo = ADSMANAGER_NOPIC_IMG;
                        }
                    } else {
                        $item->logo = null;
                    }
                    $item->icon = str_replace(JURI::base(), "", $item->logo);
                    
                } else if ($component == "com_djclassifieds") {
                    $item->component = "com_djclassifieds";
                    $item->icon      = null;
                    $item->images    = DJClassifiedsImage::getAdsImages($item->id);
                    if ((count($item->images) > 0)) {
                        if (@$item->images[0]->thumb_m) {
                            $item->logo = JURI::base(true) . $item->images[0]->thumb_m;
                        }
                        if (@$item->images[0]->thumb_s) {
                            $item->icon = JURI::base(true) . $item->images[0]->thumb_s;
                        }
                        
                    } else {
                        $item->logo = null;
                        $item->icon = null;
                    }
                    
                } else if ($component == "com_jomclassifieds") {
                    $item->component = "com_jomclassifieds";
                    if ($item->images != '') {
                        $image      = explode(',', $item->images);
                        $imgCount   = count($image);
                        $item->logo = JomclUtils::getImage($image[0], '_grid');
                    } else {
                        $item->logo = null;
                    }
                    $item->icon = str_replace(JURI::base(), "", $item->logo);
                    
                }
                $rating = "";
                if (($component == "com_mymaplocations") && ($sidebarrating)) {
                    $itemAPI = JPATH_SITE . '/components/com_itemrating/helpers/itemrating.php';
                    if (is_file($itemAPI)) {
                        require_once $itemAPI;
                        $catallow = ItemratingHelper::allowCategory($item->catid, "com_mymaplocations");
                        if ($catallow) {
                            $itemgroup           = $catallow->id;
                            $qitem               = new stdClass();
                            $qitem->id           = $item->id;
                            $qitem->introtext    = '';
                            $qitem->title        = $item->name;
                            $qitem->author       = JFactory::getUser($item->created_by)->name;
                            $qitem->created      = new JDate('now');
                            $qitem->modified     = new JDate('now');
                            $qitem->voteallowed  = 0;
                            $qitem->categoryview = 1;
                            $qitem->attribs      = json_encode(array(
                                "groupdata" => $itemgroup,
                                '',
                                ''
                            ));
                            $chtml               = ItemratingHelper::loadWidget($qitem, "top");
                            if (!$chtml) {
                                $chtml = ItemratingHelper::loadWidget($qitem, "bottom");
                            }
                            $rating = $chtml;
                        }
                    }
                } else if (($sidebarrating) && (($component == "com_k2") || ($component == "com_content"))) {
                    if (@$item->rating_sum) {
                        $rating = '<span itemtype="http://schema.org/AggregateRating" itemscope="" itemprop="aggregateRating"> <span itemprop="ratingValue" style="display:none;">' . $item->rating_sum . '</span> <span class="star-rating-wrap"><span class="star-rating-size" style="width:' . (number_format(intval($item->rating_sum) / intval($item->rating_count), 2) * 20) . '%;"></span></span></span>';
                    }
                } else if (($sidebarrating) && (($component == "com_mytestimonials"))) {
                    $rating = '<span itemtype="http://schema.org/AggregateRating" itemscope="" itemprop="aggregateRating"> <span itemprop="ratingValue" style="display:none;">' . $item->rating . '</span> <span class="star-rating-wrap"><span class="star-rating-size" style="width:' . (number_format(intval($item->rating)) * 20) . '%;"></span></span></span>';
                }
                $address     = "";
                $fulladdress = "";
                $content     = "";
                if (isset($item->description) && ($item->description != null)) {
                    $content = "<p>" . implode(' ', array_slice(explode(' ', strip_tags($item->description)), 0, $wordcount)) . "...</p>";
                }
                $item->component = $component;
                $item->link      = MyMaplocationsHelper::getUrlLink($item);
                $title           = '<span class="location-title"><a href="' . $item->link . '">' . $item->name . '</a></span>';
                $address .= $title;
                if (($sidebarrating) && ($rating != "")) {
                    $address .= $rating . "<br/>";
                }
                if ($item->component == "com_community") {
                    
                    $cbadge = new CBadge($cuser);
                    $cbadge = $cbadge->getBadge();
                    $address .= "<img src='" . $cbadge->current->image . "' alt='badge'>";
                }
                $address .= "<span class='myaddress'>";
                if (!empty($item->logo)) {
                    
                    $logo = '<a href="' . $item->link . '"><img src="' . $item->logo . '"  class="mymap-icon" alt="'.$item->name.'"/></a>';
                    $address .= $logo;
                }
                if ($component == "com_hikamarket") {
                    $fulladdress .= $price . '<br/><a href="' . JRoute::_('index.php?option=com_hikamarket&ctrl=vendor&task=show&cid=' . $item->extra_id . '&name=' . $item->vendor_alias . $urlparam) . '">' . $item->vendor_name . '</a><br/>';
                    
                }
                else if ($component == "com_virtuemart") {
                    $fulladdress .= $price . '<br/>';
                    if(@$product->virtuemart_manufacturer_id[0])
                    {
                        $fulladdress .='<a href="' . JRoute::_('index.php?option=com_virtuemart&view=manufacturer&layout=details&virtuemart_manufacturer_id='.$product->virtuemart_manufacturer_id[0]) . '">' . $product->mf_name . '</a><br/>';
                    }
                }
                else if ($component == "com_adsmanager") {
                    
                    $price = sprintf(JText::_('ADSMANAGER_CURRENCY'), number_format(floatval($item->ad_price), 2, '.', ' '));
                    $fulladdress .= '<br/>' . $price . '<br/><a href="' . TLink::getUserAdsLink($item->userid) . '">' . $item->vendor_name . '</a><br/>';
                } else if ($component == "com_djclassifieds") {
                    
                    $price    = DJClassifiedsTheme::priceFormat($item->price, $item->currency);
                    $uid_slug = $item->user_id . ':' . DJClassifiedsSEO::getAliasName($item->username);
                    $fulladdress .= $price . '<br/><a class="profile_name" href="' . JRoute::_('index.php?option=com_djclassifieds&view=profile&uid=' . $uid_slug . DJClassifiedsSEO::getUserProfileItemid()) . '">' . $item->username . '</a>';
                }
                
                $data[] = MyMaplocationsHelper::formatAddress($item);
                $fulladdress .= "<span class='locationaddress'>" . str_replace('<br/>,', '<br>', implode(",", $data)) . '</span><br/>';
                
                
                $address .= $fulladdress;
                $address .= "</span>";
                if ($component == "com_community") {
                    $onclick = CMessaging::getPopup($item->id);
                    $address .= '<br/><a onclick="joms.api.friendAdd(&quot;' . $item->id . '&quot;)" href="javascript:void(0)" class="resultmymap mymap mymap-inverse">' . JTEXT::_('COM_MYMAPLOCATIONS_ADD') . '</a><a onclick="' . $onclick . '" href="#" class="resultmymap mymap mymap-inverse">' . JTEXT::_('COM_MYMAPLOCATIONS_MESSAGE') . '</a>';
                } else if ($component == "com_comprofiler") {
                    $address .= '<br/><a  href="' . JRoute::_('index.php?option=com_comprofiler&act=connections&task=addConnection&connectionid=' . $item->extra_id) . '" class="resultmymap mymap mymap-inverse">' . JTEXT::_('COM_MYMAPLOCATIONS_ADD') . '</a>';
                    $address .= '<br/><a  href="' . JRoute::_('index.php?option=com_comprofiler&task=emailUser&uid=' . $item->extra_id) . '" class="resultmymap mymap mymap-inverse">' . JTEXT::_('COM_MYMAPLOCATIONS_MESSAGE') . '</a>';
                }
                $address .= "<span class='detailsicon'></span><a href='" . $item->link . "' class='mymap mymap-inverse resultmymap'>" . JText::_('COM_MYMAPLOCATIONS_BYVIEW') . "</a>";
                if (($contactmymap == 1)) {
                    if (@$item->contactlink) {
                        $address .= MyMaplocationsHelper::createContactLink($item->contactlink, $target);
                    }
                }
                if ($search) {
                    if ($filter_you) {
                        $fulladdress .= "<span class='mytool'><span class='routeicon'></span><a href='javascript:void(0)' onClick='getUIDirection_side(" . ($q + 1) . ",\"" . $zip['lat'] . "," . $zip['lang'] . "\")' class='mymap mymap-inverse resultmymap route'>" . JText::_('COM_MYMAPLOCATIONS_MAPLOCATION') . "</a>";
                    } else {
                        $fulladdress .= "<span class='mytool'><span class='routeicon'></span><a href='javascript:void(0)' onClick='getUIDirection_side(" . $q . ",\"" . $zip['lat'] . "," . $zip['lang'] . "\")' class='mymap mymap-inverse resultmymap route'>" . JText::_('COM_MYMAPLOCATIONS_MAPLOCATION') . "</a>";
                    }
                    $fulladdress .= "<span class='detailsicon'></span><a href='" . $item->link . "' class='mymap mymap-inverse resultmymap'>" . JText::_('COM_MYMAPLOCATIONS_BYVIEW') . "</a>";
                    if (($contactmymap == 1)) {
                        if (@$item->contactlink) {
                            $fulladdress .= MyMaplocationsHelper::createContactLink($item->contactlink, $target);
                        }
                    }
                    $fulladdress .= "</span>";
                }
                $iconurl = JURI::root(true);
                if (strpos($iconurl, 'http') === 0) {
                } else {
                    $iconurl = rtrim( JURI::base(), '/');
                }
                if ($item->icon != null) {
                    
                    if (JURI::base(true) != DIRECTORY_SEPARATOR) {
                        $item->icon = $iconurl . '/' . str_replace(JURI::base(true), "", $item->icon);
                    } else {
                        $item->icon = $iconurl . '/' . $item->icon;
                        
                    }
                } else if ($iconimage) {
                    $item->icon = $iconurl . '/' . $iconimage;
                } else {
                    if ($items[0]->id == 0) {
                        $countvar = $q;
                    } else {
                        $countvar = $q + 1;
                    }
                    if($item->markercolor)
                    {
                        $globalcolor=$item->markercolor;
                    }
                    else
                    {
                         $globalcolor  = $params->get('globalcolor', '#2980b9');
                    }
                    $item->icon = "data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2238%22%20height%3D%2238%22%20viewBox%3D%220%200%2038%2038%22%3E%3Cpath%20fill%3D%22%23" . str_replace("#", "", $globalcolor) . "%22%20stroke%3D%22%23ccc%22%20stroke-width%3D%22.5%22%20d%3D%22M34.305%2016.234c0%208.83-15.148%2019.158-15.148%2019.158S3.507%2025.065%203.507%2016.1c0-8.505%206.894-14.304%2015.4-14.304%208.504%200%2015.398%205.933%2015.398%2014.438z%22%2F%3E%3Ctext%20transform%3D%22translate%2819%2018.5%29%22%20fill%3D%22%23" . str_replace("#", "", $markercolor) . "%22%20style%3D%22font-family%3A%20Arial%2C%20sans-serif%3Bfont-weight%3Abold%3Btext-align%3Acenter%3B%22%20font-size%3D%2212%22%20text-anchor%3D%22middle%22%3E" . $countvar . "%3C%2Ftext%3E%3C%2Fsvg%3E";
                }
                $featured = 0;
                if ($component == "com_mymaplocations") {
                    $featured = $item->featured;
                }
                $q++;
                
                
                
                $feature = array(
                    'id' => $item->id,
                    'type' => 'Feature',
                    'geometry' => array(
                        'type' => 'Point',
                        # Pass Longitude and Latitude Columns here
                        'coordinates' => array(
                            $item->longitude,
                            $item->latitude
                        )
                    ),
                    # Pass other attribute columns here
                    'properties' => array(
                        'name' => MyMaplocationsHelper::formatJS($item->name),
                        'url' => MyMaplocationsHelper::formatJS($item->link),
                        'description' => $address,
                        'rating' => $rating,
                        'fulladdress' => $fulladdress,
                        'content' => $content,
                        'icon' => $item->icon,
                        'itemid' => $item->id,
                        'featured' => $featured
                    )
                );
                if (@$item->distance) {
                    if ($distance_type == 1) {
                        $feature['properties']['distance'] = number_format($item->distance, 1) . " " . JText::_('COM_MYMAPLOCATIONS_MILES');
                    } else {
                        $feature['properties']['distance'] = number_format($item->distance, 1) . " " . JText::_('COM_MYMAPLOCATIONS_KM');
                    }
                }
                array_push($geojson['features'], $feature);
                
            }
            
            return json_encode($geojson, JSON_NUMERIC_CHECK);
        }
        
        
        public static function CreateMap($items, $width = null, $height = null, $zoom = null, $type = null, $load = true, $ajax = false, $layout = null, $searchdata = null, $component = null, $latitude = 0, $longitude = 0)
        {
            MyMaplocationsHelper::loadLanguage();
            $doc       = JFactory::getDocument();
            $params    = JComponentHelper::getParams('com_mymaplocations');
            $googleapi = $params->get('googleapi', 'AIzaSyDyJXSfY3iyCQCku7oKqFiZMOV6aFXQxls');
            $jq_lib    = $params->get('jquery', 1);
            $key       = "";
            if ($googleapi) {
                $key = '&key=' . $googleapi;
            }
            if (empty($zoom)) {
                $zoom = JFactory::getApplication()->input->getString('viewzoom', ($params->get('viewzoom', 9)));
            }
            $autozoom     = $params->get('autozoom', 1);
            $bingkey      = $params->get('bingapi', 'Asbsa_hzfHl69XF3wxBd_WbW0dLNTRUH3ZHQG9qcV5EFRLuWEaOP1hjWdZ0A0P17');
            $mapboxapi    = $params->get('mapboxapi', 'pk.eyJ1IjoiZ3VhbmlvcmFtb24iLCJhIjoiY2lub252NW84MTAxb3VnbHlpODZxdGxzbiJ9.7oZ99Xw7h-jfJ-_W7LGKCg');
            $mapquestapi  = $params->get('mapquestapi', 'vhWpimBUAVMWALPN9RshljuRO8dpGc8S');
            $mapillaryapi = $params->get('mabillaryapi', 'SGwyX2ExbmVoY1M0QzF0dGRCUHFVUTplMDliODU2MDkzYWQ4YWNl');
            
            $bootstrap    = $params->get('bootstrap', 0);
            $route_format = $params->get('route_format', 0);
            $globalcolor  = $params->get('globalcolor', '#2980b9');
            $markercolor  = $params->get('markercolor', '#000000');
            $init_mode    = $params->get('init_mode', 1);
            $hidedistance = $params->get('hidedistance', 0);
            $filter_you   = $params->get('filter_you', 1);
            $iconimage    = $params->get('iconimage', null);
            $mapboxstyle  = $params->get('mapboxstyle', 'mapbox.streets');
            $enable_route= $params->get('enable_route',1);
            $layer        = "";
            if ($mapboxstyle == 'mapbox.streets') {
                $mapboxstyle = "mapbox://styles/mapbox/streets-v9";
            }
            if ($bootstrap == 1) {
                $doc->addStyleSheet(JURI::base() . '/media/jui/css/bootstrap.min.css');
            }
            $latlng      = $items[0]->latitude . "," . $items[0]->longitude;
            $map         = JFactory::getApplication()->input->getString('map', $params->get('map', 0));
            $str         = null;
            $result      = "";
            $finalscript = "";
            $finalstyle  = "";
            $address     = null;
            
            $cluster     = $params->get('cluster', 1);
            $loc         = null;
            $q           = 0;
            $v           = rand();
            $s           = $v;
            $launch      = "";
            $result      = "";
            $finalscript = "";
            $sidebar     = "";
            $contentdata = "";
            if ($jq_lib == 1) {
                if ($layout != null) {
                    JHtml::_('jquery.framework');
                    $doc->addScript('components/com_mymaplocations/assets/js/jquery.mCustomScrollbar.concat.min.js');
                    $doc->addStyleSheet('components/com_mymaplocations/assets/css/jquery.mCustomScrollbar.css');
                    $sidebar = "jQuery('#locationresult').css('overflow','hidden');
            jQuery('#locationresult').mCustomScrollbar({theme:'dark',scrollButtons:{enable:true}});";
                    
                    if (($layout == "bottom") || ($layout == "bootstrap")) {
                        
                        $doc->addScript('components/com_mymaplocations/assets/js/masonry.pkgd.js');
                        $sidebar .= "var columns= 3,
				setColumns = function() {
				columns = jQuery('.resultbar' ).width() > 980 ? 3 : jQuery( window ).width() > 768 ? 2 : 1; };
				setColumns();
				 jQuery( window ).resize( setColumns );
				jQuery( '.resultbar' ).masonry( { itemSelector: '.row0,.row1' } );
            ";
                        
                        
                        $contentdata = "
                if(geodatas.features[i].properties.content)
                {
                    html=html+geodatas.features[i].properties.content;
                }
                 ";
                    }
                    
                }
            }
            if ($filter_you) {
                $sidebar .= " launchInfoWindow_" . $s . "(0); ";
            }
            $item = $items[0];
            if (empty($width)) {
                $width = MyMaplocationsHelper::formatField(JFactory::getApplication()->input->getString('viewwidth', ($params->get('viewwidth', '60%'))));
            } else {
                $width = MyMaplocationsHelper::formatField($width);
            }
            if (empty($height)) {
                $height = MyMaplocationsHelper::formatField(JFactory::getApplication()->input->getString('viewheight', ($params->get('viewheight', 400))));
            } else {
                $height = MyMaplocationsHelper::formatField($height);
            }
            if (($type)) {
                if (($type == "bing") || ($type == 1)) {
                    
                    $map = 1;
                } else if (($type == "mapbox") || ($type == 2)) {
                    
                    $map = 2;
                } else if (($type == "openstreetmap") || ($type == 3)) {
                    $map = 3;
                } else if (($type == "mapquest") || ($type == 4)) {
                    $map = 4;
                } else if(($type=="baidu")||($type==5)){
                    $map = 5;
                }
                else {
                    
                    $map = 0;
                }
            }
            if (empty($items[0]->google_maptype)) {
                $items[0]->google_maptype = $params->get('google_maptype', 'ROADMAP');
            }
            if (empty($items[0]->bing_maptype)) {
                $items[0]->bing_maptype = $params->get('bing_maptype', 'road');
            }
            
            if (empty($items[0]->map_design)) {
                $map_design = $params->get('map_design', 1);
            } else {
                $map_design = $items[0]->map_design;
            }
            if (empty($items[0]->openmapstyle)) {
                $items[0]->openmapstyle = $params->get('openmapstyle', 1);
            }
            $markeropen = $params->get('markeropen', 'click');
            
            if ($map == 0) {
                
                if ($params->get('distance_type', 1) == 1) {
                    $dist = 'unitSystem: google.maps.UnitSystem.IMPERIAL';
                } else {
                    $dist = 'unitSystem: google.maps.UnitSystem.METRIC';
                }
                
                
                $script1 = "";
                $script2 = "";
                $script3 = "";
                $script4 = "";
                $script5 = "";
                if ($cluster == 1) {
                    $script1 = '<script type="text/javascript" src="' . JURI::base() . 'components/com_mymaplocations/assets/js/markerclusterer.js"></script>';
                    $script2 .= "gmarkers.push(marker" . $s . ");";
                    $script3 = "var mcOptions = {gridSize: 50, maxZoom: 14,imagePath: '" . JURI::base() . "components/com_mymaplocations/assets/images/m'};
                    var markerCluster = new MarkerClusterer(map" . $s . ",gmarkers,mcOptions);";
                }
                if ($autozoom == 1) {
                    $script4 = "
                    var count=countMarker(promise" . $s . ");
                    if(count!=1)
                    {
                        map" . $s . ".fitBounds(bounds" . $s . ");
                    }
                    ";
                    
                }
                if ($map_design != 1) {
                    $script5 = "styles:" . MyMaplocationsHelper::getMapDesign($map_design);
                    
                }
                $finalstyle .= ".map_canvas img, #map img
            {
        max-width: none !important;
            }
            
            .map_canvas .mymap-icon
            {
                 max-width:100px;
    max-height: 100px;
    display: inline-block;
    height: auto;
    transition: all 0.2s ease-in-out 0s;
     float:left;
      margin: 0px 10px 0px 0px;
            }
    .mml_logo
    {
         max-width:100px;
        max-height: 100px;
        display: inline-block;
        height: auto;
        transition: all 0.2s ease-in-out 0s;
        float:left;
        margin: 0px 2px;
    }
    
    ";
                
                $setDiv = "";
                if ($jq_lib == 1) {
                    $setDiv = "jQuery('#locationresult').mCustomScrollbar('scrollTo',scrollheight);";
                }
                
                $result .= MyMaplocationsHelper::loadGoogleJs($load) . $script1;
                $street    = "";
                $srcollmap = "";
                if ($params->get('mapscroll', 1) == 0) {
                    $srcollmap .= "scrollwheel: false,";
                }
                if ($params->get('mapsdrag', 1) == 0) {
                    $srcollmap .= "draggable: false,";
                }
                $street="";
                if ($params->get('street', 1) == 1) {
                    $street = "<span class=\"detailsicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-inverse route_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_TOGGLE") . "\" onclick=\"toggleStreetView" . $s . "('+i+');\"></input>";
                }
                if($enable_route==1)
                {
                    $street.="<br/><input type=\"text\" class=\"input-small routetext\" name=\"distance" . $s . "\" id=\"distance" . $s . "\" placeholder=\"" . JText::_("COM_MYMAPLOCATIONS_ADDRESS") . "\"  value=\"" . $searchdata. "\"><span class=\"routeicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-info direction_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_MAPLOCATION_ROUTE") . "\" onclick=\"getUIDirection" . $s . "('+i+',null);\"></input>";
                }
                if ($route_format) {
                    $finalscript .= "var route=0;";
                } else {
                    $finalscript .= "var route=1;";
                }
                $setdivjs = "";
                if ($layout != null) {
                    $setdivjs = "setDiv( geodata" . $s . ".features[i].id);";
                }
                if (@$items[0]->map_layer == 8) {
                    
                    $layer = " var bikeLayer_" . $s . " = new google.maps.BicyclingLayer();
              bikeLayer_" . $s . ".setMap(map" . $s . "); ";
                } else if (@$items[0]->map_layer == 7) {
                    
                    $layer = " var transitLayer_" . $s . " = new google.maps.TransitLayer();
              transitLayer_" . $s . ".setMap(map" . $s . "); ";
                } else if (@$items[0]->map_layer == 6) {
                    $layer = " var trafficLayer_" . $s . " = new google.maps.TrafficLayer();
              trafficLayer_" . $s . ".setMap(map" . $s . "); ";
                } else if (@$items[0]->map_layer == 5) {
                    if (@$items[0]->maplayer_url) {
                        $layer = " var ctaLayer_" . $s . " =new google.maps.KmlLayer({
                          url: '" . $items[0]->maplayer_url . "',
                          map: map" . $s . ",
                          preserveViewport: true
                })";
                    }
                }
                $finalscript .= "
            var marker" . $s . ";
          var map" . $s . ";
          var panning = false;
                var panorama" . $s . ";
            var mapOptions" . $s . ";
            var  dms;
             var icons_" . $s . "=[];
             var latlng" . $s . ";
              var geodata" . $s . ";
              var promise" . $s . ";
          function initialize_" . $s . "(promise) {
             promise" . $s . "=promise;
             geodata" . $s . "=JSON.parse(JSON.stringify(promise));
             var total=geodata" . $s . ".features.length;
             latlng" . $s . "=getlatlng(promise,0);
             var bounds" . $s . " = new google.maps.LatLngBounds();
            var location" . $s . " = new google.maps.LatLng(latlng[1],latlng[0]);
            mapOptions" . $s . " = {
              zoom: " . $zoom . ",
              " . $srcollmap . "
              mapTypeId: google.maps.MapTypeId." . $items[0]->google_maptype . ",
              center: location" . $s . ",
              gestureHandling: 'cooperative',
              clickableIcons: false,
              " . $script5 . "
            };


            map" . $s . " = new google.maps.Map(document.getElementById('map_canvas_" . $s . "'),
                    mapOptions" . $s . ");

            dms = new google.maps.DistanceMatrixService();

                    dirService = new google.maps.DirectionsService();
                    dirRenderer = new google.maps.DirectionsRenderer({preserveViewport:true});
                    dirRenderer.setMap(map" . $s . ");
                    google.maps.event.addListener(map" . $s . ", 'idle', function() {
                        if (panning) {
                            map.fitBounds(bounds);
                            panning = false;
                        }
                    });

            infowindow" . $s . " = new google.maps.InfoWindow({maxWidth: 350});
                var i;
            var gmarkers = [];
                for (i = 0; i < geodata" . $s . ".features.length; i++) {
                final=(geodata" . $s . ".features[i].geometry.coordinates);
                maplatlng=final.toString().split(',');
                    icons_" . $s . "[i]= geodata" . $s . ".features[i].properties.icon;
                  marker" . $s . " = new google.maps.Marker({
                    position: new google.maps.LatLng( maplatlng[1],  maplatlng[0]),
                    map: map" . $s . ",
                    icon:icons_" . $s . "[i],
                    center: new google.maps.LatLng(latlng" . $s . "[1],latlng" . $s . "[0]),
                  });
                  " . $script2 . "
                  google.maps.event.addListener(marker" . $s . ", '" . $markeropen . "', (function(marker" . $s . ", i) {
                    return function() {
                      infowindow" . $s . ".setContent( geodata" . $s . ".features[i].properties.description.replace(/\\\/g,'')+'" . $street . "');
                      infowindow" . $s . ".open(map" . $s . ", marker" . $s . ");
                       " . $setdivjs . "
                    }
                  })(marker" . $s . ", i));
                  if(total>1)
                    {
                  bounds" . $s . ".extend(marker" . $s . ".getPosition());
                  }
                }
                " . $layer . "
                panorama" . $s . " = map" . $s . ".getStreetView();
      panorama" . $s . ".setPosition(location" . $s . ");
      panorama" . $s . ".setPov(/** @type {google.maps.StreetViewPov} */({
        heading: 265,
        pitch: 0
      }));
      
            if(total>1)
                    {
                    " . $script4 . "
                    }
                    " . $script3 . "
                    " . $launch . "
            }
              google.maps.event.addDomListener(window, 'resize', function() {
                                if (map" . $s . "== null){
                                }else
                                {
								var center" . $s . " = map" . $s . ".getCenter();
								google.maps.event.trigger(map" . $s . ", 'resize');
								map" . $s . ".setCenter(center" . $s . ");
                                }
						});

                function launchInfoWindow_" . $s . "(i) {
                            final=(geodata" . $s . ".features[i].geometry.coordinates);
                            maplatlng=final.toString().split(',');
                             infowindow" . $s . ".setContent(geodata" . $s . ".features[i].properties.description.replace(/\\\/g,'')+'" . $street . "');
                            var marker" . $s . "=new google.maps.Marker({
                                position: new google.maps.LatLng(maplatlng[1], maplatlng[0]),
                                icon: icons_" . $v . "[i],
                                map: map" . $s . "
                            });
                            infowindow" . $s . ".open(map" . $s . ", marker" . $s . ");
                }
                function gm_authFailure() { 
                    alert('".JText::_('COM_MYMAPLOCATIONS_MAP_LOADING_ERROR')."');
                }

                function toggleStreetView" . $s . "(i) {
                 final=(geodata" . $s . ".features[i].geometry.coordinates);
                            maplatlng=final.toString().split(',');
            var cent= new google.maps.LatLng(maplatlng[1], maplatlng[0]);
            panorama" . $s . ".setPosition(cent);
      var toggle = panorama" . $s . ".getVisible();
        if (toggle == false) {
       panorama" . $s . ".setVisible(true);
         } else {
        panorama" . $s . ".setVisible(false);
         }
        }
            function getUIDirection" . $s . "(i,source)
                {
                    final=(geodata" . $s . ".features[i].geometry.coordinates);
                    latlng=final.toString().split(',');
                var data=[];
                data[0]=parseFloat(latlng[1]);
                data[1]=parseFloat(latlng[0]);
                    var location" . $s . " = new google.maps.LatLng(" . $latlng . ");
                    if(source==null)
                    {
                    var source=document.getElementById('distance" . $s . "').value;
                    }
                    var destination=data[0]+','+data[1];
                     if(source=='')
                    {
                        alert('" . JTEXT::_('COM_MYMAPLOCATIONS_NORESULT') . "');
                        return;
                    }
                    if(route==0)
                    {
                        var url='//www.google.com/maps/dir/'+source+'/'+destination;
						window.open(url);
                    }
                    else
                    {

                    var directionsService = new google.maps.DirectionsService();
                    var directionsDisplay = new google.maps.DirectionsRenderer();
                    directionsDisplay.setPanel(document.getElementById('infobox_" . $s . "'));

                    document.getElementById('infobox_" . $s . "').style.display='block';
                    document.getElementById('backtomap_" . $s . "').style.display='block';
                    document.getElementById('print_" . $s . "').style.display='block';
                    mapOptions" . $s . " = {
                    zoom: " . $zoom . ",
                    mapTypeId: google.maps.MapTypeId." . $items[0]->google_maptype . ",
                    center: location" . $s . ",
                    " . $script5 . "
                    };
                    map" . $s . " = new google.maps.Map(document.getElementById('map_canvas_" . $s . "'),
                    mapOptions" . $s . ");
                    directionsDisplay.setMap(map" . $s . ");
                    var trafficLayer" . $s . " = new google.maps.TransitLayer();
                    trafficLayer" . $s . ".setMap(map" . $s . ");

                    var request = {
                        origin: source,
                        destination: destination,
                        travelMode: google.maps.DirectionsTravelMode.DRIVING,
                            " . $dist . ",
                    };
                    directionsService.route(request, function(response, status) {
                        if (status == google.maps.DirectionsStatus.OK) {
                            document.getElementById('infobox_" . $s . "').innerHTML = '';
                            directionsDisplay.setDirections(response);
                        }
                        else
                        {
                            alert('" . JTEXT::_('COM_MYMAPLOCATIONS_NORESULT') . "');
                            backToMap" . $s . "();
                        }
                    });
                    }

                }
                function getUIDirection_side(i,source)
                {
                    getUIDirection" . $s . "(i,source);
                }
                function backToMap_side" . $s . "()
                {
                     initialize_" . $s . "(promise" . $s . ");
                    document.getElementById('resulttop').style.display='block';
                    document.getElementById('resultpanel').style.display='none';

                }
             
                function printDiv(divID) {
            var divElements = document.getElementById(divID).innerHTML;
            var oldPage = document.body.innerHTML;
            document.body.innerHTML =divElements;
            window.print();
            document.body.innerHTML = oldPage;
                }
                  function backToMap" . $s . "()
                {
                    initialize_" . $s . "(promise" . $s . ");
                    document.getElementById('infobox_" . $s . "').style.display='none';
                    document.getElementById('backtomap_" . $s . "').style.display='none';
                    document.getElementById('print_" . $s . "').style.display='none';

                }
                 function printDiv" . $s . "(divID) {
            var divElements = document.getElementById(divID).innerHTML;
            var oldPage = document.body.innerHTML;
            document.body.innerHTML =divElements;
            window.print();
            document.body.innerHTML = oldPage;
                }
                function reinitialize()
                {
                     var script = document.createElement('script');
                    script.type = 'text/javascript';
                    script.src = '//maps.googleapis.com/maps/api/js?v=3" . $key . "&' +'callback=reinitialize_" . $s . "';
                    document.body.appendChild(script);

                }
                function reinitialize_" . $item->component . "_" . $item->id . "()
                {
                     var script = document.createElement('script');
                    script.type = 'text/javascript';
                    script.src = '//maps.googleapis.com/maps/api/js?v=3" . $key . "&' +'callback=reinitialize_" . $s . "';
                    document.body.appendChild(script);

                }
                function reinitialize_" . $s . "()
                {
                    initialize_" . $s . "(promise" . $s . ");
                }

                ";
            } else if ($map == 1) {
                $autozoomscript = "";
                $gridsize       = "";
                $street         = "";
                if ($route_format) {
                    $finalscript .= "var route=0;";
                } else {
                    $finalscript .= "var route=1;";
                }
                if ($params->get('street', 1) == 1) {
                    $street = "<span class=\"routeicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-inverse route_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_TOGGLE") . "\" onclick=\"toggleStreetView" . $s . "('+key+');\"></input><br/><input type=\"text\" class=\"input-small\" name=\"distance" . $s . "\" id=\"distance" . $s . "\" placeholder=\"" . JText::_("COM_MYMAPLOCATIONS_ADDRESS") . "\"><span class=\"detailsicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-info direction_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_MAPLOCATION_ROUTE") . "\" onclick=\"getUIDirection" . $s . "('+key+',null);\"></input>";
                }
                $finalstyle .= "#map_canvas_" . $s . " .infobox-stalk{display:none;}
            #map_canvas_" . $s . " canvas
            {
                max-width:none !important;
            }
            ";
                if ($autozoom) {
                    
                    $autozoomscript = "

            var count=countMarker(promise" . $s . ");
                    if(count!=1)
                    {
                    var bounds" . $s . " = Microsoft.Maps.LocationRect.fromShapes(shape" . $s . ");
            map" . $s . ".setView({ bounds:bounds" . $s . ", padding: 100});
            }
            ";
                }
                if ($cluster == 1) {
                } else {
                    $gridsize = "gridSize: 1";
                }
                $setdivjs = "";
                if ($layout != null) {
                    $setdivjs = " setDiv(location.metadata.itemid);";
                }
                
                $result .= MyMaplocationsHelper::loadBingJs();
                
                $finalscript .= "
                     delete Element.prototype.send;
        var map" . $s . ";
        var shape" . $s . "
        var   promise" . $s . ";
           var infobox" . $s . ";
            var clusterLayer" . $s . ";
    function initialize_" . $s . "(promise) {
    if(promise==null)
    {
        return;
    }
        promise" . $s . "=promise;
        var latlng=getlatlng(promise" . $s . ",0);
       map" . $s . " = new Microsoft.Maps.Map('#map_canvas_" . $s . "', {
            zoom: " . $zoom . ",
            center: new Microsoft.Maps.Location(latlng[0], latlng[1]),
             mapTypeId   : Microsoft.Maps.MapTypeId." . $items[0]->bing_maptype . "
        });

        infobox" . $s . " = new Microsoft.Maps.Infobox(map" . $s . ".getCenter(), {
				description: 'Description',
				visible: false
			});
			infobox" . $s . ".setMap(map" . $s . ");

     Microsoft.Maps.loadModule('Microsoft.Maps.GeoJson', function () {
            shape" . $s . "= Microsoft.Maps.GeoJson.read(promise" . $s . ");
            " . $autozoomscript . "

        });
          Microsoft.Maps.loadModule('Microsoft.Maps.Clustering', function () {
                    clusterLayer" . $s . " = new Microsoft.Maps.ClusterLayer(shape" . $s . ", { clusteredPinCallback: createCustomClusteredPin" . $s . "," . $gridsize . "});
                    map" . $s . ".layers.insert(clusterLayer" . $s . ");
                     Microsoft.Maps.Events.addHandler(clusterLayer" . $s . ", 'click', pushpinClicked" . $s . ");
                });
                function createCustomClusteredPin" . $s . "(cluster) {
            var minRadius = 12;
            var outlineWidth = 7;
            var clusterSize = cluster.containedPushpins.length;
            var radius = Math.log(clusterSize) / Math.log(10) * 5 + minRadius;
            var fillColor = 'rgba(255, 40, 40, 0.5)';
            if (clusterSize < 10) {
                fillColor = 'rgba(20, 180, 20, 0.5)';
            } else if (clusterSize < 100) {
                fillColor = 'rgba(255, 210, 40, 0.5)';
            }
            var svg = ['<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"', (radius * 2), '\" height=\"', (radius * 2), '\">',
            '<circle cx=\"', radius, '\" cy=\"', radius, '\" r=\"', radius, '\" fill=\"', fillColor, '\"/>',
            '<circle cx=\"', radius, '\" cy=\"', radius, '\" r=\"', radius - outlineWidth, '\" fill=\"', fillColor, '\"/>',
            '</svg>'];

            cluster.setOptions({
                icon: svg.join(''),
                anchor: new Microsoft.Maps.Point(radius, radius),
                textOffset: new Microsoft.Maps.Point(0, radius - 8)
            });
            }
            function pushpinClicked" . $s . "(e) {
            if (e.target.containedPushpins) {
               var locs = [];
            for (var i = 0, len = e.target.containedPushpins.length; i < len; i++) {
                locs.push(e.target.containedPushpins[i].getLocation());
            }

            var bounds = Microsoft.Maps.LocationRect.fromLocations(locs);

            map" . $s . ".setView({ bounds: bounds, padding: 100 });
            }
            else
            {
                 var location = e.target;
                var loc = e.location; //Default to the location of the mouse event to show the infobox.
             if(location instanceof Microsoft.Maps.Pushpin){
                    loc = location.getLocation();
                }
                   var key=location.geometry.y+','+location.geometry.x;
            		infobox" . $s . ".setOptions({location: loc,description: location.metadata.description+'" . $street . "', visible: true,offset: new Microsoft.Maps.Point(0,25),maxHeight:500,maxWidth:400 });
                   " . $setdivjs . "
                }
            }
            }

            function launchInfoWindow_" . $s . "(i) {
            if(typeof shape" . $s . "==='undefined')
            {
                return;
            }
                loc = shape" . $s . "[i].getLocation();
                var key=shape" . $s . "[i].geometry.y+','+shape" . $s . "[i].geometry.x;
				map" . $s . ".setView({ center:loc});
                infobox" . $s . ".setOptions({location: loc,description: shape" . $s . "[i].metadata.description+'" . $street . "', visible: true,offset: new Microsoft.Maps.Point(0,25),maxHeight:500,maxWidth:400 });

                }
                function toggleStreetView" . $s . "(lat,lang) {
                 loc = new Microsoft.Maps.Location(lat,lang);

                 map" . $s . ".setView({center:loc,mapTypeId: Microsoft.Maps.MapTypeId.streetside});
                }
                function getUIDirection" . $s . "(lat,lang,source)
                {

                    if(source==null)
                    {
                     var source=document.getElementById('distance" . $s . "').value;
                     }
                     if(source=='')
                    {
                        alert('" . JTEXT::_('COM_MYMAPLOCATIONS_NORESULT') . "');
                        return;
                    }
                    if(route==0)
                    {
                        var url='//bing.com/maps/default.aspx?rtp=adr.'+source+'~pos.'+lat+'_'+lang;
						window.open(url);
                    }
                    else
                    {
                     document.getElementById('infobox_" . $s . "').style.display='block';
                    document.getElementById('backtomap_" . $s . "').style.display='block';
                    document.getElementById('print_" . $s . "').style.display='block';
                         Microsoft.Maps.loadModule('Microsoft.Maps.Directions', function () {
                        directionsManager = new Microsoft.Maps.Directions.DirectionsManager(map" . $s . ");
                        var seattleWaypoint = new Microsoft.Maps.Directions.Waypoint({ address: source });
                        directionsManager.addWaypoint(seattleWaypoint);
                        var workWaypoint = new Microsoft.Maps.Directions.Waypoint({  location: new Microsoft.Maps.Location(lat,lang) });
                        directionsManager.addWaypoint(workWaypoint);
                        directionsManager.setRenderOptions({ itineraryContainer: '#infobox_" . $s . "' });
                        directionsManager.calculateDirections();
                    });
                }
                }
                function getUIDirection_side(i,source)
                {
                    getUIDirection" . $s . "(shape" . $s . "[i].geometry.y,shape" . $s . "[i].geometry.x,source);
                }
                 function printDiv" . $s . "(divID) {
            var divElements = document.getElementById(divID).innerHTML;
            var oldPage = document.body.innerHTML;
            document.body.innerHTML =divElements;
            window.print();
             document.body.innerHTML = oldPage;
                }
                function backToMap" . $s . "()
                {
                 document.getElementById('infobox_" . $s . "').style.display='none';
                    document.getElementById('backtomap_" . $s . "').style.display='none';
                    document.getElementById('print_" . $s . "').style.display='none';
                initialize_" . $s . "(promise" . $s . ");

                }
                function reinitialize_" . $item->component . "_" . $item->id . "()
                {
                initialize_" . $s . "(promise" . $s . ");
                }
             
            ";
            } else if ($map == 2) {
                $result .= MyMaplocationsHelper::loadMapboxJs(true);
                $street = "";
                
                if ($cluster == 1) {
                    $mapboxcluster = "";
                } else {
                    $mapboxcluster = "{disableClusteringAtZoom:1}";
                }
                $street = "";
                if ($params->get('street', 1) == 1) {
                    $street = "<span class=\"routeicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-inverse route_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_TOGGLE") . "\" onclick=\"toggleStreetView" . $s . "('+key+');\"></input><br/><input type=\"text\" class=\"input-small\" name=\"distance" . $s . "\" id=\"distance" . $s . "\" placeholder=\"" . JText::_("COM_MYMAPLOCATIONS_ADDRESS") . "\"><span class=\"detailsicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-info direction_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_MAPLOCATION_ROUTE") . "\" onclick=\"getUIDirection" . $s . "('+key+',null);\"></input>";
                }
                $setdivjs = "";
                if ($layout != null) {
                    $setdivjs = " setDiv(e.layer.feature.id);";
                }
                $finalscript .= "
            var  map" . $s . ";
            var geojson" . $s . "='';
            var markers" . $s . "='';
            var cjson" . $s . "='';
            var promise" . $s . ";
            function  initialize_" . $s . "(promise) {
            promise" . $s . "=promise;
            geoJson" . $s . "=promise;
            var latlng=getlatlng(promise" . $s . ",0);
            if(map" . $s . " != undefined || map" . $s . " != null){
              map" . $s . ".off();
             map" . $s . ".remove();
            }
            map" . $s . " =  L.map('map_canvas_" . $s . "', {maxZoom: 17});
             map" . $s . ".attributionControl.addAttribution(' © <a href=\"https://www.mapbox.com/about/maps/\" target=\"_blank\">Mapbox</a> © <a href=\"http://www.openstreetmap.org/copyright\" target=\"_blank\">OpenStreetMap</a> <strong><a href=\"https://www.mapbox.com/map-feedback/\" target=\"_blank\">Improve this map</a></strong>');

            var fullscreen=new L.Control.Fullscreen();
               map" . $s . ".addControl(fullscreen);
            var gl" . $s . " = L.mapboxGL({
                accessToken: '" . $mapboxapi . "',
                style: '" . $mapboxstyle . "'
        }).addTo(map" . $s . ");
            map" . $s . ".setView([latlng[0],latlng[1]]," . $zoom . ");
            
             markers" . $s . " = L.markerClusterGroup(" . $mapboxcluster . ");
             var i=0;
             cjson" . $s . " =   L.geoJson( geoJson" . $s . ", {
             onEachFeature: function (feature, layer) {
                layer.setIcon(L.icon({'iconUrl':feature.properties.icon,'iconSize': [50,50], iconAnchor: [25, 50],popupAnchor: [0,-36]}));
                var key=feature.geometry.coordinates;
                i++;
                layer.bindPopup(feature.properties.description +'" . $street . "');
             }
             });
            markers" . $s . ".addLayer(cjson" . $s . ");

            markers" . $s . ".addTo(map" . $s . ").on('click', onClick" . $s . ");
            function onClick" . $s . "(e)
            {
                " . $setdivjs . "
            }
            ";
                
                if ($params->get('mapscroll', 1) == 0) {
                    $finalscript .= "map" . $s . ".scrollWheelZoom.disable();";
                }
                if ($autozoom) {
                    $finalscript .= "

            var count=countMarker(promise" . $s . ");
                    if(count!=1)
                    {
                            map" . $s . ".fitBounds(markers" . $s . ".getBounds());
                    }
        ";
                }
                
                $finalscript .= "}";
                $finalscript .= "function launchInfoWindow_" . $s . "(i) {
              var l=0;
                 markers" . $s . ".eachLayer(function(cmarker" . $s . ") {
				 if(cmarker" . $s . ".feature.properties.itemid==i)
				{
						cmarker" . $s . ".addTo(map" . $s . ").openPopup();
				}
                });
                 }
                 function printDiv" . $s . "(divID) {
            var divElements = document.getElementById(divID).innerHTML;
            var oldPage = document.body.innerHTML;
            document.body.innerHTML =divElements;
            window.print();
             document.body.innerHTML = oldPage;
                }
                function backToMap" . $s . "()
                {
                document.getElementById('map_canvas_" . $s . "').style.display='block';
                document.getElementById('infobox_" . $s . "').style.display='none';
                    document.getElementById('backtomap_" . $s . "').style.display='none';
                    document.getElementById('print_" . $s . "').style.display='none';
                    	initialize_" . $s . "(promise" . $s . ");

                }
                 function toggleStreetView" . $s . "(lang,lat) {
                    document.getElementById('map_canvas_" . $s . "').style.display='none';
                  document.getElementById('backtomap_" . $s . "').style.display='block';
                  document.getElementById('infobox_" . $s . "').style.display='block';
                    jQuery('#infobox_" . $s . "').html('');
                  var mly" . $s . ";
                  var { Viewer } = mapillary;
                    mly" . $s . "= new Viewer(
                'infobox_" . $s . "',
                '" . $mapillaryapi . "',
                 null,
                );
                
                     mly" . $s . ".moveCloseTo(lat, lang);
                   window.addEventListener('resize', function() { mly" . $s . ".resize(); });
               
                }
                function getUIDirection" . $s . "(lat,lang,source)
               {
               if(source==null)
                    {
                    var source=document.getElementById('distance" . $s . "').value;
                    }
                     if(source=='')
                    {
                        alert('" . JTEXT::_('COM_MYMAPLOCATIONS_NORESULT') . "');
                        return;
                    }
                    document.getElementById('map_canvas_" . $s . "').style.display='none';
                  document.getElementById('backtomap_" . $s . "').style.display='block';
                  document.getElementById('infobox_" . $s . "').style.display='block';
                    jQuery('#infobox_" . $s . "').html('');
                    mapboxgl.accessToken = '" . $mapboxapi . "';
var mapk_" . $s . " = new mapboxgl.Map({
    container: 'infobox_" . $s . "',
    style: '" . $mapboxstyle . "',
    center: [lat,lang],
    zoom: 13
});

var directionsk_" . $s . "=new MapboxDirections({
    accessToken: mapboxgl.accessToken,
    controls:
    {
        inputs:false
    }
});
mapk_" . $s . ".addControl(directionsk_" . $s . ");
mapk_" . $s . ".on('load', function() {
directionsk_" . $s . ".setOrigin([lat,lang]);
directionsk_" . $s . ".setDestination(source);
});

               }
               function getUIDirection_side(i,source)
                {
                var latlng=getlatlng(promise" . $s . ",i);
                getUIDirection" . $s . "(latlng[1],latlng[0],source);
                }
                function reinitialize_" . $item->component . "_" . $item->id . "()
                {
                initialize_" . $s . "(promise" . $s . ");
                }
                
                 ";
                
                
                
            } else if ($map == 3) {
                $result .= MyMaplocationsHelper::loadLeafletJs();
                $scripts = "";
                if ($autozoom == 1) {
                    $scripts = "
                     var count=countMarker(promise" . $s . ");
                    if(count!=1)
                    {
                    map" . $s . ".fitBounds(markers" . $s . ".getBounds());
                    }";
                }
                if ($cluster == 1) {
                    $mapboxcluster = "";
                } else {
                    $mapboxcluster = "{disableClusteringAtZoom:1}";
                }
                 $srcollmap="";
                 if ($params->get('mapscroll', 1) == 0) {
                    $srcollmap .= " map" . $s . ".scrollWheelZoom.disable();";
                }
                  if ($params->get('mapsdrag', 1) == 0) {
                    $srcollmap .= " map" . $s . ".dragging.disable();";
                }
                $street = "";
                if ($params->get('street', 1) == 1) {
                    $street = "<span class=\"routeicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-inverse route_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_TOGGLE") . "\" onclick=\"toggleStreetView" . $s . "('+key+');\"></input>";
                }
                $finalstyle .= ".mapillary-js-interactive > *:not(:last-child) ,mapillary-js-dom > *:not(:last-child) {
  visibility: hidden;
}

";
                
                $setdivjs = "";
                if ($layout != null) {
                    $setdivjs = " setDiv(e.layer.feature.id);";
                }
                
                $finalscript .= "var tiles" . $s . "=" . MyMaplocationsHelper::getLeafletStyle($items[0]->openmapstyle) . ";
		var map" . $s . ";
                var markers" . $s . ";
                 var promise" . $s . ";
        function  initialize_" . $s . "(promise) {
            promise" . $s . "=promise;
             var latlng=getlatlng(promise" . $s . ",0);
             if(map" . $s . " != undefined || map" . $s . " != null){
              map" . $s . ".off();
             map" . $s . ".remove();
            }
             map" . $s . " = L.map('map_canvas_" . $s . "')
				.addLayer(tiles" . $s . ");
            map" . $s . ".setView([latlng[0],latlng[1]]," . $zoom . ");
            ".$srcollmap."
             markers" . $s . " = L.markerClusterGroup(" . $mapboxcluster . ");
            var i=0;
		var geoJsonLayer" . $s . " = L.geoJson(promise" . $s . ", {
			onEachFeature: function (feature, layer) {
             layer.setIcon(L.icon({'iconUrl':feature.properties.icon,'iconSize': [50,50] , iconAnchor: [25, 50],popupAnchor: [0,-36]}));
                i++;
                var key=feature.geometry.coordinates;
				layer.bindPopup(feature.properties.description+'" . $street . "');
			}
		});
		markers" . $s . ".addLayer(geoJsonLayer" . $s . ");
        markers" . $s . ".addTo(map" . $s . ").on('click', onClick" . $s . ");
            function onClick" . $s . "(e)
            {
                " . $setdivjs . "
            }
            " . $scripts . "
        map" . $s . ".addControl(new L.Control.Fullscreen());
        
        }
             ";
                $finalscript .= "function launchInfoWindow_" . $s . "(i) {

              var l=0;
                 markers" . $s . ".eachLayer(function(cmarker" . $s . ") {
                 if(cmarker" . $s . ".feature.properties.itemid==i)
				{
						cmarker" . $s . ".addTo(map" . $s . ").openPopup();
				}
                });
                 }
                 function backToMap" . $s . "()
                {
                    document.getElementById('map_canvas_" . $s . "').style.display='block';
                    document.getElementById('infobox_" . $s . "').style.display='none';
                    document.getElementById('backtomap_" . $s . "').style.display='none';
                    document.getElementById('print_" . $s . "').style.display='none';
                    	initialize_" . $s . "(promise" . $s . ");
                }
                 function toggleStreetView" . $s . "(lang,lat) {
                  document.getElementById('map_canvas_" . $s . "').style.display='none';
                  document.getElementById('backtomap_" . $s . "').style.display='block';
                  document.getElementById('infobox_" . $s . "').style.display='block';
                    jQuery('#infobox_" . $s . "').html('');
                  var mly" . $s . ";
                    mly" . $s . "= new Mapillary.Viewer(
                'infobox_" . $s . "',
                '" . $mapillaryapi . "',
                 null,
                );
                
                     mly" . $s . ".moveCloseTo(lat, lang);
                   window.addEventListener('resize', function() { mly" . $s . ".resize(); });
                }
                function getUIDirection" . $s . "(lat,lang,source=null)
               {
               if(source==null)
                    {
                     var source=document.getElementById('distance" . $s . "').value;
                     }
                     if(source=='')
                    {
                        alert('" . JTEXT::_('COM_MYMAPLOCATIONS_NORESULT') . "');
                        return;
                    }
                             var url='//www.google.com/maps/dir/'+source+'/'+lang+','+lat;
						window.open(url);
                
                    
               }
               function getUIDirection_side(i,source)
                {
                var latlng=getlatlng(promise" . $s . ",i);
                getUIDirection" . $s . "(latlng[1],latlng[0],source);
                }
                function reinitialize_" . $item->component . "_" . $item->id . "()
                {
                initialize_" . $s . "(promise" . $s . ");
                }
                 ";
                
            } else if ($map == 4) {
                $result .= MyMaplocationsHelper::loadMapQuestJs();
                $street = "";
                $finalstyle .= "

.map_canvas .leaflet-routing-container, .map_canvas .leaflet-routing-error,.map_canvas .leaflet-routing-alt tr:hover
{
  background:#000;
  opacity:0.6;
  color:#FFF;
}
.map_canvas .leaflet-routing-alt tr:hover
{
  opacity:1;

}
.map_canvas .maneuver-icon:before
{
  font-family:'mq-icons' !important;
}
.map_canvas .leaflet-control-mapquest-narrative
{
  background:#000 !important;
  opacity: 0.6;
  color:#FFF !important;
}
.map_canvas .interactive-maneuver:hover
{
  background:#000 !important;

}";
                
                
                if ($cluster == 1) {
                    $mapboxcluster = "";
                } else {
                    $mapboxcluster = "{disableClusteringAtZoom:1}";
                }
                $street = "";
                
                $setdivjs = "";
                if ($layout != null) {
                    $setdivjs = " setDiv(e.layer.feature.id);";
                }
                if ($params->get('street', 1) == 1) {
                    $street = "<span class=\"routeicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-inverse route_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_TOGGLE") . "\" onclick=\"toggleStreetView" . $s . "('+key+');\"></input><br/><input type=\"text\" class=\"input-small\" name=\"distance" . $s . "\" id=\"distance" . $s . "\" placeholder=\"" . JText::_("COM_MYMAPLOCATIONS_ADDRESS") . "\"><span class=\"detailsicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-info direction_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_MAPLOCATION_ROUTE") . "\" onclick=\"getUIDirection" . $s . "('+key+',null);\"></input>";
                }
                $finalscript .= "
             L.mapquest.key = '" . $mapquestapi . "';
             
        var map" . $s . " ;
          var promise" . $s . ";
            var geojson" . $s . "='';
            var markers" . $s . "='';
            var cjson" . $s . "='';
            function  initialize_" . $s . "(promise) {

            promise" . $s . "=promise;
            geoJson" . $s . "=promise;
              var latlng=getlatlng(promise" . $s . ",0);
             if(map" . $s . " != undefined || map" . $s . " != null){
              map" . $s . ".off();
             map" . $s . ".remove();
            }
             map" . $s . "=L.mapquest.map('map_canvas_" . $s . "', {
             center: [latlng[0],latlng[1]],
          layers: L.mapquest.tileLayer('map'),
          zoom: " . $zoom . ",
                })
            

       

             markers" . $s . " = L.markerClusterGroup(" . $mapboxcluster . ");
             var i=0;
             cjson" . $s . " =   L.geoJson( geoJson" . $s . ", {
             onEachFeature: function (feature, layer) {
                layer.setIcon(L.icon({'iconUrl':feature.properties.icon,'iconSize': [50,50], iconAnchor: [25, 50],popupAnchor: [0,-36]}));
                var key=feature.geometry.coordinates;
                i++;
                layer.bindPopup(feature.properties.description +'" . $street . "');
             }
             });
            markers" . $s . ".addLayer(cjson" . $s . ");
            markers" . $s . ".addTo(map" . $s . ").on('click', onClick" . $s . ");
            function onClick" . $s . "(e)
            {
               " . $setdivjs . "
            }
            map" . $s . ".addControl(L.mapquest.navigationControl());
            map" . $s . ".addControl(L.mapquest.satelliteControl());
            map" . $s . ".addControl(L.mapquest.trafficControl());
            ";
                
                if ($params->get('mapscroll', 1) == 0) {
                    $finalscript .= "map" . $s . ".scrollWheelZoom.disable();";
                }
                if ($autozoom) {
                    $finalscript .= "var count=countMarker(promise" . $s . ");
                    if(count!=1)
                    {
                    map" . $s . ".fitBounds(markers" . $s . ".getBounds());
                    }
                    ";
                }
                
                $finalscript .= "}";
                $finalscript .= "function launchInfoWindow_" . $s . "(i) {
                 markers" . $s . ".eachLayer(function(cmarker" . $s . ") {
				if(cmarker" . $s . ".feature.properties.itemid==i)
				{
						cmarker" . $s . ".addTo(map" . $s . ").openPopup();
				}
                });
                 }
                 function printDiv" . $s . "(divID) {
            var divElements = document.getElementById(divID).innerHTML;
            var oldPage = document.body.innerHTML;
            document.body.innerHTML =divElements;
            window.print();
             document.body.innerHTML = oldPage;
                }
                function backToMap" . $s . "()
                {
                document.getElementById('map_canvas_" . $s . "').style.display='block';
                document.getElementById('infobox_" . $s . "').style.display='none';
                    document.getElementById('backtomap_" . $s . "').style.display='none';
                    document.getElementById('print_" . $s . "').style.display='none';
                    	initialize_" . $s . "(promise" . $s . ");

                }
                 function toggleStreetView" . $s . "(lang,lat) {
                    document.getElementById('map_canvas_" . $s . "').style.display='none';
                  document.getElementById('backtomap_" . $s . "').style.display='block';
                  document.getElementById('infobox_" . $s . "').style.display='block';
                    jQuery('#infobox_" . $s . "').html('');
                  var mly" . $s . ";
                    mly" . $s . "= new Mapillary.Viewer(
                'infobox_" . $s . "',
                '" . $mapillaryapi . "',
                 null,
                );

                     mly" . $s . ".moveCloseTo(lat, lang);
                   window.addEventListener('resize', function() { mly" . $s . ".resize(); });
               
                }
                function getUIDirection" . $s . "(lat,lang,source)
               {
                document.getElementById('backtomap_" . $s . "').style.display='block';
                    if(source==null)
                    {
                    var source=document.getElementById('distance" . $s . "').value;
                     }
                     if(source=='')
                    {
                        alert('" . JTEXT::_('COM_MYMAPLOCATIONS_NORESULT') . "');
                        return;
                    }
                    var directions = L.mapquest.directions();
          directions.route({
            start:lang+','+lat,
            end:source,
            options: {
              enhancedNarrative: true
            }
          }, createDirectionMap" . $s . ");

               }
               function createDirectionMap" . $s . "(err, response)
               {
                var directionsLayer = L.mapquest.directionsLayer({
            directionsResponse: response
          }).addTo(map" . $s . ");

          var narrativeControl = L.mapquest.narrativeControl({
            directionsResponse: response,
            compactResults: false,
            interactive: true
          });

          narrativeControl.setDirectionsLayer(directionsLayer);
          narrativeControl.addTo(map" . $s . ");
               }
              function getUIDirection_side(i,source)
                {
                var latlng=getlatlng(promise" . $s . ",i);
                getUIDirection" . $s . "(latlng[1],latlng[0],source);
                }
                function reinitialize_" . $item->component . "_" . $item->id . "()
                {
                initialize_" . $s . "(promise" . $s . ");
                }

                 ";
                
                
                
            }
             else if ($map == 5) {
                $result .= MyMaplocationsHelper::loadBaiduJs();
                $street = "";
                $cluster_script="";
                $markeropen = $params->get('markeropen', 'click');
                 $srcollmap = "";
                if ($params->get('mapscroll', 1) == 1) {
                    $srcollmap .= " map" . $s . ".enableScrollWheelZoom();map" . $s . ".enableContinuousZoom(); ";
                }
                  if ($params->get('mapsdrag', 1) == 0) {
                    $srcollmap .= " map" . $s . ".disableDragging();";
                }
                if ($params->get('street', 1) == 1) {
                    $street = "<span class=\"routeicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-inverse route_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_TOGGLE") . "\" onclick=\"toggleStreetView" . $s . "('+key+');\"></input><br/><input type=\"text\" class=\"input-small\" name=\"distance" . $s . "\" id=\"distance" . $s . "\" placeholder=\"" . JText::_("COM_MYMAPLOCATIONS_ADDRESS") . "\"><span class=\"detailsicon\"></span><input type=\"button\" class=\"resultmymap mymap mymap-info direction_mml\" value=\"" . JText::_("COM_MYMAPLOCATIONS_MAPLOCATION_ROUTE") . "\" onclick=\"getUIDirection" . $s . "('+key+',null);\"></input>";
                }
                $cluster_script2="map" . $s . ".addOverlay(marker" . $s . ");";
                 if ($cluster == 1) {
                    $cluster_script="var markerClusterer" . $s . " = new BMapLib.MarkerClusterer(map" . $s . ", {markers:markers" . $s . "});";
                    $cluster_script2="";
                 }
                 $finalscript .="var map" . $s . ";
                 var geodata" . $s . ";
                   var  markers" . $s . " =[];
                   var  geojsonData" . $s . " =[];
                   
                function  initialize_" . $s . "(promise) {
                 promise" . $s . "=promise;
                var latlng=getlatlng(promise" . $s . ",0);
                 map" . $s . " = new BMap.Map('map_canvas_" . $s . "');
                 map" . $s . ".centerAndZoom(new BMap.Point(latlng[1],latlng[0])," . $zoom . ");
                 map" . $s . ".setZoom(" . $zoom . ");
                ".$srcollmap."
                map" . $s . ".addControl(new BMap.NavigationControl({anchor: BMAP_ANCHOR_TOP_LEFT, type: BMAP_NAVIGATION_CONTROL_SMALL}));
                map" . $s . ".addControl(new BMap.MapTypeControl({mapTypes:[BMAP_NORMAL_MAP,BMAP_HYBRID_MAP]}));	
                map" . $s . ".setCurrentCity('Beijing'); 
                geodata" . $s . "=JSON.parse(JSON.stringify(promise" . $s . "));
                for(i=0;i<geodata" . $s . ".features.length;i++)
                    {
                        var pt" . $s . " = new BMap.Point(geodata" . $s . ".features[i].geometry.coordinates[0], geodata" . $s . ".features[i].geometry.coordinates[1]);
                        var key=geodata" . $s . ".features[i].geometry.coordinates;
                        var myIcon" . $s . " = new BMap.Icon(geodata" . $s . ".features[i].properties.icon, new BMap.Size(50,60),{Anchor:new BMap. Size ( 25 ,  60 )});
                        var marker" . $s . " = new BMap.Marker(pt" . $s . ",{icon:myIcon" . $s . "});  
                        markers" . $s . ".push(marker" . $s . " );
                        ".$cluster_script2."
                        var infoWindow" . $s . " = geodata" . $s . ".features[i].properties.description +'" . $street . "';
                        addClickHandler" . $s . "(infoWindow" . $s . ",marker" . $s . ");
                        geojsonData" . $s . "[geodata" . $s . ".features[i].id]=geodata" . $s . ".features[i];
                    }
                      
                      ".$cluster_script."
                     
                    }
                     function launchInfoWindow_" . $s . "(i) {
                     
                     var pt" . $s . " = new BMap.Point( geojsonData" . $s . "[i].geometry.coordinates[0],  geojsonData" . $s . "[i].geometry.coordinates[1]);
                         map" . $s . ".centerAndZoom(pt" . $s . "," . $zoom . ");
                          var key= geojsonData" . $s . "[i].geometry.coordinates;
                        var infoWindow" . $s . " = new BMap.InfoWindow( geojsonData" . $s . "[i].properties.description +'" . $street . "');
                        map" . $s . ".openInfoWindow(infoWindow" . $s . ",pt" . $s . "); 
                     }
                     
                    function addClickHandler" . $s . "(content,marker){
		marker.addEventListener('".$markeropen."',function(e){
			openInfo" . $s . "(content,e)}
		);
	}
	function openInfo" . $s . "(content,e){
		var p = e.target;
		var point = new BMap.Point(p.getPosition().lng, p.getPosition().lat);
		var infoWindow = new BMap.InfoWindow(content);  
		 map" . $s . ".openInfoWindow(infoWindow,point); 
	}
                
           function reinitialize_" . $item->component . "_" . $item->id . "()
                {
                initialize_" . $s . "(promise" . $s . ");
                }
                 function backToMap" . $s . "()
                {
                document.getElementById('map_canvas_" . $s . "').style.display='block';
                document.getElementById('infobox_" . $s . "').style.display='none';
                    document.getElementById('backtomap_" . $s . "').style.display='none';
                    document.getElementById('print_" . $s . "').style.display='none';
                    	initialize_" . $s . "(promise" . $s . ");

                }
                function toggleStreetView" . $s . "(lang,lat) {
                document.getElementById('map_canvas_" . $s . "').style.display='none';
                document.getElementById('backtomap_" . $s . "').style.display='block';
                document.getElementById('infobox_" . $s . "').style.display='block';
                var panorama = new BMap.Panorama('infobox_" . $s . "');
                panorama.setPosition(new BMap.Point(lang,lat));
                }
                function getUIDirection" . $s . "(lat,lang,source)
               {
               if(source==null)
                    {
                    var source=document.getElementById('distance" . $s . "').value;
                    }
                    else
                    {}
                     if(source=='')
                    
                    {
                        alert('" . JTEXT::_('COM_MYMAPLOCATIONS_NORESULT') . "');
                        return;
                    }
                    document.getElementById('backtomap_" . $s . "').style.display='block';
                    document.getElementById('infobox_" . $s . "').style.display='block';
                    jQuery('#infobox_" . $s . "').html('');
                    var map" . $s . " = new BMap.Map('map_canvas_" . $s . "');
                    	 var pt=new BMap.Point(lat,lang);
                        map" . $s . ".centerAndZoom(pt, ".$zoom.");
                    var driving = new BMap.DrivingRoute(map" . $s . ", {renderOptions: {map: map" . $s . ", panel: 'infobox_" . $s . "', autoViewport: true}});
                   
                    driving.search(source, pt);
                        
               }
               function getUIDirection_side(i,source)
                {
                var latlng=getlatlng(promise" . $s . ",i);               
                var pt1=new BMap.Point(latlng[1],latlng[0]);
                var sourcedata=source.split(',');
                var pt2=new BMap.Point(sourcedata[1],sourcedata[0]);
                document.getElementById('backtomap_" . $s . "').style.display='block';
                    document.getElementById('infobox_" . $s . "').style.display='block';
                    jQuery('#infobox_" . $s . "').html('');
                    var map" . $s . " = new BMap.Map('map_canvas_" . $s . "');    
                    map" . $s . ".centerAndZoom(pt1, ".$zoom.");
                    var driving = new BMap.DrivingRoute(map" . $s . ", {renderOptions: {map: map" . $s . ", panel: 'infobox_" . $s . "', autoViewport: true}});
                    driving.search(pt2, pt1);
                
                }
                  function getlatlng(geojson,i)
                     {
                var geodata=JSON.parse(JSON.stringify(geojson));
                if(typeof geodata.features==='undefined')
                {
                    return;
                }
                final=(geodata.features[i].geometry.coordinates);
                latlng=final.toString().split(',');
                var data=[];
                data[0]=parseFloat(latlng[1]);
                data[1]=parseFloat(latlng[0]);
                return data;
                    }
               
                 ";
                }
            
            $setDiv = "";
            if ($layout != null) {
                if ($jq_lib == 1) {
                    $setDiv = "jQuery('#locationresult').mCustomScrollbar('scrollTo',scrollheight);";
                }
            }
            $finalstyle .= ".myaddress{width:100%;float:left;margin-bottom:5px;}
           .mytool{width:100%;position:relative; }
              .gm-style-iw .resultmymap.mymap mymap-info.direction_mml .map_canvas .mymap-icon {
    max-width:none !important;
    max-height: 100px;
    display: inline-block;
    height: auto;
    transition: all 0.2s ease-in-out 0s;
    float: left;
    padding-right: 7px;
}
   
 .gm-style-iw .input-small
    {
    height: 22px !important;
    line-height:22px !important;
    max-width:100px;
    margin:0px;
        border-right:0;
        padding: 0px 15px 5px 15px;
        background:#f4f3f4;
        border:none;
        float:left;
    }
    .gm-style-iw .input-small:hover
    {
        border:none;
    }
   span.routeicon:before
   {
   content:url(" . JURI::root() . "components/com_mymaplocations/assets/images/routeIcn.png);
   } 
   span.contacticon:before
   {
   content:url(" . JURI::root() . "components/com_mymaplocations/assets/images/contactIcn.png); 
   }
   
   span.detailsicon:before
   {
   content:url(" . JURI::root() . "components/com_mymaplocations/assets/images/detailsIcn.png); 
   }
   span.routeicon,span.detailsicon,span.routeicon,span.contacticon
   {
    display: inline-block;
font-style: normal;
font-variant: normal;
text-rendering: auto;
line-height: 1;
position:relative;
top:5px;
    padding-left: 5px;
   }
.resultmymap.mymap.mymap-inverse,.resultmymap.mymap.mymap-info.direction_mml,.mytool .mymap.mymap-inverse.resultmymap,.mytool .mymap.mymap-inverse.resultmymap:hover,.resultmymap.mymap.mymap-inverse.contact-btn,.resultmymap.mymap.mymap-inverse.contact-btn:hover{
    display:inline-block;
     box-shadow: none;
    text-shadow: none;
    color: #1f1d22;
    font-size: 11px;
    
    font-weight: 600;
    letter-spacing: .5px;
    box-sizing: border-box;
    background: transparent;
    cursor:pointer;
    border:none;
    line-height: 22px;
    max-width:100px;
    }
 .location-title,.location-title a {
    margin: 0 0 10px;
        margin-left: 0px;
    margin-left: 0px;
    font-weight: 600;
    font-size: 17px;
    color:#1f1d22;
    display:block;
}
.leaflet-popup-content-wrapper, .leaflet-popup-tip
{
    min-height:170px;
    float:left;
}
.gm-style-iw .location-title,.gm-style-iw .location-title a
{
display:block;
}
span.locationaddress {
    font-size: 15px;
    color: #1f1d22;
}
           ";
            if ($filter_you) {
                $count_you = "(geodatas.features.length-1)";
                
            } else {
                $count_you = "geodatas.features.length";
            }
            if (($map == 0) | ($map == 1)) {
                $launchvar = "i";
            } else {
                $launchvar = "geodatas.features[i].id";
            }
            $finalscript .= "
            function getlatlng(geojson,i)
            {
                var geodata=JSON.parse(JSON.stringify(geojson));
                if(typeof geodata.features==='undefined')
                {
                    return;
                }
                final=(geodata.features[i].geometry.coordinates);
                latlng=final.toString().split(',');
                var data=[];
                data[0]=parseFloat(latlng[1]);
                data[1]=parseFloat(latlng[0]);
                return data;
            }
            function countMarker(geojson)
            {
                var geodata=JSON.parse(JSON.stringify(geojson));
               return (geodata.features.length);
            }";
            if ($layout != null) {
                $finalscript .= "function sidebar_" . $s . "(promise)
            {
                jQuery('#resulttop').html('');
                var geodatas=JSON.parse(JSON.stringify(promise));
                var html='<div class=\"resultbar resultbar" . $s . "\">';
                var totalcount=" . $count_you . ";
                jQuery('.result-count .badge-info').html(totalcount);
                for(i=0;i<geodatas.features.length;i++)
                {
                if(geodatas.features[i].id!=0)
                {
                var locationid='location_'+geodatas.features[i].id;
                var featured=geodatas.features[i].properties.featured;
                var classfeatured='';
                if(featured==1)
                {
                    classfeatured='featured';
                }
                if(i%2==0)
                {
                    var html=html+'<div class=\"row1 '+classfeatured+'\" id=\"'+locationid+'\">';
                }
                else
                {
                    var html=html+'<div class=\"row0 '+classfeatured+'\" id=\"'+locationid+'\">';
                }
                html=html+'<address>';
                html=html+'<a href=\"javascript:launchInfoWindow_" . $s . "('+" . $launchvar . "+')\" style=\"float:left;\"><img src=\"'+geodatas.features[i].properties.icon+'\" class=\"sidebar-icon\" alt=\"'+geodatas.features[i].properties.name+'\"/></a>';
                 html=html+'<span class=\"location-title\"><a href=\"'+geodatas.features[i].properties.url+'\" >'+geodatas.features[i].properties.name+'</a></span>';
                html=html+'<span class=\"label label-important distance\"> <span class=\"distance\" id=\"data-0-" . $s . "\">'+geodatas.features[i].properties.distance+'</span></span>';
                if(geodatas.features[i].properties.rating)
                    {
                 html=html+'<br/>'+geodatas.features[i].properties.rating;
                 }
                 html=html+geodatas.features[i].properties.fulladdress;
                 " . $contentdata . "
                html=html+'</address>';
                 html=html+'</div>';
                 }
                }
                html=html+'</div>';
                jQuery('#resulttop').html(html);
                  " . $sidebar . "
            }
               function setDiv(i)
			{
          	if (typeof jQuery('#location_'+i).position() !== 'undefined'){
					var  scrollheight = jQuery('#location_'+i).position().top;
					var element = document.getElementById('locationresult');
					element.scrollTop = scrollheight;
                    " . $setDiv . "
					jQuery( '.row1,.row0').removeClass( 'locationsactive' );
					jQuery('#location_'+i).addClass('locationsactive');
				}
			}
            ";
            }
            if ($ajax == false) {
                if ($init_mode == 0) {
                    $geojson = MyMaplocationsHelper::CreateJson($items, $searchdata, $component, null, $latitude, $longitude);
                    $finalscript .= " jQuery(document).ready(function() {
                     var promise=" . $geojson . ";
                     var count=countMarker(promise);
                    if(count==0)
						 {}
                         else
                         {
						initialize_" . $s . "(promise);";
                    if ($layout != null) {
                        $finalscript .= "sidebar_" . $s . "(promise)";
                    }
                    $finalscript .= "
                         }
                         });";
                    
                } else {
                    $geojson = MyMaplocationsHelper::CreateJson($items, $searchdata, $component, null, $latitude, $longitude);
                    $finalscript .= "window.addEventListener('load', function (){
                        var promise=" . $geojson . ";
                       ; var count=countMarker(promise);
                    if(count==0)
						 {}
                         else
                         {
                            initialize_" . $s . "(promise);";
                    if ($layout != null) {
                        $finalscript .= "sidebar_" . $s . "(promise)";
                    }
                    $finalscript .= "}
                         }
                         );";
                    
                }
            }
            $result .= "<div class='mmlmap' style='width:" . $width . ";float:left;position:relative;'><div class='map_canvas' id='map_canvas_" . $s . "'  style='width:100%;height:" . $height . ";float:left;position:relative;'></div><input type=\"button\" class=\"resultmymap mymap mymap-danger\" id='backtomap_" . $s . "' style='display:none;float:left;' value=\"" . JText::_("COM_MYMAPLOCATIONS_BACK") . "\" onclick=\"backToMap" . $s . "();\"><input type=\"button\" class=\"resultmymap mymap mymap-primary\" id='print_" . $s . "' style='display:none;float:left;' value=\"" . JText::_("JGLOBAL_PRINT") . "\" onclick=\"printDiv" . $s . "('infobox_" . $s . "');\"/><div class='infoboxdata' id='infobox_" . $s . "' style='width:100%;height:" . $height . ";float:left;clear:both;display:none;overflow:auto;'></div></div>";
            if($enable_route==false)
            {
                $finalstyle.=".mytool span.routeicon,.mytool a.mymap.mymap-inverse.resultmymap.route{display:none;}";
            }
            
            if (($load)) {
                $doc->addStyleDeclaration($finalstyle);
                $doc->addScriptDeclaration($finalscript);
            } else {
                $result .= "<style type='text/css'>" . $finalstyle . "</style>";
                $result .= "<script type='text/javascript'>" . $finalscript . "</script>";
            }
            
            self::$s = $s;
            
            return $result;
        }
        public static function getLeafletStyle($id)
        {
            
            if ($id == 2) {
                $style = " L.tileLayer('https://tiles.wmflabs.org/bw-mapnik/{z}/{x}/{y}.png', {
            	maxZoom: 18,
            	attribution: '&copy; <a href=\"http://www.openstreetmap.org/copyright\" target=\"_blank\">OpenStreetMap</a>'
            })";
            } else if ($id == 3) {
                $style = "L.tileLayer('https://{s}.tile.openstreetmap.fr/hot/{z}/{x}/{y}.png', {
	maxZoom: 19,
	attribution: '&copy; <a href=\"http://www.openstreetmap.org/copyright\"  target=\"_blank\">OpenStreetMap</a>, Tiles courtesy of <a href=\"http://hot.openstreetmap.org/\" target=\"_blank\">Humanitarian OpenStreetMap Team</a>'
        })";
            } else if ($id == 4) {
                $style = "L.tileLayer('https://{s}.tile.opentopomap.org/{z}/{x}/{y}.png', {
	maxZoom: 17,
	attribution: 'Map data: &copy; <a href=\"http://www.openstreetmap.org/copyright\"  target=\"_blank\">OpenStreetMap</a>, <a href=\"http://viewfinderpanoramas.org\" target=\"_blank\">SRTM</a> | Map style: &copy; <a href=\"https://opentopomap.org\" target=\"_blank\">OpenTopoMap</a> (<a href=\"https://creativecommons.org/licenses/by-sa/3.0/\" target=\"_blank\">CC-BY-SA</a>)'
})";
            } else if ($id == 5) {
                $style = "L.tileLayer('https://stamen-tiles-{s}.a.ssl.fastly.net/toner/{z}/{x}/{y}.{ext}', {
	attribution: 'Map tiles by <a href=\"http://stamen.com\"  target=\"_blank\">Stamen Design</a>, <a href=\"http://creativecommons.org/licenses/by/3.0\"  target=\"_blank\">CC BY 3.0</a> &mdash; Map data &copy; <a href=\"http://www.openstreetmap.org/copyright\"  target=\"_blank\">OpenStreetMap</a>',
	subdomains: 'abcd',
	minZoom: 0,
	maxZoom: 20,
	ext: 'png'
})";
            } else if ($id == 6) {
                $style = "L.tileLayer('https://stamen-tiles-{s}.a.ssl.fastly.net/watercolor/{z}/{x}/{y}.{ext}', {
	attribution: 'Map tiles by <a href=\"http://stamen.com\"  target=\"_blank\">Stamen Design</a>, <a href=\"http://creativecommons.org/licenses/by/3.0\"  target=\"_blank\">CC BY 3.0</a> &mdash; Map data &copy; <a href=\"http://www.openstreetmap.org/copyright\"  target=\"_blank\">OpenStreetMap</a>',
	subdomains: 'abcd',
	minZoom: 0,
	maxZoom: 20,
	ext: 'png'
})";
            } else if ($id == 7) {
                $style = "L.tileLayer('https://stamen-tiles-{s}.a.ssl.fastly.net/terrain/{z}/{x}/{y}.{ext}', {
	attribution: 'Map tiles by <a href=\"http://stamen.com\"  target=\"_blank\">Stamen Design</a>, <a href=\"http://creativecommons.org/licenses/by/3.0\"  target=\"_blank\">CC BY 3.0</a> &mdash; Map data &copy; <a href=\"http://www.openstreetmap.org/copyright\"  target=\"_blank\">OpenStreetMap</a>',
	subdomains: 'abcd',
	minZoom: 0,
	maxZoom: 20,
	ext: 'png'
})";
            } else if ($id == 8) {
                $style = "L.tileLayer('https://stamen-tiles-{s}.a.ssl.fastly.net/terrain-background/{z}/{x}/{y}.{ext}', {
	attribution: 'Map tiles by <a href=\"http://stamen.com\"  target=\"_blank\">Stamen Design</a>, <a href=\"http://creativecommons.org/licenses/by/3.0\"  target=\"_blank\">CC BY 3.0</a> &mdash; Map data &copy; <a href=\"http://www.openstreetmap.org/copyright\"  target=\"_blank\">OpenStreetMap</a>',
	subdomains: 'abcd',
	minZoom: 0,
	maxZoom: 20,
	ext: 'png'
})";
            } else if ($id == 10) {
                $params          = JComponentHelper::getParams('com_mymaplocations');
                $customopenstyle = $params->get('customopenmapstyle');
                if ($customopenstyle) {
                    $style = str_replace(array(
                        '\t',
                        '\n'
                    ), array(
                        '',
                        ''
                    ), $customopenstyle);
                } else {
                    $style = "L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
			maxZoom: 18,
			attribution: '&copy; <a href=\"https://www.openstreetmap.org/copyright\" target=\"_blank\">OpenStreetMap</a> contributors'
        	})";
                }
            } else {
                $style = "L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
			maxZoom: 18,
			attribution: '&copy; <a href=\"https://www.openstreetmap.org/copyright\" target=\"_blank\">OpenStreetMap</a> contributors'
        	})";
            }
            
            
            return $style;
        }
        public static function getConstantValue()
        {
            return self::$s;
        }
        
        public static function getLatLongFromPostcode($postcode, $latitude = 0, $longitude = 0)
        {
            $params = JComponentHelper::getParams('com_mymaplocations');
            $data = array();
            $data['lat']=null;
            $data['lang']=null;
            if (($latitude != 0) && ($longitude != 0)) {
                $qscode = $latitude . "," . $longitude;
                if (preg_match('/^(\-?\d+(\.\d+)?),\s*(\-?\d+(\.\d+)?)$/', $qscode, $match)) {
                    $data['lat']  = $latitude;
                    $data['lang'] = $longitude;
                    return $data;
                }
            }
            
            if (preg_match('/^(\-?\d+(\.\d+)?),\s*(\-?\d+(\.\d+)?)$/', $postcode, $match)) {
                $data['lat']  = $match[1];
                $data['lang'] = $match[3];
                return $data;
            }
           
            $customjson = $params->get('customjson');
            
            if ($customjson) {
                $customdata = json_decode($customjson, true);
                
                foreach ($customdata as $cdata) {
                    if ($cdata['location'] == $postcode) {
                        $data['lat']  = $cdata['lat'];
                        $data['lang'] = $cdata['long'];
                        return $data;
                    }
                }
                
            }
             $autocomplete_type= $params->get('autocomplete_type', 1);
            if($autocomplete_type==4) 
            {
                  $baidukey      = $params->get('baiduapi', '');
                  $postcode = urlencode(trim($postcode));
                  $file     = "https://api.map.baidu.com/geocoding/v3/?address=".$postcode."&output=json&ak=".$baidukey;
                $geoloc = MyMaplocationsHelper::getCurlData($file);
                if (@$geoloc['status'] == 'OK') {
                    $data['lat']  = $geoloc['result']['location']['lat'];
                    $data['lang'] = $geoloc['result']['location']['lng'];
                    $data['lang'] = str_replace(",",".",$data['lang']);
                    $data['lat'] = str_replace(",",".",$data['lat']);
                    return $data;
                } 
                   
            }
            
            /* remove spaces from postcode */
            $postcode = urlencode(trim($postcode));
            /* connect to the google geocode service */
            jimport('joomla.application.component.helper');
            $country = $params->get('country', null);
            $googleapi= $params->get('googleapi');
            $bingapi= $params->get('bingapi');
            $mapquestapi  = $params->get('mapquestapi');
            $mapboxapi    = $params->get('mapboxapi');
            $opencageapi=$params->get('opencageapi');
            if (($googleapi)) {
               $file     = "https://maps.googleapis.com/maps/api/geocode/json?address=$postcode";
                if (!empty($country)) {
                $file .= "&components=country:" . $country;
                }
                $file .= '&key=' . $googleapi;
                $geoloc = MyMaplocationsHelper::getCurlData($file);
               if (@$geoloc['status'] == 'OK') {
                    $data['lat']  = $geoloc['results'][0]['geometry']['location']['lat'];
                    $data['lang'] = $geoloc['results'][0]['geometry']['location']['lng'];
                    $data['lang'] = str_replace(",",".",$data['lang']);
                    $data['lat'] = str_replace(",",".",$data['lat']);
                    return $data;
                } 
            }
            if($mapquestapi)
            {  
               $file="https://www.mapquestapi.com/geocoding/v1/address?key=".$mapquestapi."&format=json&location=".str_ireplace(" ", "%20", $postcode)."&limit=1";
                $geoloc = MyMaplocationsHelper::getCurlData($file);
                 if($geoloc['info']['statuscode']==0)
                {
                    $data['lat']  =$geoloc['results'][0]['locations'][0]['displayLatLng']['lat'];
                    $data['lang']=$geoloc['results'][0]['locations'][0]['displayLatLng']['lng'];
                    $data['lang'] = str_replace(",",".",$data['lang']);
                    $data['lat'] = str_replace(",",".",$data['lat']);
                    return $data;
                }
            }
            if($bingapi)
            {
               
                $file         = "https://dev.virtualearth.net/REST/v1/Locations/" . str_ireplace(" ", "%20", urldecode($postcode)) . "?key=$bingapi&maxResults=1";
                 $geoloc = MyMaplocationsHelper::getCurlData($file);
                 
                if(($geoloc['authenticationResultCode']=="ValidCredentials")&&(count($geoloc['resourceSets'])==1))
                {
                    $data['lat']  = $geoloc['resourceSets'][0]['resources'][0]['point']['coordinates'][0];
                    $data['lang'] = $geoloc['resourceSets'][0]['resources'][0]['point']['coordinates'][1];
                    $data['lang'] = str_replace(",",".",$data['lang']);
                    $data['lat'] = str_replace(",",".",$data['lat']);
                    return $data;
                }   
            }
            if($opencageapi)
            {
                $file         = "https://api.opencagedata.com/geocode/v1/json?q=".str_ireplace(" ", "%20", urldecode($postcode)). "&key=".$opencageapi."&limit=1";
                 $geoloc = MyMaplocationsHelper::getCurlData($file);
                 if($geoloc['status']['code']=="200")
                 {
                    $data['lat']  = $geoloc['results'][0]['geometry']['lat'];
                    $data['lang'] = $geoloc['results'][0]['geometry']['lng'];
                    $data['lang'] = str_replace(",",".",$data['lang']);
                    $data['lat'] = str_replace(",",".",$data['lat']);
                    return $data;
                 }
                
            }
             $file = "https://geocode.arcgis.com/arcgis/rest/services/World/GeocodeServer/find?text=" . str_ireplace(" ", "%20", $postcode) . "&f=pjson";
             if (!empty($country)) {
                $file .= "&sourceCountry=" . $country;
                }
             $geoloc = MyMaplocationsHelper::getCurlData($file);
                if ($geoloc['locations'][0]['feature']['attributes']['Addr_Type'] == "LatLong") {
                         $data['lang'] = $geoloc['locations'][0]['feature']['geometry']['y'];
                        $data['lat']  = $geoloc['locations'][0]['feature']['geometry']['x'];
                        $data['lang'] = str_replace(",",".",$data['lang']);
                        $data['lat'] = str_replace(",",".",$data['lat']);
                        return $data;
                    } else {
                        $data['lang'] = $geoloc['locations'][0]['feature']['geometry']['x'];
                        $data['lat']  = $geoloc['locations'][0]['feature']['geometry']['y'];
                        $data['lang'] = str_replace(",",".",$data['lang']);
                        $data['lat'] = str_replace(",",".",$data['lat']);
                        return $data;
                    }
                
            return $data;
        }
        public static function getCurlData($file)
        {
            if (function_exists('curl_version')) {
                     $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $file);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                $geoloc = json_decode(curl_exec($ch), true);
                curl_close($ch);
                }
                else
                {
                    $contents = file_get_contents($file);
                    $geoloc   = json_decode($contents, true);
                }
                return $geoloc;
                
        }
        public static function getTag($component = "com_mymaplocations")
        {
            
                $mainframe       = JFactory::getApplication();
            if ($component == "com_k2") {
                $user            = JFactory::getUser();
                $aid             = (int) $user->get('aid');
                $db              = JFactory::getDBO();
                $order_direction = '';
                $order_value     = 'rand()';
                $jnow            = JFactory::getDate();
                $now             = K2_JVERSION == '15' ? $jnow->toMySQL() : $jnow->toSql();
                $nullDate        = $db->getNullDate();
                $query           = "SELECT i.id FROM #__k2_items as i";
                $query .= " LEFT JOIN #__k2_categories c ON c.id = i.catid";
                $query .= " WHERE i.published=1 ";
                $query .= " AND ( i.publish_up = " . $db->Quote($nullDate) . " OR i.publish_up <= " . $db->Quote($now) . " ) ";
                $query .= " AND ( i.publish_down = " . $db->Quote($nullDate) . " OR i.publish_down >= " . $db->Quote($now) . " )";
                $query .= " AND i.trash=0 ";
                if (K2_JVERSION != '15') {
                    $query .= " AND i.access IN(" . implode(',', $user->getAuthorisedViewLevels()) . ") ";
                } else {
                    $query .= " AND i.access <= {$aid} ";
                }
                $query .= " AND c.published=1 ";
                $query .= " AND c.trash=0 ";
                if (K2_JVERSION != '15') {
                    $query .= " AND c.access IN(" . implode(',', $user->getAuthorisedViewLevels()) . ") ";
                } else {
                    $query .= " AND c.access <= {$aid} ";
                }
                if (K2_JVERSION != '15') {
                    if ($mainframe->getLanguageFilter()) {
                        $languageTag = JFactory::getLanguage()->getTag();
                        $query .= " AND c.language IN (" . $db->Quote($languageTag) . ", " . $db->Quote('*') . ") AND i.language IN (" . $db->Quote($languageTag) . ", " . $db->Quote('*') . ") ";
                    }
                }
                if (K2_JVERSION != '15') {
                    if ($mainframe->getLanguageFilter()) {
                        $languageTag = JFactory::getLanguage()->getTag();
                        $query .= " AND c.language IN (" . $db->Quote($languageTag) . ", " . $db->Quote('*') . ") AND i.language IN (" . $db->Quote($languageTag) . ", " . $db->Quote('*') . ") ";
                    }
                }
                
                $db->setQuery($query);
                $IDs = K2_JVERSION == '30' ? $db->loadColumn() : $db->loadResultArray();
                if (!is_array($IDs) || !count($IDs)) {
                    return array();
                }
                $query = "SELECT tag.name as title, tag.id,count(xref.tagID) AS count
        FROM #__k2_tags as tag
        LEFT JOIN #__k2_tags_xref AS xref ON xref.tagID = tag.id 
        WHERE xref.itemID IN (" . implode(',', $IDs) . ") 
        AND tag.published = 1 ";
                $query .= "  GROUP BY xref.tagID HAVING COUNT(xref.tagID) > 0 ";
                $query .= " ORDER BY tag.name";
                $db->setQuery($query);
                $rows = $db->loadObjectList();
                return $rows;
            } else if ($component == "com_zoo") {
                $db          = JFactory::getDbo();
                $contentType = "com_mymaplocations.location";
                $getTagData  = true;
                $query       = $db->getQuery(true)->select('DISTINCT m.name,m.name as title,m.name as id')->from($db->quoteName('#__zoo_tag') . ' AS m ');
                $query->order('m.name');
                $db->setQuery($query);
                $itemTags = $db->loadObjectList();
                
            }
            
            else if ($component == "com_hikamarket") {
                $db          = JFactory::getDbo();
                $contentType = "com_hikashop.product";
                $getTagData  = true;
                $query       = $db->getQuery(true)->select('DISTINCT m.tag_id')->from($db->quoteName('#__contentitem_tag_map') . ' AS m ')->where(array(
                    $db->quoteName('m.type_alias') . ' = ' . $db->quote($contentType),
                    $db->quoteName('t.published') . ' = 1'
                ));
                
                $user   = JFactory::getUser();
                $groups = implode(',', $user->getAuthorisedViewLevels());
                
                $query->where('t.access IN (' . $groups . ')');
                if ($mainframe->getLanguageFilter()) {
                    $language = JHelperContent::getCurrentLanguage();
                    $query->where($db->quoteName('language') . ' IN (' . $db->quote($language) . ', ' . $db->quote('*') . ')');
                }
                
                if ($getTagData) {
                    $query->select($db->quoteName('t') . '.*');
                }
                
                $query->join('INNER', $db->quoteName('#__tags') . ' AS t ' . ' ON ' . $db->quoteName('m.tag_id') . ' = ' . $db->quoteName('t.id'));
                $query->order('t.title');
                $db->setQuery($query);
                $itemTags = $db->loadObjectList();
            } else if ($component == "com_easyblog") {
                $db    = JFactory::getDbo();
                $query = $db->getQuery(true)->select('DISTINCT m.title,m.title as title,m.id as id')->from($db->quoteName('#__easyblog_tag') . ' AS m ');
                $query->order('m.title');
                $db->setQuery($query);
                $itemTags = $db->loadObjectList();
            } else if ($component == "com_content") {
                if ((JFolder::exists(JPATH_SITE . '/components/com_flexicontent/'))) {
                    $db         = JFactory::getDbo();
                    $getTagData = true;
                    $query      = $db->getQuery(true)->select('DISTINCT m.tid as id')->select('t.name as title')->from($db->quoteName('#__flexicontent_tags_item_relations') . ' AS m ');
                    $query->join('INNER', $db->quoteName('#__flexicontent_tags') . ' AS t ' . ' ON ' . $db->quoteName('m.tid') . ' = ' . $db->quoteName('t.id'));
                    $query->where('t.published=1');
                    $query->order('t.name');
                    $db->setQuery($query);
                    $itemTags = $db->loadObjectList();
                } else {
                    $db          = JFactory::getDbo();
                    $contentType = "com_content.article";
                    $getTagData  = true;
                    $query       = $db->getQuery(true)->select('DISTINCT m.tag_id')->from($db->quoteName('#__contentitem_tag_map') . ' AS m ')->where(array(
                        $db->quoteName('m.type_alias') . ' = ' . $db->quote($contentType),
                        $db->quoteName('t.published') . ' = 1'
                    ));
                    
                    $user   = JFactory::getUser();
                    $groups = implode(',', $user->getAuthorisedViewLevels());
                    
                    $query->where('t.access IN (' . $groups . ')');
                    
                                    if ($mainframe->getLanguageFilter()) {
                    $language = JHelperContent::getCurrentLanguage();
                    $query->where($db->quoteName('language') . ' IN (' . $db->quote($language) . ', ' . $db->quote('*') . ')');
                }
                    
                    if ($getTagData) {
                        $query->select($db->quoteName('t') . '.*');
                    }
                    
                    $query->join('INNER', $db->quoteName('#__tags') . ' AS t ' . ' ON ' . $db->quoteName('m.tag_id') . ' = ' . $db->quoteName('t.id'));
                    $query->order('t.title');
                    $db->setQuery($query);
                    $itemTags = $db->loadObjectList();
                    
                }
            } else {
                $db          = JFactory::getDbo();
                $contentType = "com_mymaplocations.location";
                $getTagData  = true;
                $query       = $db->getQuery(true)->select('DISTINCT m.tag_id')->from($db->quoteName('#__contentitem_tag_map') . ' AS m ')->where(array(
                    $db->quoteName('m.type_alias') . ' = ' . $db->quote($contentType),
                    $db->quoteName('t.published') . ' = 1'
                ));
                
                $user   = JFactory::getUser();
                $groups = implode(',', $user->getAuthorisedViewLevels());
                
                $query->where('t.access IN (' . $groups . ')');
                
                // Optionally filter on language
                $language = JComponentHelper::getParams('com_tags')->get('tag_list_language_filter', 'all');
                
                if ($mainframe->getLanguageFilter()) {
                    $language = JHelperContent::getCurrentLanguage();
                    $query->where($db->quoteName('language') . ' IN (' . $db->quote($language) . ', ' . $db->quote('*') . ')');
                }
                
                if ($getTagData) {
                    $query->select($db->quoteName('t') . '.*');
                }
                
                $query->join('INNER', $db->quoteName('#__tags') . ' AS t ' . ' ON ' . $db->quoteName('m.tag_id') . ' = ' . $db->quoteName('t.id'));
                $query->order('t.title');
                $db->setQuery($query);
                $itemTags = $db->loadObjectList();
            }
            return $itemTags;
        }
        public function getCityList($cities)
        {
            $html = "";
            $html .= "<span class='loclist'>";
            foreach ($cities as $key => $city) {
                if (($key - 1 == -1) || ($cities[$key]->country != $cities[$key - 1]->country)) {
                    $html .= ("<h3>" . $city->country . "</h3>");
                }
                
                $html .= ("<span class='location'><span class='locationstate'>" . $city->locationstate . "</span>,");
                $url = JRoute::_("index.php?option=com_mymaplocations&view=locations&city=" . $city->town);
                $html .= "<span class='city'><a href='" . $url . "'>" . $city->town . "</a></span></span>";
            }
            $html .= "</span>";
            return $html;
        }
        
        public static function getUrlLink($item)
        {
            if ($item->id == 0) {
                return;
            }
            if (empty($item->component)) {
                $item->component = 'com_mymaplocations';
            }
            $params     = JComponentHelper::getParams('com_mymaplocations');
            $itemid     = MyMaplocationsHelper::getMenuId($item->component);
            $globalmenu = $itemid[$item->component];
            if($item->component=="com_custom")
            {
                $url=MyMaplocationsHelper::getCustomUrl($item);
                return $url;
            }
            
            if ($item->component == "com_k2") {
                require_once(JPATH_SITE . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_k2' . DIRECTORY_SEPARATOR . 'helpers' . DIRECTORY_SEPARATOR . 'route.php');
                require_once(JPATH_SITE . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_k2' . DIRECTORY_SEPARATOR . 'helpers' . DIRECTORY_SEPARATOR . 'utilities.php');
                $url = urldecode(JRoute::_(K2HelperRoute::getItemRoute($item->extra_id . ':' . urlencode($item->k2alias), $item->k2catid . ':' . urlencode($item->k2catalias))));
            } else if ($item->component == "com_comprofiler") {
                global $_CB_framework;
                $url = $_CB_framework->userProfileUrl((int) $item->extra_id, false);
            } else if ($item->component == "com_hikamarket") {
                $furl = 'product&task=show&cid=' . (int) $item->product_id . '&name=' . $item->alias;
                if ($globalmenu) {
                    $furl .= '&Itemid=' . $globalmenu;
                }
                $url = hikashop_completeLink($furl);
            } else if ($item->component == "com_hikashop") {
                $furl = 'vendor&task=show&cid=' . $item->extra_id . '&name=' . $item->vendor_alias;
                if ($globalmenu) {
                    $furl .= '&Itemid=' . $globalmenu;
                }
                $url = hikamarket::completeLink($furl);
            } else if ($item->component == "com_community") {
                include_once(JPATH_BASE . '/components/com_community/defines.community.php');
                require_once(JPATH_BASE . '/components/com_community/libraries/core.php');
                $url = CRoute::_('index.php?option=com_community&view=profile&userid=' . $item->id);
            } else if ($item->component == "com_easysocial") {
                $url = $item->url;
            } else if ($item->component == "com_easyblog") {
                $url = $item->url;
            } else if ($item->component == "com_mytestimonials") {
                if (($globalmenu)) {
                    $url = JRoute::_("index.php?option=com_mytestimonials&view=testimonial&id=" . $item->id . "&Itemid=" . $globalmenu);
                } else {
                    $url = JRoute::_('index.php?option=com_mytestimonials&view=testimonial=' . $item->id);
                }
            } else if ($item->component == "com_ohanah") {
                if (($globalmenu)) {
                    $url = JRoute::_('index.php?option=com_ohanah&view=event&id=' . $item->id . '&format=html&Itemid=' . $globalmenu);
                } else {
                    $url = JRoute::_('index.php?option=com_ohanah&view=event&id=' . $item->id . '&format=html');
                }
            } else if ($item->component == "com_eventbooking") {
                require_once JPATH_ROOT . '/components/com_eventbooking/helper/helper.php';
                require_once JPATH_ROOT . '/components/com_eventbooking/helper/route.php';
                require_once JPATH_ROOT . '/components/com_eventbooking/helper/jquery.php';
                $url = JRoute::_(EventbookingHelperRoute::getEventRoute($item->id, 0, $globalmenu));
            } else if ($item->component == "com_zoo") {
                require_once(JPATH_ADMINISTRATOR . '/components/com_zoo/config.php');
                $app  = App::getInstance('zoo');
                $link = 'index.php?option=' . $app->component->self->name . '&task=item&item_id=' . $item->id;
                if ($globalmenu) {
                    $link .= '&Itemid=' . $globalmenu;
                }
                $link = JRoute::_($link);
                return $link;
            } else if ($item->component == "com_content") {
                
                if ((JFolder::exists(JPATH_SITE . '/components/com_flexicontent/'))) {
                    require_once(JPATH_SITE . '/administrator/components/com_flexicontent/defineconstants.php');
                    require_once(JPATH_SITE . '/components/com_flexicontent/helpers/route.php');
                    $link = JRoute::_(FlexicontentHelperRoute::getItemRoute($item->slug, $item->categoryslug, null, $item));
                } else {
                     if (version_compare(JVERSION, '4.0', 'ge'))
                    {
                       $item->slug = $item->alias ? ($item->extra_id . ':' . $item->alias) : $item->extra_id;
                       $link = JRoute::_( Joomla\Component\Content\Site\Helper\RouteHelper::getArticleRoute($item->slug, $item->catid));
                    }
                    else
                    {
                    require_once JPATH_SITE . '/components/com_content/helpers/route.php';
                    $item->slug = $item->alias ? ($item->extra_id . ':' . $item->alias) : $item->extra_id;
                    $link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid));
                    }
                }
                return $link;
            } else if ($item->component == "com_adsmanager") {
                $url = @TRoute::_("index.php?option=com_adsmanager&view=details&id=" . $item->id . "&catid=" . $item->catid);
            } else if ($item->component == "com_djclassifieds") {
                require_once(JPATH_BASE . '/administrator/components/com_djclassifieds/lib/djseo.php');
                $url = JRoute::_(DJClassifiedsSEO::getItemRoute($item->id . ':' . $item->alias, $item->cat_id . ':' . $item->c_alias));
            }
            else if($item->component=="com_virtuemart")
            {
						$url = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $item->virtuemart_product_id  . '&virtuemart_category_id=' . $item->catid);
            }
            else {
                if ((@$item->extlink) && ($item->exturl)) {
                    if (strpos($item->exturl, 'menu:') !== false) {
                        $link     = explode(":", $item->exturl);
                        $menuitem = intval($link[1]);
                        $url      = JRoute::_('index.php?Itemid=' . $menuitem);
                    } else {
                        $url = $item->exturl;
                    }
                } else if (!empty($globalmenu)) {
                    $url = JRoute::_("index.php?option=com_mymaplocations&view=location&id=" . $item->id . "&Itemid=" . $globalmenu);
                } else {
                    $url = JRoute::_("index.php?option=com_mymaplocations&view=location&id=" . $item->id);
                }
            }
            $url = str_replace("'", "&apos;", $url);
            return $url;
        }
        public static function getMenuId($component)
        {
            $params = JComponentHelper::getParams('com_mymaplocations');
            
            if ((!@static::$itemid[$component]) && ($component == 'com_mymaplocations')) {
                $globalmenu                 = MyMaplocationsHelper::getAscociation($params->get('globalmenu'));
                static::$itemid[$component] = $globalmenu;
            } else if ((!@static::$itemid[$component]) && ($component == 'com_zoo')) {
                
                $globalmenu                 = MyMaplocationsHelper::getAscociation($params->get('globalzoomenu'));
                static::$itemid[$component] = $globalmenu;
            } else if ((!@static::$itemid[$component]) && ($component == 'com_ohanah')) {
                
                $globalmenu                 = MyMaplocationsHelper::getAscociation($params->get('globalohanamenu'));
                static::$itemid[$component] = $globalmenu;
            } else if ((!@static::$itemid[$component]) && ($component == 'com_mytestimonials')) {
                $globalmenu                 = MyMaplocationsHelper::getAscociation($params->get('globalmytmenu'));
                static::$itemid[$component] = $globalmenu;
            } else if ((!@static::$itemid[$component]) && ($component == 'com_eventbooking')) {
                $globalmenu                 = MyMaplocationsHelper::getAscociation($params->get('globalebmenu'));
                static::$itemid[$component] = $globalmenu;
            } else if ((!@static::$itemid[$component]) && ($component == 'com_hikamarket')) {
                
                require_once JPATH_ADMINISTRATOR . '/components/com_hikashop/helpers/helper.php';
                $config     = @hikashop::config();
                $menusClass = hikashop_get('class.menus');
                $menu_id    = $menusClass->getPublicMenuItemId();
                
                static::$itemid[$component] = $menu_id;
            } else if ((!@static::$itemid[$component]) && ($component == 'com_hikashop')) {
                require_once JPATH_ADMINISTRATOR . '/components/com_hikamarket/helpers/helper.php';
                $config = hikamarket::config();
                
                $url_itemid                 = (int) $config->get('edition_default_menu', 0);
                static::$itemid[$component] = $url_itemid;
            } else {
                static::$itemid[$component] = null;
                
            }
            return static::$itemid;
        }
        public static function getAscociation($globalamenu)
        {
            $assoc = JLanguageAssociations::isEnabled();
            if ($assoc) {
                JLoader::register('MenusHelper', JPATH_ADMINISTRATOR . '/components/com_menus/helpers/menus.php');
                $associations = MenusHelper::getAssociations($globalamenu);
                $lang_code    = JFactory::getLanguage()->getTag();
                if (@$associations[$lang_code]) {
                    $globalamenu = $associations[$lang_code];
                }
            }
            return $globalamenu;
        }
        
        public static function formatField($field)
        {
            if (is_numeric($field)) {
                $field = $field . "px";
            }
            return $field;
        }
        
        public static function addLocalization()
        {
            if (self::$language == 0) {
                $language       = JFactory::getLanguage();
                $tag            = $language->gettag();
                $ctag           = explode("-", $tag);
                self::$language = $ctag[0];
                $lang           = "&language=" . $ctag[0];
                self::$language++;
                return $lang;
            }
        }
        
        public static function formatJS($string)
        {
            $string = str_replace("'", "&apos;", $string);
            $string = str_replace("\n", '\n', str_replace('"', '\"', addcslashes(str_replace("\r", '', (string) ($string)), "\0..\37'\\")));
            return $string;
        }
        
        public static function checkComponent($component)
        {
            jimport('joomla.filesystem.folder');
            if($component=="com_custom")
            {
                return true;
            }
            if($component=="com_communityevents")
            {
                $component="com_community";
            }
            if ((JFolder::exists(JPATH_SITE . '/components/' . $component . '/'))) {
                if (JComponentHelper::getComponent($component, true)->enabled) {
                    if ($component == "com_adsmanager") {
                        $db    = JFactory::getDbo();
                        $query = "SELECT * FROM #__adsmanager_fields WHERE type = 'gmap'";
                        $db->setQuery($query);
                        $result = $db->loadObject();
                        if ($result == null) {
                            JFactory::getApplication()->enqueueMessage(JTEXT::_('Gmap Field not found in adsmanager'));
                            return false;
                        }
                    }
                    return true;
                }
            } else {
                JFactory::getApplication()->enqueueMessage(JTEXT::_($component . ' ' . JTEXT::_('JERROR_LAYOUT_REQUESTED_RESOURCE_WAS_NOT_FOUND')));
                return false;
            }
        }
        
        public static function getLocationList($id = 0, $component = "com_mymaplocations", $limit = 0)
        {
            $options = MyMaplocationsHelper::getDataList($id, $component, $limit);
            if (empty($options)) {
                return;
            }
            $html = '<select class="maplist custom-select" onchange="top.location.href=this.options[this.selectedIndex].value" style="width: auto" name="locationlist">';
            $html .= '<option value="">' . JText::_('JGLOBAL_SELECT_AN_OPTION') . '</option>';
            foreach ($options as $option) {
                $option->component = $component;
                $html .= '<option value="' . MyMaplocationsHelper::getUrlLink($option) . '">' . $option->name . '</option>';
            }
            $html .= "</select>";
            return $html;
        }
        public static function createVendorMap($vendor)
        {
            
            $db    = JFactory::getDBO();
            $query = $db->getQuery(true);
            $query->select('*');
            $query->from('#__mymaplocations_location');
            $query->where('extra_id = ' . $vendor->vendor_id);
            $query->where('component = ' . $db->quote('com_hikamarket'));
            $db->setQuery($query);
            $result          = $db->loadObject();
            $plugin          = JPluginHelper::getPlugin('hikamarket', 'mymaplocations');
            $params          = new JRegistry($plugin->params);
            $company         = $params->get('vendor_company_column', 'vendor_address_company');
            $address         = $params->get('vendor_address_column', 'vendor_address_street');
            $city            = $params->get('vendor_city_column', 'vendor_address_city');
            $st              = $params->get('vendor_state_column', 'vendor_address_state');
            $country         = $params->get('vendor_country_column', 'vendor_address_country');
            $czip            = $params->get('vendor_zip_column', 'vendor_address_post_code');
            $result->name    = $vendor->$company;
            $result->address = $vendor->$address;
            $result->town    = $vendor->$city;
            $sql             = "select zone_name_english from #__hikashop_zone where zone_namekey=" . $db->Quote($vendor->$st);
            $db->setQuery($sql);
            $locstate              = $db->loadObject();
            $result->locationstate = $locstate->zone_name_english;
            
            $sql = "select zone_name_english from #__hikashop_zone where zone_namekey=" . $db->Quote($vendor->$country);
            $db->setQuery($sql);
            $country         = $db->loadObject();
            $result->country = $country->zone_name_english;
            $result->postal  = $vendor->$czip;
            $res[]           = $result;
            $map             = MyMapLocationsHelper::CreateMap($res);
            return $map;
        }
        public static function getHikaprice($pid, $tax_id)
        {
            $arr                    = array();
            $arr[0]                 = new stdClass();
            $arr[0]->product_id     = $pid;
            $arr[0]->product_tax_id = $tax_id;
            $currency               = hikashop_get('type.currency');
            $currencyClass          = hikashop_get('class.currency');
            $zone                   = hikashop_getZone();
            $cur                    = hikashop_getCurrency();
            $currencyClass->getListingPrices($arr, $zone, $cur);
            $i         = 0;
            $currPrice = 0;
            if (@$arr[0]->prices) {
                foreach ($arr[0]->prices as $k => $price) {
                    if (!$i) {
                        $currPrice = $price->price_value_with_tax;
                    }
                    if ($price->price_value_with_tax < $currPrice)
                        $currPrice = $price->price_value_with_tax;
                    $i++;
                }
            }
            
            return $currencyClass->format($currPrice, $cur);
        }
        public static function getDataList($id = 0, $component = "com_mymaplocations", $limit = 0)
        {
            
            $db    = JFactory::getDBO();
            $data=JFactory::getApplication()->input->getString('query','');
            $data = $db->quote($db->escape($data, true) . '%', false);
            $query = $db->getQuery(true);
            if (!$id) {
                return;
            }
            
            $query->select($db->quoteName(array(
                'id',
                'name'
            )));
            
            $query->where(' name LIKE'.$data);
            $query->from('#__mymaplocations_location');
            $query->where('id != ' . $id);
            if ($component == "com_mymaplocations") {
                $query->where(' ( component = ' . $db->quote($component) . ' OR component=' . $db->quote("") . ') ');
            } else {
                $query->where(' component = ' . $db->quote($component));
            }
            if (JLanguageMultilang::isEnabled()) {
                $query->where('language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
            }
            $query->where('state= 1');
            $query->order('name ASC');
            try{
				 $db->setQuery($query);
				}
						catch (Exception $e)
						{
		echo $e->getMessage();
            exit;						
						}
            
            return $db->loadObjectList();
        }
        public static function getDataZipList($id = 0, $component = "com_mymaplocations", $limit = 0)
        {
            $db    = JFactory::getDBO();
            $data=JFactory::getApplication()->input->getString('query','');
            $data = $db->quote($db->escape($data, true) . '%', false);
            $query = $db->getQuery(true);
            $query->select('distinct(postal)');
            $query->from('#__mymaplocations_location');
            if ($component == "com_mymaplocations") {
                $query->where(' ( component = ' . $db->quote($component) . ' OR component=' . $db->quote("") . ') ');
            } else {
                $query->where(' component = ' . $db->quote($component));
            }
            if (JLanguageMultilang::isEnabled()) {
                $query->where('language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
            }
             $query->where(' postal LIKE'.$data);
            $query->where('state= 1');
            $query->order('postal ASC');
           try{
				 $db->setQuery($query);
				}
						catch (Exception $e)
						{
		echo $e->getMessage();
            exit;						
						}
            return $db->loadObjectList();
        }
        public static function loadLanguage()
        {
            $lang = JFactory::getLanguage();
            $lang->load('com_mymaplocations', JPATH_ADMINISTRATOR . '/components/com_mymaplocations', null, true);
            $lang->load('com_mymaplocations.override', JPATH_ADMINISTRATOR . '/components/com_mymaplocations', null, true);
            $lang->load('com_mymaplocations.sys', JPATH_ADMINISTRATOR . '/components/com_mymaplocations', null, true);
        }
        
        public static function createContactLink($contactlink, $target = null)
        {
            if ($target == null) {
                $params = JComponentHelper::getParams('com_mymaplocations');
                $target = $params->get('target', 1);
            }
            $mymap = "";
            if (strpos($contactlink, 'menu:') !== false) {
                $link        = explode(":", $contactlink);
                $menuitem    = intval($link[1]);
                $contactlink = JRoute::_('index.php?Itemid=' . $menuitem);
            }
            
            switch ($target) {
                case 1:
                    // open in a new window
                    $mymap = '<span class="contacticon"></span><a href="' . $contactlink . '" target="_blank" class="resultmymap mymap mymap-inverse contact-btn" rel="nofollow">' . JText::_('COM_MYMAPLOCATIONS_CONTACT') . '</a>';
                    break;
                
                case 2:
                    // open in a popup window
                    $attribs = 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes';
                    $mymap   = "<span class='contacticon'></span><a href=\"$contactlink\" onclick=\"window.open(this.href, 'targetWindow', '" . $attribs . "'); return false;\" class='resultmymap mymap mymap-inverse contact-btn'>" . JText::_('COM_MYMAPLOCATIONS_CONTACT') . '</a>';
                    break;
                case 3:
                    // open in a new window
                    $mymap = '<span class="contacticon"></span><a href="' . $contactlink . '" target="_blank" class="resultmymap mymap mymap-inverse contact-btn" rel="nofollow">' . JText::_('COM_MYMAPLOCATIONS_CONTACT') . '</a>';
                    break;
                
                default:
                    // open in parent window
                    $mymap = '<span class="contacticon"></span><a href="' . $contactlink . '" rel="nofollow" class="resultmymap mymap mymap-inverse contact-btn">' . JText::_('COM_MYMAPLOCATIONS_CONTACT') . ' </a>';
                    break;
            }
            return $mymap;
        }
        public static function getCommunityAddress($userid)
        {
            require_once(JPATH_ROOT . '/components/com_community/libraries/core.php');
            $config = CFactory::getConfig();
            $user   = CFactory::getUser($userid);
            $params = $user->getParams();
            $lang   = JFactory::getLanguage();
            $lang->load('com_community.country', JPATH_SITE);
            $item                = new stdClass();
            $item->address       = JText::_($user->getInfo($config->get('fieldcodestreet')));
            $item->town          = JText::_($user->getInfo($config->get('fieldcodecity')));
            $item->locationstate = JText::_($user->getInfo($config->get('fieldcodestate')));
            $item->country       = JText::_($user->getInfo($config->get('fieldcodecountry')));
            $item->postal        = JText::_($user->getInfo($config->get('fieldcodepostcode')));
            $item->component     = "com_community";
            $item->id            = $userid;
            if (($item->address == null) || ($item->town == null) || ($item->locationstate == null) || ($item->postal == null) || ($item->country == null)) {
                $location      = json_decode($user->getInfo($config->get('fieldcodelocation')));
                $item->address = $location->name;
                $item->town    = $location->desc;
                $address       = MyMaplocationsHelper::formatAddress($item);
            } else {
                $address = MyMaplocationsHelper::formatAddress($item);
            }
            return $address;
        }
        
        public static function getCommunityLogo($userid)
        {
            require_once(JPATH_ROOT . '/components/com_community/libraries/core.php');
            $config = CFactory::getConfig();
            $user   = CFactory::getUser($userid);
            $avatar = $user->getThumbAvatar();
            return $avatar;
        }
        public static function getCbField()
        {
            $db    = JFactory::getDBO();
            $query = $db->getQuery(true);
            $query->select($db->quoteName('params'));
            $query->from('#__comprofiler_plugin');
            $query->where(' element = ' . $db->quote('mymaplocations'));
            try{
				 $db->setQuery($query);
				}
						catch (Exception $e)
						{
		echo $e->getMessage();
            exit;						
						}
            $result = $db->loadObject();
            $param  = json_decode($result->params, true);
            if (empty($param)) {
                $param = parse_ini_string($result->params);
            }
            $usedefault = $param['usedefault'];
            
            if ($usedefault == 0) {
                return;
            }
            $data         = array();
            $extra_fields = array();
            if (!empty($param['address']))
                $data[] = $param['address'];
            if (!empty($param['city']))
                $data[] = $param['city'];
            if (!empty($param['locationstate']))
                $data[] = $param['locationstate'];
            if (!empty($param['country']))
                $data[] = $param['country'];
            if (!empty($param['postal']))
                $data[] = $param['postal'];
            if (!empty($param['phone']))
                $data[] = $param['phone'];
            if ($param['extra_fields']) {
                $extra_fields = explode('|*|', $param['extra_fields']);
                foreach ($extra_fields as $extra_field) {
                    $data[] = $extra_field;
                }
            }
            
            $sql = "SELECT * from  #__comprofiler_fields where fieldid IN (" . implode(',', $data) . ")";
            $db->setQuery($sql);
            $fieldDatas                  = $db->loadObjectList();
            $finalfields                 = array();
            $finalfields['extra_fields'] = array();
            foreach ($fieldDatas as $fielddata) {
                
                if (($param['address'] == $fielddata->fieldid)) {
                    $finalfields['address'] = $fielddata->name;
                }
                if (($param['city'] == $fielddata->fieldid)) {
                    $finalfields['city'] = $fielddata->name;
                }
                if (($param['locationstate'] == $fielddata->fieldid)) {
                    $finalfields['locationstate'] = $fielddata->name;
                }
                if (($param['country'] == $fielddata->fieldid)) {
                    $finalfields['country'] = $fielddata->name;
                }
                if (($param['postal'] == $fielddata->fieldid)) {
                    $finalfields['postal'] = $fielddata->name;
                }
                if (($param['phone'] == $fielddata->fieldid)) {
                    $finalfields['phone'] = $fielddata->name;
                }
                if ($param['extra_fields']) {
                    $extra_fields = explode('|*|', $param['extra_fields']);
                    foreach ($extra_fields as $extra_field) {
                        if (($fielddata->fieldid == $extra_field)) {
                            $finalfields['extra_fields'][] = $fielddata->name;
                        }
                    }
                }
                
            }
            return $finalfields;
        }
        public static function getCbAddress($qitem, $mmlfield)
        {
            $cbitem       = new stdClass();
            $extra_fields = "";
            $items        = $qitem;
            if ($mmlfield['address']) {
                $address         = $mmlfield['address'];
                $cbitem->address = @$qitem->$address;
            }
            if (@$mmlfield['city']) {
                
                $town         = $mmlfield['city'];
                $cbitem->town = @$qitem->$town;
            }
            if (@$mmlfield['locationstate']) {
                $locationstate         = $mmlfield['locationstate'];
                $cbitem->locationstate = @$qitem->$locationstate;
            }
            if (@$mmlfield['country']) {
                
                $country         = $mmlfield['country'];
                $cbitem->country = @$qitem->$country;
            }
            if (@$mmlfield['postal']) {
                $postal         = $mmlfield['postal'];
                $cbitem->postal = @$qitem->$postal;
            }
            if (@$mmlfield['phone']) {
                $phone         = $mmlfield['phone'];
                $cbitem->phone = @$qitem->$phone;
            }
            if (@$mmlfield['extra_fields']) {
                foreach ($mmlfield['extra_fields'] as $extra_field) {
                    $extra_fields .= strip_tags($qitem->$extra_field, '<a><br/>') . "<br/>";
                }
                
            }
            if ($extra_fields) {
                $cbitem->address = $extra_fields . $cbitem->address;
            }
            $address = MyMaplocationsHelper::formatAddress($cbitem);
            return $address;
        }
        public static function getNameFormatOnline($item)
        {
            global $ueConfig;
            $format     = $ueConfig['name_format'];
            $name_style = $ueConfig['name_style'];
            $data       = $item->getUserData();
            if ($name_style == 1) {
                $name = $data->name;
            } else if ($name_style == 2) {
                $name = $data->firstname . " " . $data->lastname;
            } else {
                $name = $data->firstname . " " . $data->middlename . " " . $data->lastname;
            }
            $uname = $data->username;
            if ($format != 3) {
                $name = str_replace(array(
                    "&amp;",
                    "&quot;",
                    "&#039;",
                    "&lt;",
                    "&gt;"
                ), array(
                    "&",
                    "\"",
                    "'",
                    "<",
                    ">"
                ), $name);
            }
            
            SWITCH ($format) {
                CASE 1:
                    $returnName = $name;
                    break;
                CASE 2:
                    $returnName = $name . " (" . $uname . ")";
                    break;
                CASE 3:
                    $returnName = $uname;
                    break;
                CASE 4:
                    $returnName = $uname . " (" . $name . ")";
                    break;
            }
            return $returnName;
        }
        public static function getAdvanceCommunitySearch($component)
        {
            if ($component == "com_community") {
                $plugin = JPluginHelper::getPlugin('community', 'mymaplocations');
                $params = new JRegistry($plugin->params);
                return $params->get('showadvsearch');
            }
            if ($component == "com_comprofiler") {
                $db    = JFactory::getDBO();
                $query = $db->getQuery(true);
                $query->select($db->quoteName('params'));
                $query->from('#__comprofiler_plugin');
                $query->where(' element = ' . $db->quote('mymaplocations'));
               try{
				 $db->setQuery($query);
				}
						catch (Exception $e)
						{
		echo $e->getMessage();
            exit;						
						}
                $result = $db->loadObject();
                $param  = json_decode($result->params, true);
                if (empty($param)) {
                    $param = parse_ini_string($result->params);
                }
                
                if (@$param['userlist'] == 0) {
                    return true;
                } else {
                    return false;
                }
            }
            return false;
        }
        public static function getAdvanceSearchDiv($component)
        {
            $html = "";
            if ($component == "com_community") {
                $lang = JFactory::getLanguage();
                $lang->load('com_community', JPATH_SITE);
                require_once(JPATH_ROOT . '/components/com_community/libraries/core.php');
                $plugin                 = JPluginHelper::getPlugin('community', 'mymaplocations');
                $params                 = new JRegistry($plugin->params);
                $field                  = new stdClass();
                $field->code            = new stdClass();
                $field->code->gender    = $params->get('field_gender', 'FIELD_GENDER');
                $field->code->birthdate = $params->get('field_birthdate', 'FIELD_BIRTHDATE');
                $field->value           = new stdClass();
                $field->value->gender   = MyMaplocationsHelper::getGenderValue($field->code->gender);
                $field->type            = MyMaplocationsHelper::getFieldType($field->code);
                $gender                 = JFactory::getApplication()->input->getString('datingsearch_gender');
                
                $agefrom = JFactory::getApplication()->input->getString('datingsearch_agefrom');
                $ageto   = JFactory::getApplication()->input->getString('datingsearch_ageto');
                $html .= JText::_('COM_COMMUNITY_SEARCH_PEOPLE_PLACEHOLDER') . "<br/>";
                $document = JFactory::getDocument();
                $document->addScript(JURI::base() . '/components/com_mymaplocations/assets/js/jquery-labelauty.js');
                $document->addStylesheet(JURI::base() . '/components/com_mymaplocations/assets/css/jquery-labelauty.css');
                $document->addScriptDeclaration('jQuery(document).ready(function(){
			jQuery(".to-labelauty").labelauty({ minimum_width: "80px" });
			jQuery(".to-labelauty-icon").labelauty({ label: false });
                });');
                
                
                foreach ($field->value->gender as $key => $data) {
                    $html .= '<input class="to-labelauty synch-icon" value="' . $data . '" name="datingsearch_gender" type="checkbox" data-labelauty="' . JText::_($data) . '" ';
                    if ($gender == $data)
                        $html .= ' checked ';
                    $html .= '"/>';
                    
                }
                
                $html .= "<br/><span style='display:inline-block;'>" . JText::_('COM_COMMUNITY_INVITE_FROM') . "";
                $html .= '<input type="text" style="width:28px;" maxlength=3 id="datingsearch_agefrom" name="datingsearch_agefrom" value="' . $agefrom . '"/>' . JText::_("COM_COMMUNITY_INVITE_TO") . '<input type="text" style="width:28px;" maxlength=3 id="datingsearch_ageto" name="datingsearch_ageto" value="' . $ageto . '"/></span>';
                
            }
            if ($component == "com_comprofiler") {
                $cb_list = JFactory::getApplication()->input->getString('cb_list');
                
                $db  = JFactory::getDBO();
                $sql = "SELECT listid, title FROM #__comprofiler_lists where published=1";
                $db->setQuery($sql);
                $rows = $db->loadObjectList();
                $html .= '<select id="cb_list" class="custom-select" name="cb_list">';
                $html .= '<option value=""';
                if ($cb_list == '')
                    $html .= ' selected';
                $html .= '>' . JText::_('COM_MYMAPLOCATIONS_LIST') . '</option>';
                foreach ($rows as $row) {
                    $html .= '<option value="' . $row->listid . '" ';
                    if ($cb_list == $row->listid)
                        $html .= 'selected';
                    $html .= '>' . JText::_($row->title) . '</option>';
                }
                $html .= '</select>';
                
            }
            return $html;
        }
        public static function getGenderValue($fieldcode)
        {
            $options = array(
                "COM_COMMUNITY_MALE" => "COM_COMMUNITY_MALE",
                "COM_COMMUNITY_FEMALE" => "COM_COMMUNITY_FEMALE"
            );
            
            return $options;
        }
        
        public static function getCountryValue($fieldcode)
        {
            // retrieve field details
            $db = JFactory::getDBO();
            
            $sql = "SELECT * FROM " . $db->quoteName("#__community_fields") . " " . "WHERE " . $db->quoteName("fieldcode") . " = " . $db->quote($fieldcode);
            
            $db->setQuery($sql);
          
            
            try{
				 $db->setQuery($query);
				}
						catch (Exception $e)
						{
		echo $e->getMessage();
            exit;						
						}
                          $results = $db->loadObject();
            
            // load countries from xml
            jimport('joomla.filesystem.file');
            $file = JPATH_ROOT . '/components/com_community/libraries/fields/countries.xml';
            
            $options = array();
            
            if (JFile::exists($file)) {
                $contents = JFile::read($file);
                $parser   = new SimpleXMLElement($file, NULL, true);
                
                $countries = $parser->countries->country;
                foreach ($countries as $country) {
                    $options[] = $country->name;
                }
            }
            
            array_walk($options, array(
                'JString',
                'trim'
            ));
            
            return $options;
        }
        
        public static function getFieldType($fieldcode)
        {
            $db = JFactory::getDBO();
            
            $sql = "SELECT " . $db->quoteName("type") . ", " . $db->quoteName("fieldcode") . " " . "FROM " . $db->quoteName("#__community_fields") . " ";
            
            $db->setQuery($sql);
            $results = $db->loadObjectList();
            
            $type = new stdClass();
            
            foreach ($fieldcode as $key => $field) {
                foreach ($results as $data) {
                    if ($field == $data->fieldcode) {
                        $type->$key = $data->type;
                    }
                }
            }
            
            return $type;
        }
        public static function getcountryList()
        {
            $country_list = JFactory::getApplication()->input->getString('country_list');
            
            $db        = JFactory::getDBO();
            $component = JFactory::getApplication()->input->getString('component');
            if ($component == "com_mymaplocations") {
                $component = "component=" . $db->Quote($component) . " OR component=" . $db->Quote("");
            } else if ($component == "com_k2") {
                $component = "component=" . $db->Quote($component);
            } else {
                return;
            }
            $sql = "SELECT distinct(country),country as listid , country as title FROM #__mymaplocations_location where state=1 and " . $component ;
            if(JLanguageMultilang::isEnabled())
            {
                $sql.=' AND language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ') ';
            }
            $sql.=" ORDER By country";
            $db->setQuery($sql);
            $html = "";
            $rows = $db->loadObjectList();
            $c    = 0;
            $html .= '<select id="country_list" class="conutry_dropdown custom-select" name="country_list">';
            $html .= '<option value=""';
            if ($country_list == '')
                $html .= ' selected';
            $html .= '>' . JText::_('COM_MYMAPLOCATIONS_FORM_LBL_STORE_COUNTRY') . '</option>';
            foreach ($rows as $row) {
                if (empty($row->listid)) {
                } else if ($row->title) {
                    $c++;
                    $html .= '<option value="' . $row->listid . '" ';
                    if ($country_list == $row->listid)
                        $html .= 'selected';
                    $html .= '>' . JText::_($row->title) . '</option>';
                }
            }
            if ($c == 0) {
                return;
            }
            $html .= '</select>';
            return $html;
            
        }
        public static function getstateList($country)
        {
            $component = JFactory::getApplication()->input->getString('component');
            $html      = "";
            $db        = JFactory::getDBO();
            if ($component == "com_mymaplocations") {
                $component = "( component=" . $db->Quote($component) . " OR component=" . $db->Quote("") . " ) ";
            } else if ($component == "com_k2") {
                $component = "component=" . $db->Quote($component);
            } else {
                return;
            }
            $state_list = JFactory::getApplication()->input->getString('state_list');
            
            $sql = "SELECT distinct(locationstate),locationstate as listid , locationstate as title FROM #__mymaplocations_location where state=1 and country=" . $db->quote($country) . " and " . $component ;
             if(JLanguageMultilang::isEnabled())
            {
                $sql.=' AND language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ') ';
            }
            $sql.= " ORDER By locationstate";
            $db->setQuery($sql);
            $rows = $db->loadObjectList();
            
            if (count($rows) == 1) {
                if (empty($rows[0]->listid)) {
                    return;
                }
            }
            $html .= '<select id="state_list" class="conutry_dropdown custom-select" name="state_list">';
            $html .= '<option value=""';
            if ($state_list == '')
                $html .= ' selected';
            $html .= '>' . JText::_('COM_MYMAPLOCATIONS_FORM_LBL_STORE_STORESTATE') . '</option>';
            foreach ($rows as $row) {
                if (empty($row->listid)) {
                } else if ($row->title) {
                    $html .= '<option value="' . $row->listid . '" ';
                    if ($state_list == $row->listid)
                        $html .= 'selected';
                    $html .= '>' . JText::_($row->title) . '</option>';
                }
            }
            $html .= '</select>';
            return $html;
            
        }
        public static function getcityajaxList($country, $state)
        {
            $component = JFactory::getApplication()->input->getString('component');
            $html      = "";
            $db        = JFactory::getDBO();
            if ($component == "com_mymaplocations") {
                $component = "( component=" . $db->Quote($component) . " OR component=" . $db->Quote("") . " ) ";
            } else if ($component == "com_k2") {
                $component = "component=" . $db->Quote($component);
            } else {
                return;
            }
            $state_list = JFactory::getApplication()->input->getString('state_list');
            $city_list  = JFactory::getApplication()->input->getString('city_list');
            
            $sql = "SELECT distinct(town),town as listid , town as title FROM #__mymaplocations_location where state=1 and country=" . $db->quote($country) . " and locationstate=" . $db->quote($state) . " and " . $component ;
             if(JLanguageMultilang::isEnabled())
            {
                $sql.=' AND language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ') ';
            }
            $sql.= " ORDER By town";
            
            $db->setQuery($sql);
            $rows = $db->loadObjectList();
            
            if (count($rows) == 1) {
                if (empty($rows[0]->listid)) {
                    return;
                }
            }
            $html .= '<select id="city_list" class="conutry_dropdown custom-select" name="city_list">';
            $html .= '<option value=""';
            if ($state_list == '')
                $html .= ' selected';
            $html .= '>' . JText::_('COM_MYMAPLOCATIONS_FORM_LBL_STORE_TOWN') . '</option>';
            foreach ($rows as $row) {
                if (empty($row->listid)) {
                } else if ($row->title) {
                    $html .= '<option value="' . $row->listid . '" ';
                    if ($city_list == $row->listid)
                        $html .= 'selected';
                    $html .= '>' . JText::_($row->title) . '</option>';
                }
            }
            $html .= '</select>';
            
            return $html;
            
        }
        public static function getNameList()
        {
            $db  = JFactory::getDBO();
            $sql = $sql = "SELECT name FROM #__mymaplocations_location where state=1 and country=" . $db->quote($country) ;
            if(JLanguageMultilang::isEnabled())
            {
                $sql.=' AND a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ') ';
            }
            $sql.= " ORDER By locationstate";
            
            $db->setQuery($sql);
            $row = $db->loadObjectList();
            return $row;
        }
        public static function getJoomsocialField($genderfield, $birthdate)
        {
            $db  = JFactory::getDBO();
            $sql = "SELECT
                                                            " . $db->quoteName("fieldcode") . ",
                                                            " . $db->quoteName("id") . "
                                            FROM
                                                            " . $db->quoteName("#__community_fields") . "
                                            WHERE
                                                            " . $db->quoteName("fieldcode") . " IN (" . $db->Quote($genderfield) . ", " . $db->Quote($birthdate) . ")";
            
            $db->setQuery($sql);
            $row = $db->loadObjectList();
            return $row;
            
        }
        public static function getOhanahCategory($extraid = 0)
        {
            $html               = "";
            $db                 = JFactory::getDBO();
            $ohanah_category_id = JFactory::getApplication()->input->getString('ohanah_category_id', $extraid);
            $sql                = "SELECT ohanah_category_id, title FROM #__ohanah_categories where enabled=1";
            $db->setQuery($sql);
            $rows = $db->loadObjectList();
            if (count($rows) == 0) {
                return;
            }
            $html .= '<select id="ohanah_category_id" name="ohanah_category_id" class="mmlcategory_list  custom-select">';
            $html .= '<option value=""';
            if ($ohanah_category_id == '')
                $html .= ' selected';
            $html .= '>' . JText::_('JOPTION_SELECT_CATEGORY') . '</option>';
            foreach ($rows as $row) {
                $html .= '<option value="' . $row->ohanah_category_id . '" ';
                if ($ohanah_category_id == $row->ohanah_category_id)
                    $html .= 'selected';
                $html .= '>' . JText::_($row->title) . '</option>';
            }
            $html .= '</select>';
            return $html;
        }
        public static function getCommunityCategory($extraid = 0)
        {
            $html                  = "";
            $db                    = JFactory::getDBO();
            $community_category_id = JFactory::getApplication()->input->getString('community_category_id', $extraid);
            $sql                   = "SELECT id, name FROM #__community_profiles where published=1";
            $db->setQuery($sql);
            $rows = $db->loadObjectList();
            if (count($rows) == 0) {
                return;
            }
            $html .= '<select id="community_category_id" name="community_category_id"  class="mmlcategory_list  custom-select">';
            $html .= '<option value=""';
            if ($community_category_id == '')
                $html .= ' selected';
            $html .= '>' . JText::_('JOPTION_SELECT_CATEGORY') . '</option>';
            foreach ($rows as $row) {
                $html .= '<option value="' . $row->id . '" ';
                if ($community_category_id == $row->id)
                    $html .= 'selected';
                $html .= '>' . JText::_($row->name) . '</option>';
            }
            $html .= '</select>';
            return $html;
        }
        public static function getZooCategory($extraid = 0)
        {
            
            $html            = "";
            $db              = JFactory::getDBO();
            $zoo_category_id = JFactory::getApplication()->input->getString('zoo_category_id', $extraid);
            $sql             = "SELECT * FROM #__zoo_category where published=1 ORDER BY parent, ordering";
            $db->setQuery($sql);
            $rows = $db->loadObjectList();
            
            if ($rows) {
                foreach ($rows as $v) {
                    $tag=JFactory::getLanguage()->getTag();
                    $params=json_decode($v->params,true);
                    $cat_name=@$params['content.name_translation'][$tag];
                    if($cat_name)
                    {
                        $v->title=$cat_name;
                    }
                    else
                    {
                    $v->title=$v->name;
                    }
                    $v->parent_id = $v->parent;
                    $pt           = $v->parent;
                    $list         = @$children[$pt] ? $children[$pt] : array();
                    array_push($list, $v);
                    $children[$pt] = $list;
                }
                $list     = JHTML::_('menu.treerecurse', 0, '', array(), $children, 9999, 0, 0);
                $mitems   = array();
                $mitems[] = JHTML::_('select.option', '0', JText::_('JOPTION_SELECT_CATEGORY'));
                
                foreach ($list as $item) {
                    $item->treename = str_ireplace('&#160;', '-', $item->treename);
                    $mitems[]       = JHTML::_('select.option', $item->id, $item->treename);
                }
                $attributes = 'class="mmlcategory_list"';
                return JHTML::_('select.genericlist', $mitems, 'zoo_category_id', $attributes, 'value', 'text', $zoo_category_id);
                
            }
            return;
        }
        public static function getEventBookingCategory($extraid = 0)
        {
            $html              = "";
            $db                = JFactory::getDBO();
            $event_category_id = JFactory::getApplication()->input->getString('event_category_id', $extraid);
            $sql               = "SELECT id, name FROM #__eb_categories where published=1";
            $db->setQuery($sql);
            $rows = $db->loadObjectList();
            if (count($rows) == 0) {
                return;
            }
            $html .= '<select id="event_category_id" name="event_category_id"  class="mmlcategory_list  custom-select">';
            $html .= '<option value=""';
            if ($event_category_id == '')
                $html .= ' selected';
            $html .= '>' . JText::_('JOPTION_SELECT_CATEGORY') . '</option>';
            foreach ($rows as $row) {
                $html .= '<option value="' . $row->id . '" ';
                if ($event_category_id == $row->id)
                    $html .= 'selected';
                $html .= '>' . JText::_($row->name) . '</option>';
            }
            $html .= '</select>';
            return $html;
        }
        public static function getEasyBlogCategory($extraid = 0)
        {
            $html              = "";
            $db                = JFactory::getDBO();
            $event_category_id = JFactory::getApplication()->input->getString('eb_category_id', $extraid);
            $sql               = "SELECT id, title FROM #__easyblog_category where published=1";
            $db->setQuery($sql);
            $rows = $db->loadObjectList();
            if (count($rows) == 0) {
                return;
            }
            $html .= '<select id="eb_category_id" name="eb_category_id"  class="mmlcategory_list  custom-select">';
            $html .= '<option value=""';
            if ($event_category_id == '')
                $html .= ' selected';
            $html .= '>' . JText::_('JOPTION_SELECT_CATEGORY') . '</option>';
            foreach ($rows as $row) {
                $html .= '<option value="' . $row->id . '" ';
                if ($event_category_id == $row->id)
                    $html .= 'selected';
                $html .= '>' . JText::_($row->title) . '</option>';
            }
            $html .= '</select>';
            return $html;
        }
        public static function getVirtueCategory($extraid = 0)
        {
            if (!class_exists( 'VmConfig' )) require(JPATH_ROOT .'/administrator/components/com_virtuemart/helpers/config.php');
		VmConfig::loadConfig();
		vmLanguage::loadJLang('com_virtuemart');
        require_once(JPATH_ROOT .'/administrator/components/com_virtuemart/helpers/shopfunctions.php');
        require_once(JPATH_ROOT .'/administrator/components/com_virtuemart/helpers/html.php');
        $html="";
        $searchproduct         = JFactory::getApplication()->input->getString('searchproduct');
            $minprice         = JFactory::getApplication()->input->getInt('minprice');
            $maxprice         = JFactory::getApplication()->input->getInt('maxprice');
            if($minprice==0)
            {
                $minprice="";
            }
            if($maxprice==0)
            {
                $maxprice="";
            }
            $html .= '<input type="text" autocomplete="off" value="' . $searchproduct . '" name="searchproduct" id="searchproduct" class="search-query" placeholder="' . JText::_("COM_MYMAPLOCATIONS_PRODUCT_SEARCHVM") . '"><br/>';
            $html .= '<label for="price-min">' . JText::_("COM_MYMAPLOCATIONS_PRODUCT_MINPRICE") . ':</label><input type="number" autocomplete="off" value="' . $minprice . '" name="minprice" id="minprice" class="search-price-range" placeholder="' . JText::_("COM_MYMAPLOCATIONS_PRODUCT_MINPRICE") . '"><br/>';
            $html .= '<label for="price-max">' . JText::_("COM_MYMAPLOCATIONS_PRODUCT_MAXPRICE") . ':</label><input type="number" autocomplete="off" value="' . $maxprice . '" name="maxprice" id="maxprice" class="search-price-range" placeholder="' . JText::_("COM_MYMAPLOCATIONS_PRODUCT_MAXPRICE") . '">';
        $vm_category_id = JFactory::getApplication()->input->getString('vm_category', $extraid);
		$categorylist = ShopFunctions::categoryListTree($vm_category_id);
		$name = "vm_category";
		$id = VmHtml::ensureUniqueId('vmcategories');
		$html .= '<select id="'.$id.'" class="inputbox mmlcategory_list  custom-select"   name="' . $name . '" >';
		$html .= '<option value="0">' . vmText::_('COM_VIRTUEMART_CATEGORY_FORM_TOP_LEVEL') . '</option>';
		$html .= $categorylist;
		$html .= "</select>";
        
		return $html;
        }
        public static function getHikaCategory($extraid = 0)
        {
            
            require_once(JPATH_SITE . '/administrator/components/com_hikashop/helpers/helper.php');
            require_once(JPATH_SITE . '/administrator/components/com_hikashop/classes/category.php');
            $plugin                = JPluginHelper::getPlugin('hikamarket', 'mymaplocations');
            $params                = new JRegistry($plugin->params);
            $hk_category           = $params->get('hk_category', '');
            $hikashopCategoryClass = new hikashopCategoryClass();
            $lists                 = $hikashopCategoryClass->getList('product', 0, true);
            $html                  = "";
            $product_category      = JFactory::getApplication()->input->getString('product_category', $extraid);
            $searchproduct         = JFactory::getApplication()->input->getString('searchproduct');
            $minprice         = JFactory::getApplication()->input->getInt('minprice');
            $maxprice         = JFactory::getApplication()->input->getInt('maxprice');
            if($minprice==0)
            {
                $minprice="";
            }
            if($maxprice==0)
            {
                $maxprice="";
            }
            $html .= '<input type="text" autocomplete="off" value="' . $searchproduct . '" name="searchproduct" id="searchproduct" class="search-query" placeholder="' . JText::_("COM_MYMAPLOCATIONS_PRODUCT_SEARCH") . '"><br/>';
            $html .= '<label for="price-min">' . JText::_("COM_MYMAPLOCATIONS_PRODUCT_MINPRICE") . ':</label><input type="number" autocomplete="off" value="' . $minprice . '" name="minprice" id="minprice" class="search-price-range" placeholder="' . JText::_("COM_MYMAPLOCATIONS_PRODUCT_MINPRICE") . '"><br/>';
            $html .= '<label for="price-max">' . JText::_("COM_MYMAPLOCATIONS_PRODUCT_MAXPRICE") . ':</label><input type="number" autocomplete="off" value="' . $maxprice . '" name="maxprice" id="maxprice" class="search-price-range" placeholder="' . JText::_("COM_MYMAPLOCATIONS_PRODUCT_MAXPRICE") . '">';
            
            $html .= '<select id="product_category" name="product_category"  class="mmlcategory_list  custom-select">';
            $html .= '<option value=""';
            if ($product_category == '')
                $html .= ' selected';
            $html .= '>' . JText::_('JOPTION_SELECT_CATEGORY') . '</option>';
            foreach ($lists as $data) {
                if ($data->category_depth == 0) {
                    continue;
                }
                if (((!empty($hk_category))) && !(in_array($data->category_id, $hk_category))) {
                    continue;
                }
                $html .= '<option value="' . $data->category_id . '" ';
                if ($product_category == $data->category_id)
                    $html .= 'selected';
                $html .= '>';
                if ($data->category_depth > 0) {
                    
                    for ($n = 0; $n <= $data->category_depth; $n++) {
                        $html .= "-";
                    }
                }
                $html .= JText::_($data->category_name);
                $html .= '</option>';
            }
            $html .= '</select>';
            return $html;
        }
        public static function getAdsManagerCategory($extraid = 0)
        {
            $html                   = "";
            $db                     = JFactory::getDBO();
            $adsmanager_category_id = JFactory::getApplication()->input->getString('adsmanager_category_id', $extraid);
            $sql                    = "SELECT * FROM #__adsmanager_categories where published=1 ORDER BY parent, ordering";
            $db->setQuery($sql);
            $rows = $db->loadObjectList();
            if ($rows) {
                foreach ($rows as $v) {
                    $v->title     = $v->name;
                    $v->parent_id = $v->parent;
                    $pt           = $v->parent;
                    $list         = @$children[$pt] ? $children[$pt] : array();
                    array_push($list, $v);
                    $children[$pt] = $list;
                }
                $list     = JHTML::_('menu.treerecurse', 0, '', array(), $children, 9999, 0, 0);
                $mitems   = array();
                $mitems[] = JHTML::_('select.option', '0', JText::_('JOPTION_SELECT_CATEGORY'));
                
                foreach ($list as $item) {
                    $item->treename = str_ireplace('&#160;', '-', $item->treename);
                    $mitems[]       = JHTML::_('select.option', $item->id, $item->treename);
                }
                $attributes = 'class="mmlcategory_list"';
                return JHTML::_('select.genericlist', $mitems, 'adsmanager_category_id', $attributes, 'value', 'text', $adsmanager_category_id);
                
            }
            return $html;
            
        }
        public static function getDjClassifiedsCategory($extraid = 0)
        {
            $html                     = "";
            $db                       = JFactory::getDBO();
            $djclassified_category_id = JFactory::getApplication()->input->getString('djclassified_category_id', $extraid);
            $sql                      = "SELECT * FROM #__djcf_categories where published=1";
            $db->setQuery($sql);
            $rows = $db->loadObjectList();
            if ($rows) {
                foreach ($rows as $v) {
                    $v->title     = $v->name;
                    $v->parent_id = $v->parent_id;
                    $pt           = $v->parent_id;
                    $list         = @$children[$pt] ? $children[$pt] : array();
                    array_push($list, $v);
                    $children[$pt] = $list;
                }
                $list     = JHTML::_('menu.treerecurse', 0, '', array(), $children, 9999, 0, 0);
                $mitems   = array();
                $mitems[] = JHTML::_('select.option', '0', JText::_('JOPTION_SELECT_CATEGORY'));
                
                foreach ($list as $item) {
                    $item->treename = str_ireplace('&#160;', '-', $item->treename);
                    $mitems[]       = JHTML::_('select.option', $item->id, $item->treename);
                }
                $attributes = 'class="mmlcategory_list"';
                return JHTML::_('select.genericlist', $mitems, 'djclassified_category_id', $attributes, 'value', 'text', $djclassified_category_id);
                
            }
            return $html;
        }
         public static function getCountryformat($country)
        {
            $country = explode(",", $country);
            if (count($country) == 1) {
                return '"' . $country[0] . '"';
            }
            $finalcountry = "";
            foreach ($country as $countr) {
                $finalcountry .= "'" . $countr . "',";
            }
            return "[" . $finalcountry . "]";
        }
        
        public static function formatAddress($item)
        {
            
            if ((@$item->id == 0) && (@$item->component == "com_mymaplocations")) {
                return $item->address;
            }
            
            $params         = JComponentHelper::getParams('com_mymaplocations');
            $address_format = $params->get('address_format', '[ADDRESS][BR][TOWN][COMMA][SPACE][STATE][BR][COUNTRY][SPACE][POSTAL]');
            $var            = array('[ADDRESS]','[BR]','[TOWN]','[SPACE]','[STATE]','[COUNTRY]','[POSTAL]','[COMMA]','[PHONE]','[HOURS]');
            $replace        = @array(MyMaplocationsHelper::formatJS($item->address),'<br/>',MyMaplocationsHelper::formatJS($item->town),'&nbsp;',MyMaplocationsHelper::formatJS($item->locationstate),MyMaplocationsHelper::formatJS(JText::_($item->country)),$item->postal,'&#44;','<a href="tel:' . $item->phone . '" target="_blank">' . $item->phone . '</a>',MyMaplocationsHelper::formatJS(strip_tags($item->hours, '<br>')));
            $address        = nl2br(str_replace($var, $replace, $address_format));
            $extrafields    = $params->get('extrafield');
            if (file_exists(JPATH_ADMINISTRATOR . '/components/com_fields/helpers/fields.php')) {
                if ((count($extrafields) != 0) && ($item->component == "com_mymaplocations")) {
                    if (self::$loadfield == 0) {
                        JLoader::register('FieldsHelper', JPATH_ADMINISTRATOR . '/components/com_fields/helpers/fields.php');
                        self::$loadfield++;
                    }
                    
                    if ($item->id != 0) {
                        $jcfields = FieldsHelper::getFields('com_mymaplocations.location', $item, true);
                        
                        foreach ($jcfields as $field) {
                            if (in_array($field->id, $extrafields)) {
                                if ((@$field->value) && ($field->value != '')) {
                                    $address .= "<br/>" . str_replace(array(
                                        "field-label",
                                        "field-value"
                                    ), array(
                                        "field-label field-label" . $field->id,
                                        "field-value field-value" . $field->id
                                    ), FieldsHelper::render($field->context, 'field.render', array(
                                        'field' => $field
                                    )));
                                }
                            }
                        }
                    }
                }
            }
            $address = str_replace(array(
                '<a href="tel:" target="_blank"></a>',
                '\t',
                '\n',
                '<br/>&#44;<br/>'
            ), array(
                '',
                '',
                '',
                ''
            ), $address);
            $address =  preg_replace("/,+/", ",",$address);
            $address =  preg_replace("/,<\/div>/", "</div>",$address);
            $address =  preg_replace("/<\/div>,<div/","</div><div",$address);
            return $address;    
        }
       
        public static function getAutocomplete($id, $mode, $country, $container)
        {
            $params            = JComponentHelper::getParams('com_mymaplocations');
            $autocomplete_type = $params->get('autocomplete_type', 1);
            $postal            = "";
            $countrystr        = "";
            $function          = "";
            $document=JFactory::getDocument();
            if ($mode == 2) {
                $postal = "searchpostal";
            } else {
                if ($id) {
                    $postal = "searchmodinput_" . $id;
                } else {
                    $postal = "searchinput";
                }
            }
            if (!empty($country)) {
                $countrystr = 'ac.setComponentRestrictions({"country": ' . MyMaplocationsHelper::getCountryformat($country) . '});';
            }
            if ($id) {
                $function = "_" . $id;
            }
            if ($autocomplete_type == 2) {
                
                 $bingkey = $params->get('bingapi','Asbsa_hzfHl69XF3wxBd_WbW0dLNTRUH3ZHQG9qcV5EFRLuWEaOP1hjWdZ0A0P17');
                             $document->addCustomTag("<script type='text/javascript' src='https://www.bing.com/api/maps/mapcontrol?key=".$bingkey."&callback=initRSA". $function."' async defer></script>
   ");
                          $script='
    function initRSA'. $function.'() { Microsoft.Maps.loadModule("Microsoft.Maps.AutoSuggest", {
            callback: function () {
                var manager = new Microsoft.Maps.AutosuggestManager({
                    placeSuggestions: true,
                    addressSuggestions:true
                });
               
                manager.attachAutosuggest("#'.$postal.'", "#'.$container.'",selectedSuggestion);
            },
            errorCallback: function(msg){
                alert(msg);
            },
        });}
         function selectedSuggestion(result) {
        jQuery("#mj_rs_ref_lat").val(result.location.latitude) ;jQuery("#mj_rs_ref_lng").val(result.location.longitude) ;
        }
        
        ';
        
            }
            else if($autocomplete_type==3)
            {
                $document=JFactory::getDocument();
                 $document->addScript(JURI::root().'components/com_mymaplocations/assets/js/typeahead.bundle.js');
                 $document->addScript(JURI::root().'components/com_mymaplocations/assets/js/typeahead-address-photon.js');
                 $document->addStyleSheet(JURI::root().'components/com_mymaplocations/assets/css/typehead.css');
                 $script='
                  var engine = new PhotonAddressEngine({
    url: "https://photon.komoot.io",
    onPredictions: showPredictions
  });
 
function showPredictions(event, predictions) {
  }
  
  function showSelected(event, selected) {
  jQuery("#mj_rs_ref_lat").val(selected.geometry.coordinates[1]) ;jQuery("#mj_rs_ref_lng").val(selected.geometry.coordinates[0]) ;
  }
  function initRSA' . $function . '()
  {
      jQuery("#' . $postal . '").typeahead({
    hint: true,
    highlight: true,
    limit:1
  }, {
    source: engine.ttAdapter(),
    displayKey: "description"
  });
  engine.bindDefaultTypeaheadEvent(jQuery("#' . $postal . '"));
  jQuery(engine).bind("addresspicker:predictions", showPredictions);
  jQuery(engine).bind("addresspicker:selected", showSelected);
  }
  jQuery(document).ready(function () {
	initRSA' . $function . '();
    });
  ';
            }
             else if($autocomplete_type==4) {
                 MyMaplocationsHelper::loadBaiduJs(true);
                $script = 'function initRSA' . $function . '() { var ac = new BMap.Autocomplete( { "input": "' . $postal . '"});
                ac.addEventListener("onconfirm", function(e){  var _value = e.item.value;
		myValue=_value.province +_value.city+_value.district+_value.street+_value.business;
		var myGeo = new BMap.Geocoder();
        myGeo.getPoint(myValue, function(point){
		if (point) {
                jQuery("#mj_rs_ref_lat").val(point.lat) ;jQuery("#mj_rs_ref_lng").val(point.lng) ;
         }
	});
    });
                }
                 jQuery(document).ready(function () {
                    initRSA' . $function . '();
                    });            
                ';
                
            }
            else {
                 MyMaplocationsHelper::loadGoogleJs(true);
                $script = 'var spSearchDefStr = "search...";
    function initRSA' . $function . '() {var input = document.getElementById("' . $postal . '");var options = {types:["geocode"]};var ac = new google.maps.places.Autocomplete(input, options);' . $countrystr . 'google.maps.event.addListener(ac, "place_changed", function() {var pl = ac.getPlace();jQuery("#mj_rs_ref_lat").val(pl.geometry.location.lat()) ;jQuery("#mj_rs_ref_lng").val(pl.geometry.location.lng()) ;});}google.maps.event.addDomListener(window, "load", initRSA' . $function . ');function gm_authFailure() { 
                    alert("'.JText::_('COM_MYMAPLOCATIONS_MAP_LOADING_ERROR').'");
                }';
                
            }
            return $script;
        }
        public static function getBackEndJs($jform=true,$latitude="44.824708",$longitude="-0.615234",$load=true)
        {
            if($jform)
            {
                $jform_latitude="jform_latitude";
                $jform_longitude="jform_longitude";
                $jform_address="jform_address";
                $jform_town="jform_town" ;
                $jform_locationstate="jform_locationstate";
                $jform_postal="jform_postal";
                $jform_country="jform_country";
                $jform_place_id="jform_place_id";
                $jform_name="jform_name";
                $jform_alias="jform_alias";
                $jform_phone="jform_phone";
                $jform_contactlink="jform_contactlink";
                $jform_hours="jform_hours";
                $jform_metakey="jform_metakey";
            }
            else
            {
                $jform_latitude="latitude";
                $jform_longitude="longitude";
                $jform_address="address";
                $jform_town="town" ;
                $jform_locationstate="locationstate";
                $jform_postal="postal";
                $jform_country="country";
                $jform_place_id="place_id";
                $jform_name="name";
                $jform_alias="alias";
                $jform_phone="phone";
                $jform_contactlink="contactlink";
                $jform_hours="hours";
                $jform_metakey="metakey";
            }
            $params            = JComponentHelper::getParams('com_mymaplocations');
            $autocomplete_type = $params->get('autocomplete_type', 1);
            $script='';
             $document=JFactory::getDocument();
             $html="";
               JHtml::_('jquery.framework'); 
            if($autocomplete_type==2)
            {
                  $bingkey = $params->get('bingapi','Asbsa_hzfHl69XF3wxBd_WbW0dLNTRUH3ZHQG9qcV5EFRLuWEaOP1hjWdZ0A0P17');
                  if($load){
                             $document->addCustomTag("<script type='text/javascript' src='https://www.bing.com/api/maps/mapcontrol?key=".$bingkey."&callback=createMap' async defer></script>");
                  }
                  else
                  {
                    $html.="<script type='text/javascript' src='https://www.bing.com/api/maps/mapcontrol?key=".$bingkey."&callback=createMap' async defer></script>";
                  }
                 $script=' var map,marker,searchManager;
            var lat = '.$latitude.';
             var long = '.$longitude.';
        function createMap()
        {
          map = new Microsoft.Maps.Map("#map", { center: new Microsoft.Maps.Location('.$latitude.', '.$longitude.')});
           var center = map.getCenter();

        //Create custom Pushpin
        var pin = new Microsoft.Maps.Pushpin(center);
        map.entities.push(pin);
          Microsoft.Maps.loadModule("Microsoft.Maps.AutoSuggest", {
            callback: function () {
                var manager = new Microsoft.Maps.AutosuggestManager({
                    placeSuggestions: false
                });
                manager.attachAutosuggest("#postcode", "#container_mml", selectedSuggestion);
            },
            errorCallback: function(msg){
                alert(msg);
            }
        });
         Microsoft.Maps.Events.addHandler(map, "click", function (e) {
          var point = new Microsoft.Maps.Point(e.getX(), e.getY());
            var loc = e.target.tryPixelToLocation(point);
          document.getElementById("'.$jform_latitude.'").value=loc.latitude;
        document.getElementById("'.$jform_longitude.'").value=loc.longitude;
        GeocodeLatlang();
         });
        
        }
   
         function selectedSuggestion(result) {
         recreateMap(result);
    }
   
    function Geocode()
    {
         if (!searchManager) {
            Microsoft.Maps.loadModule("Microsoft.Maps.Search", function () {
                searchManager = new Microsoft.Maps.Search.SearchManager(map);
                Search()
            });
        } else {
            map.entities.clear();
            var query = document.getElementById("postcode").value;
            geocodeQuery(query);
        }
    }
    function GeocodeLatlang()
    {
    var lat=document.getElementById("'.$jform_latitude.'").value;
    var lang=document.getElementById("'.$jform_longitude.'").value;
    
                Microsoft.Maps.loadModule("Microsoft.Maps.Search", function () {
                searchManager = new Microsoft.Maps.Search.SearchManager(map);
                    var reverseGeocodeRequestOptions = {
                        location: new Microsoft.Maps.Location(lat,lang),
                        callback: function (answer, userData) {
                             recreateMap(answer);
                        }
                    };
                    searchManager.reverseGeocode(reverseGeocodeRequestOptions);
                });
    }
    function recreateMap(result)
    {
        map.entities.clear();
         var pin = new Microsoft.Maps.Pushpin(result.location);
        map.entities.push(pin);
        map.setView({ bounds: result.bestView });
        if(result.address.addressLine=="undefined")
        {
            result.address.addressLine=result.title;
        }
         document.getElementById("'.$jform_address.'").value = result.address.addressLine  || result.title;
        document.getElementById("'.$jform_town.'").value = result.address.locality || "" ;
        document.getElementById("'.$jform_locationstate.'").value = result.address.adminDistrict  || "";
        document.getElementById("'.$jform_postal.'").value = result.address.postalCode || "" ;
        document.getElementById("'.$jform_country.'").value = result.address.countryRegion || "";
        document.getElementById("'.$jform_latitude.'").value = result.location.latitude || "";
        document.getElementById("'.$jform_longitude.'").value = result.location.longitude || "";
        
    }
        function geocodeQuery(query) {
        var searchRequest = {
            where: query,
            callback: function (r) {
                if (r && r.results && r.results.length > 0) {
                   recreateMap(r.results[0]);
                }
            },
            errorCallback: function (e) {
            }
        };
        searchManager.geocode(searchRequest);
    }
            ';
            }
            else if(($autocomplete_type==3))
            {
                    $document=JFactory::getDocument();
                    if($load){
                 $document->addStyleSheet('https://unpkg.com/leaflet@1.7.1/dist/leaflet.css');
                 $document->addScript('https://unpkg.com/leaflet@1.7.1/dist/leaflet.js');
                 $document->addScript(JURI::root().'components/com_mymaplocations/assets/js/typeahead.bundle.js');
                 $document->addScript(JURI::root().'components/com_mymaplocations/assets/js/typeahead-address-photon.js');
                 $document->addStyleSheet(JURI::root().'components/com_mymaplocations/assets/css/typehead.css');
                    }
                    else
                    {
                        $html.="<script type='text/javascript' src='https://unpkg.com/leaflet@1.7.1/dist/leaflet.js'></script><script type='text/javascript' src='".JURI::root()."components/com_mymaplocations/assets/js/typeahead.bundle.js'></script><script type='text/javascript' src='".JURI::root()."components/com_mymaplocations/assets/js/typeahead-address-photon.js'></script><link href='https://unpkg.com/leaflet@1.7.1/dist/leaflet.css' rel='stylesheet'/><link href='".JURI::root()."components/com_mymaplocations/assets/css/typehead.css' rel='stylesheet'/>";
                    }
                 $script.='
             var map,marker;
            var lat = '.$latitude.';
             var long = '.$longitude.';
             var engine = new PhotonAddressEngine({
    url: "https://photon.komoot.io",
    lat: lat,
    lon: long,
    onPredictions: showPredictions
  });
 
            jQuery(document).ready(function() {
            map = L.map("map").setView([lat, long], 12);
            createMap();
map.on("click", function(e) {
 map.scrollWheelZoom.disable();
          engine.reverseGeocode([ e.latlng.lat, e.latlng.lng ]);
});

      jQuery("#postcode").typeahead({
    hint: true,
    highlight: true,
    limit:2
  }, {
    source: engine.ttAdapter(),
    displayKey: "description"
  });
  engine.bindDefaultTypeaheadEvent(jQuery("#postcode"));
  jQuery(engine).bind("addresspicker:predictions", showPredictions);
  jQuery(engine).bind("addresspicker:selected", showSelected);
        
            });
        function createMap()
        {
             marker= L.marker(map.getCenter(),{draggable: true}).addTo(map);
    L.tileLayer("https://{s}.tile.osm.org/{z}/{x}/{y}.png", {
    attribution: "&copy; <a href=\'http://osm.org/copyright\'>OpenStreetMap</a> contributors"
}).addTo(map);
marker.on("dragend", function (e) {
     engine.reverseGeocode([ marker.getLatLng().lat,  marker.getLatLng().lng ]);
   });
}
function Geocode()
{
var postcode=jQuery("#postcode").val();
    jQuery.getJSON("https://photon.komoot.io/api/?q="+postcode+"&limit=1", function(result){
     var selected=result.features[0];
     document.getElementById("'.$jform_latitude.'").value=selected.geometry.coordinates[1];
        document.getElementById("'.$jform_longitude.'").value=selected.geometry.coordinates[0];
        var address="";
        if(selected.properties.name)
        {
        address=address+selected.properties.name;
		 }
        if(selected.properties.housenumber)
        {
        address=address+" "+selected.properties.housenumber;
		 }
         if(selected.properties.street)
        {
        address=+" "+address+selected.properties.street;
		 }
         jQuery("#'.$jform_address.'").val(selected.properties.name);
         jQuery("#'.$jform_town.'").val(selected.properties.city);
		 jQuery("#'.$jform_country.'").val(selected.properties.country);
		 jQuery("#'.$jform_postal.'").val(selected.properties.postcode);
		 jQuery("#'.$jform_locationstate.'").val(selected.properties.state);
         recreateMap();
  
     });
}
 function GeocodeLatlang()
{
        lat = jQuery("#'.$jform_latitude.'").val();
        long = jQuery("#'.$jform_longitude.'").val();
        engine.reverseGeocode([ lat, long ]);
        recreateMap();
 }
function recreateMap()
{
    lat = jQuery("#'.$jform_latitude.'").val();
   long = jQuery("#'.$jform_longitude.'").val();
   map.removeLayer(marker);
    marker= L.marker([lat,long],{draggable: true}).addTo(map);
    map.setView(marker.getLatLng(),map.getZoom());
    marker.on("dragend", function (e) {
     engine.reverseGeocode([ marker.getLatLng().lat,  marker.getLatLng().lng ]);
   });
}
function showPredictions(event, predictions) {
  }
   
  function showSelected(event, selected) {
  
  document.getElementById("'.$jform_latitude.'").value=selected.geometry.coordinates[1];
        document.getElementById("'.$jform_longitude.'").value=selected.geometry.coordinates[0];
        var address="";
        if(selected.properties.name)
        {
        address=address+selected.properties.name;
		 }
        if(selected.properties.housenumber)
        {
        address=address+" "+selected.properties.housenumber;
		 }
         if(selected.properties.street)
        {
        address=+" "+address+selected.properties.street;
		 }
         jQuery("#'.$jform_address.'").val(selected.properties.name);
         jQuery("#'.$jform_town.'").val(selected.properties.city);
		 jQuery("#'.$jform_country.'").val(selected.properties.country);
		 jQuery("#'.$jform_postal.'").val(selected.properties.postcode);
		 jQuery("#'.$jform_locationstate.'").val(selected.properties.state);
         recreateMap();
  }
    function showError(error) {
		 var x = document.getElementById("show-alert");
			x.style.display="block";
            x.innerHTML="Geolocation is not supported by this browser.";
	}
   
            ';
                 
               
            }
              else if(($autocomplete_type==4))
            {
                 $html .= MyMaplocationsHelper::loadBaiduJs($load);
                  $document=JFactory::getDocument();
            $script.='
            jQuery(document).ready(function() {
            initialize_map();
           
});
 var latlng,map,marker,autocomplete;
var initListener;

function initialize_map()
{
    map = new BMap.Map("map");
    var pt=new BMap.Point('.$longitude.','.$latitude.');
  
     map.addControl(new BMap.MapTypeControl({
		mapTypes:[
            BMAP_NORMAL_MAP,
            BMAP_HYBRID_MAP
        ]}));	  
	map.enableScrollWheelZoom(true);
      map.centerAndZoom(pt, 5);
	var marker = new BMap.Marker(pt); 
	map.addOverlay(marker);
    var ac = new BMap.Autocomplete( { "input": "postcode"});
    ac.addEventListener("onconfirm", function(e){
      var _value = e.item.value;
		myValue=_value.province +_value.city+_value.district+_value.street+_value.business;
		var myGeo = new BMap.Geocoder();
        myGeo.getPoint(myValue, function(point){
		if (point) {
                insertData(point.lng ,point.lat);
         }
    });
    });
    map.addEventListener("click",function(e){
       insertData(e.point.lng ,e.point.lat);
    });
}
function Geocode()
{
     var postcode = jQuery("#postcode").val();
     var myGeo = new BMap.Geocoder();
      myGeo.getPoint(postcode, function(point){
		if (point) {
                insertData(point.lng ,point.lat);
         }
    });
}
function GeocodeLatlang()
{
    lat = jQuery("#'.$jform_latitude.'").val();
        long = jQuery("#'.$jform_longitude.'").val();
        insertData(long,lat);
}
function insertData(lng,lat)
{
    
     map.clearOverlays();
        var pt=new BMap.Point(lng,lat);
         map.centerAndZoom(pt);
        var marker = new BMap.Marker(pt);
        map.panTo(pt);
        map.addOverlay(marker);
         document.getElementById("'.$jform_latitude.'").value=lat;
        document.getElementById("'.$jform_longitude.'").value=lng;
        var geoc = new BMap.Geocoder();
        geoc.getLocation(pt, function(rs){
        var addComp = rs.addressComponents;
         jQuery("#'.$jform_address.'").val(addComp.street + " " + addComp.streetNumber);
         jQuery("#'.$jform_town.'").val(addComp.city);
		 jQuery("#'.$jform_locationstate.'").val(addComp.province);
          jQuery("#'.$jform_country.'").val("");
		 jQuery("#'.$jform_postal.'").val("");
});
}
';
            }
            else
            {
            $html .= MyMaplocationsHelper::loadGoogleJs($load);
            $country=$params->get('country',null);
            $countryres="";
             if(!empty($country)) {
                $countryres="autocomplete.setComponentRestrictions({'country': ". MyMaplocationsHelper::getCountryformat($country)."});";
                }
            $document=JFactory::getDocument();
            $script.='
            jQuery(document).ready(function() {
            initialize_map();
           
});
 var latlng,map,marker,autocomplete;
var initListener;
function initialize_map()
{
 latlng = new google.maps.LatLng('.$latitude.','.$longitude.'); var options = {
                       zoom: 5,
                       center: latlng,
                       mapTypeId: google.maps.MapTypeId.ROADMAP,
                       draggableCursor: "crosshair",
                       streetViewControl: false
                   };
                map = new google.maps.Map(document.getElementById("map"), options);
                marker = new google.maps.Marker({
               position: latlng,
               map: map
               });
               
                   
                   jQuery("#zoom").html(5);
                   google.maps.event.addListener(map,"click", function(location)
                   {
                       GetlocationInfo(location.latLng);
                   });
                   autocomplete = new google.maps.places.Autocomplete(document.getElementById("postcode"), {});'.$countryres.'
                   google.maps.event.addListener(autocomplete, "place_changed", function() {
                       jQuery("#locations").html("");
                       jQuery("#error").html("");
                       var place = autocomplete.getPlace();
               if (place.place_id ) {
                       jQuery("#place_id_data").show();
                       jQuery("#place_id").html(\'We have found Google Place <a href="\'+place.url+\'" class="btn btn-primary" target="_blank">\'+place.name+\'</a> linked with data.Click here to copy data directly to our fields from Google places API  <input type="button" class="btn btn-inverse" value="insert" onclick="insertGooglePlaces()"/>\');
               }
                       Gotolocation(place.geometry.location);
                   });
               }
                   function roundNumber(num, dec) {
                        return Math.round(num*Math.pow(10,dec))/Math.pow(10,dec);
                  }
                   function StartStreetView() {
                       // street view
                       if (jQuery("#streetViewBtn").val() == "Start StreetView") {
                           initListener = google.maps.event.addListener(myPano, "position_changed", handlePanoMove);
                           jQuery("#pano").show();
                           myPano.setVisible(true);
                           jQuery("#streetViewBtn").val("End StreetView");
                           google.maps.event.trigger(myPano, "resize");
                           GotoLatLong();
                       }
                       else {
                           google.maps.event.removeListener(initListener);
                           myPano.setVisible(false);
                           jQuery("#pano").hide();
                           jQuery("#streetViewBtn").val("Start StreetView");
                           google.maps.event.trigger(myPano, "resize");
                       }
                   }
               function GeocodeLatlang()
               {
               var localSearch = new google.maps.Geocoder();
               var clat=jQuery("#'.$jform_latitude.'").val();
               var clang=jQuery("#'.$jform_longitude.'").val();
               var latlng = new google.maps.LatLng(clat,clang);
               localSearch.geocode({ "location": latlng },
                       function(results, status) {
                           if (results.length) {
                               var result = results[0];
                               var location = result.geometry.location;
                               Gotolocation(location);
                           }
                           else {
                               jQuery("#error").html("Address not found");
                           }
               
               
               });	
               }
                function gm_authFailure() { 
                    alert("'.JText::_('COM_MYMAPLOCATIONS_MAP_LOADING_ERROR').'");
                }
   
                   function Geocode()
                   {
                       jQuery("#locations").html("");
                       jQuery("#error").html("");
                       var place = autocomplete.getPlace();
               if(typeof place === "undefined"){
                        var localSearch = new google.maps.Geocoder();
                       var postcode = jQuery("#postcode").val();
                       localSearch.geocode({ "address": postcode },
                       function(results, status) {
                           if (results.length >= 1) {
                               var result = results[0];
                               var location = result.geometry.location;
                               Gotolocation(location);
                           }
                           else {
                               jQuery("#error").html("Address not found");
                           }
                       });	
               }
               else
               {
               if (place.place_id ) {
                       jQuery("#place_id_data").show();
                       jQuery("#place_id").html(\'We have found Google Place <a href="\'+place.url+\'" class="btn btn-primary" target="_blank">\'+place.name+\'</a> linked with data.Click here to copy data directly to our fields from Google places API  <input type="button" class="btn btn-inverse" value="insert" onclick="insertGooglePlaces()"/>\');
               }
               Gotolocation(place.geometry.location);
               }   
                   }
                   function Gotolocation(location) {
                       GetlocationInfo(location);
                       map.setCenter(location);
                   }
               
                   function GetlocationInfo(latlng)
                   {
                       if (latlng != null)
                       {
                           ShowLatLong(latlng);
                       }
                   }
                   function GotoLatLong()
                   {
                       if (jQuery("#'.$jform_latitude.'").val() != "" && jQuery("#'.$jform_longitude.'").val() != "") {
                           var lat = jQuery("#'.$jform_latitude.'").val();
                           var long = jQuery("#'.$jform_longitude.'").val();
                           var latLong = new google.maps.LatLng(lat, long);
                           ShowLatLong(latLong);
                           map.setCenter(latLong);
                       }
                   }
                   function ShowLatLong(latLong)
                   {
                       // show the lat/long
                       if (marker != null) {
                           marker.setMap(null);
                       }
                       marker = new google.maps.Marker({
                           position: latLong,
                           map: map});
                       jQuery("#'.$jform_latitude.'").val(roundNumber(latLong.lat(), 6));
                       jQuery("#'.$jform_longitude.'").val(roundNumber(latLong.lng(), 6));                       
                       ReverseGeocode(latLong.lat(), latLong.lng(), "#address");
               
                   }
               
                                 
                   function handlePanoMove(location)
                   {
                       ShowLatLong(myPano.getPosition());
                   }
                   function copyData()
                   {
                       var lat=document.getElementById("lat").value;
                       var long=document.getElementById("long").value;
                       document.getElementById("'.$jform_latitude.'").value=lat;
                       document.getElementById("'.$jform_longitude.'").value=long;
                   }
               function insertGooglePlaces() {
                       //code
               var place = autocomplete.getPlace();
               document.getElementById("'.$jform_place_id.'").value=place.place_id;
               document.getElementById("'.$jform_name.'").value=place.name;
               document.getElementById("'.$jform_alias.'").value="";
               if (typeof place.international_phone_number !== "undefined") {
               document.getElementById("'.$jform_phone.'").value=place.international_phone_number;
               }else
               {
               document.getElementById("'.$jform_phone.'").value="";
               }
               if (typeof place.website !== "undefined") {
               document.getElementById("'.$jform_contactlink.'").value=place.website;
               }else
               {
               document.getElementById("'.$jform_contactlink.'").value="";
               }
               document.getElementById("'.$jform_hours.'").value="";
               if (typeof place.types !== "undefined") {
               document.getElementById("'.$jform_metakey.'").value=place.types;
               }else
               {
               document.getElementById("'.$jform_metakey.'").value="";
               }
            }
            function ReverseGeocode(lat, long, selector){
    var geocoder = new google.maps.Geocoder();
    var latLong = new google.maps.LatLng(lat, long);
    var streetNumber = "";
    var streetName = "";
    var country = "";
    var postalCode = "";
    var city = "";
    var estate="";
    geocoder.geocode({
        "latLng": latLong
    }, function(results, status) {
        if (status == google.maps.GeocoderStatus.OK) {
            if (results) {
         
                 var foundAddress = false;
                for (var i=0; i<results.length; i++) {
                    if ((results[i].types[0] == "street_address") || (results[i].types[0] == "route")) {
                        jQuery.each(results[i].address_components, function(k,v1) {jQuery.each(v1.types, function(k2, type){
                            
                       
                            if (type == "street_number") {
                                    streetNumber = v1.long_name;
                                }

                                if (type == "route") {
                                    streetName = v1.long_name;
                                }
                                if (type == "administrative_area_level_1") {
                                    estate = v1.long_name;
                                }
                                if (type == "country") {
                                    country = v1.long_name;
                                }

                                if (type == "postal_code") {
                                    postalCode = v1.long_name;
                                }

                                if (type == "locality") {
                                    city = v1.long_name;
                                }
                            
                            });})
               
                       jQuery("#'.$jform_address.'").val(streetNumber+" "+streetName);
                        jQuery("#'.$jform_town.'").val(city);
                        jQuery("#'.$jform_country.'").val(country);
                        jQuery("#'.$jform_postal.'").val(postalCode);
                        jQuery("#'.$jform_locationstate.'").val(estate);
                        foundAddress = true;
                        break;
                    }
                }
                if (!foundAddress) {
                    jQuery("#'.$jform_address.'").html(results[0].formatted_address);
                }
            }
        }
    });
    
}
';
            }
            if($load)
            {
            $document->addScriptDeclaration($script);
            return null;
            }
            else
            {
                
            $html.="<script type='text/javascript'>" . $script . "</script>";
            
            return $html;
            }
        }
        public static function getAllowAdd()
        {
            $component = JFactory::getApplication()->input->get('component');
            $view      = JFactory::getApplication()->input->get('view');
            if (($component != "com_mymaplocations") && (($view == "locations"))) {
                return false;
            }
            $user       = JFactory::getUser();
            $authorised = $user->authorise('core.create', 'com_mymaplocations');
            return $authorised;
        }
        public static function getAllowDelete()
        {
            $component = JFactory::getApplication()->input->get('component');
            $view      = JFactory::getApplication()->input->get('view');
            if (($component != "com_mymaplocations") && (($view == "locations"))) {
                return false;
            }
            $user       = JFactory::getUser();
            $authorised = $user->authorise('core.delete', 'com_mymaplocations');
            return $authorised;
        }
        public static function getAllowEdit($item)
        {
            $component = JFactory::getApplication()->input->get('component');
            $view      = JFactory::getApplication()->input->get('view');
            if (($component != "com_mymaplocations") && (($view == "locations"))) {
                return false;
            }
            $user      = JFactory::getUser();
            $assetName = 'com_mymaplocations';
            $res       = new JObject;
            $actions   = array(
                'core.admin',
                'core.manage',
                'core.create',
                'core.edit',
                'core.edit.own',
                'core.edit.state',
                'core.delete'
            );
            
            foreach ($actions as $action) {
                $res->set($action, $user->authorise($action, $assetName));
            }
            if ($res->get('core.edit')) {
                $authorised = true;
            } else if ($res->get('core.edit.own')) {
                if ($item->created_userid == $user->id) {
                    $authorised = true;
                } else {
                    $authorised = false;
                }
            } else {
                $authorised = false;
                
            }
            return $authorised;
            
        }
        public static function getActions()
        {
            $component = JFactory::getApplication()->input->get('component');
            if ($component != "com_mymaplocations") {
                return false;
            }
            $user   = JFactory::getUser();
            $result = new JObject;
            
            $assetName = 'com_mymaplocations';
            
            $actions = array(
                'core.admin',
                'core.manage',
                'core.create',
                'core.edit',
                'core.edit.own',
                'core.edit.state',
                'core.delete'
            );
            
            foreach ($actions as $action) {
                $result->set($action, $user->authorise($action, $assetName));
            }
            
            return $result;
        }
        public static function getMapDesign($id)
        {
            if ($id == 2) {
                return '[{"featureType": "all","stylers": [{"saturation": -100},{"gamma": 0.5}]}]';
            } else if ($id == 3) {
                return '[{"featureType": "water","elementType": "geometry","stylers": [
                {
                    "color": "#a2daf2"
                }
            ]
        },
        {
            "featureType": "landscape.man_made",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#f7f1df"
                }
            ]
        },
        {
            "featureType": "landscape.natural",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#d0e3b4"
                }
            ]
        },
        {
            "featureType": "landscape.natural.terrain",
            "elementType": "geometry",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "poi.park",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#bde6ab"
                }
            ]
        },
        {
            "featureType": "poi",
            "elementType": "labels",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "poi.medical",
            "elementType": "geometry",
            "stylers": [
                {
                    "color": "#fbd3da"
                }
            ]
        },
        {
            "featureType": "poi.business",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "road",
            "elementType": "labels",
            "stylers": [
                {
                    "visibility": "off"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry.fill",
            "stylers": [
                {
                    "color": "#ffe15f"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "color": "#efd151"
                }
            ]
        },
        {
            "featureType": "road.arterial",
            "elementType": "geometry.fill",
            "stylers": [
                {
                    "color": "#ffffff"
                }
            ]
        },
        {
            "featureType": "road.local",
            "elementType": "geometry.fill",
            "stylers": [
                {
                    "color": "black"
                }
            ]
        },
        {
            "featureType": "transit.station.airport",
            "elementType": "geometry.fill",
            "stylers": [
                {
                    "color": "#cfb2db"
                }
            ]
        }
    ]';
            } else if ($id == 4) {
                return '[
        {
            "featureType": "water",
            "elementType": "all",
            "stylers": [
                {
                    "color": "#3b5998"
                }
            ]
        },
        {
            "featureType": "administrative.province",
            "elementType": "all",
            "stylers": [
                {
                    "visibility": "on"
                }
            ]
        },
        {
            "featureType": "all",
            "elementType": "all",
            "stylers": [
                {
                    "hue": "#3b5998"
                },
                {
                    "saturation": -22
                }
            ]
        },
        {
            "featureType": "landscape",
            "elementType": "all",
            "stylers": [
                {
                    "visibility": "on"
                },
                {
                    "color": "#f7f7f7"
                },
                {
                    "saturation": 10
                },
                {
                    "lightness": 76
                }
            ]
        },
        {
            "featureType": "landscape.natural",
            "elementType": "all",
            "stylers": [
                {
                    "color": "#f7f7f7"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "all",
            "stylers": [
                {
                    "color": "#8b9dc3"
                }
            ]
        },
        {
            "featureType": "administrative.country",
            "elementType": "geometry.stroke",
            "stylers": [
                {
                    "visibility": "on"
                },
                {
                    "color": "#3b5998"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "all",
            "stylers": [
                {
                    "visibility": "on"
                },
                {
                    "color": "#8b9dc3"
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "all",
            "stylers": [
                {
                    "visibility": "on"
                },
                {
                    "color": "#8b9dc3"
                }
            ]
        },
        {
            "featureType": "transit.line",
            "elementType": "all",
            "stylers": [
                {
                    "invert_lightness": false
                },
                {
                    "color": "#ffffff"
                },
                {
                    "weight": 0.43
                }
            ]
        },
        {
            "featureType": "road.highway",
            "elementType": "labels.icon",
            "stylers": [
                {
                    "visibility": "on"
                }
            ]
        },
        {
            "featureType": "road.local",
            "elementType": "geometry.fill",
            "stylers": [
                {
                    "color": "#8b9dc3"
                }
            ]
        },
        {
            "featureType": "administrative",
            "elementType": "labels.icon",
            "stylers": [
                {
                    "visibility": "on"
                },
                {
                    "color": "#3b5998"
                }
            ]
        }
    ]						';
            } else if ($id == 5) {
                return '[{"stylers":[{"hue":"#ff8800"},{"gamma":0.4}]}]';
            } else if ($id == 6) {
                
                return '[{"featureType":"all","elementType":"all","stylers":[{"invert_lightness":true},{"saturation":10},{"lightness":30},{"gamma":0.5},{"hue":"#435158"}]}]';
            } else if ($id == 7) {
                return '[{"featureType":"road","stylers":[{"hue":"#5e00ff"},{"saturation":-79}]},{"featureType":"poi","stylers":[{"saturation":-78},{"hue":"#6600ff"},{"lightness":-47},{"visibility":"off"}]},{"featureType":"road.local","stylers":[{"lightness":22}]},{"featureType":"landscape","stylers":[{"hue":"#6600ff"},{"saturation":-11}]},{},{},{"featureType":"water","stylers":[{"saturation":-65},{"hue":"#1900ff"},{"lightness":8}]},{"featureType":"road.local","stylers":[{"weight":1.3},{"lightness":30}]},{"featureType":"transit","stylers":[{"visibility":"simplified"},{"hue":"#5e00ff"},{"saturation":-16}]},{"featureType":"transit.line","stylers":[{"saturation":-72}]},{}]';
            } else if ($id == 8) {
                return '[{"featureType":"water","stylers":[{"saturation":43},{"lightness":-11},{"hue":"#0088ff"}]},{"featureType":"road","elementType":"geometry.fill","stylers":[{"hue":"#ff0000"},{"saturation":-100},{"lightness":99}]},{"featureType":"road","elementType":"geometry.stroke","stylers":[{"color":"#808080"},{"lightness":54}]},{"featureType":"landscape.man_made","elementType":"geometry.fill","stylers":[{"color":"#ece2d9"}]},{"featureType":"poi.park","elementType":"geometry.fill","stylers":[{"color":"#ccdca1"}]},{"featureType":"road","elementType":"labels.text.fill","stylers":[{"color":"#767676"}]},{"featureType":"road","elementType":"labels.text.stroke","stylers":[{"color":"#ffffff"}]},{"featureType":"poi","stylers":[{"visibility":"off"}]},{"featureType":"landscape.natural","elementType":"geometry.fill","stylers":[{"visibility":"on"},{"color":"#b8cb93"}]},{"featureType":"poi.park","stylers":[{"visibility":"on"}]},{"featureType":"poi.sports_complex","stylers":[{"visibility":"on"}]},{"featureType":"poi.medical","stylers":[{"visibility":"on"}]},{"featureType":"poi.business","stylers":[{"visibility":"simplified"}]}]';
            } else if ($id == 9) {
                return '[{"featureType":"landscape.natural","elementType":"geometry.fill","stylers":[{"visibility":"on"},{"color":"#e0efef"}]},{"featureType":"poi","elementType":"geometry.fill","stylers":[{"visibility":"on"},{"hue":"#1900ff"},{"color":"#8EF1DD"}]},{"featureType":"landscape.man_made","elementType":"geometry.fill"},{"featureType":"road","elementType":"geometry","stylers":[{"lightness":100},{"visibility":"simplified"}]},{"featureType":"road","elementType":"labels","stylers":[{"visibility":"off"}]},{"featureType":"water","stylers":[{"color":"#73D4C0"}]},{"featureType":"transit.line","elementType":"geometry","stylers":[{"visibility":"on"},{"lightness":700}]}]';
            } else if ($id == 10) {
                return '[{"featureType":"water","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":17}]},{"featureType":"landscape","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":20}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#000000"},{"lightness":17}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#000000"},{"lightness":29},{"weight":0.2}]},{"featureType":"road.arterial","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":18}]},{"featureType":"road.local","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":16}]},{"featureType":"poi","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":21}]},{"elementType":"labels.text.stroke","stylers":[{"visibility":"on"},{"color":"#000000"},{"lightness":16}]},{"elementType":"labels.text.fill","stylers":[{"saturation":36},{"color":"#000000"},{"lightness":40}]},{"elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"transit","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":19}]},{"featureType":"administrative","elementType":"geometry.fill","stylers":[{"color":"#000000"},{"lightness":20}]},{"featureType":"administrative","elementType":"geometry.stroke","stylers":[{"color":"#000000"},{"lightness":17},{"weight":1.2}]}]';
            }
        }
        public static function getCustomSql($zip,$distance)
        {
            ///sample code for fetching data from my map location change accordingly
            $query=null;
            //$db = JFactory::getDbo();
            //$query = $db->getQuery(true);
            //$query->select(" a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( a.latitude ) ) * cos( radians( a.longitude ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( a.latitude ) ) ) ) AS distance " );
            //$query->from('`#__mymaplocations_location` AS a');    
            //should allways be query parameter
            //all request variable are assigned here
            return $query;
        }
        public static function getCustomUrl($item)
        {
            //change the url
           //  $url = JRoute::_("index.php?option=com_mymaplocations&view=location&id=" . $item->id );
            //return $url;
        }
        public static function utf8RawUrlDecode($source, $charset = null)
        {
            $decodedStr = '';   
            $pos = 0;
            $len = strlen($source);
            while ($pos < $len) {
                $charAt = substr($source, $pos, 1);
                if ($charAt == '%') {
                    $pos++;
                    $charAt = substr($source, $pos, 1);
                    if ($charAt == 'u') { // we got a unicode character
                        $pos++;
                        $unicodeHexVal = substr($source, $pos, 4);
                        $unicode = hexdec($unicodeHexVal);
                        $entity = "&#" . $unicode . ';';
                        $decodedStr .= html_entity_decode($entity, ENT_QUOTES, $charset);
                        $pos += 4;
                    } else { // we have an escaped ascii character
                        $hexVal = substr($source, $pos, 2);
                        if ($charset == 'UTF-8') {
                            $decodedStr .= utf8_encode(chr(hexdec($hexVal)));
                        } else {
                            $decodedStr .= chr(hexdec($hexVal));   
                        }
                        $pos += 2;   
                    }
                } else {
                    $decodedStr .= $charAt;
                    $pos++;   
                }   
            }
            return $decodedStr;   
        }
        public static function checkCms()
			{
       if (version_compare(JVERSION, '4.0', 'ge'))
				{
					return true;
                }
            else
            {
            return false;
            }
        
        }
    }
}
