<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// no direct access
defined('_JEXEC') or die;

// Always load abstract class
require_once( JPATH_ROOT . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_komento' . DIRECTORY_SEPARATOR . 'komento_plugins' . DIRECTORY_SEPARATOR .'abstract.php' );

class KomentoComMymaplocations extends KomentoExtension
{
    public $component = 'com_mymaplocations';
    public $_item;
    public $_staticid;

    public $_map = array(
        'id'            => 'id',
        'title'         => 'name',
        'hits'          => 0,
        'created_by'    => 'created_by',
        'catid'         => 'catid',
        'state'         => 'state',
        );

    public function __construct( $component )
    {
        
        parent::__construct( $component );
    }
    public function load( $cid )
    {
        static $instances = array();

        if( !isset( $instances[$cid] ) )
        {
           $db        = Komento::getDBO();
            $query    = 'SELECT * from #__mymaplocations_location where id='. $db->quote( (int) $cid );
            $db->setQuery( $query );

            if( !$result = $db->loadObject() )
            {
                return $this->onLoadArticleError( $cid );
            }
	    $this->_staticid=$cid ;

            $instances[$cid] = $result;
        }
	
        $this->_item = $instances[$cid];

        return $this;
    }

    public function getContentIds( $categories = '' )
    {
        $articleIds = array();
        $db=JFactory::getDbo();
        if( empty( $categories ) )
        {
             $query = 'SELECT `id` FROM ' . $db->quoteName( '#__mymaplocations_location' ) . ' ORDER BY `id`';
        }
        else
        {
            if( is_array( $categories ) )
            {
                $categories = implode( ',', $categories );
            }
        $query = 'SELECT `id` FROM ' . $db->quoteName( '#__mymaplocations_location' ) . ' WHERE `catid` IN (' . $categories . ') ORDER BY `id`';
            // with category filters
            // return article ids in that category
        }
        $db->setQuery( $query );
        return $db->loadResultArray();	
    }

    public function getCategories()
	{
		$db		= Komento::getDBO();
		$query	= 'SELECT a.id, a.title, a.level, a.parent_id'
				. ' FROM `#__categories` AS a'
				. ' WHERE a.extension = ' . $db->quote( 'com_mymaplocations' )
				. ' AND a.parent_id > 0'
				. ' ORDER BY a.lft';

		$db->setQuery( $query );
		$categories = $db->loadObjectList();

		if( Komento::joomlaVersion() >= '1.6' )
		{
			foreach( $categories as &$row )
			{
				$repeat = ( $row->level - 1 >= 0 ) ? $row->level - 1 : 0;
				$row->treename = str_repeat( '.&#160;&#160;&#160;', $repeat ) . ( $row->level - 1 > 0 ? '|_&#160;' : '' ) . $row->title;
			}
		}

		return $categories;
	}

    // to determine if is listing view
    public function isListingView()
    {
        return JFactory::getApplication()->input->getString('view') == 'location';
    }

    // to determine if is entry view
    public function isEntryView()
    {
        return JFactory::getApplication()->input->getString('view') == 'location';
    }

    public function onExecute( &$article, $html, $view, $options = array() )
    {
	return $html;
		
    }
         public function getComponentIcon()
	{
		return JUri::root(TRUE) . '/images/icons/icon-blue-love.png';
	}
        public function getComponentName()
	{
		return JText::_( 'My Map Locations' );
	}
	public function getContentPermalink( $append = '', $external = false )
	{
	
	    $link = 'index.php?option=com_mymaplocations&view=location&id='.$this->_staticid;
		$link	= JRoute::_( $link );
		return $link;
	}
}
