<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// No direct access.
defined('_JEXEC') or die;
use Joomla\Utilities\ArrayHelper;

jimport('joomla.application.component.modelform');
jimport('joomla.application.component.modeladmin');
jimport('joomla.event.dispatcher');

/**
 * MyMaplocations model.
 */
class MyMaplocationsModellocation extends JModelAdmin {

    var $_item = null;

    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @since	1.6
     */
    protected function populateState() {
        $app = JFactory::getApplication('com_mymaplocations');

        // Load state from the request userState on edit or from the passed variable on default
        if (JFactory::getApplication()->input->getString('layout') == 'edit') {
            $id = JFactory::getApplication()->getUserState('com_mymaplocations.edit.location.id');
        } else {
            $id = JFactory::getApplication()->input->getInt('id');
            JFactory::getApplication()->setUserState('com_mymaplocations.edit.location.id', $id);
        }
        $this->setState('location.id', $id);

        // Load the parameters.
        $params = $app->getParams();
        $this->setState('params', $params);
    }

    /**
     * Method to get an ojbect.
     *
     * @param	integer	The id of the object to get.
     *
     * @return	mixed	Object on success, false on failure.
     */
    public function &getData($id = null) {
        if ($this->_item === null) {
            $this->_item = false;

            if (empty($id)) {
                $id = $this->getState('location.id');
            }

            // Get a level row instance.
            $table = $this->getTable();

            // Attempt to load the row.
            if ($table->load($id)) {
                // Check published state.
                if ($published = $this->getState('filter.published')) {
                    if ($table->state != $published) {
                        return $this->_item;
                    }
                }

                // Convert the JTable to a clean JObject.
                $properties = $table->getProperties(1);
                $this->_item = ArrayHelper::toObject($properties, 'JObject');
            } elseif ($error = $table->getError()) {
                $this->setError($error);
            }
        }

        return $this->_item;
    }

    public function getTable($type = 'location', $prefix = 'MyMaplocationsTable', $config = array()) {
        $this->addTablePath(JPATH_COMPONENT_ADMINISTRATOR . '/tables');
        return JTable::getInstance($type, $prefix, $config);
    }

    /**
     * Method to check in an item.
     *
     * @param	integer		The id of the row to check out.
     * @return	boolean		True on success, false on failure.
     * @since	1.6
     */
    public function checkin($id = null) {
        // Get the id.
        $id = (!empty($id)) ? $id : (int) $this->getState('location.id');

        if ($id) {

            // Initialise the table
            $table = $this->getTable();

            // Attempt to check the row in.
            if (method_exists($table, 'checkin')) {
                if (!$table->checkin($id)) {
                    $this->setError($table->getError());
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * Method to check out an item for editing.
     *
     * @param	integer		The id of the row to check out.
     * @return	boolean		True on success, false on failure.
     * @since	1.6
     */
    public function checkout($id = null) {
        // Get the user id.
        $id = (!empty($id)) ? $id : (int) $this->getState('location.id');

        if ($id) {

            // Initialise the table
            $table = $this->getTable();

            // Get the current user object.
            $user = JFactory::getUser();

            // Attempt to check the row out.
            if (method_exists($table, 'checkout')) {
                if (!$table->checkout($user->get('id'), $id)) {
                    $this->setError($table->getError());
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * Method to get the profile form.
     *
     * The base form is loaded from XML 
     * 
     * @param	array	$data		An optional array of data for the form to interogate.
     * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
     * @return	JForm	A JForm object on success, false on failure
     * @since	1.6
     */
    public function getForm($data = array(), $loadData = true) {
        // Get the form.
        $form = $this->loadForm('com_mymaplocations.location', 'location', array('control' => 'jform', 'load_data' => $loadData));
        if (empty($form)) {
            return false;
        }

        return $form;
    }

    /**
     * Method to get the data that should be injected in the form.
     *
     * @return	mixed	The data for the form.
     * @since	1.6
     */
    protected function loadFormData() {
        $data = $this->getData();

        return $data;
    }

    /**
     * Method to save the form data.
     *
     * @param	array		The form data.
     * @return	mixed		The user id on success, false on failure.
     * @since	1.6
     */
    public function save($data) {
        $id = (!empty($data['id'])) ? $data['id'] : (int) $this->getState('location.id');
        $user = JFactory::getUser();

        if ($id) {
            //Check the user can edit this item
            $authorised = $user->authorise('core.edit', 'com_mymaplocations.location.' . $id);
             if($authorised)
             {}
             else
             {
                 $authorised = $user->authorise('core.edit.own', 'com_mymaplocations.location.' . $id);
             }
        } else {
            //Check the user can create new items in this section
            $authorised = $user->authorise('core.create', 'com_mymaplocations');
        }

        if ($authorised !== true) {
           JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'),'error');
            return false;
        }
        $jinput = JFactory::getApplication()->input;
        $files = $jinput->files->get('jform');
		$picture = $files['file_logo'];
        if($picture['error']== 0)
        {
            $fileName = $picture['name'];
            $uploadedFileNameParts = explode('.',$fileName);
            $uploadedFileExtension = array_pop($uploadedFileNameParts);
            $validFileExts = explode(',', 'jpeg,jpg,png,gif');
            //assume the extension is false until we know its ok
            $extOk = false;
            foreach($validFileExts as $key => $value)
            {
        	if( preg_match("/$value/i", $uploadedFileExtension ) )
        	{
        		$extOk = true;
        	}
            }
			if($extOk)
			{
                $fileTemp = $picture['tmp_name'];
                $imageinfo = getimagesize($fileTemp);
                $okMIMETypes = 'image/jpeg,image/pjpeg,image/png,image/x-png,image/gif';
                $validFileTypes = explode(",", $okMIMETypes);
				$rand=rand(0,1000);
                $uploadPath = JPATH_SITE.DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.$rand.'_'.$fileName;
                if(JFile::upload($fileTemp, $uploadPath)) 
                {
                    $data['logo']='images'.DIRECTORY_SEPARATOR.$rand.'_'.$fileName;
                }
			}
        }
		if($data['icon_list'])
		{
			     $data['icon']='images'.DIRECTORY_SEPARATOR.'icons'.DIRECTORY_SEPARATOR.$data['icon_list'];    
		}
		$icon = $files['file_icon'];
        if($icon['error']== 0)
        {
            $fileName = $icon['name'];
            $uploadedFileNameParts = explode('.',$fileName);
            $uploadedFileExtension = array_pop($uploadedFileNameParts);
            $validFileExts = explode(',', 'jpeg,jpg,png,gif');
            //assume the extension is false until we know its ok
            $extOk = false;
            foreach($validFileExts as $key => $value)
            {
        	if( preg_match("/$value/i", $uploadedFileExtension ) )
        	{
        		$extOk = true;
        	}
            }
			if($extOk)
			{
                $fileTemp = $icon['tmp_name'];
                $imageinfo = getimagesize($fileTemp);
                $okMIMETypes = 'image/jpeg,image/pjpeg,image/png,image/x-png,image/gif';
                $validFileTypes = explode(",", $okMIMETypes);
				$rand=rand(0,1000);
                $uploadPath = JPATH_SITE.DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'icons'.DIRECTORY_SEPARATOR.$rand.'_'.$fileName;
                if(JFile::upload($fileTemp, $uploadPath)) 
                {
                    $data['icon']='images'.DIRECTORY_SEPARATOR.'icons'.DIRECTORY_SEPARATOR.$rand.'_'.$fileName;
                }
			}
        }
         parent::save($data);
    }
      protected function prepareTable($table) {
        jimport('joomla.filter.output');
        $table->name = htmlspecialchars_decode($table->name, ENT_QUOTES);
        $table->alias = JApplicationHelper::stringURLSafe($table->alias);

        if (empty($table->alias)) {
            $table->alias = JApplicationHelper::stringURLSafe($table->name);
        }
        if (empty($table->id)) {

            // Set ordering to the last item if not set
            if (@$table->ordering === '') {
                $db = JFactory::getDbo();
                $db->setQuery('SELECT MAX(ordering) FROM #__mymaplocations_location');
                $max = $db->loadResult();
                $table->ordering = $max + 1;
            }
        }
    }
  

}