<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
defined('_JEXEC') or die;
use Joomla\Utilities\ArrayHelper;

jimport('joomla.application.component.modellist');
jimport('joomla.application.categories');

/**
 * Methods supporting a list of MyMaplocations records.
 */
class MyMaplocationsModellocations extends JModelList {
            static $result = 0;
    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'a.id',
				'name', 'nom',
				'distance', 'distance',
				'rdate','rdate',
				'date','date',
				'alpha','alpha',
				'ralpha','ralpha'
			);
		}
        parent::__construct($config);
    }

    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @since	1.6
     */
    protected function populateState($ordering = null, $direction = null) {

        // Initialise variables.
        $app = JFactory::getApplication();

        // List state information
        $limit = 0;
        $this->setState('list.limit', $limit);
		$active = JFactory::getApplication()->getMenu()->getActive();
		if($active)
		{
		$extra_catid=$active->getParams()->get('extra_catid',0);
		$fetchchild=$active->getParams()->get('fetchchild',1);
		}
		else
		{
		$extra_catid=0;
		$fetchchild=1;
		}
		$this->setState('filter.extra_catid',$extra_catid);
        $this->setState('filter.fetchchild',$fetchchild);
		$limitstart = 0;
        $this->setState('list.start', $limitstart);
        $search = $app->getUserStateFromRequest($this->context . '.filter.zip', 'searchzip');
        $this->setState('filter.zip', $search);
		$searchpostal = $app->getUserStateFromRequest($this->context . '.filter.searchpostal', 'searchpostal');
        $this->setState('filter.searchpostal', $searchpostal);
        $radius = $app->getUserStateFromRequest($this->context . '.filter.radius', 'radius');
        $this->setState('filter.radius', $radius);
        $catid = $app->getUserStateFromRequest($this->context . '.filter.category', 'filter_catid');
        $this->setState('filter.category', $catid);
        $component = $app->getUserStateFromRequest($this->context . '.filter.component', 'component');
        $this->setState('filter.component', $component);
        $this->setState('filter.language', JLanguageMultilang::isEnabled());
        $k2_catid = $app->getUserStateFromRequest($this->context . '.filter.k2_catid', 'k2_catid',$extra_catid);
	    $this->setState('filter.k2_catid', $k2_catid);
		$latitude=JFactory::getApplication()->input->getFloat('latitude',0);
	    $this->setState('filter.lat', $latitude);
		$longitude=JFactory::getApplication()->input->getFloat('longitude',0);
		$this->setState('filter.long', $longitude);
		$searchzipcode =  $app->input->getString('searchzipcode');
        $this->setState('filter.searchzipcode', $searchzipcode);
        $country_list =  $app->input->getString('country_list');
        $this->setState('filter.country_list', $country_list);
        $state_list=  $app->input->getString('state_list');
        $this->setState('filter.state_list', $state_list);
		$city_list= $app->input->getString('city_list');
        $this->setState('filter.city_list', $city_list);
        
        $orderCol = $app->input->getString('filter_order', 'distance');
		if (!in_array($orderCol, $this->filter_fields))
		{
			$orderCol = 'distance';
		}

		$this->setState('list.ordering', $orderCol);

        
        // List state information.
        parent::populateState();
    }

    /**
     * Build an SQL query to load the list data.
     *
     * @return	JDatabaseQuery
     * @since	1.6
     */
    protected function getListQuery() {
		
        // Create a new query object.
        $location = array();
		
		$now=JFactory::getDate()->toSql();
        $component = $this->getState('filter.component');
		$extra_catid=$this->getState('filter.extra_catid');
		$fetchchild=$this->getState('filter.fetchchild');
		
            $catid = $this->getState('filter.category');
            $zipcode = $this->getState('filter.zip');
            $k2_catid = $this->getState('filter.k2_catid');
			$country_list =  JFactory::getApplication()->input->getString('country_list');
        
            $state_list=JFactory::getApplication()->input->getString('state_list');
			$city_list=JFactory::getApplication()->input->getString('city_list');
            $searchzipcode=JFactory::getApplication()->input->getString('searchzipcode');
            $tags=JFactory::getApplication()->input->getVar('tags',array());
			$format=JFactory::getApplication()->input->getVar('format',null);
            $db = $this->getDbo();
			$nullDate = $db->getNullDate();
            $query = $db->getQuery(true);
			if($format=="json")
			{
				$start=JFactory::getApplication()->input->getInt('start',0);
				$this->setState('list.start', $start);
			}
             $zoo_category_id=(int)JFactory::getApplication()->input->getInt('zoo_category_id',$extra_catid);
            if (empty($zipcode)) {
                $query->select("*");
				 $query->from("#__mymaplocations_locations");
				 $query->where("1=0");
				 return $query;
            }
            $radius = $this->getState('filter.radius');
            @$zip = MyMaplocationsHelper::getLatLongFromPostcode($zipcode,$this->getState('filter.lat'),$this->getState('filter.long'));
            $this->setState('filter.lat', $zip['lat']);
            $this->setState('filter.long', $zip['lang']);
            
            $params = JComponentHelper::getParams('com_mymaplocations');
            $type = $params->get('distance_type', 1);
            if ($type == 1) {
                $distance = 3959;
            } else {
                $distance = 6371;
            }
            // Select the required fields from the table.
            if($component=="com_custom")
            {
                $sql=MyMaplocationsHelper::getCustomSql($zip,$distance);
                return $sql;
            }
             if($component=="com_community")
            {
                $query->select(
                    $this->getState(
                            "list.select", " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( a.latitude ) ) * cos( radians( a.longitude ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( a.latitude ) ) ) ) AS distance "
                    )
                    );
                $query->select('a.*');
                $query->select('a.userid as id,a.avatar as logo, a.thumb as icon');
                $query->select('l.name as name');
				$query->select('l.name as nom');
				
                $query->where(' l.block =0');
                $datingsearch_gender=JFactory::getApplication()->input->getString('datingsearch_gender');
                $datingsearch_agefrom=JFactory::getApplication()->input->getInt('datingsearch_agefrom');
                $datingsearch_ageto=JFactory::getApplication()->input->getInt('datingsearch_ageto');
				$community_category_id=JFactory::getApplication()->input->getInt('community_category_id',$extra_catid);
                if(!empty( $datingsearch_gender)||(!empty($datingsearch_ageto)))
                {
                    
                    require_once( JPATH_ROOT .'/components/com_community/libraries/core.php');
                    $plugin = JPluginHelper::getPlugin('community', 'mymaplocations');
                    $params = new JRegistry($plugin->params);
                    $genderfield=$params->get('field_gender','FIELD_GENDER');
                    $birthdate=$params->get('field_birthdate','FIELD_BIRTHDATE');
                    $fields=MyMaplocationsHelper::getJoomsocialField($genderfield,$birthdate);
                    foreach($fields as $field)
                    {
                        if($field->fieldcode==$genderfield)
                        {
                            $genderid=$field->id;
                        }
                        if($field->fieldcode==$birthdate)
                        {
                            $birthid=$field->id;
                        }
                    }
                    $datetime0 = new Datetime();
				$datetime0->modify('-'.$datingsearch_ageto . ' year');
				$date1 = $datetime0->format('Y-m-d 00:00:00');

				$datetime1 = new Datetime();
				$datetime1->modify('-'.$datingsearch_agefrom . ' year');
				$date2 = $datetime1->format('Y-m-d 23:59:59');
                                if(!empty($datingsearch_gender))
                                {
                                
                    $datingsearch_gender = $db->quote('%' . $db->escape($datingsearch_gender, true) . '%', false);
                    $query->where(' b.value LIKE'.$datingsearch_gender);
                    $query->where(' b.field_id ='. $db->quote($genderid));
                                }
                                if(!empty($datingsearch_ageto)||!empty($datingsearch_agefrom))
                                {
                    $query->where(" DATE_FORMAT(c.value,'%Y-%m-%d %H:%i:%s') BETWEEN ".$db->quote($date1)." AND ".$db->quote($date2)." ");
                    $query->where(' c.field_id ='. $db->quote($birthid));
                                }
                }
				if(($community_category_id)&&($community_category_id!=0))
					{
						$query->where(' a.profile_id ='. $db->quote($community_category_id));
					}
                $query->from('`#__community_users` AS a');
                $query->join('LEFT', '#__users AS l ON l.id = a.userid');
                if(!empty( $datingsearch_gender))
                {
                    $query->join('LEFT', '#__community_fields_values AS b ON a.userid = b.user_id');
                     
                }
                if(!empty($datingsearch_ageto)||!empty($datingsearch_agefrom))
                    {
                $query->join('LEFT', '#__community_fields_values AS c ON a.userid = c.user_id');
                    }
					
                
                //echo nl2br(str_replace('#__','jos_',$query));die();
                
            }
            else if($component=="com_ohanah")
            {
                $currentDate  = JHtml::_('date', 'Now', 'Y-m-d');
				$cal_event_date=$db->quote(JFactory::getApplication()->input->getString('cal_event_date',$currentDate));
				$date     = JFactory::getDate();
				$newDate  = new JDate($date . '+ 365 day');  
				$endate = $newDate->format('Y-m-d');
				$cal_event_enddate=$db->quote(JFactory::getApplication()->input->getString('cal_event_enddate',$endate));
                $query->select(
                    $this->getState(
                            "list.select", " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( a.latitude ) ) * cos( radians( a.longitude ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( a.latitude ) ) ) ) AS distance "
                    )
                    );
                $ohanah_category_id=JFactory::getApplication()->input->getInt('ohanah_category_id',$extra_catid);
                $query->select('d.start,d.end,DATE_FORMAT(d.start, "%Y-%m-%d") AS start_date,DATE_FORMAT(d.end, "%Y-%m-%d") AS end_date');
                $query->select('a.ohanah_event_id as id,a.image_path as logo,a.image_path as icon');
                $query->select('a.address_1 as address');
                $query->select('a.city as town');
                $query->select('a.state as locationstate');
                $query->select('a.title as name');
				$query->select('a.title as nom');
          
                if(is_numeric($ohanah_category_id)&&($ohanah_category_id!=0))
                {
                 $query->where('ohanah_category_id ='.$db->quote($ohanah_category_id));	
                }
				
				$query->having('(start_date <= '.$cal_event_date.' AND end_date >= '.$cal_event_enddate.' OR start_date BETWEEN '.$cal_event_date.' AND '.$cal_event_enddate.' OR end_date BETWEEN '.$cal_event_date.' AND '.$cal_event_enddate.')');
           
                $query->from('`#__ohanah_events` AS a');
                $query->join('LEFT', '#__ohanah_dates AS d ON d.ohanah_event_id = a.ohanah_event_id');
                
                //echo nl2br(str_replace('#__','jos_',$query));die();
                
            }
            else if($component=="com_eventbooking")
            {
                $user     = JFactory::getUser();
                $query->select(
                    $this->getState(
                            "list.select", " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( c.lat ) ) * cos( radians( c.long ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( c.lat ) ) ) ) AS distance "
                    )
                    );
                $currentDate  = JHtml::_('date', 'Now', 'Y-m-d');
				$cal_event_date=$db->quote(JFactory::getApplication()->input->getString('cal_event_date',$currentDate));
				$date     = JFactory::getDate();
				$newDate  = new JDate($date . ' + 365 day');  
				$endate = $newDate->format('Y-m-d');
				$cal_event_enddate=$db->quote(JFactory::getApplication()->input->getString('cal_event_enddate',$endate));
                $query->select('a.*, c.name AS location_name,c.*,c.city as town,c.zip as postal');
				$query->select('c.name AS nom');
				$query->select('a.title AS name');
                $query->select('a.id AS id');
                $query->select('a.id AS extra_id');
				$query->select('d.category_id AS category_id');
				$query->select('a.event_date as start, a.event_end_date as end');
                $query->select('c.lat as latitude, c.long as longitude');
                $query->from('#__eb_events AS a')
                ->leftJoin('#__eb_locations AS c ON a.location_id = c.id')
                ->leftJoin('#__eb_event_categories AS d ON a.id = d.event_id')
                ->where('a.published = 1')
                ->where('a.access IN (' . implode(',', $user->getAuthorisedViewLevels()) . ')')
                ->where('(DATE(a.event_date) >= ' . $cal_event_date . ' OR DATE(a.cut_off_date) >= ' . $cal_event_date . ')')
				->where('(DATE(a.event_date) <= ' . $cal_event_enddate .')');
                 $event_category_id=JFactory::getApplication()->input->getInt('event_category_id',$extra_catid);
                  if(is_numeric($event_category_id)&&($event_category_id!=0))
                {
                 $query->where('d.category_id ='.$db->quote($event_category_id));
				
                }
				else
				{
					 $query->where(('d.main_category = 1'));
				}
				$query->group('a.id');
                //echo nl2br(str_replace('#__','jos_',$query));die();
                
            }
			else if($component=="com_easyblog")
			{
				    $query->select(
                    $this->getState(
                            "list.select", " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( a.latitude ) ) * cos( radians( a.longitude ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( a.latitude ) ) ) ) AS distance "
                    )
				);
                $query->select('a.title as nom');
				$query->select('a.title as name');
				$query->select('a.id as extra_id');
				$query->where(' a.published =1');
				$query->where(' a.state =0');
				$eb_category_id=JFactory::getApplication()->input->getInt('eb_category_id',$extra_catid);
                if(is_numeric($eb_category_id)&&($eb_category_id!=0))
					{

						$query->where('a.category_id ='.$db->quote($eb_category_id));

					}
					if(($tags))
					{
                    ArrayHelper::toInteger($tags);
                    $tags = @implode(',', $tags);
                    $db = JFactory::getDBO();
                    $sql="select DISTINCT post_id from #__easyblog_post_tag where tag_id IN ({$tags})";
                    $db->setQuery($sql);
                    $finaltags=$db->loadAssoclist();
					$finalarr=array();
                    foreach($finaltags as $finaltag)
                    {
                        $finalarr[]=$finaltag['post_id'];
                    }
					
                    $query->where('a.id IN('.implode(",", $finalarr).')');
					}
         
				       if ($this->getState('filter.language'))
					{
				$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
			}
				$query->from('`#__easyblog_post` AS a');
			}
            else  if($component=="com_easysocial")
            {
                $query->select(
                    $this->getState(
                            "list.select", " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( m.raw ) ) * cos( radians( n.raw ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( m.raw ) ) ) ) AS distance "
                    )
                    );
                $query->select('a.user_id as id');
                $query->select('l.name as name');
				$query->select('l.name as nom');
                $query->select('m.raw as latitude');
                $query->select('n.raw as longitude');
                $query->where(' l.block =0');
                $query->where(' a.type ='.$db->quote('joomla'));
                $query->where(' m.datakey ='.$db->quote('latitude'));
                $query->where('n.datakey ='.$db->quote('longitude'));
                $query->from('`#__social_users` AS a');
                $query->join('LEFT', '#__users AS l ON l.id = a.user_id');
                $query->join('LEFT', '#__social_fields_data AS m ON l.id = m.uid');
                $query->join('LEFT', '#__social_fields_data AS n ON l.id = n.uid');
                $query->where('(m.raw !="" ) ');
                $query->where('(n.raw !="" ) ');
                  $query->group("l.id");
            }
			else  if($component=="com_adsmanager")
            {
                $query->select(
                    $this->getState(
                            "list.select", " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( a.ad_gmap_lat ) ) * cos( radians( a.ad_gmap_lng ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( a.ad_gmap_lat ) ) ) ) AS distance "
                    )
                    );
                $query->select('a.ad_headline as nom');
				$query->select('a.ad_headline as name');
				$query->select('a.ad_text as description');
				$query->select('a.name as vendor_name');
                $query->select('a.ad_gmap_lat as latitude');
                $query->select('a.ad_gmap_lng as longitude');
				$query->select('a.ad_gmap_address as address');
				$query->select('a.ad_phone as phone');
				$query->select('c.catid as catid');
				$query->select('a.id as extra_id');
				$query->where('a.published=1');
				$query->where("(a.expiration_date	 = ".$db->Quote($nullDate)." OR a.expiration_date	 >= ".$db->Quote($now).")");
				$adsmanager_category_id=JFactory::getApplication()->input->getInt('adsmanager_category_id',$extra_catid);
                if(is_numeric($adsmanager_category_id)&&($adsmanager_category_id!=0))
					{
						
						$query->where('c.catid ='.$db->quote($adsmanager_category_id));
						
					}
         
					$query->from('`#__adsmanager_ads` AS a');
				 $query->join('LEFT', '#__adsmanager_adcat AS c ON a.id = c.adid');
            }
			else  if($component=="com_jomclassifieds")
            {
                $query->select(
                    $this->getState(
                            "list.select", " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( a.latitude ) ) * cos( radians( a.langtitude ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( a.latitude ) ) ) ) AS distance "
                    )
                    );
                $query->select('a.title as nom');
				$query->select('a.title as name');
				$query->select('a.description as description');
                $query->select('a.latitude as latitude');
                $query->select('a.langtitude as longitude');
				$query->select('a.address as address');
				$query->select('a.postalcode as zipcode');
				$query->select('a.catid as catid');
				$query->where('a.published=1');
				$jom_category_id=JFactory::getApplication()->input->getInt('jom_category_id',$extra_catid);
                if(is_numeric($jom_category_id)&&($jom_category_id!=0))
					{
						
						$query->where('a.catid ='.$db->quote($jom_category_id));
						
					}
					if($tags)
					{
					ArrayHelper::toInteger($tags);
					$query->where('a.tagid IN('.implode(",",$tags).		')');
					}
					$query->from('`#__jomcl_adverts` AS a');
			
			}
			else  if($component=="com_djclassifieds")
            {
                $query->select(
                    $this->getState(
                            "list.select", " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( a.latitude ) ) * cos( radians( a.longitude ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( a.latitude ) ) ) ) AS distance "
                    )
				);
                $query->select('a.name as nom');
				$query->select('a.id as extra_id');
				$query->select('c.alias as c_alias');
				$query->select('u.name as username');
				$query->where('a.published=1');
				$query->where("(a.date_exp	 = ".$db->Quote($nullDate)." OR a.date_exp	 >= ".$db->Quote($now).")");
				$djclassified_category_id=JFactory::getApplication()->input->getInt('djclassified_category_id',$extra_catid);
                if(is_numeric($djclassified_category_id)&&($djclassified_category_id!=0))
					{
						require_once(JPATH_BASE.DIRECTORY_SEPARATOR.'administrator'.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_djclassifieds'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'djcategory.php');
						$cats= DJClassifiedsCategory::getSubCatIemsCount($djclassified_category_id,1,'c.name');
						$djcatid=array();
						foreach($cats as $ci => $c){
							$djcatid[]=$c->id;
						}
						 ArrayHelper::toInteger($djcatid);
						$query->where('a.cat_id IN('.implode(",",$djcatid).')');
					}
                $query->from('`#__djcf_items` AS a');
				$query->join('LEFT', '#__djcf_categories AS c ON a.cat_id = c.id');
				$query->join('LEFT', '#__users u ON u.id = a.user_id');
				//==echo nl2br($query);die();
				
            }
			else  if($component=="com_mytestimonials")
            {
                $query->select(
                    $this->getState(
                            "list.select", " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( a.latitude ) ) * cos( radians( a.longitude ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( a.latitude ) ) ) ) AS distance "
                    )
				);
                $query->select('a.title as nom');
				$query->select('a.title as name');
				$query->select('a.image as icon');
				$query->select('a.image as logo');
				$query->select('a.comments as description');
				$query->select('a.city as town');
				$query->select('a.county as locationstate');
				$query->select('a.zip as postal');
				$query->select('c.title as categorytitle');
				$query->where('a.state=1');
				$query->where('c.published=1');
				$mytestimonials_category_id=JFactory::getApplication()->input->getInt('mytestimonials_category_id',$extra_catid);
                if(is_numeric($mytestimonials_category_id)&&($mytestimonials_category_id!=0))
					{
						$query->where('a.catid ='.(int)$mytestimonials_category_id);
					}
                $query->from('`#__mytestimonials_testimonial` AS a');
				$query->join('LEFT', '#__categories AS c ON a.catid = c.id');
				//echo nl2br($query);die();
				
            }
            else
            {
           
            $query->select(
                    $this->getState(
                            "list.select", " a.* ,( " . $distance . " * acos( cos( radians(" . $zip['lat'] . ") ) * cos( radians( a.latitude ) ) * cos( radians( a.longitude ) - radians( " . $zip['lang'] . ") ) + sin( radians( " . $zip['lat'] . ") ) * sin( radians( a.latitude ) ) ) ) AS distance "
                    )
            );
            if ($component == "com_k2") {
                $query->select('k.title as name,k.alias as k2alias,k.catid as k2catid');
				$query->select('cat.alias as k2catalias');
				$query->select('k.title as nom');
						$query->select('r.*');
            }
			 else if ($component == "com_content") {
                $query->select('k.title as name');
				$query->select('k.catid  as catid');
				$query->select('mc.title AS maincat_title, mc.alias AS maincat_alias');
                $query->select('k.alias AS alias');
                $query->select('k.title as nom');
				$query->select('r.*');
				
            }
            else if ($component == "com_zoo") {
                $query->select('k.*');
				$query->select('k.name as nom');
                
            }
            else if ($component == "com_virtuemart") {
                $query->select('k.*');
                $query->select('c.virtuemart_category_id as catid');
                $query->select('m.product_name as nom');
                $query->select('m.product_name as product_name');
				$query->select('r.product_price as price_value');
                
            }
            else if ($component == "com_comprofiler") {
                $query->select('l.username as name');
                 $query->select('k.*');
				 $query->select('l.username as nom');
				 
            }
            else if($component=="com_hikamarket")
            {
                 $plugin = JPluginHelper::getPlugin('hikamarket', 'mymaplocations');
                $params = new JRegistry($plugin->params);
                $company=$db->escape($params->get('vendor_company_column','vendor_address_company'));
                $address=$db->escape($params->get('vendor_address_column','vendor_address_street'));
                $city=$db->escape($params->get('vendor_city_column','vendor_address_city'));
                $st=$db->escape($params->get('vendor_state_column','vendor_address_state'));
                $country=$db->escape($params->get('vendor_country_column','vendor_address_country '));
                $zip=$db->escape($params->get('vendor_zip_column','vendor_address_post_code'));
                $query->select('j.product_id as product_id,r.price_currency_id as currency_id,r.price_value as price_value,n.category_name as category_name ,n.category_id as category_id,j.product_vendor_id as vendor_id,j.product_tax_id as tax_id,k.vendor_name as vendor_name,i.file_path as logo,i.file_path as icon,j.product_name as name,k.'.$company.' as company, k.'.$address.' as address, k.'.$zip.' as postal,k.'.$city.' as town,q.zone_name_english as locationstate,m.zone_name_english as country');
				 $query->select('j.product_name as nom');
				  $query->select('j.product_alias as alias');
				  $query->select('k.vendor_alias as vendor_alias');
         
            }
             else if($component=="com_hikashop")
            {
                 $plugin = JPluginHelper::getPlugin('hikamarket', 'mymaplocations');
                $params = new JRegistry($plugin->params);
                $company=$db->escape($params->get('vendor_company_column','vendor_address_company'));
                $address=$db->escape($params->get('vendor_address_column','vendor_address_street'));
                $city=$db->escape($params->get('vendor_city_column','vendor_address_city'));
                $st=$db->escape($params->get('vendor_state_column','vendor_address_state'));
                $country=$db->escape($params->get('vendor_country_column','vendor_address_country '));
                $zip=$db->escape($params->get('vendor_zip_column','vendor_address_post_code'));
                $query->select('k.vendor_name as name,k.'.$company.' as company, k.'.$address.' as address, k.'.$zip.' as postal,k.'.$city.' as town,q.zone_name_english as locationstate,m.zone_name_english as country,k.vendor_image as icon');  
			 $query->select('k.vendor_name as nom');
			  $query->select('k.vendor_alias as vendor_alias');
			 
            }
            
			else if($component=="com_mymaplocations")
			{
				 $query->select('a.name as nom');
            	
			}

            $query->from('`#__mymaplocations_location` AS a');
            if ($component == "com_k2") {
                $query->join('LEFT', '#__k2_items AS k ON k.id = a.extra_id');
				$query->join('LEFT', '#__k2_rating AS r ON r.itemID = a.extra_id');
				$query->join('LEFT', '#__k2_categories AS cat ON cat.id = k.catid');

            }
			else if($component=="com_content")
			{
				$query->join('LEFT', '#__content AS k ON k.id = a.extra_id');
				$query->join('LEFT', '#__categories AS mc ON mc.id = k.catid');
				$query->join('LEFT', '#__content_rating AS r ON r.content_id = a.extra_id');
				
			}
            else if ($component == "com_zoo") {
                $query->join('LEFT', '#__zoo_item AS k ON k.id = a.extra_id');
                if($zoo_category_id)
                {
                     $query->join('LEFT', '#__zoo_category_item AS c ON c.item_id = a.extra_id');
                }
            } 
            
            else if ($component == "com_comprofiler") {
                $query->join('LEFT', '#__comprofiler AS k ON k.id = a.extra_id');
                $query->join('LEFT', '#__users AS l ON l.id = a.extra_id');
                $userlist=JFactory::getApplication()->input->getInt('cb_list',$extra_catid);
			
                if(!empty($userlist))
                {
                $db = JFactory::getDBO();
                $sql="select * from #__comprofiler_lists where listid=".(int)$userlist;
                $db->setQuery($sql);
                $group = $db->loadObject();
				
			    $cbparams=new JRegistry($group->params);
                $ugroup=explode( '|*|',$group->usergroupids);
                   
                   if (  $cbparams->get( 'filter_basic' ) ) {
			$filtering=$cbparams->get( 'filter_basic' );
                        foreach ( $filtering as $filter ) {
                                        $column					=	( isset( $filter->column ) ? $filter->column : null );
					$operator				=	( isset( $filter->operator ) ? $filter->operator : null );
					$value					=	( isset( $filter->value ) ? $filter->value : null );
                                        if ( $column && $operator ) {
											if($column=="name")
											{
												$column="l.name";
											}
                                            $column				=	$db->QuoteName( $column );
					    $escapedValue		=	 $db->escape($value, true);
                                            if ( in_array( $operator, array( 'IN', 'NOT IN||ISNULL' ) ) ) {
							$escapedValue	=	explode( ',', $escapedValue );
						} elseif ( in_array( $operator, array( 'LIKE', 'NOT LIKE||ISNULL' ) ) ) {
							$escapedValue	=	'%' . addcslashes( $escapedValue, '%_' ) . '%';
						}
                                                if ( is_array( $escapedValue ) ) {
						} else {
							$escapedValue	=	$db->Quote( $escapedValue );
						}
                                                if ( substr( $operator, -8 ) == '||ISNULL' ) {
							$operator		=	substr( $operator, 0, -8 );
							$isNull			=	true;
						} else {
							$isNull			=	false;
						}
    						$basicFilter		=	$column . ' ' . $operator . ' ' . $escapedValue;
                                                if ( ( $operator === '<>' ) && ( $value === '' ) ) {
							// Users expect a filter of not equal to empty string to also not match null (no value):
							$basicFilter	=	'( ' . $basicFilter . ' AND ' . $column . ' IS NOT NULL )';
						} elseif ( $isNull || ( ( $operator === '=' ) && ( $value === '' ) ) ) {
							// Users expect a filter of equal to empty to also match null (no value) or in the case of ISNULL operator:
							$basicFilter	=	'( ' . $basicFilter . ' OR ' . $column . ' IS NULL )';
						}
                                                $query->where($basicFilter);
                                        }
                        }
			}
			   if (  $cbparams->get( 'filter_advanced' ) ) {
				$filtering=$cbparams->get( 'filter_advanced' );
				$filtering=str_replace( array( "u", "ue" ), array( "l", "k" ),$filtering );

				$query->where($filtering);
			   }
			
                
                    if(!empty($ugroup))
                        { 
                    $query->where('g.group_id IN (' . implode( ",",$ugroup) . ')');
                  $query->join('LEFT','#__user_usergroup_map AS g ON g.user_id = a.extra_id');

                }
                }
            }
            else if ($component == "com_hikamarket") {
                $query->join('LEFT', '#__hikamarket_vendor AS k ON k.vendor_id = a.extra_id');
                $query->join('LEFT', '#__hikashop_product AS j ON k.vendor_id = j.product_vendor_id');
                $product_category_id=JFactory::getApplication()->input->getInt('product_category',$extra_catid);
                $searchproduct=JFactory::getApplication()->input->getString('searchproduct');
                $query->join('LEFT', '#__hikashop_product_category AS p ON p.product_id = j.product_id');
                $query->join('LEFT', '#__hikashop_file AS i ON i.file_ref_id = j.product_id');
                $query->join('LEFT', '#__hikashop_zone AS q ON q.zone_namekey =k.'.$st);
                $query->join('LEFT', '#__hikashop_zone AS m ON m.zone_namekey =k.'.$country);
                $query->join('LEFT', '#__hikashop_category AS n ON n.category_id =p.category_id');
                $query->join('LEFT', '#__hikashop_price AS r ON r.price_product_id =j.product_id');
            }
            else if ($component == "com_hikashop") {
                $query->join('LEFT', '#__hikamarket_vendor AS k ON k.vendor_id = a.extra_id');
                $query->join('LEFT', '#__hikashop_zone AS q ON q.zone_namekey =k.'.$st);
                $query->join('LEFT', '#__hikashop_zone AS m ON m.zone_namekey =k.'.$country);
            }
            else if ($component == "com_virtuemart") {
                 if (!class_exists( 'VmConfig' )) require(JPATH_ROOT .'/administrator/components/com_virtuemart/helpers/config.php');
                $query->join('LEFT', '#__virtuemart_products AS k ON k.virtuemart_product_id = a.extra_id');
                $query->join('LEFT', '#__virtuemart_product_categories AS c ON k.virtuemart_product_id = c.virtuemart_product_id');
                $query->join('LEFT', '#__virtuemart_product_prices AS r ON k.virtuemart_product_id = r.virtuemart_product_id');
                $vmconfig = VmConfig::loadConfig();
				$vmlang = $vmconfig::$vmlang;
                $query->join('LEFT', '#__virtuemart_products_'.$vmlang.' AS m ON k.virtuemart_product_id = m.virtuemart_product_id');
                
            }
            // Filter by published state
            $published = 1;
			if(empty($k2_catid))
			{
				$k2_catid=$extra_catid;
			}
            if (($component == "com_k2")&&(!empty($k2_catid))) {
				$finaldata=array();
				if($fetchchild)
				{
                require_once JPATH_SITE.'/components/com_k2/models/itemlist.php';
                $K2ModelItemlist = K2Model::getInstance('Itemlist', 'K2Model');
                $finaldata=$K2ModelItemlist->getCategoryTree((int)$k2_catid);
                }
				else
				{
					$finaldata[]=$k2_catid;
				}
				ArrayHelper::toInteger($finaldata);
                $query->where('k.catid IN('.implode(",", $finaldata).')');

            }
            else if (($catid)&&($component=="com_mymaplocations")) {
                $finalcat[]=$catid;
				if($fetchchild)
				{
                $categoriesModel = JCategories::getInstance('mymaplocations');
                $category = ($categoriesModel->get($catid));
                $childrens = $category->getChildren(true);
                foreach( $childrens as $children)
                {
                   $finalcat[]=($children->id);
                }
				}
                ArrayHelper::toInteger($finalcat);
                $query->where('a.catid IN('.implode(",", $finalcat).')');
            }
            
            if ($component == "com_k2") {
                $query->where(' a.component = ' . $db->quote($component));
                $query->where(' k.published =1 AND k.trash=0 ');
				$query->where(' cat.published =1  ');
				
                if ($this->getState('filter.language'))
		{
			$query->where('k.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}
        
                if(($tags))
                {
                    ArrayHelper::toInteger($tags);
                    $tags = @implode(',', $tags);
                    $db = JFactory::getDBO();
                    $sql="select DISTINCT itemID as tag_id from #__k2_tags_xref where tagID IN ({$tags})";
                    $db->setQuery($sql);
                    $finaltags=$db->loadAssoclist();
                    $finalarr=array();
                    foreach($finaltags as $finaltag)
                    {
                        $finalarr[]=$finaltag['tag_id'];
                    }
                    $query->where('k.id IN('.implode(",", $finalarr).')');
                
                    
                }
				$searchname=JFactory::getApplication()->input->getString('searchname');
				if($searchname)
                {
					
                    $text = $db->quote('%' . $db->escape($searchname, true) . '%', false);
                    $query->where( 'k.title  LIKE ' . $text);    
                }
				$query->where("(k.publish_up = ".$db->Quote($nullDate)." OR k.publish_up <= ".$db->Quote($now).")");
				$query->where("(k.publish_down = ".$db->Quote($nullDate)." OR k.publish_down >= ".$db->Quote($now).")");
				
            }
            else if($component=="com_virtuemart")
			{
                $query->where(' a.component = ' . $db->quote($component));
                $query->where(' k.published = 1' );
                $searchproduct=JFactory::getApplication()->input->getString('searchproduct');
                $text = $db->quote('%' . $db->escape($searchproduct, true) . '%', false);
                if(!empty($searchproduct))
                {
                    $wheres2	= array();
                    $wheres2[]	= 'm.product_name LIKE ' . $text;
                    $where		= '(' . implode(') OR (', $wheres2) . ')';
                    $query->where('('. $where .')');
                }
                 $minprice         = JFactory::getApplication()->input->getInt('minprice',0);
                $maxprice         = JFactory::getApplication()->input->getInt('maxprice',0);
                if($minprice!=0)
                {
                   $query->where(' r.product_price >= '.$minprice);
                }
                if($maxprice!=0)
                {
                   $query->where(' r.product_price <= '.$maxprice);
                }
                
                
            }
			else if($component=="com_content")
			{
				 $query->where(' a.component = ' . $db->quote($component));
                $query->where(' k.state =1');
				$filter_contentcatid=JFactory::getApplication()->input->getInt('filter_contentcatid', $extra_catid);
                if ($this->getState('filter.language'))
				{
					$query->where('k.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
				}
				if(($tags))
                {
                    ArrayHelper::toInteger($tags);
                    $tags = @implode(',', $tags);
                    $db = JFactory::getDBO();
                    if ((JFolder::exists(JPATH_SITE . '/components/com_flexicontent/')))  {
                    $sql="select DISTINCT itemID as tag_id from #__flexicontent_tags_item_relations where tid IN ({$tags})";
					 }else
					 {
						 $sql="select DISTINCT content_item_id as tag_id from #__contentitem_tag_map where tag_id IN ({$tags}) AND type_alias=".$db->quote('com_content.article');
					 }
					
                    $db->setQuery($sql);
                    $finaltags=$db->loadAssoclist();
                    $finalarr=array();
                    foreach($finaltags as $finaltag)
                    {
                        $finalarr[]=$finaltag['tag_id'];
                    }
                    $query->where('k.id IN('.implode(",", $finalarr).')');
                
                    
                }
				if($filter_contentcatid)
				{
					$query->where('k.catid ='.$filter_contentcatid);
				}
			}
			
             else if ($component == "com_zoo") {
                 $query->where(' a.component = ' . $db->quote($component));
                 $zootag=array();
                 if($tags)
                 {
                    $c=0;
                    foreach($tags as $tag)
                    {
                        $zootag[$c]=$db->quote($tag);
                        $c++;
                    }
                     $zootag = @implode(',',$zootag);
                    $db = JFactory::getDBO();
                    $sql="select DISTINCT item_id as tag_id from #__zoo_tag where name IN ({$zootag})";
                    $db->setQuery($sql);
                    $finaltags=$db->loadAssoclist();
                    
                    $finalarr=array();
                    foreach($finaltags as $finaltag)
                    {
                        $finalarr[]=$finaltag['tag_id'];
                    }
                    $query->where('k.id IN('.implode(",", $finalarr).')');
                 }
                       if(($zoo_category_id)&&($zoo_category_id!=0))
                    {
                        $query->where(' c.category_id='.$zoo_category_id);
                    }
                $query->where(' k.state =1 ');
             }
            else if ($component == "com_comprofiler") {
                $query->where(' a.component = ' . $db->quote($component));
                $query->where(' k.approved =1 AND k.confirmed=1 ');
            }
            else if ($component == "com_hikamarket") {
               
                $query->where(' a.component = ' . $db->quote($component));
                $query->where(' k.vendor_published =1');
                $query->where(' j.product_published =1');
                  if(!empty($product_category_id)&&($product_category_id!=0))
                  {
                    $query->where('p.category_id ='.$product_category_id);
                  }
                   $query->where('q.zone_namekey =k.'.$st);
                  
                $text = $db->quote('%' . $db->escape($searchproduct, true) . '%', false);
                if(!empty($searchproduct))
                {
                    $wheres2	= array();
		    $wheres2[]	= 'j.product_name LIKE ' . $text;
		    $wheres2[]	= 'k.vendor_name LIKE ' . $text;
                    $where		= '(' . implode(') OR (', $wheres2) . ')';
                    $query->where('('. $where .')');
                
                }
				if(($tags))
                {
					
                    ArrayHelper::toInteger($tags);
                    $tags = @implode(',', $tags);
                    $db = JFactory::getDBO();
                    $sql="select DISTINCT content_item_id as tag_id from #__contentitem_tag_map where tag_id IN ({$tags}) AND type_alias=".$db->quote('com_hikashop.product');
                    $db->setQuery($sql);
                    $finaltags=$db->loadAssoclist();
                    $finalarr=array();
                    foreach($finaltags as $finaltag)
                    {
                        $finalarr[]=$finaltag['tag_id'];
                    }
                    $query->where('j.product_id IN('.implode(",", $finalarr).')');
                }
                $minprice         = JFactory::getApplication()->input->getInt('minprice',0);
                $maxprice         = JFactory::getApplication()->input->getInt('maxprice',0);
                if($minprice!=0)
                {
                    $query->where(' r.price_value >= '.$minprice);
                }
                if($maxprice!=0)
                {
                    $query->where(' r.price_value <= '.$maxprice);
                }
				
                $query->group($db->quoteName('j.product_id'));
            }
            else {
                if($component=="com_hikashop")
                {
                     $query->where(' k.vendor_published =1');
                    $component="com_hikamarket";
                }
                $query->where(' ( a.component = ' . $db->quote($component) . ' OR a.component=' . $db->quote("") . ') ');
            }
            
            // Filter by language
            if($component=="com_mymaplocations")
            {
				$query->select('c.title as categorytitle');
				$query->select('c.params as catparams');	
                $query->select('c.access AS category_access')
			->join('LEFT', '#__categories AS c on c.id = a.catid');
		if ($this->getState('filter.language'))
		{
			$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}
               
                if(($tags))
                {
                    ArrayHelper::toInteger($tags);
                    $tags = @implode(',', $tags);
                    $db = JFactory::getDBO();
                    $sql="select DISTINCT content_item_id as tag_id from #__contentitem_tag_map where tag_id IN ({$tags}) AND type_alias=".$db->quote('com_mymaplocations.location');
                    $db->setQuery($sql);
                    $finaltags=$db->loadAssoclist();
                    $finalarr=array();
                    foreach($finaltags as $finaltag)
                    {
                        $finalarr[]=$finaltag['tag_id'];
                    }
                    $query->where('a.id IN('.implode(",", $finalarr).')');
                }
				
				
                $query->where( 'c.published=1');
				 $query->where('a.state = 1' );
                $searchname=JFactory::getApplication()->input->getString('searchname');
                if($searchname)
                {
                    $text = $db->quote('%' . $db->escape($searchname, true) . '%', false);
                    $query->where( 'a.name  LIKE ' . $text);    
                }
            }
             if($country_list)
                {
                    $query->where('a.country =' . $db->quote($country_list) .'');
                    
                }
                if(($country_list)&&($state_list))
                {
                    $query->where('a.locationstate =' . $db->quote($state_list) .'');
                    
                }
				if(($country_list)&&($state_list)&&($city_list))
                {
                    $query->where('a.town =' . $db->quote($city_list) .''); 
                }
                if($searchzipcode)
                {
                    $query->where('a.postal =' . $db->quote($searchzipcode) .''); 
                }
            }
			if(($component!="com_easysocial")&&($component!="com_eventbooking")&&($component!="com_adsmanager")&&($component!="com_ohanah"))
			{

			$query->where('(latitude !=0 OR longitude !=0) ');
			$query->where('(latitude !=255 OR longitude !=255) ');
			}
			if (empty($radius)) {
                $radius = explode(',', $params->get('distance'));
                $query->having('distance < ' . (int) $radius[0]);
            }
            //option to add anywhere in the list
            else if ($radius == -1) {

            } else {
                $query->having('distance < ' . (int) $radius);
            }
            $orderCol = $this->state->get( 'list.ordering' );
		if (($orderCol=="rdate")&&($component=="com_mymaplocations"))
            {
			$query->order( $db->escape( 'id desc'  ) );
            }
			else if (($orderCol=="rdate")&&($component!="com_mymaplocations"))
			{
				$query->order( $db->escape( 'extra_id  desc'  ) );
			}
			else if (($orderCol=="date")&&($component=="com_mymaplocations"))
            {
			$query->order( $db->escape( 'id asc'  ) );
            }
			else if (($orderCol=="date")&&($component!="com_mymaplocations"))
			{
				$query->order( $db->escape( 'extra_id  asc'  ) );
			}
			else if (($orderCol=="alpha"))
            {
			$query->order( $db->escape( 'nom asc'  ));
            }
			else if (($orderCol=="ralpha"))
			{
				$query->order( $db->escape( 'nom desc'  ));
			}
			else
            {
                $query->order('distance');
            }
        
        //==echo nl2br(str_replace('#__','jos_',$query));die();
        return $query;
    }

    /**
	 * Method to get a list of Locations.
	 * Overridden to add a check for access levels.
	 *
	 * @return  mixed  An array of data items on success, false on failure.
	 *
	 * @since   1.6.1
	 */
	public function getItems()
	{
		$items = parent::getItems();
        $component = $this->getState('filter.component');
		if ((JFactory::getApplication()->isClient('site'))&&($component=="com_mymaplocations"))
		{
			$user = JFactory::getUser();
			$groups = $user->getAuthorisedViewLevels();

			for ($x = 0, $count = count($items); $x < $count; $x++)
			{
				// Check the access level. Remove articles the user shouldn't see
				if (!in_array(@$items[$x]->category_access, $groups))
				{
					unset($items[$x]);
				}
			}
		}
         if (self::$result == 0) {
         $this->insertReports();
         self::$result = self::$result + 1;
         }
        return $items;
	}
    public function insertReports()
    {
        
        $params = JComponentHelper::getParams('com_mymaplocations');
        $report=$params->get('stats',0);
        if($report)
        {
            $db = JFactory::getDBO();
            $report_data=new stdClass();
            $report_data->extension = $this->getState('filter.component');
            $report_data->catid = $this->getState('filter.category');
            $report_data->term = $this->getState('filter.zip');
            $report_data->month= JFactory::getDate()->format("m");
            $report_data->year=JFactory::getDate()->format("Y");
            $report_data->hits=1;
            $report_data->updated=JFactory::getDate()->toSql();
            $query = $db->getQuery(true);
            $query->select('*')
            ->from($db->quoteName('#__mymaplocations_statistics'))
            ->where($db->quoteName('extension') . ' = '. $db->quote($report_data->extension))
            ->where($db->quoteName('catid') . ' = '. $db->quote($report_data->catid))
            ->where($db->quoteName('term') . ' = '. $db->quote($report_data->term))
            ->where($db->quoteName('month') . ' = '. $db->quote($report_data->month))
            ->where($db->quoteName('year') . ' = '. $db->quote($report_data->year));
            $db->setQuery($query);
            $result_data = $db->loadObject();
            if($result_data)
            {
                $result_data->hits=$result_data->hits+1;
                $final_result = JFactory::getDbo()->updateObject('#__mymaplocations_statistics', $result_data, 'id');
            }
            else
            {
                $final_result = JFactory::getDbo()->insertObject('#__mymaplocations_statistics', $report_data);
            }
        }
    }
    

}
