<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');
jimport('joomla.application.categories');
use Joomla\Utilities\ArrayHelper;

/**
 * Methods supporting a list of MyMaplocations records for single user.
 */
class MyMaplocationsModelmylocations extends JModelList {

    /**
     * Constructor.
     *
     * @param    array    An optional associative array of configuration settings.
     * @see        JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'a.id',
				'name', 'name',
				'created_by', 'created_by',
				'postal','postal',
				'language','language',
			);
		}
        parent::__construct($config);
    }

    /**
         * Method to auto-populate the model state.
         *
         * Note. Calling getState in this method will result in recursion.
         */
        protected function populateState($ordering = null, $direction = null) {
            // Initialise variables.
            $app = JFactory::getApplication('administrator');
    
            // Load the filter state.
            $search = $app->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
            $this->setState('filter.search', $search);
    
            $published = $app->getUserStateFromRequest($this->context . '.filter.state', 'filter_published', '', 'string');
            $this->setState('filter.state', $published);
    
    
            $access = $this->getUserStateFromRequest($this->context . '.filter.access', 'filter_access', 0, 'int');
            $this->setState('filter.access', $access);
    
    
            $categoryId = $this->getUserStateFromRequest($this->context . '.filter.category_id', 'filter_category_id');
            $this->setState('filter.category_id', $categoryId);
    
            $language = $this->getUserStateFromRequest($this->context . '.filter.language', 'filter_language', '');
            $this->setState('filter.language', $language);
    
            $component = $this->getUserStateFromRequest($this->context . '.filter.component', 'filter_component', 'com_mymaplocations');
            $this->setState('filter.component', $component);
    
            // Load the parameters.
            $params = JComponentHelper::getParams('com_mymaplocations');
            $this->setState('params', $params);
    
    
            // List state information.
            parent::populateState('a.name', 'asc');
        }
    
   /**
         * Method to get a location id based on model configuration state.
         *
         * This is necessary because the model is used by the component and
         * different modules that might need different sets of data or different
         * ordering requirements.
         *
         * @param	string		$id	A prefix for the location id.
         * @return	string		A location id.
         * @since	1.6
         */
        protected function getlocationId($id = '') {
            // Compile the location id.
            $id.= ':' . $this->getState('filter.search');
            $id.= ':' . $this->getState('filter.state');
    
            return parent::getlocationId($id);
        }
    
        /**
         * Build an SQL query to load the list data.
         *
         * @return	JDatabaseQuery
         * @since	1.6
         */
        protected function getListQuery() {
			$user=JFactory::getUser();
            // Create a new query object.
            $db = $this->getDbo();
            $query = $db->getQuery(true);
    
            // Select the required fields from the table.
            $query->select(
                    $this->getState(
                            'list.select', 'a.*'
                    )
            );
            $query->from('`#__mymaplocations_location` AS a');
    
    
            // Join over the users for the checked out user.
            $query->select('uc.name AS editor');
            $query->join('LEFT', '#__users AS uc ON uc.id=a.checked_out');
    
            $query->select('l.title AS language_title')
                    ->join('LEFT', $db->quoteName('#__languages') . ' AS l ON l.lang_code = a.language');
    
    
            // Join over the created by field 'created_by'
            $query->select('created_by.name AS created_by');
            $query->select('created_by.id AS created_userid');
            $query->join('LEFT', '#__users AS created_by ON created_by.id = a.created_by');
            $query->select('c.title AS category_title');
            $query->join('LEFT', '#__categories AS c ON c.id = a.catid');
    
            // Filter by published state
            $published = $this->getState('filter.state');
            if (is_numeric($published)) {
                $query->where('a.state = ' . (int) $published);
            } else if ($published === '') {
                $query->where('(a.state IN (0, 1))');
            }
			 $query->where('a.created_by ='.(int)$user->id);
    
            // Filter by search in title
            $search = $this->getState('filter.search');
            if (!empty($search)) {
                if (stripos($search, 'id:') === 0) {
                    $query->where('a.id = ' . (int) substr($search, 3));
                } else {
                    $search = $db->Quote('%' . $db->escape($search, true) . '%');
                    $query->where('( a.name LIKE ' . $search . ' )');
                }
            }
            // Filter on the language.
            // Filter by a single or group of categories.
            $categoryId = $this->getState('filter.category_id');
            if (is_numeric($categoryId)) {
                $query->where('a.catid = ' . (int) $categoryId);
            } elseif (is_array($categoryId)) {
                ArrayHelper::toInteger($categoryId);
                $categoryId = implode(',', $categoryId);
                $query->where('a.catid IN (' . $categoryId . ')');
            }
    
            if ($language = $this->getState('filter.language')) {
                $query->where('a.language = ' . $db->quote($language));
            }
            if ($component = $this->getState('filter.component')) {
                if ($component == "com_mymaplocations") {
                    $query->where(' ( a.component = ' . $db->quote($component) . ' OR a.component=' . $db->quote("") . ') ');
                } else {
                    $query->where('a.component = ' . $db->quote($component));
                }
            }
    
    
            // Add the list ordering clause.
            $orderCol = $this->state->get('list.ordering');
            $orderDirn = $this->state->get('list.direction');
            if ($orderCol == 'a.ordering' || $orderCol == 'category_title') {
                $orderCol = 'c.title ' . $orderDirn . ', a.ordering';
            }
            $query->order($db->escape($orderCol . ' ' . $orderDirn));
    
            return $query;
        }
     
}
