<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
defined('_JEXEC') or die;
JLoader::registerPrefix('Mymaplocations', JPATH_SITE . '/components/com_mymaplocations/');
JLoader::register('MymaplocationsHelperRoute', JPATH_SITE  . '/components/com_mymaplocations/helpers/route.php');
JLoader::register('MyMaplocationsHelper',JPATH_SITE . '/components/com_mymaplocations/helpers/mymaplocations.php');
if (version_compare(JVERSION, '4.0', 'ge'))
{
class MymaplocationsRouter extends JComponentRouterView
{
	protected $noIDs = false;

	/**
	 * Mymaplocations Component router constructor
	 *
	 * @param   JApplicationCms  $app   The application object
	 * @param   JMenu            $menu  The menu object to work with
	 */
	public function __construct($app = null, $menu = null)
	{
		$params = JComponentHelper::getParams('com_mymaplocations');
		$this->noIDs =true;
		$categories = new JComponentRouterViewconfiguration('locations');
		$categories->setKey('filter_catid');
		$this->registerView($categories);
		$location = new JComponentRouterViewconfiguration('location');
		$location->setKey('id');
		$this->registerView($location);
		$this->registerView(new JComponentRouterViewconfiguration('mylocations'));
		$form = new JComponentRouterViewconfiguration('locationform');
		$form->setKey('a_id');
		$this->registerView($form);
		parent::__construct($app, $menu);
		$this->attachRule(new JComponentRouterRulesMenu($this));
		$this->attachRule(new JComponentRouterRulesStandard($this));
		JLoader::register('MymaplocationsRouterRulesLegacy', __DIR__ . '/helpers/legacyrouter.php');
		$this->attachRule(new MymaplocationsRouterRulesLegacy($this));
	}

	/**
	 * Method to get the segment(s) for a category
	 *
	 * @param   string  $id     ID of the category to retrieve the segments for
	 * @param   array   $query  The request that is built right now
	 *
	 * @return  array|string  The segments of this item
	 */
	public function getLocationsSegment($id, $query)
	{
		$category = JCategories::getInstance($this->getName())->get($id);

		if ($category)
		{
			$path = array_reverse($category->getPath(), true);
			$path[0] = '1:root';

			if ($this->noIDs)
			{
				foreach ($path as &$segment)
				{
					list($id, $segment) = explode(':', $segment, 2);
				}
			}

			return $path;
		}

		return array();
	}

	/**
	 * Method to get the segment(s) for an location
	 *
	 * @param   string  $id     ID of the location to retrieve the segments for
	 * @param   array   $query  The request that is built right now
	 *
	 * @return  array|string  The segments of this item
	 */
	public function getLocationsegment($id, $query)
	{
		
		if (!strpos($id, ':'))
		{
			
			$db = JFactory::getDbo();
			
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('alias'))
				->from($dbquery->qn('#__mymaplocations_location'))
				->where('id = ' . $dbquery->q($id));
				
			$db->setQuery($dbquery);

			$id .= ':' . $db->loadResult();
			
		}

		if ($this->noIDs)
		{
			list($void, $segment) = explode(':', $id, 2);

			return array($void => $segment);
		}

		return array((int) $id => $id);
	}

	/**
	 * Method to get the segment(s) for a form
	 *
	 * @param   string  $id     ID of the location form to retrieve the segments for
	 * @param   array   $query  The request that is built right now
	 *
	 * @return  array|string  The segments of this item
	 *
	 * @since   3.7.3
	 */
	public function getFormSegment($id, $query)
	{
		return $this->getLocationsegment($id, $query);
	}

	/**
	 * Method to get the id for a category
	 *
	 * @param   string  $segment  Segment to retrieve the ID for
	 * @param   array   $query    The request that is parsed right now
	 *
	 * @return  mixed   The id of this item or false
	 */
	public function getLocationsId($segment, $query)
	{
		if (isset($query['filter_catid']))
		{
			$category = JCategories::getInstance($this->getName(), array('access' => false))->get($query['filter_catid']);

			if ($category)
			{
				foreach ($category->getChildren() as $child)
				{
					if ($this->noIDs)
					{
						if ($child->alias == $segment)
						{
							return $child->id;
						}
					}
					else
					{
						if ($child->id == (int) $segment)
						{
							return $child->id;
						}
					}
				}
			}
		}

		return false;
	}

	/**
	 * Method to get the segment(s) for an location
	 *
	 * @param   string  $segment  Segment of the location to retrieve the ID for
	 * @param   array   $query    The request that is parsed right now
	 *
	 * @return  mixed   The id of this item or false
	 */
	public function getLocationId($segment, $query)
	{
		if ($this->noIDs)
		{
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('id'))
				->from($dbquery->qn('#__mymaplocations_location'))
				->where('alias = ' . $dbquery->q($segment))
				->where('catid = ' . $dbquery->q($query['id']));
			$db->setQuery($dbquery);

			return (int) $db->loadResult();
		}

		return (int) $segment;
	}
}

/**
 * Mymaplocations router functions
 *
 * These functions are proxys for the new router interface
 * for old SEF extensions.
 *
 * @param   array  &$query  An array of URL arguments
 *
 * @return  array  The URL arguments to use to assemble the subsequent URL.
 *
 * @deprecated  4.0  Use Class based routers instead
 */
function mymaplocationsBuildRoute(&$query)
{
	$app = JFactory::getApplication();
	$router = new MymaplocationsRouter($app, $app->getMenu());

	return $router->build($query);
}

/**
 * Parse the segments of a URL.
 *
 * This function is a proxy for the new router interface
 * for old SEF extensions.
 *
 * @param   array  $segments  The segments of the URL to parse.
 *
 * @return  array  The URL attributes to be used by the application.
 *
 * @since   3.3
 * @deprecated  4.0  Use Class based routers instead
 */
function mymaplocationsParseRoute($segments)
{
	$app = JFactory::getApplication();
	$router = new MymaplocationsRouter($app, $app->getMenu());

	return $router->parse($segments);
}
}
else
{
/**
 * @param	array	A named array
 * @return	array
 */
function MyMaplocationsBuildRoute(&$query) {
    $segments = array();

    // get a menu item based on Itemid or currently active
    $app = JFactory::getApplication();
    $menu = $app->getMenu();
    if (empty($query['Itemid'])) {
        $menuItem = $menu->getActive();
    } else {
        $menuItem = $menu->getItem($query['Itemid']);
    }
    $mView = (empty($menuItem->query['view'])) ? null : $menuItem->query['view'];
    $mCatid = (empty($menuItem->query['catid'])) ? null : $menuItem->query['catid'];
    $mId = (empty($menuItem->query['id'])) ? null : $menuItem->query['id'];
    $segments = array();
    if (isset($query['view'])) {
        $view = $query['view'];
        //$segments[] = $view;
        unset($query['view']);
    }
    if (isset($query['task'])) {
        $segments[] = $query['task'];
        unset($query['task']);
    }
    if (isset($query['city'])) {
        $segments[] = $query['city'];
        unset($query['city']);
    }
        
    if (isset($query['layout'])) {
        $segments[] = 'location-edit';
        unset($query['layout']);
    }
    if (isset($query['id'])) {
        $id = $query['id'];
        $db = JFactory::getDBO();
        $q = 'SELECT alias FROM #__mymaplocations_location WHERE id = ' . $db->Quote($id).' AND state=1';
        $db->setQuery($q);
        $alias = $db->loadResult();
        $segments[] = $alias;
        unset($query['id']);
    }
    return $segments;
}

/**
 * @param	array	A named array
 * @param	array
 *
 * Formats:
 *
 */
function MyMaplocationsParseRoute($segments) {

    // view is always the first element of the array
    $count = count($segments);
    if($segments[0]=="location:edit")
    {
        
         $vars['view'] = "form";
         $vars['layout'] = "edit";
         if($count==2)
         {
                $slug = str_replace(":", "-", $segments[1]);
                $slug = str_replace(" ", "-", $slug);
                $db = JFactory::getDBO();
                $q = 'SELECT id FROM #__mymaplocations_location WHERE alias = ' . $db->Quote($slug).' AND state=1';
                $db->setQuery($q);
                $id = $db->loadResult();
                $vars['id'] = $id;
         }
                return $vars;
    }
    if ($count) {
        if ($count == 2) {
            $vars['view'] = $segments[0];
            if ($vars['view'] == 'locations') {
                $vars['city'] = $segments[1];
            } else {
                $slug = str_replace(":", "-", $segments[1]);
                $slug = str_replace(" ", "-", $slug);
                $db = JFactory::getDBO();
                $q = 'SELECT id FROM #__mymaplocations_location WHERE alias = ' . $db->Quote($slug).' AND state=1';
                $db->setQuery($q);
                $id = $db->loadResult();
                $vars['id'] = $id;
            }
        } else {
            $slug = str_replace(":", "-", $segments[0]);
                $slug = str_replace(" ", "-", $slug);
                $db = JFactory::getDBO();
                $q = 'SELECT id FROM #__mymaplocations_location WHERE alias = ' . $db->Quote($slug).' AND state=1';
                $db->setQuery($q);
                $id = $db->loadResult();
                $vars['id'] = $id;
                $vars['view'] = 'location';
        
        }
    }

    return $vars;
}
}