<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// No direct access
defined('_JEXEC') or die;

/**
 * View class for a list of MyMaplocations.
 *
 * @since  1.5
 */
class MyMaplocationsViewForm extends JViewLegacy
{
	protected $form;

	protected $item;

	protected $return_page;

	protected $state;

	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  mixed  A string if successful, otherwise a Error object.
	 */
	public function display($tpl = null)
	{
		$user = JFactory::getUser();

		// Get model data.
		$this->state       = $this->get('State');
		$this->item        = $this->get('Item');
		$this->form        = $this->get('Form');
		$this->return_page = $this->get('ReturnPage');
		  $this->showcontact = $this->state->params->get('contact_link', 1);

		if (empty($this->item->id))
		{
			$authorised = $user->authorise('core.create', 'com_mymaplocations') ;
		}
		else
		{
					if(($this->item->component)&&($this->item->component!="com_mymaplocations"))
					{
							$authorised = false;
						
					}
					else
					{
					 $assetName = 'com_mymaplocations';
				$res = new JObject;
        $actions = array(
            'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
        );

        foreach ($actions as $action) {
            $res->set($action, $user->authorise($action, $assetName));
        }
		
							if($res->get('core.edit'))
							{
							$authorised = true;
							}
							else if($res->get('core.edit.own'))
							{
									if($this->item->created_by==$user->id)
									{
										$authorised = true;
									}
									else
									{
										$authorised =false;
									}
							}
							else
							{
							$authorised = false;
								
							}
					}

		}

		if ($authorised !== true)
		{
			JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'),'error');

			return false;
		}

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JFactory::getApplication()->enqueueMessage(implode("\n", $errors),'error');
			return false;
		}

		// Create a shortcut to the parameters.
		$params =  JComponentHelper::getParams('com_mymaplocations');;

		// Escape strings for HTML output
		$this->pageclass_sfx = htmlspecialchars($params->get('pageclass_sfx'));

		$this->params = $params;
		$this->user   = $user;

		// Propose current language as default when creating new article
		if (JLanguageMultilang::isEnabled() && empty($this->item->id))
		{
			$lang = JFactory::getLanguage()->getTag();
			$this->form->setFieldAttribute('language', 'default', $lang);
		}

		$this->_prepareDocument();
		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 *
	 * @return  void.
	 */
	protected function _prepareDocument()
	{
		$app   = JFactory::getApplication();
		$menus = $app->getMenu();
		$title = null;

		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();

		if ($menu)
		{
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		}
		else
		{
			$this->params->def('page_heading', JText::_('COM_MYMAPLOCATIONS_TITLE_STORES'));
		}

		$title = $this->params->def('page_title', JText::_('COM_MYMAPLOCATIONS_TITLE_STORES'));

		if ($app->get('sitename_pagetitles', 0) == 1)
		{
			$title = JText::sprintf('JPAGETITLE', $app->get('sitename'), $title);
		}
		elseif ($app->get('sitename_pagetitles', 0) == 2)
		{
			$title = JText::sprintf('JPAGETITLE', $title, $app->get('sitename'));
		}

		$this->document->setTitle($title);

		$pathway = $app->getPathWay();
		$pathway->addItem($title, '');

		if ($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}

		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
	}
}
