<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View to edit
 */
class MyMaplocationsViewlocation extends JViewLegacy {

    protected $state;
    protected $item;
    protected $form;
    protected $params;

    /**
     * Display the view
     */
    public function display($tpl = null) {
        $doc = JFactory::getDocument();
        $doc->addStyleSheet(JURI::base() . 'components/com_mymaplocations/assets/style.css');
        $app = JFactory::getApplication();
        $user = JFactory::getUser();

        $this->state = $this->get('State');
        $this->item = $this->get('Data');
        
	$this->item->tags = new JHelperTags;
	$this->item->tags->getItemTags('com_mymaplocations.location', $this->item->id);
        $this->params = $app->getParams('com_mymaplocations');
        $this->params = JComponentHelper::getParams('com_mymaplocations');

        $active = $app->getMenu()->getActive();
        if ($active) {
            $params = $app->getMenu()->getParams($active->id);
            $this->params->merge($params);
        }
		$this->item->googleapi=$this->params->get('googleapi', '');
        $this->item->google_maptype = $this->params->get('google_maptype', 'ROADMAP');
        $this->item->bing_maptype = $this->params->get('bing_maptype', 'road');
		$this->item->openmapstyle=$this->params->get('openmapstyle', 1);
        $this->map = $this->params->get('map', 0);
        $this->show_locationlist = $this->params->get('show_locationlist', 1);
        $this->height = MyMaplocationsHelper::formatField($this->params->get('viewheight', 400));
        $this->width = MyMaplocationsHelper::formatField($this->params->get('viewwidth', '60%'));
        $this->viewzoom = $this->params->get('viewzoom', 9);
        $this->contact_link = $this->params->get('contact_link', 1);
        $this->contactbtn=$this->params->get('contact_button',1);
        $this->target = $this->params->get('target', 3);
        $this->item->map_design=$this->params->get('map_design', 1);
        $this->globalcolor = $this->params->get('globalcolor', '#2980b9');
        $this->jcomments=$this->params->get('jcomments',0);
        $this->itemratingroup=$this->params->get('itemratingroup',null);
		$this->googlereview=$this->params->get('googlereview',true);
		        $this->map_layer=$this->params->get('map_layer',1);
        $this->maplayer_url=$this->params->get('maplayer_url','');
        $this->address_format=$this->params->get('address_format', '[ADDRESS][BR][TOWN][COMMA][STATE][BR][COUNTRY][POSTAL]');
        if ($this->show_locationlist == 1) {
            $component = "com_mymaplocations";
            $this->selectLocation = MyMaplocationsHelper::getLocationList($this->item->id, $component, 0);
        }
        // Check for errors.
        if (count($errors = $this->get('Errors'))) {
           JFactory::getApplication()->enqueueMessage( implode("\n", $errors));
            return false;
        }

        // Check if an item was found.
        if (!$this->item->id) {
             JFactory::getApplication()->enqueueMessage(JText::_('COM_MYMAPLOCATIONS_NORESULT'));
            return false;
        }
		if(file_exists( JPATH_ADMINISTRATOR . '/components/com_fields/helpers/fields.php'))
		{
		JLoader::register('FieldsHelper', JPATH_ADMINISTRATOR . '/components/com_fields/helpers/fields.php');
		$this->item->jcfields=FieldsHelper::getFields('com_mymaplocations.location', $this->item, true);
		}
        if ($this->_layout == 'edit') {

            $authorised = $user->authorise('core.create', 'com_mymaplocations');

            if ($authorised !== true) {
                JFactory::getApplication()->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'),'error');
                return false;
            }
        }

        $this->_prepareDocument();

        parent::display($tpl);
    }

    /**
     * Prepares the document
     */
    protected function _prepareDocument() {
        $app = JFactory::getApplication();
        $menus = $app->getMenu();
        $title = null;

        // Because the application sets a default page title,
        // we need to get it from the menu item itself
        $menu = $menus->getActive();
		if(@$menu->query['view']=="locations")
		{
		     $this->params->def('page_heading', $this->params->get('page_title', $this->item->name));	
		}
        else if ($menu) {
            $this->params->def('page_heading', $this->params->get('page_title', $menu->title));
        } else {
            $this->params->def('page_heading', JText::_('com_mymaplocations_DEFAULT_PAGE_TITLE'));
        }
        $title = $this->params->get('page_title', '');
		if(@$menu->query['view']=="locations")
		{
			 $title = $this->item->name;
		}
        if (empty($title)) {
            $title = $app->getCfg('sitename');
        } elseif ($app->getCfg('sitename_pagetitles', 0) == 1) {
            $title = JText::sprintf('JPAGETITLE', $app->getCfg('sitename'), $title);
        } elseif ($app->getCfg('sitename_pagetitles', 0) == 2) {
            $title = JText::sprintf('JPAGETITLE', $title, $app->getCfg('sitename'));
        }
        $this->document->setTitle($title);
        if(@$menu->query['view']=="locations")
		{
		     $this->document->setDescription($this->item->metadesc); 
		}
        else if ($this->params->get('menu-meta_description')) {
            $this->document->setDescription($this->params->get('menu-meta_description'));
        }
        else if(!empty($this->item->metadesc))
        {
            $this->document->setDescription($this->item->metadesc);    
        }
		if(@$menu->query['view']=="locations")
		{
		      $this->document->setMetadata('keywords', $this->item->metakey); 
		}
        else if ($this->params->get('menu-meta_keywords')) {
            $this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
        }
        else if(!empty($this->item->metakey))
        {
               $this->document->setMetadata('keywords', $this->item->metakey);
        }
        if ($this->params->get('robots')) {
            $this->document->setMetadata('robots', $this->params->get('robots'));
        }
    }

}
