<?php

/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of MyMaplocations.
 */
class MyMaplocationsViewlocations extends JViewLegacy {

    protected $items;
    protected $pagination;
    protected $state;
    protected $params;

    /**
     * Display the view
     */
    public function display($tpl = null) {
        $doc = JFactory::getDocument();
        $doc->addStyleSheet(JURI::base() . 'components/com_mymaplocations/assets/style.css');
        $app = JFactory::getApplication();
        $this->params = JComponentHelper::getParams('com_mymaplocations');
        $active = $app->getMenu()->getActive();
        if ($active) {
     
            $params = $app->getMenu()->getParams($active->id);
            $this->params->merge($params);
        }
     
        $bootstrap = $this->params->get('bootstrap', 0);
        if ($bootstrap == 1) {
            $doc->addStyleSheet(JURI::base() . '/media/jui/css/bootstrap.min.css');
        }
        $this->distances = explode(",", $this->params->get('distance', '5,10,15,20'));
        $this->distance_type = $this->params->get('distance_type', 1);
        $this->ajax=$this->params->get('ajax', 1);
        $this->jq_lib = $this->params->get('jquery', 1);
        $this->zoom = JFactory::getApplication()->input->getString('zoom', ($this->params->get('zoom', 11)));
        $this->map = JFactory::getApplication()->input->getString('map', $this->params->get('map', 0));
        $this->bingkey = $this->params->get('bingapi');
        $this->mapboxapi=$this->params->get('mapboxapi');
        $this->mapboxstyle=$this->params->get('mapboxstyle','mapbox.streets');
        $this->mapscroll=$this->params->get('mapscroll',1);
        $this->mapsdrag=$this->params->get('mapsdrag',1);
        $this->hidedistance=$this->params->get('hidedistance',1);
        $this->enable_route=$this->params->get('enable_route',0);
        $this->component = JFactory::getApplication()->input->getString('component', ($this->params->get('component', 'com_mymaplocations')));
        $this->extra_catid = $this->params->get('extra_catid',0);
        $this->height = MyMaplocationsHelper::formatField(JFactory::getApplication()->input->getString('height', $this->params->get('height', 400)));
        $this->width = MyMaplocationsHelper::formatField(JFactory::getApplication()->input->getString('width', $this->params->get('width', '58%')));
        $this->matwidth = MyMaplocationsHelper::formatField(JFactory::getApplication()->input->getString('matwidth', $this->params->get('matwidth','40%')));
        $this->matheight = MyMaplocationsHelper::formatField(JFactory::getApplication()->input->getString('matheight', $this->params->get('matheight', 400)));
        $this->show_filter = $this->params->get('filter_cat', 0);
        $this->show_country=$this->params->get('filter_country', 0);
        $this->show_zip=$this->params->get('filter_zip', 0);
        $this->show_anywhere = $this->params->get('anywhere', 1);
        $this->show_anywheredefault = $this->params->get('anywhere_default', 1);
        $this->distance_hide = $this->params->get('distance_hide', 1);
        $this->orcolor = $this->params->get('butoncolor', null);
        $this->mode=$this->params->get('mode',1);
        $this->globalcolor = $this->params->get('globalcolor', '#2980b9');
        $this->markercolor = $this->params->get('markercolor', '#000000');
        $this->bgimage = $this->params->get('bgimage', null);
        $this->route_format = $this->params->get('route_format', 1);
        $this->youimage = $this->params->get('youimage','components/com_mymaplocations/assets/images/marker.png');
        $this->iconimage=$this->params->get('iconimage',null);
        $this->dms = $this->params->get('dms', 1);
        $this->geo = JFactory::getApplication()->input->getString('geo');
        $this->itemratingroup=$this->params->get('itemratingroup',null);
        $this->sidebarrating=$this->params->get('sidebarrating',true);
        $this->cluster = $this->params->get('cluster', 1);
        $this->google_maptype = $this->params->get('google_maptype', 'ROADMAP');
        $this->bing_maptype = $this->params->get('bing_maptype', 'road');
        $this->geocode = 0;
        $this->contactbtn=$this->params->get('contact_button',1);
        $this->target = $this->params->get('target', 3);
        $this->map_design=$this->params->get('map_design', 1);
        $this->openmapstyle=$this->params->get('openmapstyle', 1);
        $this->autozoom=$this->params->get('autozoom', 1);
        $this->limit=JFactory::getApplication()->input->getString('limit',0);
        $this->tagsearch=$this->params->get('tagsearch', 0);
        $this->tag_format=$this->params->get('tag_format', 1);
        $this->filter_you=$this->params->get('filter_you', 1);
        $this->tag=JFactory::getApplication()->input->getString('tags');
        $this->layout=$this->params->get('layout', 'simple');
        $this->init_mode=$this->params->get('init_mode',1);
        $this->geolocation=$this->params->get('geolocation',1);
        $this->map_layer=$this->params->get('map_layer',1);
        $this->maplayer_url=$this->params->get('maplayer_url','');
        $this->count=0;
        $this->ajax=$this->params->get('ajax',1);
        $this->wordcount=$this->params->get('wordcount',30);
        $this->markeropen=$this->params->get('markeropen', 'click');
        JFactory::getApplication()->input->set('limit', $this->limit);
        JFactory::getApplication()->input->set('component', $this->component);
        $lang = JFactory::getLanguage();
        if($this->component=="com_community")
        {
        
            $lang->load( 'com_community.country',JPATH_SITE);
        }
        $this->state = $this->get('State');
        $this->filterlat=$this->state->get('filter.lat');
        $this->filterlang=$this->state->get('filter.long');
        $zipcode = $this->state->get('filter.zip');
        $this->zipcode= $zipcode;
        $category = "";
        @$zip = MyMaplocationsHelper::getLatLongFromPostcode($this->state->get('filter.zip'),$this->state->get('filter.lat'),$this->state->get('filter.long'));
        $filter_catid = JFactory::getApplication()->input->getString('filter_catid', 0);
         if(!(MyMaplocationsHelper::checkComponent($this->component)))
        {
            
            return;
        }
        if($this->ajax)
        {
            jimport('joomla.html.pagination');
            $this->pagination=new JPagination(array(), 1,1);
        }
        //$this->lists['catid'] 	= JHTML::_('list.category',  'filter_catid', 'com_mymaplocations', intval( $filter_catid ));
        if (empty($zip['lat']) && empty($zip['lang'])) {
            if (!empty($zipcode)) {
                JFactory::getApplication()->enqueueMessage(JTEXT::_('COM_MYMAPLOCATIONS_ERROR_GEOCODE'));
            }
            $this->items = array();
            if($this->ajax)
            {
                $you=new stdClass();
				$you->id=0;
				$you->extra_id=0;
				$you->icon= "";
				$you->logo=null;
				$you->position=null;
				$you->company=null;
				$you->username=null;
				$you->address=JTEXT::_("COM_MYMAPLOCATIONS_YOU");
				$you->latitude=44.824708;
				$you->longitude=-0.615234;
				$you->name='';
                $you->type='';

                $you->google_maptype=$this->google_maptype;
                $you->bing_maptype=$this->bing_maptype;
                $you->map_design=$this->map_design;
                $you->openmapstyle=$this->openmapstyle;
                $you->component=$this->component;
                $this->items[]=$you;
            }
        }

        else if(empty($zipcode))
        {
            $this->items = array();
            if($this->ajax)
            {
                $you=new stdClass();
				$you->id=0;
				$you->extra_id=0;
				$you->icon= "";
				$you->logo=null;
				$you->position=null;
				$you->company=null;
				$you->username=null;
				$you->address=JTEXT::_("COM_MYMAPLOCATIONS_YOU");
				$you->latitude=44.824708;
				$you->longitude=-0.615234;
				$you->name='';
                $you->google_maptype=$this->google_maptype;
                $you->bing_maptype=$this->bing_maptype;
                $you->map_design=$this->map_design;
                $you->openmapstyle=$this->openmapstyle;
                $you->component=$this->component;
                $this->items[]=$you;
            }
        }
        else {
            if($this->ajax)
            {
            $this->items =array();
            $you=new stdClass();
				$you->id=0;
				$you->extra_id=0;
				$you->icon= $this->youimage;
				$you->logo=null;
				$you->position=null;
				$you->company=null;
				$you->username=null;
				$you->address=$this->escape(MyMaplocationsHelper::formatJS($this->state->get('filter.zip')));
				$you->latitude=$zip['lat'];
				$you->longitude=$zip['lang'];
				$you->name='';
                $you->google_maptype=$this->google_maptype;
                $you->bing_maptype=$this->bing_maptype;
                $you->map_design=$this->map_design;
                $you->openmapstyle=$this->openmapstyle;
                $you->component=$this->component;
                $this->items[]=$you;
            }
            else
            {
            $this->items = $this->get('Items');
            $this->pagination = $this->get('Pagination');
            if(@$active->query['searchzip'])
            {
                $this->pagination->setAdditionalUrlParam("searchzip",$this->state->get('filter.zip'));
            }
            }
        }
        // Check for errors.
        if (count($errors = $this->get('Errors'))) {
            JFactory::getApplication()->enqueueMessage(implode("\n", $errors),'error');
            return false;
        }
        if (empty($this->geo)) {
            $this->geocode = $this->params->get('geo', 0);
        }
        if ($this->show_filter == 1) {
            $userId = JFactory::getUser()->id; 
            $allowedViewLevels = JAccess::getAuthorisedViewLevels($userId);
            $options = array_merge(
                    array('' => JText::_('JOPTION_SELECT_CATEGORY')), JHtml::_('category.options', 'com_mymaplocations',$config = array('filter.published' => array(1),'filter.access' =>$allowedViewLevels, 'filter.language' => array('*',JFactory::getLanguage()->getTag()))));
            
            $this->category = str_replace("(".$lang->getTag().")","",JHTML::_('select.genericlist', $options, 'filter_catid', null, 'value', 'text', $filter_catid));
            
            if($this->component=="com_k2")
            {
                
                $this->k2catid=JFactory::getApplication()->input->getInt('k2_catid',$this->extra_catid);

		require_once JPATH_ADMINISTRATOR.'/components/com_k2/models/categories.php';
		$categoriesModel = K2Model::getInstance('Categories', 'K2Model');
		$categories = array_merge(
                    array('' => JText::_('JOPTION_SELECT_CATEGORY')), $categoriesModel->categoriesTree(NULL, true, false)
                );
                $this->k2category=JHTML::_('select.genericlist', $categories, 'k2_catid', 'class="inputbox"', 'value', 'text', $this->k2catid);
            }
            else if($this->component=="com_content")
            {
                $filter_contentcatid = JFactory::getApplication()->input->getInt('filter_contentcatid', $this->extra_catid);
                $options =  JHtml::_('category.options', 'com_content',$config = array('filter.published' => array(1)));
                $content_catid=$this->params->get('filter_catid');
                if($content_catid)
                {
                    foreach($options as $i=>$option)
                    {
                            if(in_array($option->value,$content_catid))
                            {
                                
                            }
                            else
                            {
                                unset($options[$i]);
                            }
                    }
                }
                $contentoptions = array_merge(
                    array('' => JText::_('JOPTION_SELECT_CATEGORY')),$options );
            $this->contentcategory = str_replace("(".$lang->getTag().")","",JHTML::_('select.genericlist', $contentoptions, 'filter_contentcatid', null, 'value', 'text', $filter_contentcatid));
            
            }
            else if($this->component=="com_mytestimonials")
            {
                 $filter_mytestimonialscatid = JFactory::getApplication()->input->getInt('mytestimonials_category_id', $this->extra_catid);
                $options = array_merge(
                    array('' => JText::_('JOPTION_SELECT_CATEGORY')), JHtml::_('category.options', 'com_mytestimonials',$config = array('filter.published' => array(1)))     );
            $this->mytestimonialscategory = str_replace("(".$lang->getTag().")","",JHTML::_('select.genericlist', $options, 'mytestimonials_category_id', null, 'value', 'text', $filter_mytestimonialscatid));
           
            }
            else if($this->component=="com_hikamarket")
            {
                $this->hikacategory="<div class='adv-search'>".MyMaplocationsHelper::getHikaCategory($this->extra_catid)."</div>";
            }
            else if($this->component=="com_virtuemart")
            {
                $this->virtuecategory="<div class='adv-search'>".MyMaplocationsHelper::getVirtueCategory($this->extra_catid)."</div>";
            }
            else if($this->component=="com_easyblog")
            {
                $this->easyblogcategory=MyMaplocationsHelper::getEasyBlogCategory($this->extra_catid);
            }
            else if($this->component=="com_jomclassifieds")
            {
                $this->jomcategory="<div class='adv-search'>".MyMaplocationsHelper::getJomclassifiedsCategory($this->extra_catid)."</div>";
                            
            }
            else if($this->component=="com_ohanah")
            {
                $this->ohanahcategory=MyMaplocationsHelper::getOhanahCategory($this->extra_catid);
            }
            else if($this->component=="com_eventbooking")
            {
                $this->eventbookingcategory=MyMaplocationsHelper::getEventBookingCategory($this->extra_catid);
            }
            else if($this->component=="com_zoo")
            {
               $this->zoocategory=MyMaplocationsHelper::getZooCategory($this->extra_catid);
            }
            else if($this->component=="com_community")
            {
                 $this->communitycategory=MyMaplocationsHelper::getCommunityCategory($this->extra_catid);
            }
            else if($this->component=="com_adsmanager")
            {
                 $this->adsmanagercategory=MyMaplocationsHelper::getAdsManagerCategory($this->extra_catid);
            }
            else if($this->component=="com_djclassifieds")
            {
                 $this->djclassifiedscategory=MyMaplocationsHelper::getDjClassifiedsCategory($this->extra_catid);
            }
        }
        
        $this->zip=$zip;
        $this->_prepareDocument();
        parent::display($tpl);
    }

    /**
     * Prepares the document
     */
    protected function _prepareDocument() {
        $app = JFactory::getApplication();
        $menus = $app->getMenu();
        $title = null;

        // Because the application sets a default page title,
        // we need to get it from the menu item itself
        $menu = $menus->getActive();
        if ($menu) {
            $this->params->def('page_heading', $this->params->get('page_title', $menu->title));
        } else {
            $this->params->def('page_heading', '');
        }
        $title = $this->params->get('page_title', '');
        if (empty($title)) {
            $title = $app->getCfg('sitename');
        } elseif ($app->getCfg('sitename_pagetitles', 0) == 1) {
            $title = JText::sprintf('JPAGETITLE', $app->getCfg('sitename'), $title);
        } elseif ($app->getCfg('sitename_pagetitles', 0) == 2) {
            $title = JText::sprintf('JPAGETITLE', $title, $app->getCfg('sitename'));
        }
        $this->document->setTitle($title);

        if ($this->params->get('menu-meta_description')) {
            $this->document->setDescription($this->params->get('menu-meta_description'));
        }

        if ($this->params->get('menu-meta_keywords')) {
            $this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
        }

        if ($this->params->get('robots')) {
            $this->document->setMetadata('robots', $this->params->get('robots'));
        }
    }

}
