<?php
/**
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ****@author      joomunited - contact@joomunited.com
 */
// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('behavior.multiselect');
JHtml::_('dropdown.init');


JHTML::_('script', 'system/multiselect.js', false, true);
// Import CSS
$document = JFactory::getDocument();
$user = JFactory::getUser();
$userId = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
$archived = $this->state->get('filter.published') == 2 ? true : false;
$trashed = $this->state->get('filter.published') == -2 ? true : false;
$canOrder = $user->authorise('core.edit.state', 'com_mymaplocations.category');
$saveOrder = $listOrder == 'a.ordering';
if ($saveOrder) {
    $saveOrderingUrl = 'index.php?option=com_mymaplocations&task=locations.saveOrderAjax&tmpl=component';
    JHtml::_('sortablelist.sortable', 'articleList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}
$sortFields = $this->getSortFields();
?>
<script type="text/javascript">
    Joomla.orderTable = function() {
        table = document.getElementById("sortTable");
        direction = document.getElementById("directionTable");
        order = table.options[table.selectedIndex].value;
        if (order != '<?php echo $listOrder; ?>') {
            dirn = 'asc';
        } else {
            dirn = direction.options[direction.selectedIndex].value;
        }
        Joomla.tableOrdering(order, dirn, '');
    }
</script>

<?php if(MyMaplocationsHelper::getAllowAdd()) {?>
								<a
                                        href="<?php echo JRoute::_('index.php?option=com_mymaplocations&view=form&layout=edit'); ?>" class="btn btn-inverse resultbtn"><i class="mml-edit" class="edit"></i><?php echo JTEXT::_('JACTION_CREATE')." ".JTEXT::_('COM_MYMAPLOCATIONS_TITLE_STORES'); ?></a>
								<?php } ?>
	

<form action="<?php echo JRoute::_('index.php?option=com_mymaplocations&view=mylocations'); ?>" method="post" name="adminForm" id="adminForm">

        <div id="j-main-container" class="span12 row-fluid">
            <div id="j-main-container">

            <div id="filter-bar" class="btn-toolbar">
                <div class="filter-search btn-group pull-left input-group">
                    <label for="filter_search" class="element-invisible"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
                    <input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('Search'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('JGLOBAL_TITLE'); ?>" />
                </div>
                <div class="btn-group pull-left">
                    <button class="btn hasTooltip btn-primary" type="submit" title="<?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i></button>
                    <button class="btn hasTooltip btn-danger" type="button" title="<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value='';this.form.submit();"><i class="icon-remove"></i></button>
                </div>
      
                <div class="btn-group pull-right hidden-phone">
                    <label for="limit" class="element-invisible"><?php echo JText::_('MOD_MYMAPLOCATIONS_SEARCHLIMIT_LABEL'); ?></label>
<?php echo $this->pagination->getLimitBox(); ?>
                </div>
                <div class="btn-group pull-right">
                    <select name="sortTable" id="sortTable" class="input-medium" onchange="Joomla.orderTable()">    
                    <?php echo JHtml::_('select.options', $sortFields, 'value', 'text', $listOrder); ?>
                    </select>
                </div>
            </div>
            <div class="clearfix"> </div>

            <div class="clr"> </div>
            <table class="table table-striped" id="articleList">
                <thead>
                    <tr>
                    <tr>
                        <th>
                            <?php echo JHtml::_('grid.sort', 'JGLOBAL_TITLE', 'a.name', $listDirn, $listOrder); ?>
                        </th>
                        <th class="nowrap hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'COM_MYMAPLOCATIONS_LOCATIONS_CREATED_BY', 'a.created_by', $listDirn, $listOrder); ?>
                        </th>
                        <th width="5%" class="nowrap hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'COM_MYMAPLOCATIONS_LOCATIONS_POSTAL', 'a.postal', $listDirn, $listOrder); ?>
                        </th>
                        <th width="5%" class="nowrap hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'JGRID_HEADING_LANGUAGE', 'a.language', $listDirn, $listOrder); ?>
                        </th>
                        <th width="1%" class="nowrap center hidden-phone">
                            <?php echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                </thead>
                <tbody>
<?php
$n = count($this->items);
foreach ($this->items as $i => $item) :
    $ordering = $listOrder == 'a.ordering';
    $canCreate = $user->authorise('core.create', 'com_mymaplocations.category.' . $item->catid);
    $canEdit = $user->authorise('core.edit', 'com_mymaplocations.category.' . $item->catid);
    $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $userId || $item->checked_out == 0;
    $canEditOwn = $user->authorise('core.edit.own', 'com_mymaplocations.category.' . $item->catid) && $item->created_by == $userId;
    $canChange = $user->authorise('core.edit.state', 'com_mymaplocations.category.' . $item->catid) && $canCheckin;
    ?>
                        <tr class="row<?php echo $i % 2; ?>" sortable-group-id="<?php echo $item->catid ?>">
                            
                            <td class="nowrap has-context">
                                <div class="pull-left">
                                    <?php if ($item->checked_out) : ?>
                                        <?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'locations.', $canCheckin); ?>
                                    <?php endif; ?>
                                    <?php  if(MyMaplocationsHelper::getAllowEdit($item)) : ?>
                                        <a href="<?php echo JRoute::_('index.php?option=com_mymaplocations&view=form&layout=edit&id=' . (int) $item->id); ?>">
                                            <?php echo $this->escape($item->name); ?></a>
                                        <?php else : ?>
                                        <?php echo $this->escape($item->name); ?>
                                    <?php endif; ?>
                                    
                                </div>
                                
                            </td>
                            <td align="small hidden-phone">
                                <?php echo $item->created_by; ?>
                            </td>
                            <td class="center hidden-phone">
                                <?php echo $item->postal; ?>
                            </td>
                            <td class="small hidden-phone">
                                <?php if ($item->language == '*'): ?>
                                    <?php echo JText::alt('JALL', 'language'); ?>
                                <?php else: ?>
                                    <?php echo $item->language_title ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
                                <?php endif; ?>
                            </td>
                            <td align="center hidden-phone">
                                <?php echo $item->id; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="10">
                            <?php echo $this->pagination->getListFooter(); ?>
                        </td>
                    </tr>
                </tfoot>

            </table>

            <div>
                <input type="hidden" name="task" value="" />
                <input type="hidden" name="boxchecked" value="0" />
                <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
                <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
                <?php echo JHtml::_('form.token'); ?>
            </div>
            </form>