RSFormPro.Signature = {
	ids    : [],
	drawAll: function () {
		for (var i = 0; i < RSFormPro.Signature.ids.length; i++) {
			RSFormPro.Signature.draw(RSFormPro.Signature.ids[i]);
		}

		jQuery('.clear-signature').click(function () {
			// Get signature ID
			var id = jQuery(this).data('clear');
			// Reset
			jQuery(document.getElementById(id)).jSignature('reset');
			jQuery(document.getElementById('hidden-' + id)).removeAttr('value');
		});
	},
	draw   : function (id) {
		var $signature = jQuery(document.getElementById(id));

		// Hidden input used to store data
		var $hidden = jQuery(document.getElementById('hidden-' + id));

		var $options = {
			lineWidth: 0,
			sizeRatio: 2.4,
			'background-color': 'transparent'
		};

		// Initialize
		var $initialOffset = $signature.offset().left;
		var $initiated = false;
		if ($initialOffset < 0) {
			var $val = $hidden.val();
			$signature.onPositionChanged(function () {
				if ($signature.offset().left > 0 && !$initiated) {
					$signature.jSignature($options);
					$hidden.val($val);
					$initiated = true;
					if ($val !== '') {
						$signature.jSignature('setData', $val);
					}
				}
			});
		} else {
			$signature.jSignature($options);
			$initiated = true;
			if ($hidden.val() !== '') {
				$signature.jSignature('setData', $hidden.val());
			}
		}

		// Populate hidden input
		$signature.bind('change', function (e) {
			var $data = jQuery(this).jSignature('getData');
			var $hidden = jQuery(document.getElementById('hidden-' + jQuery(e.target).attr('id')));
			$hidden.val($data);
		});

	}
};

if (typeof jQuery !== 'undefined') {
	jQuery(document).ready(RSFormPro.Signature.drawAll);
}

jQuery.fn.onPositionChanged = function (trigger, millis) {
	if (millis == null) millis = 100;
	var o = jQuery(this[0]);
	if (o.length < 1) return o;

	var lastPos = null;
	var lastOff = null;
	setInterval(function () {
		if (o == null || o.length < 1) return o;
		if (lastPos == null) lastPos = o.position();
		if (lastOff == null) lastOff = o.offset();
		var newPos = o.position();
		var newOff = o.offset();
		if (lastPos.top != newPos.top || lastPos.left != newPos.left) {
			jQuery(this).trigger('onPositionChanged', {lastPos: lastPos, newPos: newPos});
			if (typeof (trigger) == "function") trigger(lastPos, newPos);
			lastPos = o.position();
		}
		if (lastOff.top != newOff.top || lastOff.left != newOff.left) {
			jQuery(this).trigger('onOffsetChanged', {lastOff: lastOff, newOff: newOff});
			if (typeof (trigger) == "function") trigger(lastOff, newOff);
			lastOff = o.offset();
		}
	}, millis);

	return o;
};