<?php
/** aikon Floating Search
 * @copyright   Copyright (C) 2014 aikon CMS, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

abstract class ModAikonsearchHelper
{

    /*
     * load some CSS files to the doc based on params
     * @param JRegistry $params
     * @param $assetPath string
     *
     * return bool
     */
    public static function addCssByParams(JRegistry $params, $assetsPath = ''){

        $doc = JFactory::getDocument();
        // if no asset params assign default
        if ($assetsPath == '' ){
            $assetsPath = JUri::root() . 'modules/mod_aikon_floating_search/assets/';
        }

        // add RTL if needed
        if ($params->get('direction') === 'rtl'){
            $doc->addStylesheet($assetsPath .'css/rtl.css');

        }

        // if needed, load css to align the search aikon to the left
        if ($params->get('searchIconPosition') === 'left'){
            $doc->addStylesheet($assetsPath .'css/left.css');
        }

        // if needed, load the dark box theme
        if ($params->get('boxTheme') === 'dark'){
            $doc->addStylesheet($assetsPath .'css/stylesdark.css');
        }

        // if needed, load css of the dark search box trigger (icon)
        if ($params->get('triggrtTheme') === 'dark'){
            $doc->addStylesheet($assetsPath .'css/triggerdark.css');
        }

        return true;
    }
}
