<?php
/** aikon Floating Search
 * @copyright   Copyright (C) 2014 aikon CMS, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

require_once __DIR__ . '/helper.php';

// set some basic vars
$assetsPath = JUri::root() . 'modules/mod_aikon_floating_search/assets/';
$doc = JFactory::getDocument();




// add jQuery if needed
if ($params->get('loadJquery')){
	$doc->addScript('//ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js');
}

//load default CSS
$doc->addStylesheet($assetsPath .'css/stylesbright.css');
$doc->addStylesheet($assetsPath .'css/triggerbright.css');

// load optional CSS files based on params
ModAikonsearchHelper::addCssByParams($params, $assetsPath);


$ostitle = $params->get('opensearch_title', JText::_('MOD_AIKONSEARCH_SEARCHBUTTON_TEXT') . ' ' . $app->get('sitename'));
$doc->addHeadLink(
        JUri::getInstance()->toString(array('scheme', 'host', 'port'))
        . JRoute::_('&option=com_search&format=opensearch'), 'search', 'rel',
        array(
            'title' => htmlspecialchars($ostitle),
            'type' => 'application/opensearchdescription+xml'
        )
    );

// set variables for TPL
$searchBoxText	= htmlspecialchars($params->get('searchBoxText', ''));
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
$introText = $params->get('introText');
$itemId = $params->get('itemId');

// load template
require JModuleHelper::getLayoutPath('mod_aikon_floating_search', $params->get('layout', 'default'));

