<?php

/*
 * @version    4.3.2
 * @package     com_mymaplocations
 * @copyright   JoomUnited (C) 2011. All rights reserved.
 * @license     http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * ***@author      Created by JoomUnited (C)
 */

defined('_JEXEC') or die;
jimport('joomla.version');
use Joomla\Utilities\ArrayHelper;

// import Joomla Categories Library
jimport('joomla.application.categories');
if (!(class_exists('MyMapLocationsHelper'))) {

    $helper = JPATH_SITE . '/components/com_mymaplocations/helpers/mymaplocations.php';
    if (file_exists($helper)) {
        require_once($helper);
    }
}

if (!(MyMapLocationsHelper::checkComponent('com_content'))) {
    return;
}
$lang = JFactory::getLanguage();
$app = JFactory::getApplication();
$category_id = $params->get('catids');
$mapid = $params->get('mapid');
$height = $params->get('height');
$width = $params->get('width');
$zoom = $params->get('zoom');
$type = $params->get('type');
$limit=$params->get('limit');
$map_display=$params->get('map_display',0);
$orderCol=$params->get('filter_order');
$db = JFactory::getDBO();

$query = $db->getQuery(true);
$query->select('a.*');
$query->select('k.title as name');

$query->select(' k.catid as catid');
$query->select('k.ordering as cordering');
$query->select('mc.title AS maincat_title, mc.alias AS maincat_alias');
$query->select('k.alias as alias');
$query->select('CASE WHEN CHAR_LENGTH(mc.alias) THEN CONCAT_WS(\':\', mc.id, mc.alias) ELSE mc.id END as categoryslug');
$query->from('#__mymaplocations_location AS a');
$query->join('LEFT', '#__content AS k ON k.id = a.extra_id');
$query->join('LEFT', '#__categories AS mc ON mc.id = k.catid');
$query->where('component=' . $db->quote('com_content'));
$query->where(' k.state =1');

if ($category_id!= 0) {
	   ArrayHelper::toInteger($category_id);
        $query->where('k.catid IN (' . implode(',', $category_id) . ')');
    }
if(JLanguageMultilang::isEnabled())
{
$query->where('k.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
}
if ($orderCol=="date")
	{
		$query->order( $db->escape( 'extra_id  asc'  ) );
	}
	else if($orderCol=="rdate")
	{
		$query->order( $db->escape( 'extra_id  desc'  ) );
	}
	else if (($orderCol=="alpha"))
            {
			$query->order( $db->escape( 'k.title asc'  ));
            }
			else if (($orderCol=="ralpha"))
			{
				$query->order( $db->escape( 'k.title desc'  ));
			}
			else
            {
                $query->order('cordering');
            }

if($limit!=0)
{
	$db->setQuery($query,0,$limit);

}
else
{
$db->setQuery($query);
}
$result = $db->loadObjectList();

if(!$result)
{
    return;
}



$result[0]->google_maptype = $params->get('google_maptype', 'ROADMAP');
$result[0]->bing_maptype = $params->get('bing_maptype', 'road');
$result[0]->openmapstyle=$params->get('openmapstyle', 1);
$result[0]->map_design=$params->get('map_design', 1);
$result[0]->map_layer=$params->get('map_layer',1);
$result[0]->maplayer_url=$params->get('maplayer_url','');
require JModuleHelper::getLayoutPath('mod_flexicontentmymaplocationsmaps', $params->get('layout', 'default'));
