<?php
/**
 * @version     $Id$
 * @author      JoomlaUX Admin
 * @package     Joomla!
 * @subpackage  com_jux_news_wall !
 * @copyright   Copyright (C) 2016 by JoomlaUX Solutions. All rights reserved.
 * @license     http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL version 3
 */
// no direct access
defined('_JEXEC') or die('Restricted access');
jimport('joomla.html.html');
jimport('joomla.form.formfield');
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');
if (file_exists(JPATH_SITE.'/components/com_k2')){

    class JFormFieldJUXTags extends JFormFieldList {

        public $causes = 'JUXTags';

        /**
         * fetch Element
         */
        protected function getInput() {
            // Initialize variables.
            $html = array();
            $attr = '';

            // Initialize some field attributes.
            $attr .= $this->element['class'] ? ' class="' . (string) $this->element['class'] . '"' : '';
            $attr .= $this->element['size'] ? ' size="' . (int) $this->element['size'] . '"' : '1';
            $attr .= $this->element['multiple'] ? ' multiple="multiple"' : '';
            // Initialize JavaScript field attributes.
            $attr .= $this->element['onchange'] ? ' onchange="' . (string) $this->element['onchange'] . '"' : '';

            $data = $this->getData();

            return JHTML::_('select.genericlist', $data, $this->name, $attr, 'value', 'text', $this->value, $this->id, true);

            return implode($html);
        }

        /**
         * Method to get list of countries.
         *
         * @return  array
         */
        protected function getData() {
            // Get a database object.
            $db = JFactory::getDBO();

            $query = $db->getQuery(true);

            $query->select('`id` AS value, `name` AS text');
            $query->from('#__k2_tags');
            $query->where('published = 1');
            $db->setQuery($query);
            $sec = array();
            $sec[] = JHTML::_('select.option', '', '- ' . JText::_('MOD_JUX_SELECT_NEWS_WALL') . ' -', 'value', 'text', 'multiple="multiple" size="5"');
            try {
                $realties = $db->loadObjectList();
                if (count($realties)) {
                    foreach ($realties as $causes) {
                        $sec[] = JHTML::_('select.option', $causes->value, $causes->text, 'value', 'text');
                    }
                }
            } catch (JDatabaseException $e) {
                $je = new JException($e->getMessage());
                $this->setError($je);
                return array();
            }
            return $sec;
        }

    }
}else{
    class JFormFieldJUXTags extends JFormField{
            protected $type= "JUXTags";

            public function getInput(){
                return '';
            }
            public function getLabel(){
                return '<label style="width: 100%; max-width: 100%; padding: 5px 0 0 0; border-bottom: solid 1px #003399; color: #003399; font-weight: bold;">'.parent::getTitle().'</label>';
            }       
    };
}
?>
