<?php
/**
 * @version		$id: $
 * @author		JoomlaUX!
 * @package		Joomla!
 * @subpackage          mod_jux_news_wall
 * @copyright           Copyright (C) 2012 - 2014 by Joomlaux. All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL version 3, See LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

// k2 content
    if (file_exists(JPATH_ADMINISTRATOR.'/components/com_k2')){
    		require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php');
			require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'utilities.php');
    }


// joomla content
$com_path = JPATH_SITE . '/components/com_content/';
require_once $com_path . 'router.php';
require_once $com_path . 'helpers/route.php';
JModelLegacy::addIncludePath($com_path . '/models', 'ContentModel');

if (!class_exists('modJUXNewsWallCss')){
    require_once dirname(__FILE__).'/includes/css.php';
}

class mod_JUX_NewsWallHelper {
    public static function getCssProcessor(&$params,$filename,$prefix){
        return modJUXNewsWallCss::process($params,$filename,$prefix);		
    }
}

class modJUXNewsWallHelper
{
	// Limit words
	public static function limit_words($string, $word_limit)
	{
	    $words = preg_split('/\s+/', $string);
	    return implode(" ",array_splice($words,0,$word_limit));
	}

    /*
     * Convert Hex to RBG
     * $return Params String rgba('$rbg,$opacity')
     */
    public static function getTags($idtags){
    	$db    = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('t.*')
			  ->from('#__k2_tags AS t');
		if($idtags != -1){
        	$query->where(' t.id in ('.$idtags.')');  
		}
		$query->where(' published =1');  
        $db->setQuery($query);
        $tags = $db->loadObjectList();
        return $tags;    
    }
    public static function juxHex2rgb($background_color){
            $color		= str_replace("#",'',$background_color);
            if(strlen($color) == 3) {
                    $r = hexdec(substr($color,0,1).substr($color,0,1));
                    $g = hexdec(substr($color,1,1).substr($color,1,1));
                    $b = hexdec(substr($color,2,1).substr($color,2,1));
             } else {
                    $r = hexdec(substr($color,0,2));
                    $g = hexdec(substr($color,2,2));
                    $b = hexdec(substr($color,4,2));
             }
             // return value color rgb(r,g,b,opacity)
            $rgb = $r .','. $g .','.$b;
            return $rgb;
    }
	
    /**
     * load javascript files: processing override js, load js compress or not.
     */
    public static function loadjQuery($params)
    {
        $document = JFactory::getDocument();
        $enable_jquery = $params->get('enable_jquery', 0);
        $enable_noconflict = $params->get('enable_noconflict', 0);

        if ($enable_jquery) {
            $document->addScript(JURI::base() . 'modules/mod_jux_news_wall/assets/js/jquery.min.js');
        }
        if ($enable_noconflict) {
            $document->addScript(JURI::base() . 'modules/mod_jux_news_wall/assets/js/jquery-noconflict.js');
        }

    }
    // Get items from K2 content
	public static function getItems(&$params, $format = 'html',$limitstart="", $limit="")
	{

		jimport('joomla.filesystem.file');
		$mainframe = JFactory::getApplication();
		$cid = $params->get('category_id', NULL);
		$ordering = $params->get('itemsOrdering', '');
		$componentParams = JComponentHelper::getParams('com_k2');

		$user = JFactory::getUser();
		$aid = $user->get('aid');
		$db = JFactory::getDBO();

		$jnow = JFactory::getDate();
		$now =  K2_JVERSION == '15'?$jnow->toMySQL():$jnow->toSql();
		$nullDate = $db->getNullDate();

		if ($params->get('source') == 'specific')
		{

			$value = $params->get('items');
			$current = array();
			if (is_string($value) && !empty($value))
				$current[] = $value;
			if (is_array($value))
				$current = $value;

			$items = array();

			foreach ($current as $id)
			{

				$query = "SELECT i.*, c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams 
				FROM #__k2_items as i 
				LEFT JOIN #__k2_categories c ON c.id = i.catid 
				WHERE i.published = 1 ";
				if (K2_JVERSION != '15')
				{
					$query .= " AND i.access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
				}
				else
				{
					$query .= " AND i.access<={$aid} ";
				}
				$query .= " AND i.trash = 0 AND c.published = 1 ";
				if (K2_JVERSION != '15')
				{
					$query .= " AND c.access IN(".implode(',', $user->getAuthorisedViewLevels()).") ";
				}
				else
				{
					$query .= " AND c.access<={$aid} ";
				}
				$query .= " AND c.trash = 0 
				AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." ) 
				AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." ) 
				AND i.id={$id}";
				if (K2_JVERSION != '15')
				{
					if ($mainframe->getLanguageFilter())
					{
						$languageTag = JFactory::getLanguage()->getTag();
						$query .= " AND c.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") AND i.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').")";
					}
				}
				$db->setQuery($query);
				$item = $db->loadObject();
				if ($item)
					$items[] = $item;

			}
		}

		else
		{
			$query = "SELECT i.*,";

			if ($ordering == 'modified')
			{
				$query .= " CASE WHEN i.modified = 0 THEN i.created ELSE i.modified END as lastChanged,";
			}
			
			$query .= "c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams";
			
			if ($ordering == 'best')
				$query .= ", (r.rating_sum/r.rating_count) AS rating";

			if ($ordering == 'comments')
				$query .= ", COUNT(comments.id) AS numOfComments";

			$query .= " FROM #__k2_items as i RIGHT JOIN #__k2_categories c ON c.id = i.catid";

			if ($ordering == 'best')
				$query .= " LEFT JOIN #__k2_rating r ON r.itemID = i.id";

			if ($ordering == 'comments')
				$query .= " LEFT JOIN #__k2_comments comments ON comments.itemID = i.id";

			if (K2_JVERSION != '15')
			{
				$query .= " WHERE i.published = 1 AND i.access IN(".implode(',', $user->getAuthorisedViewLevels()).") AND i.trash = 0 AND c.published = 1 AND c.access IN(".implode(',', $user->getAuthorisedViewLevels()).")  AND c.trash = 0";
			}
			else
			{
				$query .= " WHERE i.published = 1 AND i.access <= {$aid} AND i.trash = 0 AND c.published = 1 AND c.access <= {$aid} AND c.trash = 0";
			}

			$query .= " AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." )";
			$query .= " AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." )";

			if ($params->get('catfilter'))
			{
				if (!is_null($cid))
				{
					if (is_array($cid))
					{
						if ($params->get('getChildren'))
						{
							$itemListModel = K2Model::getInstance('Itemlist', 'K2Model');
							$categories = $itemListModel->getCategoryTree($cid);
							$sql = @implode(',', $categories);
							$query .= " AND i.catid IN ({$sql})";

						}
						else
						{
							JArrayHelper::toInteger($cid);
							$query .= " AND i.catid IN(".implode(',', $cid).")";
						}

					}
					else
					{
						if ($params->get('getChildren'))
						{
							$itemListModel = K2Model::getInstance('Itemlist', 'K2Model');
							$categories = $itemListModel->getCategoryTree($cid);
							$sql = @implode(',', $categories);
							$query .= " AND i.catid IN ({$sql})";
						}
						else
						{
							$query .= " AND i.catid=".(int)$cid;
						}

					}
				}
			}

			if ($params->get('FeaturedItems') == '0')
				$query .= " AND i.featured != 1";

			if ($params->get('FeaturedItems') == '2')
				$query .= " AND i.featured = 1";

			if ($params->get('videosOnly'))
				$query .= " AND (i.video IS NOT NULL AND i.video!='')";

			if ($ordering == 'comments')
				$query .= " AND comments.published = 1";

			if (K2_JVERSION != '15')
			{
				if ($mainframe->getLanguageFilter())
				{
					$languageTag = JFactory::getLanguage()->getTag();
					$query .= " AND c.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').") AND i.language IN (".$db->Quote($languageTag).", ".$db->Quote('*').")";
				}
			}

			switch ($ordering)
			{

				case 'date' :
					$orderby = 'i.created ASC';
					break;

				case 'rdate' :
					$orderby = 'i.created DESC';
					break;

				case 'alpha' :
					$orderby = 'i.title';
					break;

				case 'ralpha' :
					$orderby = 'i.title DESC';
					break;

				case 'order' :
					if ($params->get('FeaturedItems') == '2')
						$orderby = 'i.featured_ordering';
					else
						$orderby = 'i.ordering';
					break;

				case 'rorder' :
					if ($params->get('FeaturedItems') == '2')
						$orderby = 'i.featured_ordering DESC';
					else
						$orderby = 'i.ordering DESC';
					break;

				case 'hits' :
					if ($params->get('popularityRange'))
					{
						$datenow = JFactory::getDate();
						$date =  K2_JVERSION == '15'?$datenow->toMySQL():$datenow->toSql();
						$query .= " AND i.created > DATE_SUB('{$date}',INTERVAL ".$params->get('popularityRange')." DAY) ";
					}
					$orderby = 'i.hits DESC';
					break;

				case 'rand' :
					$orderby = 'RAND()';
					break;

				case 'best' :
					$orderby = 'rating DESC';
					break;

				case 'comments' :
					if ($params->get('popularityRange'))
					{
						$datenow = JFactory::getDate();
						$date =  K2_JVERSION == '15'?$datenow->toMySQL():$datenow->toSql();
						$query .= " AND i.created > DATE_SUB('{$date}',INTERVAL ".$params->get('popularityRange')." DAY) ";
					}
					$query .= " GROUP BY i.id ";
					$orderby = 'numOfComments DESC';
					break;

				case 'modified' :
					$orderby = 'lastChanged DESC';
					break;

				case 'publishUp' :
					$orderby = 'i.publish_up DESC';
					break;

				default :
					$orderby = 'i.id DESC';
					break;
			}

			$query .= " ORDER BY ".$orderby;
			$db->setQuery($query, $limitstart, $limit);
			$items = $db->loadObjectList();
		}

		$model = K2Model::getInstance('Item', 'K2Model');

		if (count($items))
		{

			foreach ($items as $item)
			{
			    $item->event = new stdClass;

				//Clean title
				$item->title = JFilterOutput::ampReplace($item->title);

				//Images
				if ($params->get('itemImage'))
				{

					$date = JFactory::getDate($item->modified);
					$timestamp = '?t='.$date->toUnix();

					if (JFile::exists(JPATH_SITE.DS.'media'.DS.'k2'.DS.'items'.DS.'cache'.DS.md5("Image".$item->id).'_XS.jpg'))
					{
						$item->imageXSmall = JURI::base(true).'/media/k2/items/cache/'.md5("Image".$item->id).'_XS.jpg';
						if ($componentParams->get('imageTimestamp'))
						{
							$item->imageXSmall .= $timestamp;
						}
					}

					if (JFile::exists(JPATH_SITE.DS.'media'.DS.'k2'.DS.'items'.DS.'cache'.DS.md5("Image".$item->id).'_S.jpg'))
					{
						$item->imageSmall = JURI::base(true).'/media/k2/items/cache/'.md5("Image".$item->id).'_S.jpg';
						if ($componentParams->get('imageTimestamp'))
						{
							$item->imageSmall .= $timestamp;
						}
					}

					if (JFile::exists(JPATH_SITE.DS.'media'.DS.'k2'.DS.'items'.DS.'cache'.DS.md5("Image".$item->id).'_M.jpg'))
					{
						$item->imageMedium = JURI::base(true).'/media/k2/items/cache/'.md5("Image".$item->id).'_M.jpg';
						if ($componentParams->get('imageTimestamp'))
						{
							$item->imageMedium .= $timestamp;
						}
					}

					if (JFile::exists(JPATH_SITE.DS.'media'.DS.'k2'.DS.'items'.DS.'cache'.DS.md5("Image".$item->id).'_L.jpg'))
					{
						$item->imageLarge = JURI::base(true).'/media/k2/items/cache/'.md5("Image".$item->id).'_L.jpg';
						if ($componentParams->get('imageTimestamp'))
						{
							$item->imageLarge .= $timestamp;
						}
					}

					if (JFile::exists(JPATH_SITE.DS.'media'.DS.'k2'.DS.'items'.DS.'cache'.DS.md5("Image".$item->id).'_XL.jpg'))
					{
						$item->imageXLarge = JURI::base(true).'/media/k2/items/cache/'.md5("Image".$item->id).'_XL.jpg';
						if ($componentParams->get('imageTimestamp'))
						{
							$item->imageXLarge .= $timestamp;
						}
					}

					if (JFile::exists(JPATH_SITE.DS.'media'.DS.'k2'.DS.'items'.DS.'cache'.DS.md5("Image".$item->id).'_Generic.jpg'))
					{
						$item->imageGeneric = JURI::base(true).'/media/k2/items/cache/'.md5("Image".$item->id).'_Generic.jpg';
						if ($componentParams->get('imageTimestamp'))
						{
							$item->imageGeneric .= $timestamp;
						}
					}

					$image = 'image'.$params->get('itemImgSize', 'Small');
					if (isset($item->$image))
						$item->image = $item->$image;

				}

				//Read more link
				$item->link = urldecode(JRoute::_(K2HelperRoute::getItemRoute($item->id.':'.urlencode($item->alias), $item->catid.':'.urlencode($item->categoryalias))));

				//Tags
				if ($params->get('itemTags'))
				{
					$tags = $model->getItemTags($item->id);
					for ($i = 0; $i < sizeof($tags); $i++)
					{
						$tags[$i]->link = JRoute::_(K2HelperRoute::getTagRoute($tags[$i]->name));
					}
					$item->tags = $tags;
				}

				//Category link
				if ($params->get('itemCategory'))
					$item->categoryLink = urldecode(JRoute::_(K2HelperRoute::getCategoryRoute($item->catid.':'.urlencode($item->categoryalias))));

				//Extra fields
				if ($params->get('itemExtraFields'))
				{
					$item->extra_fields = $model->getItemExtraFields($item->extra_fields, $item);
				}

				//Comments counter
				if ($params->get('itemCommentsCounter'))
					$item->numOfComments = $model->countItemComments($item->id);

				//Attachments
				if ($params->get('itemAttachments'))
					$item->attachments = $model->getItemAttachments($item->id);

				//Import plugins
				if ($format != 'feed')
				{
					$dispatcher = JDispatcher::getInstance();
					JPluginHelper::importPlugin('content');
				}

				//Video
				if ($params->get('itemVideo') && $format != 'feed')
				{
					$params->set('vfolder', 'media/k2/videos');
					$params->set('afolder', 'media/k2/audio');
					$item->text = $item->video;
					            if (K2_JVERSION == '15')
            {
                $dispatcher->trigger('onPrepareContent', array(&$item, &$params, $limitstart));
            }
            else
            {
                $dispatcher->trigger('onContentPrepare', array('mod_jux_news_wall.', &$item, &$params, $limitstart));
            }
					$item->video = $item->text;
				}

				// Introtext
				$item->text = '';
				if ($params->get('itemIntroText'))
				{
					// Word limit
					if ($params->get('itemIntroTextWordLimit'))
					{
						$item->text .= K2HelperUtilities::wordLimit($item->introtext, $params->get('itemIntroTextWordLimit'));
					}
					else
					{
						$item->text .= $item->introtext;
					}
				}

				if ($format != 'feed')
				{

					$params->set('parsedInModule', 1);
					// for plugins to know when they are parsed inside this module
					
					$item->event = new stdClass;
					$item->event->BeforeDisplay = '';
					$item->event->AfterDisplay = '';
					$item->event->AfterDisplayTitle = '';
					$item->event->BeforeDisplayContent = '';
					$item->event->AfterDisplayContent = '';

					if ($params->get('JPlugins', 1))
					{
						//Plugins
						if (K2_JVERSION != '15')
						{

							$item->event->BeforeDisplay = '';
							$item->event->AfterDisplay = '';

							$dispatcher->trigger('onContentPrepare', array('mod_jux_news_wall', &$item, &$params, $limitstart));

							$results = $dispatcher->trigger('onContentAfterTitle', array('mod_jux_news_wall', &$item, &$params, $limitstart));
							$item->event->AfterDisplayTitle = trim(implode("\n", $results));

							$results = $dispatcher->trigger('onContentBeforeDisplay', array('mod_jux_news_wall', &$item, &$params, $limitstart));
							$item->event->BeforeDisplayContent = trim(implode("\n", $results));

							$results = $dispatcher->trigger('onContentAfterDisplay', array('mod_jux_news_wall', &$item, &$params, $limitstart));
							$item->event->AfterDisplayContent = trim(implode("\n", $results));
						}
						else
						{
							$results = $dispatcher->trigger('onBeforeDisplay', array(&$item, &$params, $limitstart));
							$item->event->BeforeDisplay = trim(implode("\n", $results));

							$results = $dispatcher->trigger('onAfterDisplay', array(&$item, &$params, $limitstart));
							$item->event->AfterDisplay = trim(implode("\n", $results));

							$results = $dispatcher->trigger('onAfterDisplayTitle', array(&$item, &$params, $limitstart));
							$item->event->AfterDisplayTitle = trim(implode("\n", $results));

							$results = $dispatcher->trigger('onBeforeDisplayContent', array(&$item, &$params, $limitstart));
							$item->event->BeforeDisplayContent = trim(implode("\n", $results));

							$results = $dispatcher->trigger('onAfterDisplayContent', array(&$item, &$params, $limitstart));
							$item->event->AfterDisplayContent = trim(implode("\n", $results));

							$dispatcher->trigger('onPrepareContent', array(&$item, &$params, $limitstart));
						}
						
					}
					//Init K2 plugin events
					$item->event->K2BeforeDisplay = '';
					$item->event->K2AfterDisplay = '';
					$item->event->K2AfterDisplayTitle = '';
					$item->event->K2BeforeDisplayContent = '';
					$item->event->K2AfterDisplayContent = '';
					$item->event->K2CommentsCounter = '';

					if ($params->get('K2Plugins', 1))
					{
						//K2 plugins
						JPluginHelper::importPlugin('k2');
						$results = $dispatcher->trigger('onK2BeforeDisplay', array(&$item, &$params, $limitstart));
						$item->event->K2BeforeDisplay = trim(implode("\n", $results));

						$results = $dispatcher->trigger('onK2AfterDisplay', array(&$item, &$params, $limitstart));
						$item->event->K2AfterDisplay = trim(implode("\n", $results));

						$results = $dispatcher->trigger('onK2AfterDisplayTitle', array(&$item, &$params, $limitstart));
						$item->event->K2AfterDisplayTitle = trim(implode("\n", $results));

						$results = $dispatcher->trigger('onK2BeforeDisplayContent', array(&$item, &$params, $limitstart));
						$item->event->K2BeforeDisplayContent = trim(implode("\n", $results));

						$results = $dispatcher->trigger('onK2AfterDisplayContent', array(&$item, &$params, $limitstart));
						$item->event->K2AfterDisplayContent = trim(implode("\n", $results));

						$dispatcher->trigger('onK2PrepareContent', array(&$item, &$params, $limitstart));

						if ($params->get('itemCommentsCounter'))
						{
							$results = $dispatcher->trigger('onK2CommentsCounter', array(&$item, &$params, $limitstart));
							$item->event->K2CommentsCounter = trim(implode("\n", $results));
						}

					}

				}

                // Restore the intotext variable after plugins execution
                $item->introtext = $item->text;

				//Clean the plugin tags
				$item->introtext = preg_replace("#{(.*?)}(.*?){/(.*?)}#s", '', $item->introtext);

				//Author
				if ($params->get('itemAuthor'))
				{
					if (!empty($item->created_by_alias))
					{
						$item->author = $item->created_by_alias;
						$item->authorGender = NULL;
						$item->authorDescription = NULL;
						if ($params->get('itemAuthorAvatar'))
							$item->authorAvatar = K2HelperUtilities::getAvatar('alias');
						$item->authorLink = Juri::root(true);
					}
					else
					{
						$author = JFactory::getUser($item->created_by);
						$item->author = $author->name;

						$query = "SELECT `description`, `gender` FROM #__k2_users WHERE userID=".(int)$author->id;
						$db->setQuery($query, 0, 1);
						$result = $db->loadObject();
						if ($result)
						{
							$item->authorGender = $result->gender;
							$item->authorDescription = $result->description;
						}
						else
						{
							$item->authorGender = NULL;
							$item->authorDescription = NULL;
						}

						if ($params->get('itemAuthorAvatar'))
						{
							$item->authorAvatar = K2HelperUtilities::getAvatar($author->id, $author->email, $componentParams->get('userImageWidth'));
						}
						//Author Link
						$item->authorLink = JRoute::_(K2HelperRoute::getUserRoute($item->created_by));
					}
				}

				// Extra fields plugins
				if (is_array($item->extra_fields))
				{
					foreach ($item->extra_fields as $key => $extraField)
					{
						if ($extraField->type == 'textarea' || $extraField->type == 'textfield')
						{
							$tmp = new JObject();
							$tmp->text = $extraField->value;
							if ($params->get('JPlugins', 1))
							{
								if (K2_JVERSION != '15')
								{
									$dispatcher->trigger('onContentPrepare', array('mod_jux_news_wall', &$tmp, &$params, $limitstart));
								}
								else
								{
									$dispatcher->trigger('onPrepareContent', array(&$tmp, &$params, $limitstart));
								}
							}
							if ($params->get('K2Plugins', 1))
							{
								$dispatcher->trigger('onK2PrepareContent', array(&$tmp, &$params, $limitstart));
							}
							$extraField->value = $tmp->text;
						}
					}
				}

				$rows[] = $item;
			}

			return $rows;

		}

	}
        
        public static function getk2Total($params)
        {
		jimport('joomla.filesystem.file');
		$cid = $params->get('category_id', NULL);
		$ordering = $params->get('itemsOrdering', '');

		$user = JFactory::getUser();
		$aid = $user->get('aid');
		$db = JFactory::getDBO();

		$jnow = JFactory::getDate();
		$now =  K2_JVERSION == '15'?$jnow->toMySQL():$jnow->toSql();
		$nullDate = $db->getNullDate();

                $query = "SELECT i.*,";

                if ($ordering == 'modified')
                {
                        $query .= " CASE WHEN i.modified = 0 THEN i.created ELSE i.modified END as lastChanged,";
                }

                $query .= "c.name AS categoryname,c.id AS categoryid, c.alias AS categoryalias, c.params AS categoryparams";

                if ($ordering == 'best')
                        $query .= ", (r.rating_sum/r.rating_count) AS rating";

                if ($ordering == 'comments')
                        $query .= ", COUNT(comments.id) AS numOfComments";

                $query .= " FROM #__k2_items as i RIGHT JOIN #__k2_categories c ON c.id = i.catid";

                if ($ordering == 'best')
                        $query .= " LEFT JOIN #__k2_rating r ON r.itemID = i.id";

                if ($ordering == 'comments')
                        $query .= " LEFT JOIN #__k2_comments comments ON comments.itemID = i.id";

                if (K2_JVERSION != '15')
                {
                        $query .= " WHERE i.published = 1 AND i.access IN(".implode(',', $user->getAuthorisedViewLevels()).") AND i.trash = 0 AND c.published = 1 AND c.access IN(".implode(',', $user->getAuthorisedViewLevels()).")  AND c.trash = 0";
                }
                else
                {
                        $query .= " WHERE i.published = 1 AND i.access <= {$aid} AND i.trash = 0 AND c.published = 1 AND c.access <= {$aid} AND c.trash = 0";
                }

                $query .= " AND ( i.publish_up = ".$db->Quote($nullDate)." OR i.publish_up <= ".$db->Quote($now)." )";
                $query .= " AND ( i.publish_down = ".$db->Quote($nullDate)." OR i.publish_down >= ".$db->Quote($now)." )";

                if ($params->get('catfilter'))
                {
                        if (!is_null($cid))
                        {
                                if (is_array($cid))
                                {
                                        if ($params->get('getChildren'))
                                        {
                                                $itemListModel = K2Model::getInstance('Itemlist', 'K2Model');
                                                $categories = $itemListModel->getCategoryTree($cid);
                                                $sql = @implode(',', $categories);
                                                $query .= " AND i.catid IN ({$sql})";

                                        }
                                        else
                                        {
                                                JArrayHelper::toInteger($cid);
                                                $query .= " AND i.catid IN(".implode(',', $cid).")";
                                        }

                                }
                                else
                                {
                                        if ($params->get('getChildren'))
                                        {
                                                $itemListModel = K2Model::getInstance('Itemlist', 'K2Model');
                                                $categories = $itemListModel->getCategoryTree($cid);
                                                $sql = @implode(',', $categories);
                                                $query .= " AND i.catid IN ({$sql})";
                                        }
                                        else
                                        {
                                                $query .= " AND i.catid=".(int)$cid;
                                        }

                                }
                        }
                }

                $db->setQuery($query);
                $items = $db->loadObjectList();
                
		return $items;
        }
        
        
	//helper joomla content
	public static function getList(&$params, $start="", $limit="")
	{
		// Get an instance of the generic articles model
		$articles = JModelLegacy::getInstance('Articles', 'ContentModel', array('ignore_request' => true));

		// Set application parameters in model
		$app = JFactory::getApplication();
                
		$appParams = $app->getParams();
		$articles->setState('params', $appParams);

		// Set the filters based on the module params
		$articles->setState('list.start', $start);
		$articles->setState('list.limit', $limit);
		$articles->setState('filter.published', 1);
		
		// Access filter
		$access = !JComponentHelper::getParams('com_content')->get('show_noauth');
		$authorised = JAccess::getAuthorisedViewLevels(JFactory::getUser()->get('id'));
		$articles->setState('filter.access', $access);

		// Prep for Normal or Dynamic Modes
		$mode = $params->get('mode', 'normal');

		switch ($mode)
		{
			case 'dynamic':
				$option = $app->input->get('option');
				$view = $app->input->get('view');

				if ($option === 'com_content')
				{
					switch ($view)
					{
						case 'category':
							$catids = array($app->input->getInt('id'));
							break;
						case 'categories':
							$catids = array($app->input->getInt('id'));
							break;
						case 'article':
							if ($params->get('show_on_article_page', 1))
							{
								$article_id = $app->input->getInt('id');
								$catid = $app->input->getInt('catid');

								if (!$catid)
								{
									// Get an instance of the generic article model
									$article = JModelLegacy::getInstance('Article', 'ContentModel', array('ignore_request' => true));

									$article->setState('params', $appParams);
									$article->setState('filter.published', 1);
									$article->setState('article.id', (int) $article_id);
									$item = $article->getItem();

									$catids = array($item->catid);
								}
								else
								{
									$catids = array($catid);
								}
							}
							else
							{
								// Return right away if show_on_article_page option is off
								return;
							}
							break;

						case 'featured':
						default:
							// Return right away if not on the category or article views
							return;
					}
				}
				else
				{
					// Return right away if not on a com_content page
					return;
				}

				break;

			case 'normal':
			default:
				$catids = $params->get('catid');
				$articles->setState('filter.category_id.include', (bool) $params->get('category_filtering_type', 1));
				break;
		}

		// Category filter
		if ($catids)
		{
			if ($params->get('show_child_category_articles', 0) && (int) $params->get('levels', 0) > 0)
			{
				// Get an instance of the generic categories model
				$categories = JModelLegacy::getInstance('Categories', 'ContentModel', array('ignore_request' => true));
				$categories->setState('params', $appParams);
				$levels = $params->get('levels', 1) ? $params->get('levels', 1) : 9999;
				$categories->setState('filter.get_children', $levels);
				$categories->setState('filter.published', 1);
				$categories->setState('filter.access', $access);
				$additional_catids = array();

				foreach ($catids as $catid)
				{
					$categories->setState('filter.parentId', $catid);
					$recursive = true;
					$items = $categories->getItems($recursive);

					if ($items)
					{
						foreach ($items as $category)
						{
							$condition = (($category->level - $categories->getParent()->level) <= $levels);

							if ($condition)
							{
								$additional_catids[] = $category->id;
							}
						}
					}
				}

				$catids = array_unique(array_merge($catids, $additional_catids));
			}

			$articles->setState('filter.category_id', $catids);
		}

		// Ordering
		$articles->setState('list.ordering', $params->get('article_ordering', 'a.ordering'));
		$articles->setState('list.direction', $params->get('article_ordering_direction', 'ASC'));

		// New Parameters
		$articles->setState('filter.featured', $params->get('show_front', 'show'));
		$articles->setState('filter.author_id', $params->get('created_by', ""));
		$articles->setState('filter.author_id.include', $params->get('author_filtering_type', 1));
		$articles->setState('filter.author_alias', $params->get('created_by_alias', ""));
		$articles->setState('filter.author_alias.include', $params->get('author_alias_filtering_type', 1));
		$excluded_articles = $params->get('excluded_articles', '');

		if ($excluded_articles)
		{
			$excluded_articles = explode("\r\n", $excluded_articles);
			$articles->setState('filter.article_id', $excluded_articles);

			// Exclude
			$articles->setState('filter.article_id.include', false);
		}

		$date_filtering = $params->get('date_filtering', 'off');

		if ($date_filtering !== 'off')
		{
			$articles->setState('filter.date_filtering', $date_filtering);
			$articles->setState('filter.date_field', $params->get('date_field', 'a.created'));
			$articles->setState('filter.start_date_range', $params->get('start_date_range', '1000-01-01 00:00:00'));
			$articles->setState('filter.end_date_range', $params->get('end_date_range', '9999-12-31 23:59:59'));
			$articles->setState('filter.relative_date', $params->get('relative_date', 30));
		}

		// Filter by language
		$articles->setState('filter.language', $app->getLanguageFilter());

		$items = $articles->getItems();

		// Display options
		$show_date = $params->get('show_date', 0);
		$show_date_field = $params->get('show_date_field', 'created');
		$show_date_format = $params->get('show_date_format', 'Y-m-d H:i:s');
		$show_category = $params->get('show_category', 0);
		$show_hits = $params->get('show_hits', 0);
		$show_author = $params->get('show_author', 0);
		$show_introtext = $params->get('show_introtext', 0);
		$introtext_limit = $params->get('introtext_limit', 100);

		// Find current Article ID if on an article page
		$option = $app->input->get('option');
		$view = $app->input->get('view');

		if ($option === 'com_content' && $view === 'article')
		{
			$active_article_id = $app->input->getInt('id');
		}
		else
		{
			$active_article_id = 0;
		}

		// Prepare data for display using display options
		foreach ($items as &$item)
		{
			$item->slug = $item->id . ':' . $item->alias;
			$item->catslug = $item->catid ? $item->catid . ':' . $item->category_alias : $item->catid;
			if (!empty($item->id))
			{
			  	$item->tags = new JHelperTags;
			  	$item->tags->getTagIds($item->id, 'com_content.article');
			  	$item ->tags_new = modJUXNewsWallHelper::getTagsJoomlaContent($item->tags);
			}
			if ($access || in_array($item->access, $authorised))
			{
				// We know that user has the privilege to view the article
				$item->link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug));
			}
			else
			{
				$app  = JFactory::getApplication();
				$menu = $app->getMenu();
				$menuitems = $menu->getItems('link', 'index.php?option=com_users&view=login');

				if (isset($menuitems[0]))
				{
					$Itemid = $menuitems[0]->id;
				}
				elseif ($app->input->getInt('Itemid') > 0)
				{
					// Use Itemid from requesting page only if there is no existing menu
					$Itemid = $app->input->getInt('Itemid');
				}

				$item->link = JRoute::_('index.php?option=com_users&view=login&Itemid=' . $Itemid);
			}

			// Used for styling the active article
			$item->active = $item->id == $active_article_id ? 'active' : '';

			$item->displayDate = '';

			if ($show_date)
			{
				$item->displayDate = JHTML::_('date', $item->$show_date_field, $show_date_format);
			}

			if ($item->catid)
			{
				$item->displayCategoryLink = JRoute::_(ContentHelperRoute::getCategoryRoute($item->catid));
				$item->displayCategoryTitle = $show_category ? '<a href="' . $item->displayCategoryLink . '">' . $item->category_title . '</a>' : '';
			}
			else
			{
				$item->displayCategoryTitle = $show_category ? $item->category_title : '';
			}

			$item->displayHits = $show_hits ? $item->hits : '';
			$item->displayAuthorName = $show_author ? $item->author : '';

			// if ($show_introtext)
			// {
			// 	$item->introtext = JHtml::_('content.prepare', $item->introtext, '', 'mod_articles_category.content');
			// 	$item->introtext = self::_cleanIntrotext($item->introtext);
			// }

			$item->displayIntrotext = $show_introtext ? self::truncate($item->introtext, $introtext_limit) : '';
			$item->displayIntrotext = self::limit_words($item->introtext,13);
			
			$item->displayReadmore = $item->alternative_readmore;
		}	
		return $items;
	}

	//get tags in joomla content
	public static function getTagsJoomlaContent($tagsID){
		//var_dump($tagsID->tags);die;
		if($tagsID->tags ==''){
			$tagsID->tags=-1;
		}
		$db = JFactory::getDBO();
        $query = $db->getQuery(true);

        $query->select($db->quoteName(array('title','id')))
              ->from($db->quoteName('#__tags'));
        $query ->where('#__tags.level=1');
        $query ->where('id IN ('.$tagsID->tags.')');     
        $db->setQuery($query);
        $tags = $db->loadObjectList();
        return $tags;

	}

	public static function limit_words_new($string, $word_limit)
	{
	    $words = explode(" ",$string);
	    return implode(" ",array_splice($words,0,$word_limit));
	}
        
        
        public static function getTotal($params){


		$app	= JFactory::getApplication();
		$db		= JFactory::getDbo();

		//Parameters
//		$catids = self::categories($params->get('catid'));
		$catids = $params->get('catid');
		
		//Get an instance of the generic articles model
		$model = JModelLegacy::getInstance('Articles', 'ContentModel', array('ignore_request' => true));

		//Set application parameters in model
		$appParams = $app->getParams();
		$model->setState('params', $appParams);

		// Set the filters based on the module params
		$model->setState('filter.published', 1);
		
		// Access filter
		$access = !JComponentHelper::getParams('com_content')->get('show_noauth');
		$authorised = JAccess::getAuthorisedViewLevels(JFactory::getUser()->get('id'));
		$model->setState('filter.access', $access);		
		
		// Category filter
		$model->setState('filter.category_id', $catids);

		// Filter by language
		$model->setState('filter.language', $app->getLanguageFilter());		

		//  Featured switch
		switch ($params->get('show_featured'))
		{
			case '1':
				$model->setState('filter.featured', 'only');
				break;
			case '0':
				$model->setState('filter.featured', 'hide');
				break;
			default:
				$model->setState('filter.featured', 'show');
				break;
		}
		
		$items = $model->getItems();
		
		return count($items);
	}

        

	/**
	 * Strips unnecessary tags from the introtext
	 *
	 * @param   string  $introtext  introtext to sanitize
	 *
	 * @return mixed|string
	 */
	public static function _cleanIntrotext($introtext)
	{
		$introtext = str_replace('<p>', ' ', $introtext);
		$introtext = str_replace('</p>', ' ', $introtext);
		$introtext = strip_tags($introtext, '<a><em><strong>');

		$introtext = trim($introtext);

		return $introtext;
	}

	/**
	 * Method to truncate introtext
	 *
	 * The goal is to get the proper length plain text string with as much of
	 * the html intact as possible with all tags properly closed.
	 *
	 * @param   string   $html       The content of the introtext to be truncated
	 * @param   integer  $maxLength  The maximum number of charactes to render
	 *
	 * @return  string  The truncated string
	 */
	public static function truncate($html, $maxLength = 0)
	{
		$baseLength = strlen($html);

		// First get the plain text string. This is the rendered text we want to end up with.
		$ptString = JHtml::_('string.truncate', $html, $maxLength, $noSplit = true, $allowHtml = false);

		for ($maxLength; $maxLength < $baseLength;)
		{
			// Now get the string if we allow html.
			$htmlString = JHtml::_('string.truncate', $html, $maxLength, $noSplit = true, $allowHtml = true);

			// Now get the plain text from the html string.
			$htmlStringToPtString = JHtml::_('string.truncate', $htmlString, $maxLength, $noSplit = true, $allowHtml = false);

			// If the new plain text string matches the original plain text string we are done.
			if ($ptString == $htmlStringToPtString)
			{
				return $htmlString;
			}

			// Get the number of html tag characters in the first $maxlength characters
			$diffLength = strlen($ptString) - strlen($htmlStringToPtString);

			// Set new $maxlength that adjusts for the html tags
			$maxLength += $diffLength;

			if ($baseLength <= $maxLength || $diffLength <= 0)
			{
				return $htmlString;
			}
		}

		return $html;
	}

	/**
	 * Groups items by field
	 *
	 * @param   array   $list                        list of items
	 * @param   string  $fieldName                   name of field that is used for grouping
	 * @param   string  $article_grouping_direction  ordering direction
	 * @param   null    $fieldNameToKeep             field name to keep
	 *
	 * @return array
	 */
	public static function groupBy($list, $fieldName, $article_grouping_direction, $fieldNameToKeep = null)
	{
		$grouped = array();

		if (!is_array($list))
		{
			if ($list == '')
			{
				return $grouped;
			}

			$list = array($list);
		}

		foreach ($list as $key => $item)
		{
			if (!isset($grouped[$item->$fieldName]))
			{
				$grouped[$item->$fieldName] = array();
			}

			if (is_null($fieldNameToKeep))
			{
				$grouped[$item->$fieldName][$key] = $item;
			}
			else
			{
				$grouped[$item->$fieldName][$key] = $item->$fieldNameToKeep;
			}

			unset($list[$key]);
		}

		$article_grouping_direction($grouped);

		return $grouped;
	}

	/**
	 * Groups items by date
	 *
	 * @param   array   $list                        list of items
	 * @param   string  $type                        type of grouping
	 * @param   string  $article_grouping_direction  ordering direction
	 * @param   string  $month_year_format           date format to use
	 *
	 * @return array
	 */
	public static function groupByDate($list, $type = 'year', $article_grouping_direction, $month_year_format = 'F Y')
	{
		$grouped = array();

		if (!is_array($list))
		{
			if ($list == '')
			{
				return $grouped;
			}

			$list = array($list);
		}

		foreach ($list as $key => $item)
		{
			switch ($type)
			{
				case 'month_year':
					$month_year = JString::substr($item->created, 0, 7);

					if (!isset($grouped[$month_year]))
					{
						$grouped[$month_year] = array();
					}

					$grouped[$month_year][$key] = $item;
					break;

				case 'year':
				default:
					$year = JString::substr($item->created, 0, 4);

					if (!isset($grouped[$year]))
					{
						$grouped[$year] = array();
					}

					$grouped[$year][$key] = $item;
					break;
			}

			unset($list[$key]);
		}

		$article_grouping_direction($grouped);

		if ($type === 'month_year')
		{
			foreach ($grouped as $group => $items)
			{
				$date = new JDate($group);
				$formatted_group = $date->format($month_year_format);
				$grouped[$formatted_group] = $items;
				unset($grouped[$group]);
			}
		}

		return $grouped;
	}
	public static function getArticles($params)
    {
    	// From joomla content
    	// Get an instance of the generic articles model
		$articles = JModelLegacy::getInstance('Articles', 'ContentModel', array('ignore_request' => true));

		// Set application parameters in model
		$app = JFactory::getApplication();
		$appParams = $app->getParams();
		$articles->setState('params', $appParams);

		$catids = $params->get('catid');
		$articles->setState('filter.category_id.include', (bool) $params->get('category_filtering_type', 1));
		// Category filter
		if ($catids)
		{
			if ($params->get('show_child_category_articles', 0) && (int) $params->get('levels', 0) > 0)
			{
				// Get an instance of the generic categories model
				$categories = JModelLegacy::getInstance('Categories', 'ContentModel', array('ignore_request' => true));
				$categories->setState('params', $appParams);
				$levels = $params->get('levels', 1) ? $params->get('levels', 1) : 9999;
				$categories->setState('filter.get_children', $levels);
				$categories->setState('filter.published', 1);
				$categories->setState('filter.access', $access);
				$additional_catids = array();

				foreach ($catids as $catid)
				{
					$categories->setState('filter.parentId', $catid);
					$recursive = true;
					$items = $categories->getItems($recursive);

					if ($items)
					{
						foreach ($items as $category)
						{
							$condition = (($category->level - $categories->getParent()->level) <= $levels);

							if ($condition)
							{
								$additional_catids[] = $category->id;
							}
						}
					}
				}

				$catids = array_unique(array_merge($catids, $additional_catids));
			}

			$articles->setState('filter.category_id', $catids);
		}

		// Ordering
		$articles->setState('list.ordering', $params->get('article_ordering', 'a.ordering'));
		$articles->setState('list.direction', $params->get('article_ordering_direction', 'ASC'));
    	// End from joomla content

    	$user = JFactory::getUser();
        $db = JFactory::getDbo();
        //$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		//Filter By Category
		
		// $Categories = implode("", $catids);
		
		
		
		$query->select('*');
		$query->from('#__content as a');

		if ($catids[0] == '')
		{
	    	$query = $query;
		} else
		{
		    JArrayHelper::toInteger($catids);
		    $catids = implode(',', $catids);
		    $query->where('a.catid IN (' . $catids . ')');
		}
		$query->group('a.id');
		
		
		// $query->where('i.catid IN');
		
		$db->setQuery($query);
		$items = $db->loadObjectList();
		return $items;
    }
}
