<?php
/**
 * @version		$id: $
 * @author		JoomlaUX!
 * @package		Joomla!
 * @subpackage          mod_jux_news_wall
 * @copyright           Copyright (C) 2012 - 2014 by Joomlaux. All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL version 3, See LICENSE.txt
 */
// no direct access
defined('_JEXEC') or die ;
if(!defined('DS')) define('DS', DIRECTORY_SEPARATOR);
require_once (dirname(__FILE__).DS.'helper.php');
 
// Demo mode
if(!defined('DEMO_MODE')) {
    define('DEMO_MODE', 0);
}
if(DEMO_MODE) {
    $input = JFactory::getApplication()->input;
    $data = $input->post->get('jux_demo_control', array(), 'array');
    
    $properties = $params->toArray();
    foreach($properties as $key => $value) {
        $params->set($key, isset($data[$key]) ? $data[$key] : $value);
    }
}

$sourcetype = $params->get('sourcetype','0');
if($sourcetype==0){
    if (!file_exists(JPATH_SITE.'/components/com_k2')){
            echo  '<div style="float: left;color:red">This module can not work without the k2 Component</div>';
    }
}
if($sourcetype==0){
    if (file_exists(JPATH_SITE.'/components/com_k2')){
        $tags= $params->get('jux-tags');
        if(count($tags)>0){
            $source_tags = implode(',',$tags );
        }else{
            $source_tags = -1;
        }
        $tags= modJUXNewsWallHelper::getTags($source_tags);
    }
}
if($sourcetype==0){
    if (file_exists(JPATH_SITE.'/components/com_k2')){
            $moduleclass_sfx = $params->get('moduleclass_sfx', '');
        
            // Clone get data via ajax
            $limitstart                         = 0;
            $limit				= (int)$params->get('itemCount', 4);
            $ajaxlimit                          = $params->get('k2ajaxlimit', 4);
            $ajaxRequest                        = false;

            if( JRequest::getInt('moduleID', 0) > 0 ){
                $limitstart			= JRequest::getInt('limitstart');
                $limit                          = JRequest::getInt('limit');
                $ajaxRequest                    = true;
            }

            

            $items 	= modJUXNewsWallHelper::getItems($params,$format = 'html',$limitstart, $limit);
            $total      = count(modJUXNewsWallHelper::getk2Total($params));
            $list      = modJUXNewsWallHelper::getk2Total($params);

            //Add css and javascripts
            JHtml::_('jquery.framework');
            $document = JFactory::getDocument();

            $document->addStyleSheet(JURI::base() . 'modules/mod_jux_news_wall/assets/css/nivo-lightbox.css');
            $document->addStyleSheet(JURI::base() . 'modules/mod_jux_news_wall/assets/css/nivolightbox/default.css');
            $document->addStyleSheet(JURI::base() . 'modules/mod_jux_news_wall/assets/css/style.css');

            /* load javascript. */
            modJUXNewsWallHelper::loadjQuery($params);
            $document->addScript(JURI::base() . 'modules/mod_jux_news_wall/assets/js/nivo-lightbox.js');
            $document->addScript(JURI::base() . 'modules/mod_jux_news_wall/assets/js/isotope.pkgd.min.js');
            $document->addScript(JURI::base() . 'modules/mod_jux_news_wall/assets/js/imagesloaded.pkgd.min.js');

            //add custom css file
            $customcss = 'modules/mod_jux_news_wall/assets/css/style/custom-'.$module->id.'.css';
            if (mod_JUX_NewsWallHelper::getCssProcessor($params,$customcss,'#news-wall-'.$module->id)){
                $document->addStyleSheet($customcss);
            }

            if (K2_JVERSION != '15')
            {
                $language = JFactory::getLanguage();
                $language->load('mod_k2.j16', JPATH_ADMINISTRATOR, null, true);
            }

            $getTemplate = $params->get('getTemplate', 'Default');
            
            $itemAuthorAvatarWidthSelect = $params->get('itemAuthorAvatarWidthSelect', 'custom');
            $itemAuthorAvatarWidth = $params->get('itemAuthorAvatarWidth', 50);
            $itemCustomLinkTitle = $params->get('itemCustomLinkTitle', '');
            if ($params->get('itemCustomLinkMenuItem'))
            {
                $menu = JMenu::getInstance('site');
                $menuLink = $menu->getItem($params->get('itemCustomLinkMenuItem'));
                if (!$itemCustomLinkTitle)
                {
                    $itemCustomLinkTitle = (K2_JVERSION != '15') ? $menuLink->title : $menuLink->name;
                }
                $params->set('itemCustomLinkURL', JRoute::_('index.php?&Itemid='.$menuLink->id));
            }

            // Get component params

            $componentParams = JComponentHelper::getParams('com_k2');

            // User avatar
            if ($itemAuthorAvatarWidthSelect == 'inherit')
            {
                
                $avatarWidth = $componentParams->get('userImageWidth');
            }

            else
            {
                $avatarWidth = $itemAuthorAvatarWidth;
            }

            if (count($items))
            {
                require (JModuleHelper::getLayoutPath('mod_jux_news_wall', 'default_k2'));
            }
        }
    }

    //end k2    die('22');
if ($sourcetype==1)
    {
        $moduleclass_sfx = $params->get('moduleclass_sfx', '');
        
        // Clone get data via ajax
        $start				= 0;
        $limit				= (int)$params->get('count', 6);
        $ajaxlimit			= $params->get('ajaxlimit', 3);
        $ajaxRequest                    = false;
        
        if( JRequest::getInt('moduleID', 0) > 0 ){
            $start			= JRequest::getInt('start');
            $limit			= JRequest::getInt('limit', $ajaxlimit);
            $ajaxRequest		= true;
        }
        
        require_once (dirname(__FILE__).DS.'helper.php');
        
        $items 	= modJUXNewsWallHelper::getList($params, $start, $limit);
        $total  = modJUXNewsWallHelper::getTotal($params);

        //Add css and javascripts
        JHtml::_('jquery.framework');
        $document = JFactory::getDocument();

        $document->addStyleSheet(JURI::base() . 'modules/mod_jux_news_wall/assets/css/nivo-lightbox.css');
        $document->addStyleSheet(JURI::base() . 'modules/mod_jux_news_wall/assets/css/nivolightbox/default.css');
        $document->addStyleSheet(JURI::base() . 'modules/mod_jux_news_wall/assets/css/style.css');
        
        /* load javascript. */
        modJUXNewsWallHelper::loadjQuery($params);
        $document->addScript(JURI::base() . 'modules/mod_jux_news_wall/assets/js/nivo-lightbox.js');
        $document->addScript(JURI::base() . 'modules/mod_jux_news_wall/assets/js/isotope.pkgd.min.js');
        $document->addScript(JURI::base() . 'modules/mod_jux_news_wall/assets/js/imagesloaded.pkgd.min.js');
        
        //add custom css file
        $customcss = 'modules/mod_jux_news_wall/assets/css/style/custom-'.$module->id.'.css';
        if (mod_JUX_NewsWallHelper::getCssProcessor($params,$customcss,'#news-wall-'.$module->id)){
            $document->addStyleSheet($customcss);
        }

        //get links
        $input = JFactory::getApplication()->input;

        // Prep for Normal or Dynamic Modes
        $mode = $params->get('mode', 'normal');
        $idbase = null;

        switch ($mode)
        {
            case 'dynamic':
                $option = $input->get('option');
                $view = $input->get('view');

                if ($option === 'com_content')
                {
                    switch ($view)
                    {
                        case 'category':
                            $idbase = $input->getInt('id');
                            break;
                        case 'categories':
                            $idbase = $input->getInt('id');
                            break;
                        case 'article':
                            if ($params->get('show_on_article_page', 1))
                            {
                                $idbase = $input->getInt('catid');
                            }
                            break;
                    }
                }
                break;
            case 'normal':
            default:
                $idbase = $params->get('catid');
                break;
        }



        $cacheid = md5(serialize(array ($idbase, $module->module)));

        $cacheparams = new stdClass;
        $cacheparams->cachemode = 'id';
        $cacheparams->class = 'modJUXNewsWallHelper';
        $cacheparams->method = 'getList';
        $cacheparams->methodparams = $params;
        $cacheparams->modeparams = $cacheid;

        $list = JModuleHelper::moduleCache($module, $params, $cacheparams);
        if (!empty($list))
        {
            $grouped = false;
            $article_grouping = $params->get('article_grouping', 'none');
            $article_grouping_direction = $params->get('article_grouping_direction', 'ksort');
            $moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
            $item_heading = $params->get('item_heading');

            if ($article_grouping !== 'none')
            {
                $grouped = true;

                switch ($article_grouping)
                {
                    case 'year':
                    case 'month_year':
                        $list = modJUXNewsWallHelper::groupByDate($list, $article_grouping, $article_grouping_direction, $params->get('month_year_format', 'F Y'));
                        break;
                    case 'author':
                    case 'category_title':
                        $list = modJUXNewsWallHelper::groupBy($list, $article_grouping, $article_grouping_direction);
                        break;
                    default:
                        break;
                }
            }


        require( JModuleHelper::getLayoutPath( 'mod_jux_news_wall','default'));
        }
    }

?>
