<?php
/**
 * ------------------------------------------------------------------------
 * Helper - Logo Slider  Module
 * ------------------------------------------------------------------------
 * Copyright (C) 2014-2016 LogicHunt, All Rights Reserved.
 * license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: LogicHunt
 * Websites:  http://logichunt.com
 * ------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');

class LgxLogoSliderHelper
{


    /**
     * Source Data
     *
     * @param $source
     * @param $native_field
     * @param $custom_field
     *
     * @return array
     */

    public static function LgxLogoSliderSource($source, $native_field, $custom_field)
    {

        $output = array();

        if(isset($native_field) || isset($custom_field)) {
            $data_source = array();

            if ($source == 'joomla' && isset($native_field)) {
                $data_source = $native_field;
            } elseif(isset($custom_field)) {
                $data_source = $custom_field;
            }

            foreach ($data_source as $key => $logo_content):
                $output[] = array(
                    'active'  => $logo_content->active,
                    'thumb'   => $logo_content->thumb,
                    'title'   => $logo_content->title,
                    'tooltip' => (!empty($logo_content->tooltip) ? $logo_content->tooltip : ''),
                    'url'     => $logo_content->url,
                );
            endforeach;
        }

        return $output;
    }


    public static function lgx_logo_hex2rgba($color, $opacity)
    {

        $default = 'rgb(0,0,0)';

        //Return default if no color provided
        if (empty($color))
            return $default;

        //Sanitize $color if "#" is provided
        if ($color[0] == '#') {
            $color = substr($color, 1);
        }

        //Check if color has 6 or 3 characters and get values
        if (strlen($color) == 6) {
            $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
        } elseif (strlen($color) == 3) {
            $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
        } else {
            return $default;
        }

        //Convert hexadec to rgb
        $rgb = array_map('hexdec', $hex);

        //Check if opacity is set(rgba or rgb)
        if (isset($opacity)) {
            if (abs($opacity) > 1) {
                $opacity = 1.0;
            }

            $output = 'rgba(' . implode(",", $rgb) . ',' . $opacity . ')';
        } else {
            $output = 'rgb(' . implode(",", $rgb) . ')';
        }

        //Return rgb(a) color string
        return $output;
    }


    public static function nav_text_img($nav_tape, $navTextLeft, $navTextRight, $navimgLeft, $navimgRight)
    {

        if ($nav_tape == 'img') {

            if (!isset($navimgLeft) || $navimgLeft == '') {
                $navimgLeft = JURI::root() . 'modules/mod_lgx_logoslider/assets/img/prev-m.png';
            }
            if (!isset($navimgRight) || $navimgRight == '') {
                $navimgRight = JURI::root() . 'modules/mod_lgx_logoslider/assets/img/next-m.png';
            }

            $navtext = '[\'<img src="' . $navimgLeft . '" alt="Left Navigation" />\',\'<img src="' . $navimgRight . '" alt="Right Navigation" />\']';
        } else {

            $navtext = '["' . $navTextLeft . '","' . $navTextRight . '"]';
        }
        return $navtext;
    }


    public static function lgx_logo_btngroup($option)
    {

        if ($option == 1) {
            $value = 'true';
        } elseif ($option == 0) {
            $value = 'false';
        }

        return $value;

    }


    public static function lgx_TP_Slide_type($tp_side)
    {

        if ($tp_side == 'bottom') {
            return '["bottom", "top", "right", "left"]';
        } elseif ($tp_side == 'right') {
            return '["right", "left", "top", "bottom"]';

        } elseif ($tp_side == 'left') {
            return '["left", "right", "top", "bottom"]';
        } else {
            return '["top", "bottom", "right", "left"]';
        }
    }

    public static function LgxLogoRandomize($items)
    {
        $shuffleKeys = array_keys($items);
        shuffle($shuffleKeys);
        $newArray = array();
        foreach ($shuffleKeys as $key) {
            $newArray[$key] = $items[$key];
        }
        return $newArray;
    }


}