<?php
/**
 * @package RSForm! Pro
 * @copyright (C) 2007-2019 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/copyleft/gpl.html
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

// Setup the modal
if ($modal) {
	JHtml::_('behavior.modal', 'a.feedback-modal');
} elseif ($bsmodal) {
	$modalData = array(
		'selector'	=> 'feedbackModal' . $module->id,
		'params'	=> array(
			'title' 	=> $title,
			'url' 		=> JRoute::_($form_url),
		),
		'body'		=> ''
	);

	$modalData['params']['bodyHeight'] = (int) $params->get('bsmodal_height', 70);
	if ($modalWidth = (int) $params->get('bsmodal_width'))
	{
		$modalData['params']['modalWidth'] = $modalWidth;
	}

	echo JLayoutHelper::render('joomla.modal.main', $modalData);
}

JFactory::getDocument()->addStyleDeclaration('
#feedback-'.$module->id.' a {
	background-color: '.htmlspecialchars($bg_color, ENT_COMPAT, 'utf-8').';
	border: solid 2px '.htmlspecialchars($border_color, ENT_COMPAT, 'utf-8').';
	color: '.htmlspecialchars($text_color, ENT_COMPAT, 'utf-8').';
	font-size: '.(int) $font_size.'px;
}
')
?>
<div id="feedback-<?php echo $module->id; ?>" class="feedback-container<?php echo htmlspecialchars($sfx, ENT_COMPAT, 'utf-8'); ?> feedback-position-<?php echo htmlspecialchars($position, ENT_COMPAT, 'utf-8'); ?>">
<?php
if ($bsmodal)
{
	echo JHtml::_('link', '#', $text, $attribs);
}
else
{
	echo JHtml::_('link', JRoute::_($form_url), $text, $attribs);
}
?>
</div>